/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.project;

import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.ui.CustomNotificationListener;
import com.google.common.base.Objects;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.impl.NotificationsManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.BalloonLayoutData;
import com.intellij.ui.awt.RelativePoint;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidNotification {
    public static final NotificationGroup BALLOON_GROUP = NotificationGroup.balloonGroup((String)"Android Notification Group", (PluginId)PluginId.getId((String)"org.jetbrains.android"));
    public static final NotificationGroup LOG_ONLY_GROUP = NotificationGroup.logOnlyGroup((String)"Android Notification Log-Only Group", (PluginId)PluginId.getId((String)"org.jetbrains.android"));
    private static final Key<JFrame> NOTIFICATION_DESTINATION_FALLBACK_KEY = Key.create((String)"NOTIFICATION_DESTINATION_FALLBACK");
    @Nullable
    private Notification myNotification;
    @NotNull
    private final Project myProject;

    @NotNull
    public static AndroidNotification getInstance(@NotNull Project project) {
        if (project == null) {
            AndroidNotification.$$$reportNull$$$0(0);
        }
        AndroidNotification androidNotification = (AndroidNotification)project.getService(AndroidNotification.class);
        if (androidNotification == null) {
            AndroidNotification.$$$reportNull$$$0(1);
        }
        return androidNotification;
    }

    public AndroidNotification(@NotNull Project project) {
        if (project == null) {
            AndroidNotification.$$$reportNull$$$0(2);
        }
        this.myProject = project;
    }

    public void addLogEvent(@NotNull String title, @NotNull String text2, @NotNull NotificationType type) {
        if (title == null) {
            AndroidNotification.$$$reportNull$$$0(3);
        }
        if (text2 == null) {
            AndroidNotification.$$$reportNull$$$0(4);
        }
        if (type == null) {
            AndroidNotification.$$$reportNull$$$0(5);
        }
        this.showNotification(title, text2, type, LOG_ONLY_GROUP, null);
    }

    public void showBalloon(@NotNull String title, @NotNull String text2, @NotNull NotificationType type) {
        if (title == null) {
            AndroidNotification.$$$reportNull$$$0(6);
        }
        if (text2 == null) {
            AndroidNotification.$$$reportNull$$$0(7);
        }
        if (type == null) {
            AndroidNotification.$$$reportNull$$$0(8);
        }
        this.showBalloon(title, text2, type, (NotificationListener)null);
    }

    public void showBalloon(@NotNull String title, @NotNull String text2, @NotNull NotificationType type, NotificationHyperlink ... hyperlinks) {
        if (title == null) {
            AndroidNotification.$$$reportNull$$$0(9);
        }
        if (text2 == null) {
            AndroidNotification.$$$reportNull$$$0(10);
        }
        if (type == null) {
            AndroidNotification.$$$reportNull$$$0(11);
        }
        if (hyperlinks == null) {
            AndroidNotification.$$$reportNull$$$0(12);
        }
        this.showBalloon(title, text2, type, BALLOON_GROUP, hyperlinks);
    }

    public void showBalloon(@NotNull String title, @NotNull String text2, @NotNull NotificationType type, @NotNull NotificationGroup group2, NotificationHyperlink ... hyperlinks) {
        if (title == null) {
            AndroidNotification.$$$reportNull$$$0(13);
        }
        if (text2 == null) {
            AndroidNotification.$$$reportNull$$$0(14);
        }
        if (type == null) {
            AndroidNotification.$$$reportNull$$$0(15);
        }
        if (group2 == null) {
            AndroidNotification.$$$reportNull$$$0(16);
        }
        if (hyperlinks == null) {
            AndroidNotification.$$$reportNull$$$0(17);
        }
        this.showBalloon(title, text2, type, group2, true, hyperlinks);
    }

    public void showBalloon(@NotNull String title, @NotNull String text2, @NotNull NotificationType type, @NotNull NotificationGroup group2, boolean newLineForLinkText, NotificationHyperlink ... hyperlinks) {
        if (title == null) {
            AndroidNotification.$$$reportNull$$$0(18);
        }
        if (text2 == null) {
            AndroidNotification.$$$reportNull$$$0(19);
        }
        if (type == null) {
            AndroidNotification.$$$reportNull$$$0(20);
        }
        if (group2 == null) {
            AndroidNotification.$$$reportNull$$$0(21);
        }
        if (hyperlinks == null) {
            AndroidNotification.$$$reportNull$$$0(22);
        }
        CustomNotificationListener notificationListener = new CustomNotificationListener(this.myProject, hyperlinks);
        String newText = AndroidNotification.addHyperlinksToText(text2, newLineForLinkText, hyperlinks);
        this.showNotification(title, newText, type, group2, (NotificationListener)notificationListener);
    }

    @NotNull
    private static String addHyperlinksToText(@NotNull String text2, boolean newLineForLinkText, NotificationHyperlink ... hyperlinks) {
        if (text2 == null) {
            AndroidNotification.$$$reportNull$$$0(23);
        }
        if (hyperlinks == null) {
            AndroidNotification.$$$reportNull$$$0(24);
        }
        if (hyperlinks.length == 0) {
            String string = text2;
            if (string == null) {
                AndroidNotification.$$$reportNull$$$0(25);
            }
            return string;
        }
        StringBuilder b = new StringBuilder();
        b.append(text2);
        for (NotificationHyperlink hyperlink : hyperlinks) {
            if (newLineForLinkText) {
                b.append("<br>\n");
            }
            b.append(hyperlink.toHtml());
        }
        String string = b.toString();
        if (string == null) {
            AndroidNotification.$$$reportNull$$$0(26);
        }
        return string;
    }

    public void showBalloon(@NotNull String title, @NotNull String text2, @NotNull NotificationType type, @Nullable NotificationListener listener2) {
        if (title == null) {
            AndroidNotification.$$$reportNull$$$0(27);
        }
        if (text2 == null) {
            AndroidNotification.$$$reportNull$$$0(28);
        }
        if (type == null) {
            AndroidNotification.$$$reportNull$$$0(29);
        }
        this.showNotification(title, text2, type, BALLOON_GROUP, listener2);
    }

    private void showNotification(@NotNull String title, @NotNull String text2, @NotNull NotificationType type, @NotNull NotificationGroup group2, @Nullable NotificationListener listener2) {
        if (title == null) {
            AndroidNotification.$$$reportNull$$$0(30);
        }
        if (text2 == null) {
            AndroidNotification.$$$reportNull$$$0(31);
        }
        if (type == null) {
            AndroidNotification.$$$reportNull$$$0(32);
        }
        if (group2 == null) {
            AndroidNotification.$$$reportNull$$$0(33);
        }
        Notification notification = group2.createNotification(title, text2, type);
        if (listener2 != null) {
            notification.setListener(listener2);
        }
        Runnable notificationTask = () -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            if (this.myProject.isOpen()) {
                boolean similar;
                Notification old2 = this.myNotification;
                if (old2 != null && (similar = Objects.equal((Object)notification.getContent(), (Object)old2.getContent()))) {
                    old2.expire();
                }
                this.myNotification = notification;
                notification.notify(this.myProject);
            } else {
                JFrame jFrame = AndroidNotification.getFallbackNotificationDestination(this.myProject);
                if (jFrame == null) {
                    return;
                }
                AndroidNotification.showNotification(this.myProject, notification, jFrame);
            }
        };
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            notificationTask.run();
        } else {
            application.invokeLater(notificationTask);
        }
    }

    public static void setFallbackNotificationDestination(final Project project, final JFrame jFrame) {
        project.putUserData(NOTIFICATION_DESTINATION_FALLBACK_KEY, (Object)jFrame);
        Notifications subscriber2 = new Notifications(){

            public void notify(@NotNull Notification notification) {
                if (notification == null) {
                    1.$$$reportNull$$$0(0);
                }
                AndroidNotification.showNotification(project, notification, jFrame);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/android/tools/idea/project/AndroidNotification$1", "notify"));
            }
        };
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(Notifications.TOPIC, (Object)subscriber2);
        project.getMessageBus().connect().subscribe(Notifications.TOPIC, (Object)subscriber2);
    }

    private static void showNotification(Project project, Notification notification, JFrame jFrame) {
        Balloon balloon = NotificationsManagerImpl.createBalloon((JComponent)jFrame.getRootPane(), (Notification)notification, (boolean)false, (boolean)true, (Ref)BalloonLayoutData.fullContent(), (Disposable)project);
        Dimension jFrameSize = jFrame.getSize();
        Dimension balloonSize = balloon.getPreferredSize();
        RelativePoint point = new RelativePoint((Component)jFrame, new Point(jFrameSize.width - balloonSize.width / 2, jFrameSize.height - balloonSize.height / 2));
        balloon.show(point, Balloon.Position.above);
    }

    @Nullable
    private static JFrame getFallbackNotificationDestination(Project project) {
        return (JFrame)project.getUserData(NOTIFICATION_DESTINATION_FALLBACK_KEY);
    }

    @Nullable
    public Notification getNotification() {
        return this.myNotification;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 25: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 25: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/project/AndroidNotification";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 13: 
            case 18: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 14: 
            case 19: 
            case 23: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 15: 
            case 20: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 12: 
            case 17: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hyperlinks";
                break;
            }
            case 16: 
            case 21: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/project/AndroidNotification";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "addHyperlinksToText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 25: 
            case 26: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addLogEvent";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "showBalloon";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addHyperlinksToText";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "showNotification";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

