/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.stacktrace;

import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.ApkFacetConfiguration;
import com.android.tools.idea.profilers.TraceSignatureConverter;
import com.android.tools.nativeSymbolizer.NativeSymbolizer;
import com.android.tools.nativeSymbolizer.Symbol;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.stacktrace.CodeLocation;
import com.android.tools.profilers.stacktrace.CodeNavigator;
import com.google.common.base.Strings;
import com.intellij.build.FileNavigatable;
import com.intellij.build.FilePosition;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.ClassUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IntellijCodeNavigator
extends CodeNavigator {
    @NotNull
    private final Project myProject;
    @NotNull
    private final NativeSymbolizer myNativeSymbolizer;
    @NotNull
    private final Map<String, String> myApkSrcDirMap;
    @NotNull
    private Supplier<String> myCpuAbiArchSupplier;

    public IntellijCodeNavigator(@NotNull Project project, @NotNull NativeSymbolizer nativeSymbolizer, @NotNull FeatureTracker featureTracker) {
        if (project == null) {
            IntellijCodeNavigator.$$$reportNull$$$0(0);
        }
        if (nativeSymbolizer == null) {
            IntellijCodeNavigator.$$$reportNull$$$0(1);
        }
        if (featureTracker == null) {
            IntellijCodeNavigator.$$$reportNull$$$0(2);
        }
        super(featureTracker);
        this.myProject = project;
        this.myNativeSymbolizer = nativeSymbolizer;
        this.myApkSrcDirMap = this.getApkSourceDirMap();
        this.myCpuAbiArchSupplier = () -> null;
    }

    public void setCpuAbiArchSupplier(@NotNull Supplier<String> cpuAbiArch) {
        if (cpuAbiArch == null) {
            IntellijCodeNavigator.$$$reportNull$$$0(3);
        }
        this.myCpuAbiArchSupplier = cpuAbiArch;
    }

    @Nullable
    public String fetchCpuAbiArch() {
        return this.myCpuAbiArchSupplier.get();
    }

    protected void handleNavigate(@NotNull CodeLocation location) {
        if (location == null) {
            IntellijCodeNavigator.$$$reportNull$$$0(4);
        }
        CompletableFuture.supplyAsync(() -> (Navigatable)ReadAction.compute(() -> this.getNavigatable(location)), arg_0 -> ((Application)ApplicationManager.getApplication()).executeOnPooledThread(arg_0)).thenAcceptAsync(nav -> {
            if (nav != null) {
                nav.navigate(true);
            }
        }, arg_0 -> ((Application)ApplicationManager.getApplication()).invokeLater(arg_0));
    }

    public boolean isNavigatable(@NotNull CodeLocation location) {
        if (location == null) {
            IntellijCodeNavigator.$$$reportNull$$$0(5);
        }
        return this.getNavigatable(location) != null;
    }

    @Nullable
    private Navigatable getNavigatable(@NotNull CodeLocation location) {
        if (location == null) {
            IntellijCodeNavigator.$$$reportNull$$$0(6);
        }
        if (!Strings.isNullOrEmpty((String)location.getFileName()) && location.getLineNumber() != -1) {
            Navigatable navigatable = this.getExplicitLocationNavigable(location);
            if (navigatable != null) {
                return navigatable;
            }
            navigatable = this.getApkMappingNavigable(location);
            if (navigatable != null) {
                return navigatable;
            }
        }
        if (location.isNativeCode()) {
            return this.getNativeNavigatable(location);
        }
        PsiClass psiClass = ClassUtil.findPsiClassByJVMName((PsiManager)PsiManager.getInstance((Project)this.myProject), (String)location.getClassName());
        if (psiClass == null && location.getLineNumber() >= 0) {
            psiClass = ClassUtil.findPsiClassByJVMName((PsiManager)PsiManager.getInstance((Project)this.myProject), (String)location.getOuterClassName());
        }
        if (psiClass == null) {
            return null;
        }
        if (location.getLineNumber() >= 0) {
            return new OpenFileDescriptor(this.myProject, psiClass.getNavigationElement().getContainingFile().getVirtualFile(), location.getLineNumber(), 0);
        }
        if (location.getMethodName() != null && location.getSignature() != null) {
            PsiMethod method2 = IntellijCodeNavigator.findMethod(psiClass, location.getMethodName(), location.getSignature());
            return method2 != null ? method2 : psiClass;
        }
        return psiClass;
    }

    @Nullable
    private Navigatable getExplicitLocationNavigable(@NotNull CodeLocation location) {
        LocalFileSystem fileSystem;
        VirtualFile sourceFile;
        if (location == null) {
            IntellijCodeNavigator.$$$reportNull$$$0(7);
        }
        if ((sourceFile = (fileSystem = LocalFileSystem.getInstance()).findFileByPath(location.getFileName())) == null || !sourceFile.exists()) {
            return null;
        }
        return new OpenFileDescriptor(this.myProject, sourceFile, location.getLineNumber(), 0);
    }

    @Nullable
    private Navigatable getApkMappingNavigable(@NotNull CodeLocation location) {
        if (location == null) {
            IntellijCodeNavigator.$$$reportNull$$$0(8);
        }
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        for (Map.Entry<String, String> entry : this.myApkSrcDirMap.entrySet()) {
            if (!location.getFileName().startsWith(entry.getKey())) continue;
            String pathTailAfterPrefix = location.getFileName().substring(entry.getKey().length());
            String newFileName = Paths.get(entry.getValue(), pathTailAfterPrefix).toString();
            VirtualFile sourceFile = fileSystem.findFileByPath(newFileName);
            if (sourceFile == null || !sourceFile.exists()) continue;
            return new OpenFileDescriptor(this.myProject, sourceFile, location.getLineNumber(), 0);
        }
        return null;
    }

    @NotNull
    private Map<String, String> getApkSourceDirMap() {
        LinkedHashMap<String, String> sourceMap = new LinkedHashMap<String, String>();
        for (Module module2 : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            ApkFacet apkFacet = ApkFacet.getInstance(module2);
            if (apkFacet == null) continue;
            for (Map.Entry<String, String> entry : ((ApkFacetConfiguration)apkFacet.getConfiguration()).getSymbolFolderPathMappings().entrySet()) {
                if (entry.getValue().isEmpty() || entry.getKey().equals(entry.getValue())) continue;
                sourceMap.put(entry.getKey(), entry.getValue());
            }
        }
        LinkedHashMap<String, String> linkedHashMap = sourceMap;
        if (linkedHashMap == null) {
            IntellijCodeNavigator.$$$reportNull$$$0(9);
        }
        return linkedHashMap;
    }

    @Nullable
    private Navigatable getNativeNavigatable(@NotNull CodeLocation location) {
        Symbol symbol;
        if (location == null) {
            IntellijCodeNavigator.$$$reportNull$$$0(10);
        }
        String arch = this.fetchCpuAbiArch();
        if (location.getFileName() == null || arch == null) {
            return null;
        }
        try {
            symbol = this.myNativeSymbolizer.symbolize(arch, location.getFileName(), location.getNativeVAddress());
        }
        catch (IOException e) {
            return null;
        }
        if (symbol == null) {
            return null;
        }
        return new FileNavigatable(this.myProject, new FilePosition(new File(symbol.getSourceFile()), symbol.getLineNumber() - 1, 0));
    }

    @Nullable
    private static PsiMethod findMethod(@NotNull PsiClass psiClass, @NotNull String methodName, @NotNull String signature) {
        if (psiClass == null) {
            IntellijCodeNavigator.$$$reportNull$$$0(11);
        }
        if (methodName == null) {
            IntellijCodeNavigator.$$$reportNull$$$0(12);
        }
        if (signature == null) {
            IntellijCodeNavigator.$$$reportNull$$$0(13);
        }
        for (PsiMethod method2 : psiClass.findMethodsByName(methodName, true)) {
            if (!signature.equals(TraceSignatureConverter.getTraceSignature(method2))) continue;
            return method2;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeSymbolizer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "featureTracker";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cpuAbiArch";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/profilers/stacktrace/IntellijCodeNavigator";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/profilers/stacktrace/IntellijCodeNavigator";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getApkSourceDirMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setCpuAbiArchSupplier";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handleNavigate";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isNavigatable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNavigatable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getExplicitLocationNavigable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getApkMappingNavigable";
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getNativeNavigatable";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findMethod";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

