/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.stacktrace;

import com.android.tools.nativeSymbolizer.NativeSymbolizer;
import com.android.tools.nativeSymbolizer.Symbol;
import com.android.tools.profiler.proto.Memory;
import com.android.tools.profilers.stacktrace.NativeFrameSymbolizer;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class IntelliJNativeFrameSymbolizer
implements NativeFrameSymbolizer {
    static final int PREVIOUS_INSTRUCTION_OFFSET = -1;
    @NotNull
    private final NativeSymbolizer mySymbolizer;

    private static Logger getLogger() {
        return Logger.getInstance(IntelliJNativeFrameSymbolizer.class);
    }

    public IntelliJNativeFrameSymbolizer(@NotNull NativeSymbolizer symbolizer) {
        if (symbolizer == null) {
            IntelliJNativeFrameSymbolizer.$$$reportNull$$$0(0);
        }
        this.mySymbolizer = symbolizer;
    }

    @NotNull
    public Memory.NativeCallStack.NativeFrame symbolize(String abi, Memory.NativeCallStack.NativeFrame unsymbolizedFrame) {
        Symbol symbol = null;
        long instructionOffset = this.getOffsetOfPreviousInstruction(unsymbolizedFrame.getModuleOffset());
        try {
            symbol = this.mySymbolizer.symbolize(abi, unsymbolizedFrame.getModuleName(), instructionOffset);
        }
        catch (IOException | RuntimeException e) {
            IntelliJNativeFrameSymbolizer.getLogger().warn((Throwable)e);
        }
        Memory.NativeCallStack.NativeFrame.Builder builder2 = unsymbolizedFrame.toBuilder();
        if (symbol == null) {
            String unfoundSymbolName = String.format("0x%x", instructionOffset);
            builder2.setSymbolName(unfoundSymbolName);
        } else {
            builder2.setSymbolName(symbol.getName()).setModuleName(symbol.getModule()).setFileName(symbol.getSourceFile()).setLineNumber(symbol.getLineNumber());
        }
        Memory.NativeCallStack.NativeFrame nativeFrame = builder2.build();
        if (nativeFrame == null) {
            IntelliJNativeFrameSymbolizer.$$$reportNull$$$0(1);
        }
        return nativeFrame;
    }

    public void stop() {
        this.mySymbolizer.stop();
    }

    private long getOffsetOfPreviousInstruction(long offset2) {
        return offset2 + -1L;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolizer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/profilers/stacktrace/IntelliJNativeFrameSymbolizer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/profilers/stacktrace/IntelliJNativeFrameSymbolizer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "symbolize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

