/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.perfetto.traceprocessor;

import com.android.tools.idea.profilers.perfetto.traceprocessor.NameDemangler;
import com.android.tools.idea.profilers.perfetto.traceprocessor.NameHolder;
import com.android.tools.idea.util.StudioPathManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\b\u0010\f\u001a\u00020\rH\u0002J\r\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/profilers/perfetto/traceprocessor/WindowsNameDemangler;", "Lcom/android/tools/idea/profilers/perfetto/traceprocessor/NameDemangler;", "timeoutMsc", "", "(J)V", "getTimeoutMsc", "()J", "demangleInplace", "", "stackFrames", "", "Lcom/android/tools/idea/profilers/perfetto/traceprocessor/NameHolder;", "getLlvmCppFiltPath", "", "getLogger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger$intellij_android_profilersAndroid", "start", "Lcom/android/tools/idea/profilers/perfetto/traceprocessor/WindowsNameDemangler$ProcessHolder;", "ProcessHolder", "intellij.android.profilersAndroid"})
public final class WindowsNameDemangler
implements NameDemangler {
    private final long timeoutMsc;

    private final String getLlvmCppFiltPath() {
        String exe = "x86_64-linux-android-c++filt.exe";
        Path result2 = StudioPathManager.isRunningFromSources() ? Paths.get(StudioPathManager.getSourcesRoot(), "prebuilts", "tools", "windows-x86_64", "lldb", "bin", exe) : Paths.get(PathManager.getBinPath(), "lldb", "bin", exe);
        return ((Object)result2).toString();
    }

    @Override
    public void demangleInplace(@NotNull Collection<? extends NameHolder> stackFrames) {
        Intrinsics.checkNotNullParameter(stackFrames, (String)"stackFrames");
        if (!SystemInfo.isWindows) {
            return;
        }
        ProcessHolder holder = this.start();
        if (holder == null) {
            return;
        }
        HashMap duplicatesMap = new HashMap();
        for (NameHolder nameHolder : stackFrames) {
            try {
                if (duplicatesMap.containsKey(nameHolder.getName())) {
                    Object v = duplicatesMap.get(nameHolder.getName());
                    Intrinsics.checkNotNull(v);
                    nameHolder.setName((String)v);
                    continue;
                }
                if (!StringsKt.startsWith$default((String)nameHolder.getName(), (String)"_Z", (boolean)false, (int)2, null)) continue;
                holder.getStdin().write(nameHolder.getName() + "\n");
                holder.getStdin().flush();
                String string = holder.getStdout().readLine();
                if (string == null) {
                    string = nameHolder.getName();
                }
                String response = string;
                ((Map)duplicatesMap).put(nameHolder.getName(), response);
                nameHolder.setName(response);
            }
            catch (Exception ex) {
                this.getLogger$intellij_android_profilersAndroid().error((Throwable)ex);
            }
        }
        holder.dispose();
    }

    private final ProcessHolder start() {
        ProcessHolder procHolder = null;
        try {
            Process process;
            String llvmfiltPath = this.getLlvmCppFiltPath();
            ProcessBuilder builder2 = new ProcessBuilder(llvmfiltPath);
            Process process2 = process = builder2.start();
            Intrinsics.checkNotNullExpressionValue((Object)process2, (String)"process");
            if (!process2.isAlive()) {
                throw (Throwable)new IOException("C++ filt process is not alive. Executable: " + llvmfiltPath);
            }
            OutputStreamWriter stdin = new OutputStreamWriter(process.getOutputStream(), Charsets.UTF_8);
            BufferedReader stdout = new BufferedReader(new InputStreamReader(process.getInputStream(), Charsets.UTF_8));
            procHolder = new ProcessHolder(process, stdout, stdin, this.timeoutMsc);
        }
        catch (Exception e) {
            Logger.getInstance((String)"CppNameDemangler").error((Throwable)e);
            procHolder = null;
        }
        return procHolder;
    }

    @NotNull
    public final Logger getLogger$intellij_android_profilersAndroid() {
        Logger logger2 = Logger.getInstance((String)"CppNameDemangler");
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(\"CppNameDemangler\")");
        return logger2;
    }

    public final long getTimeoutMsc() {
        return this.timeoutMsc;
    }

    public WindowsNameDemangler(long timeoutMsc) {
        this.timeoutMsc = timeoutMsc;
    }

    public /* synthetic */ WindowsNameDemangler(long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            l = 5000L;
        }
        this(l);
    }

    public WindowsNameDemangler() {
        this(0L, 1, null);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/profilers/perfetto/traceprocessor/WindowsNameDemangler$ProcessHolder;", "Lcom/intellij/openapi/Disposable;", "process", "Ljava/lang/Process;", "stdout", "Ljava/io/BufferedReader;", "stdin", "Ljava/io/OutputStreamWriter;", "timeoutMsc", "", "(Ljava/lang/Process;Ljava/io/BufferedReader;Ljava/io/OutputStreamWriter;J)V", "getProcess", "()Ljava/lang/Process;", "getStdin", "()Ljava/io/OutputStreamWriter;", "getStdout", "()Ljava/io/BufferedReader;", "getTimeoutMsc", "()J", "dispose", "", "intellij.android.profilersAndroid"})
    private static final class ProcessHolder
    implements Disposable {
        @NotNull
        private final Process process;
        @NotNull
        private final BufferedReader stdout;
        @NotNull
        private final OutputStreamWriter stdin;
        private final long timeoutMsc;

        public void dispose() {
            this.process.destroy();
            this.process.waitFor(this.timeoutMsc, TimeUnit.MILLISECONDS);
        }

        @NotNull
        public final Process getProcess() {
            return this.process;
        }

        @NotNull
        public final BufferedReader getStdout() {
            return this.stdout;
        }

        @NotNull
        public final OutputStreamWriter getStdin() {
            return this.stdin;
        }

        public final long getTimeoutMsc() {
            return this.timeoutMsc;
        }

        public ProcessHolder(@NotNull Process process, @NotNull BufferedReader stdout, @NotNull OutputStreamWriter stdin, long timeoutMsc) {
            Intrinsics.checkNotNullParameter((Object)process, (String)"process");
            Intrinsics.checkNotNullParameter((Object)stdout, (String)"stdout");
            Intrinsics.checkNotNullParameter((Object)stdin, (String)"stdin");
            this.process = process;
            this.stdout = stdout;
            this.stdin = stdin;
            this.timeoutMsc = timeoutMsc;
        }
    }
}

