/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.perfetto.traceprocessor;

import com.android.tools.idea.profilers.perfetto.traceprocessor.HeapProfdConverter;
import com.android.tools.idea.profilers.perfetto.traceprocessor.TraceProcessorDaemonClient;
import com.android.tools.idea.profilers.perfetto.traceprocessor.TraceProcessorDaemonQueryResult;
import com.android.tools.idea.profilers.perfetto.traceprocessor.WindowsNameDemangler;
import com.android.tools.profiler.perfetto.proto.Memory;
import com.android.tools.profiler.perfetto.proto.TraceProcessor;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.cpu.systemtrace.ProcessModel;
import com.android.tools.profilers.cpu.systemtrace.SystemTraceModelAdapter;
import com.android.tools.profilers.memory.adapters.classifiers.NativeMemoryHeapSet;
import com.android.tools.profilers.perfetto.traceprocessor.TraceProcessorModel;
import com.android.tools.profilers.perfetto.traceprocessor.TraceProcessorService;
import com.android.tools.profilers.stacktrace.NativeFrameSymbolizer;
import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.google.wireless.android.sdk.stats.TraceProcessorDaemonQueryStats;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u0000 '2\u00020\u00012\u00020\u0002:\u0001'B\u0019\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J&\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J&\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\n2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J0\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010$\u001a\u00020%2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010&\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/android/tools/idea/profilers/perfetto/traceprocessor/TraceProcessorServiceImpl;", "Lcom/android/tools/profilers/perfetto/traceprocessor/TraceProcessorService;", "Lcom/intellij/openapi/Disposable;", "ticker", "Lcom/google/common/base/Ticker;", "client", "Lcom/android/tools/idea/profilers/perfetto/traceprocessor/TraceProcessorDaemonClient;", "(Lcom/google/common/base/Ticker;Lcom/android/tools/idea/profilers/perfetto/traceprocessor/TraceProcessorDaemonClient;)V", "loadedTraces", "", "", "Ljava/io/File;", "dispose", "", "executeBatchQuery", "Lcom/android/tools/idea/profilers/perfetto/traceprocessor/TraceProcessorDaemonQueryResult;", "Lcom/android/tools/profiler/perfetto/proto/TraceProcessor$QueryBatchResponse;", "traceId", "query", "Lcom/android/tools/profiler/perfetto/proto/TraceProcessor$QueryBatchRequest;", "tracker", "Lcom/android/tools/profilers/analytics/FeatureTracker;", "getProcessMetadata", "", "Lcom/android/tools/profilers/cpu/systemtrace/ProcessModel;", "loadCpuData", "Lcom/android/tools/profilers/cpu/systemtrace/SystemTraceModelAdapter;", "processIds", "", "loadMemoryData", "abi", "", "symbolizer", "Lcom/android/tools/profilers/stacktrace/NativeFrameSymbolizer;", "memorySet", "Lcom/android/tools/profilers/memory/adapters/classifiers/NativeMemoryHeapSet;", "loadTrace", "", "traceFile", "Companion", "intellij.android.profilersAndroid"})
public final class TraceProcessorServiceImpl
implements TraceProcessorService,
Disposable {
    private final Map<Long, File> loadedTraces;
    private final Ticker ticker;
    private final TraceProcessorDaemonClient client;
    private static final Logger LOGGER;
    @NotNull
    public static final Companion Companion;

    public boolean loadTrace(long traceId, @NotNull File traceFile, @NotNull FeatureTracker tracker) {
        TraceProcessor.LoadTraceRequest requestProto;
        Intrinsics.checkNotNullParameter((Object)traceFile, (String)"traceFile");
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)this.ticker);
        LOGGER.info("TPD Service: Loading trace " + traceId + ": " + traceFile.getAbsolutePath());
        TraceProcessor.LoadTraceRequest loadTraceRequest = requestProto = TraceProcessor.LoadTraceRequest.newBuilder().setTraceId(traceId).setTracePath(traceFile.getAbsolutePath()).build();
        Intrinsics.checkNotNullExpressionValue((Object)loadTraceRequest, (String)"requestProto");
        TraceProcessorDaemonQueryResult<TraceProcessor.LoadTraceResponse> queryResult = this.client.loadTrace(loadTraceRequest, tracker);
        stopwatch.stop();
        long queryTimeMs = stopwatch.elapsed(TimeUnit.MILLISECONDS);
        long traceSizeBytes = traceFile.length();
        if (!queryResult.getCompleted()) {
            tracker.trackTraceProcessorLoadTrace(TraceProcessorDaemonQueryStats.QueryReturnStatus.QUERY_FAILED, queryTimeMs, queryTimeMs, traceSizeBytes);
            Exception exception = queryResult.getFailure();
            Intrinsics.checkNotNull((Object)exception);
            Exception failureReason = exception;
            LOGGER.warn("TPD Service: Fail to load trace " + traceId + ": " + failureReason.getMessage());
            throw (Throwable)new RuntimeException("TPD Service: Fail to load trace " + traceId + ": " + failureReason.getMessage(), failureReason);
        }
        TraceProcessor.LoadTraceResponse loadTraceResponse = queryResult.getResponse();
        Intrinsics.checkNotNull((Object)loadTraceResponse);
        TraceProcessor.LoadTraceResponse response = loadTraceResponse;
        TraceProcessorDaemonQueryStats.QueryReturnStatus queryStatus = response.getOk() ? TraceProcessorDaemonQueryStats.QueryReturnStatus.OK : TraceProcessorDaemonQueryStats.QueryReturnStatus.QUERY_ERROR;
        tracker.trackTraceProcessorLoadTrace(queryStatus, queryTimeMs, queryTimeMs, traceSizeBytes);
        if (response.getOk()) {
            LOGGER.info("TPD Service: Trace " + traceId + " loaded.");
            this.loadedTraces.put(traceId, traceFile);
            return true;
        }
        LOGGER.info("TPD Service: Error loading trace " + traceId + ": " + response.getError());
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ProcessModel> getProcessMetadata(long traceId, @NotNull FeatureTracker tracker) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Object element$iv2;
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        Stopwatch methodStopwatch = Stopwatch.createStarted((Ticker)this.ticker);
        TraceProcessor.QueryBatchRequest query = TraceProcessor.QueryBatchRequest.newBuilder().addQuery(TraceProcessor.QueryParameters.newBuilder().setTraceId(traceId).setProcessMetadataRequest(TraceProcessor.QueryParameters.ProcessMetadataParameters.getDefaultInstance())).build();
        LOGGER.info("TPD Service: Querying process metadata for trace " + traceId + '.');
        Stopwatch queryStopwatch = Stopwatch.createStarted((Ticker)this.ticker);
        TraceProcessor.QueryBatchRequest queryBatchRequest2 = query;
        Intrinsics.checkNotNullExpressionValue((Object)queryBatchRequest2, (String)"query");
        TraceProcessorDaemonQueryResult<TraceProcessor.QueryBatchResponse> queryResult = this.executeBatchQuery(traceId, queryBatchRequest2, tracker);
        queryStopwatch.stop();
        long queryTimeMs = queryStopwatch.elapsed(TimeUnit.MILLISECONDS);
        if (!queryResult.getCompleted()) {
            methodStopwatch.stop();
            long methodTimeMs = methodStopwatch.elapsed(TimeUnit.MILLISECONDS);
            tracker.trackTraceProcessorProcessMetadata(TraceProcessorDaemonQueryStats.QueryReturnStatus.QUERY_FAILED, methodTimeMs, queryTimeMs);
            Exception exception = queryResult.getFailure();
            Intrinsics.checkNotNull((Object)exception);
            Exception failureReason = exception;
            LOGGER.info("TPD Service: Fail to get process metadata for trace " + traceId + ": " + failureReason.getMessage());
            throw (Throwable)new RuntimeException("TPD Service: Fail to get process metadata for trace " + traceId + ": " + failureReason.getMessage(), failureReason);
        }
        TraceProcessor.QueryBatchResponse queryBatchResponse = queryResult.getResponse();
        Intrinsics.checkNotNull((Object)queryBatchResponse);
        TraceProcessor.QueryBatchResponse response = queryBatchResponse;
        boolean queryError = false;
        List list = response.getResultList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"response.resultList");
        Iterable $this$forEach$iv2 = list;
        boolean $i$f$forEach22 = false;
        for (Object element$iv2 : $this$forEach$iv2) {
            TraceProcessor.QueryResult it = (TraceProcessor.QueryResult)element$iv2;
            boolean bl = false;
            TraceProcessor.QueryResult queryResult2 = it;
            Intrinsics.checkNotNullExpressionValue((Object)queryResult2, (String)"it");
            if (queryResult2.getOk()) continue;
            queryError = true;
            LOGGER.warn("TPD Service: Process metadata query error - " + it.getFailureReason() + " - " + it.getError());
        }
        TraceProcessorModel.Builder modelBuilder = new TraceProcessorModel.Builder();
        List list2 = response.getResultList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"response.resultList");
        Iterable $i$f$forEach22 = list2;
        boolean $i$f$filter = false;
        element$iv2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TraceProcessor.QueryResult it = (TraceProcessor.QueryResult)element$iv$iv;
            boolean bl = false;
            if (!it.hasProcessMetadataResult()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv3 : $this$forEach$iv) {
            TraceProcessor.QueryResult it = (TraceProcessor.QueryResult)element$iv3;
            boolean bl = false;
            TraceProcessor.QueryResult queryResult3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)queryResult3, (String)"it");
            TraceProcessor.ProcessMetadataResult processMetadataResult = queryResult3.getProcessMetadataResult();
            Intrinsics.checkNotNullExpressionValue((Object)processMetadataResult, (String)"it.processMetadataResult");
            modelBuilder.addProcessMetadata(processMetadataResult);
        }
        TraceProcessorModel model2 = modelBuilder.build();
        methodStopwatch.stop();
        long methodTimeMs = methodStopwatch.elapsed(TimeUnit.MILLISECONDS);
        TraceProcessorDaemonQueryStats.QueryReturnStatus queryStatus = queryError ? TraceProcessorDaemonQueryStats.QueryReturnStatus.QUERY_ERROR : TraceProcessorDaemonQueryStats.QueryReturnStatus.OK;
        tracker.trackTraceProcessorProcessMetadata(queryStatus, methodTimeMs, queryTimeMs);
        return model2.getProcesses();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public SystemTraceModelAdapter loadCpuData(long traceId, @NotNull List<Integer> processIds, @NotNull FeatureTracker tracker) {
        void $this$forEach$iv;
        TraceProcessor.QueryResult it;
        Object element$iv$iv;
        Object $this$filterTo$iv$iv;
        Object element$iv2;
        Intrinsics.checkNotNullParameter(processIds, (String)"processIds");
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        Stopwatch methodStopwatch = Stopwatch.createStarted((Ticker)this.ticker);
        TraceProcessor.QueryBatchRequest.Builder queryBuilder = TraceProcessor.QueryBatchRequest.newBuilder().addQuery(TraceProcessor.QueryParameters.newBuilder().setTraceId(traceId).setProcessMetadataRequest(TraceProcessor.QueryParameters.ProcessMetadataParameters.getDefaultInstance())).addQuery(TraceProcessor.QueryParameters.newBuilder().setTraceId(traceId).setSchedRequest(TraceProcessor.QueryParameters.SchedulingEventsParameters.getDefaultInstance())).addQuery(TraceProcessor.QueryParameters.newBuilder().setTraceId(traceId).setCpuCoreCountersRequest(TraceProcessor.QueryParameters.CpuCoreCountersParameters.getDefaultInstance()));
        Iterator<Integer> iterator = processIds.iterator();
        while (iterator.hasNext()) {
            int id = ((Number)iterator.next()).intValue();
            queryBuilder.addQuery(TraceProcessor.QueryParameters.newBuilder().setTraceId(traceId).setTraceEventsRequest(TraceProcessor.QueryParameters.TraceEventsParameters.newBuilder().setProcessId((long)id)));
            queryBuilder.addQuery(TraceProcessor.QueryParameters.newBuilder().setTraceId(traceId).setProcessCountersRequest(TraceProcessor.QueryParameters.ProcessCountersParameters.newBuilder().setProcessId((long)id)));
        }
        LOGGER.info("TPD Service: Querying cpu data for trace " + traceId + '.');
        Stopwatch queryStopwatch = Stopwatch.createStarted((Ticker)this.ticker);
        TraceProcessor.QueryBatchRequest queryBatchRequest2 = queryBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)queryBatchRequest2, (String)"queryBuilder.build()");
        TraceProcessorDaemonQueryResult<TraceProcessor.QueryBatchResponse> queryResult = this.executeBatchQuery(traceId, queryBatchRequest2, tracker);
        queryStopwatch.stop();
        long queryTimeMs = queryStopwatch.elapsed(TimeUnit.MILLISECONDS);
        if (!queryResult.getCompleted()) {
            methodStopwatch.stop();
            long methodTimeMs = methodStopwatch.elapsed(TimeUnit.MILLISECONDS);
            tracker.trackTraceProcessorCpuData(TraceProcessorDaemonQueryStats.QueryReturnStatus.QUERY_FAILED, methodTimeMs, queryTimeMs);
            Exception exception = queryResult.getFailure();
            Intrinsics.checkNotNull((Object)exception);
            Exception failureReason = exception;
            LOGGER.info("TPD Service: Fail to get cpu data for trace " + traceId + ": " + failureReason.getMessage());
            throw (Throwable)new RuntimeException("TPD Service: Fail to get cpu data for trace " + traceId + ": " + failureReason.getMessage(), failureReason);
        }
        TraceProcessor.QueryBatchResponse queryBatchResponse = queryResult.getResponse();
        Intrinsics.checkNotNull((Object)queryBatchResponse);
        TraceProcessor.QueryBatchResponse response = queryBatchResponse;
        boolean queryError = false;
        List list = response.getResultList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"response.resultList");
        Iterable $this$forEach$iv2 = list;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv2) {
            TraceProcessor.QueryResult it2 = (TraceProcessor.QueryResult)element$iv2;
            boolean bl = false;
            TraceProcessor.QueryResult queryResult2 = it2;
            Intrinsics.checkNotNullExpressionValue((Object)queryResult2, (String)"it");
            if (queryResult2.getOk()) continue;
            queryError = true;
            LOGGER.warn("TPD Service: Load cpu data query error - " + it2.getFailureReason() + " - " + it2.getError());
        }
        TraceProcessorModel.Builder modelBuilder = new TraceProcessorModel.Builder();
        List list2 = response.getResultList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"response.resultList");
        Iterable $this$filter$iv = list2;
        boolean $i$f$filter = false;
        element$iv2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv$iv = iterator2.next();
            it = (TraceProcessor.QueryResult)element$iv$iv;
            boolean bl = false;
            if (!it.hasProcessMetadataResult()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv3 : $this$forEach$iv) {
            TraceProcessor.QueryResult it3 = (TraceProcessor.QueryResult)element$iv3;
            boolean bl = false;
            TraceProcessor.QueryResult queryResult3 = it3;
            Intrinsics.checkNotNullExpressionValue((Object)queryResult3, (String)"it");
            TraceProcessor.ProcessMetadataResult processMetadataResult = queryResult3.getProcessMetadataResult();
            Intrinsics.checkNotNullExpressionValue((Object)processMetadataResult, (String)"it.processMetadataResult");
            modelBuilder.addProcessMetadata(processMetadataResult);
        }
        List list3 = response.getResultList();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"response.resultList");
        $this$filter$iv = list3;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        Iterator bl = $this$filterTo$iv$iv.iterator();
        while (bl.hasNext()) {
            element$iv$iv = bl.next();
            it = (TraceProcessor.QueryResult)element$iv$iv;
            boolean bl2 = false;
            if (!it.hasTraceEventsResult()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$forEach2 = false;
        for (Object element$iv3 : $this$forEach$iv) {
            TraceProcessor.QueryResult it4 = (TraceProcessor.QueryResult)element$iv3;
            boolean bl3 = false;
            TraceProcessor.QueryResult queryResult4 = it4;
            Intrinsics.checkNotNullExpressionValue((Object)queryResult4, (String)"it");
            TraceProcessor.TraceEventsResult traceEventsResult = queryResult4.getTraceEventsResult();
            Intrinsics.checkNotNullExpressionValue((Object)traceEventsResult, (String)"it.traceEventsResult");
            modelBuilder.addTraceEvents(traceEventsResult);
        }
        List list4 = response.getResultList();
        Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"response.resultList");
        $this$filter$iv = list4;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        Iterator bl3 = $this$filterTo$iv$iv.iterator();
        while (bl3.hasNext()) {
            element$iv$iv = bl3.next();
            it = (TraceProcessor.QueryResult)element$iv$iv;
            boolean bl4 = false;
            if (!it.hasSchedResult()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$forEach2 = false;
        for (Object element$iv3 : $this$forEach$iv) {
            TraceProcessor.QueryResult it5 = (TraceProcessor.QueryResult)element$iv3;
            boolean bl5 = false;
            TraceProcessor.QueryResult queryResult5 = it5;
            Intrinsics.checkNotNullExpressionValue((Object)queryResult5, (String)"it");
            TraceProcessor.SchedulingEventsResult schedulingEventsResult = queryResult5.getSchedResult();
            Intrinsics.checkNotNullExpressionValue((Object)schedulingEventsResult, (String)"it.schedResult");
            modelBuilder.addSchedulingEvents(schedulingEventsResult);
        }
        List list5 = response.getResultList();
        Intrinsics.checkNotNullExpressionValue((Object)list5, (String)"response.resultList");
        $this$filter$iv = list5;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        Iterator bl5 = $this$filterTo$iv$iv.iterator();
        while (bl5.hasNext()) {
            element$iv$iv = bl5.next();
            it = (TraceProcessor.QueryResult)element$iv$iv;
            boolean bl6 = false;
            if (!it.hasCpuCoreCountersResult()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$forEach2 = false;
        for (Object element$iv3 : $this$forEach$iv) {
            TraceProcessor.QueryResult it6 = (TraceProcessor.QueryResult)element$iv3;
            boolean bl7 = false;
            TraceProcessor.QueryResult queryResult6 = it6;
            Intrinsics.checkNotNullExpressionValue((Object)queryResult6, (String)"it");
            TraceProcessor.CpuCoreCountersResult cpuCoreCountersResult = queryResult6.getCpuCoreCountersResult();
            Intrinsics.checkNotNullExpressionValue((Object)cpuCoreCountersResult, (String)"it.cpuCoreCountersResult");
            modelBuilder.addCpuCounters(cpuCoreCountersResult);
        }
        List list6 = response.getResultList();
        Intrinsics.checkNotNullExpressionValue((Object)list6, (String)"response.resultList");
        $this$filter$iv = list6;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        Iterator bl7 = $this$filterTo$iv$iv.iterator();
        while (bl7.hasNext()) {
            element$iv$iv = bl7.next();
            it = (TraceProcessor.QueryResult)element$iv$iv;
            boolean bl8 = false;
            if (!it.hasProcessCountersResult()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$forEach2 = false;
        for (Object element$iv3 : $this$forEach$iv) {
            TraceProcessor.QueryResult it7 = (TraceProcessor.QueryResult)element$iv3;
            boolean bl9 = false;
            TraceProcessor.QueryResult queryResult7 = it7;
            Intrinsics.checkNotNullExpressionValue((Object)queryResult7, (String)"it");
            TraceProcessor.ProcessCountersResult processCountersResult = queryResult7.getProcessCountersResult();
            Intrinsics.checkNotNullExpressionValue((Object)processCountersResult, (String)"it.processCountersResult");
            modelBuilder.addProcessCounters(processCountersResult);
        }
        TraceProcessorModel model2 = modelBuilder.build();
        methodStopwatch.stop();
        long methodTimeMs = methodStopwatch.elapsed(TimeUnit.MILLISECONDS);
        TraceProcessorDaemonQueryStats.QueryReturnStatus queryStatus = queryError ? TraceProcessorDaemonQueryStats.QueryReturnStatus.QUERY_ERROR : TraceProcessorDaemonQueryStats.QueryReturnStatus.OK;
        tracker.trackTraceProcessorCpuData(queryStatus, methodTimeMs, queryTimeMs);
        return (SystemTraceModelAdapter)model2;
    }

    public void loadMemoryData(long traceId, @NotNull String abi, @NotNull NativeFrameSymbolizer symbolizer, @NotNull NativeMemoryHeapSet memorySet, @NotNull FeatureTracker tracker) {
        Iterator $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)abi, (String)"abi");
        Intrinsics.checkNotNullParameter((Object)symbolizer, (String)"symbolizer");
        Intrinsics.checkNotNullParameter((Object)memorySet, (String)"memorySet");
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        Stopwatch methodStopwatch = Stopwatch.createStarted((Ticker)this.ticker);
        HeapProfdConverter converter = new HeapProfdConverter(abi, symbolizer, memorySet, new WindowsNameDemangler(0L, 1, null));
        TraceProcessor.QueryBatchRequest query = TraceProcessor.QueryBatchRequest.newBuilder().addQuery(TraceProcessor.QueryParameters.newBuilder().setTraceId(traceId).setMemoryRequest(Memory.AllocationDataRequest.getDefaultInstance())).build();
        LOGGER.info("TPD Service: Querying process metadata for trace " + traceId + '.');
        Stopwatch queryStopwatch = Stopwatch.createStarted((Ticker)this.ticker);
        TraceProcessor.QueryBatchRequest queryBatchRequest2 = query;
        Intrinsics.checkNotNullExpressionValue((Object)queryBatchRequest2, (String)"query");
        TraceProcessorDaemonQueryResult<TraceProcessor.QueryBatchResponse> queryResult = this.executeBatchQuery(traceId, queryBatchRequest2, tracker);
        queryStopwatch.stop();
        long queryTimeMs = queryStopwatch.elapsed(TimeUnit.MILLISECONDS);
        if (!queryResult.getCompleted()) {
            methodStopwatch.stop();
            long methodTimeMs = methodStopwatch.elapsed(TimeUnit.MILLISECONDS);
            tracker.trackTraceProcessorMemoryData(TraceProcessorDaemonQueryStats.QueryReturnStatus.QUERY_FAILED, methodTimeMs, queryTimeMs);
            Exception exception = queryResult.getFailure();
            Intrinsics.checkNotNull((Object)exception);
            Exception failureReason = exception;
            LOGGER.info("TPD Service: Fail to get memory data for trace " + traceId + ": " + failureReason.getMessage());
            throw (Throwable)new RuntimeException("TPD Service: Fail to get memory data for trace " + traceId + ": " + failureReason.getMessage(), failureReason);
        }
        TraceProcessor.QueryBatchResponse queryBatchResponse = queryResult.getResponse();
        Intrinsics.checkNotNull((Object)queryBatchResponse);
        TraceProcessor.QueryBatchResponse response = queryBatchResponse;
        boolean queryError = false;
        List list = response.getResultList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"response.resultList");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TraceProcessor.QueryResult it = (TraceProcessor.QueryResult)element$iv;
            boolean bl = false;
            TraceProcessor.QueryResult queryResult2 = it;
            Intrinsics.checkNotNullExpressionValue((Object)queryResult2, (String)"it");
            if (queryResult2.getOk()) continue;
            queryError = true;
            LOGGER.warn("TPD Service: Load memory data query error - " + it.getFailureReason() + " - " + it.getError());
        }
        List list2 = response.getResultList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"response.resultList");
        Iterable $this$filter$iv = list2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator bl = $this$filterTo$iv$iv.iterator();
        while (bl.hasNext()) {
            Object element$iv$iv = bl.next();
            TraceProcessor.QueryResult it = (TraceProcessor.QueryResult)element$iv$iv;
            boolean bl2 = false;
            if (!it.hasMemoryEvents()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TraceProcessor.QueryResult it = (TraceProcessor.QueryResult)element$iv;
            boolean bl3 = false;
            TraceProcessor.QueryResult queryResult3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)queryResult3, (String)"it");
            Memory.NativeAllocationContext nativeAllocationContext = queryResult3.getMemoryEvents();
            Intrinsics.checkNotNullExpressionValue((Object)nativeAllocationContext, (String)"it.memoryEvents");
            converter.populateHeapSet(nativeAllocationContext);
        }
        methodStopwatch.stop();
        long methodTimeMs = methodStopwatch.elapsed(TimeUnit.MILLISECONDS);
        TraceProcessorDaemonQueryStats.QueryReturnStatus queryStatus = queryError ? TraceProcessorDaemonQueryStats.QueryReturnStatus.QUERY_ERROR : TraceProcessorDaemonQueryStats.QueryReturnStatus.OK;
        tracker.trackTraceProcessorMemoryData(queryStatus, methodTimeMs, queryTimeMs);
    }

    private final TraceProcessorDaemonQueryResult<TraceProcessor.QueryBatchResponse> executeBatchQuery(long traceId, TraceProcessor.QueryBatchRequest query, FeatureTracker tracker) {
        TraceProcessorDaemonQueryResult<TraceProcessor.QueryBatchResponse> queryResult = this.client.queryBatchRequest(query, tracker);
        Object object = queryResult.getResponse();
        if (object != null && (object = object.getResultList()) != null) {
            boolean bl;
            block7: {
                Iterable $this$any$iv = (Iterable)object;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        TraceProcessor.QueryResult it = (TraceProcessor.QueryResult)element$iv;
                        boolean bl2 = false;
                        TraceProcessor.QueryResult queryResult2 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)queryResult2, (String)"it");
                        if (!(queryResult2.getFailureReason() == TraceProcessor.QueryResult.QueryFailureReason.TRACE_NOT_FOUND)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            if (bl) {
                File loadedTrace = this.loadedTraces.get(traceId);
                if (loadedTrace != null) {
                    this.loadTrace(traceId, loadedTrace, tracker);
                    queryResult = this.client.queryBatchRequest(query, tracker);
                } else {
                    return new TraceProcessorDaemonQueryResult<TraceProcessor.QueryBatchResponse>(new IllegalStateException("Trace " + traceId + " needs to be loaded before querying."));
                }
            }
        }
        return queryResult;
    }

    public void dispose() {
    }

    public TraceProcessorServiceImpl(@NotNull Ticker ticker2, @NotNull TraceProcessorDaemonClient client) {
        Intrinsics.checkNotNullParameter((Object)ticker2, (String)"ticker");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.ticker = ticker2;
        this.client = client;
        boolean bl = false;
        this.loadedTraces = new LinkedHashMap();
        Disposer.register((Disposable)this, (Disposable)this.client);
    }

    public /* synthetic */ TraceProcessorServiceImpl(Ticker ticker2, TraceProcessorDaemonClient traceProcessorDaemonClient, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            Ticker ticker3 = Ticker.systemTicker();
            Intrinsics.checkNotNullExpressionValue((Object)ticker3, (String)"Ticker.systemTicker()");
            ticker2 = ticker3;
        }
        if ((n & 2) != 0) {
            traceProcessorDaemonClient = new TraceProcessorDaemonClient(ticker2);
        }
        this(ticker2, traceProcessorDaemonClient);
    }

    public TraceProcessorServiceImpl() {
        this(null, null, 3, null);
    }

    static {
        Companion = new Companion(null);
        Logger logger2 = Logger.getInstance(TraceProcessorServiceImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(Trace\u2026rServiceImpl::class.java)");
        LOGGER = logger2;
    }

    @JvmStatic
    @NotNull
    public static final TraceProcessorService getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/profilers/perfetto/traceprocessor/TraceProcessorServiceImpl$Companion;", "", "()V", "LOGGER", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lcom/android/tools/profilers/perfetto/traceprocessor/TraceProcessorService;", "intellij.android.profilersAndroid"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final TraceProcessorService getInstance() {
            Object object = ApplicationManager.getApplication().getService(TraceProcessorServiceImpl.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ApplicationManager.getAp\u2026rServiceImpl::class.java)");
            return (TraceProcessorService)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

