/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.perfetto.traceprocessor;

import com.android.tools.idea.profilers.perfetto.traceprocessor.TraceProcessorDaemonManager;
import com.android.tools.idea.transport.DeployableFile;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00162\u00020\u0001:\u0003\u0016\u0017\u0018B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\rH\u0007R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/profilers/perfetto/traceprocessor/TraceProcessorDaemonManager;", "Lcom/intellij/openapi/Disposable;", "ticker", "Lcom/google/common/base/Ticker;", "executorService", "Ljava/util/concurrent/ExecutorService;", "(Lcom/google/common/base/Ticker;Ljava/util/concurrent/ExecutorService;)V", "<set-?>", "", "daemonPort", "getDaemonPort", "()I", "disposed", "", "process", "Ljava/lang/Process;", "dispose", "", "makeSureDaemonIsRunning", "tracker", "Lcom/android/tools/profilers/analytics/FeatureTracker;", "processIsRunning", "Companion", "DaemonStatus", "TPDStdoutListener", "intellij.android.profilersAndroid"})
public final class TraceProcessorDaemonManager
implements Disposable {
    private Process process;
    private boolean disposed;
    private int daemonPort;
    private final Ticker ticker;
    private final ExecutorService executorService;
    @Deprecated
    private static final Logger LOGGER;
    @Deprecated
    private static final long TPD_SPAWN_TIMEOUT;
    @Deprecated
    private static final Pattern SERVER_STARTED;
    @Deprecated
    private static final String SERVER_PORT_BIND_FAILED = "Server failed to start. A port number wasn't bound.";
    @Deprecated
    private static final Lazy TPD_DEV_PATH$delegate;
    @Deprecated
    private static final String TPD_RELEASE_PATH;
    @Deprecated
    private static final Lazy TPD_EXECUTABLE$delegate;
    @Deprecated
    private static final DeployableFile TPD_BINARY;
    @NotNull
    private static final Companion Companion;

    public final int getDaemonPort() {
        return this.daemonPort;
    }

    @VisibleForTesting
    public final boolean processIsRunning() {
        Process process = this.process;
        return process != null ? process.isAlive() : false;
    }

    public final synchronized void makeSureDaemonIsRunning(@NotNull FeatureTracker tracker) {
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        if (!this.processIsRunning() && !this.disposed) {
            Process newProcess;
            Stopwatch spawnStopwatch = Stopwatch.createStarted((Ticker)this.ticker);
            LOGGER.info("TPD Manager: Starting new instance of TPD");
            Process process = newProcess = new ProcessBuilder(TraceProcessorDaemonManager.Companion.getExecutablePath()).redirectErrorStream(true).start();
            Intrinsics.checkNotNullExpressionValue((Object)process, (String)"newProcess");
            TPDStdoutListener stdoutListener = new TPDStdoutListener(new BufferedReader(new InputStreamReader(process.getInputStream())));
            this.executorService.execute(stdoutListener);
            stdoutListener.waitForRunningOrFailed(TPD_SPAWN_TIMEOUT);
            spawnStopwatch.stop();
            long timeToSpawnMs = spawnStopwatch.elapsed(TimeUnit.MILLISECONDS);
            if (stdoutListener.getStatus() == DaemonStatus.RUNNING) {
                tracker.trackTraceProcessorDaemonSpawnAttempt(true, timeToSpawnMs);
                this.daemonPort = stdoutListener.getSelectedPort();
                this.process = newProcess;
                LOGGER.info("TPD Manager: TPD instance ready on port " + this.daemonPort + '.');
            } else {
                tracker.trackTraceProcessorDaemonSpawnAttempt(false, timeToSpawnMs);
                LOGGER.info("TPD Manager: Unable to start TPD instance.");
                Process process2 = newProcess.destroyForcibly();
                if (process2 != null) {
                    process2.waitFor();
                }
                throw (Throwable)new RuntimeException("Unable to start TPD instance.");
            }
        }
    }

    public synchronized void dispose() {
        block0: {
            this.disposed = true;
            Process process = this.process;
            if (process == null || (process = process.destroyForcibly()) == null) break block0;
            process.waitFor();
        }
    }

    public TraceProcessorDaemonManager(@NotNull Ticker ticker2, @NotNull ExecutorService executorService) {
        Intrinsics.checkNotNullParameter((Object)ticker2, (String)"ticker");
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        this.ticker = ticker2;
        this.executorService = executorService;
    }

    public /* synthetic */ TraceProcessorDaemonManager(Ticker ticker2, ExecutorService executorService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            ExecutorService executorService2 = Executors.newSingleThreadExecutor();
            Intrinsics.checkNotNullExpressionValue((Object)executorService2, (String)"Executors.newSingleThreadExecutor()");
            executorService = executorService2;
        }
        this(ticker2, executorService);
    }

    static {
        Companion = new Companion(null);
        Logger logger2 = Logger.getInstance(TraceProcessorDaemonManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(Trace\u2026aemonManager::class.java)");
        LOGGER = logger2;
        TPD_SPAWN_TIMEOUT = TimeUnit.MINUTES.toMillis(1L);
        SERVER_STARTED = Pattern.compile("^Server listening on (?:127.0.0.1|localhost):(?<port>\\d+)\n*$");
        TPD_DEV_PATH$delegate = LazyKt.lazy((Function0)Companion.TPD_DEV_PATH.2.INSTANCE);
        TPD_RELEASE_PATH = "plugins/android/resources/trace_processor_daemon";
        TPD_EXECUTABLE$delegate = LazyKt.lazy((Function0)Companion.TPD_EXECUTABLE.2.INSTANCE);
        DeployableFile deployableFile = new DeployableFile.Builder(TraceProcessorDaemonManager.Companion.getTPD_EXECUTABLE()).setReleaseDir(TPD_RELEASE_PATH).setDevDir(TraceProcessorDaemonManager.Companion.getTPD_DEV_PATH()).setExecutable(true).build();
        Intrinsics.checkNotNullExpressionValue((Object)deployableFile, (String)"DeployableFile.Builder(T\u2026able(true)\n      .build()");
        TPD_BINARY = deployableFile;
    }

    @VisibleForTesting
    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0087\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/profilers/perfetto/traceprocessor/TraceProcessorDaemonManager$DaemonStatus;", "", "(Ljava/lang/String;I)V", "STARTING", "RUNNING", "FAILED", "END_OF_STREAM", "intellij.android.profilersAndroid"})
    public static final class DaemonStatus
    extends Enum<DaemonStatus> {
        public static final /* enum */ DaemonStatus STARTING;
        public static final /* enum */ DaemonStatus RUNNING;
        public static final /* enum */ DaemonStatus FAILED;
        public static final /* enum */ DaemonStatus END_OF_STREAM;
        private static final /* synthetic */ DaemonStatus[] $VALUES;

        static {
            DaemonStatus[] daemonStatusArray = new DaemonStatus[4];
            DaemonStatus[] daemonStatusArray2 = daemonStatusArray;
            daemonStatusArray[0] = STARTING = new DaemonStatus();
            daemonStatusArray[1] = RUNNING = new DaemonStatus();
            daemonStatusArray[2] = FAILED = new DaemonStatus();
            daemonStatusArray[3] = END_OF_STREAM = new DaemonStatus();
            $VALUES = daemonStatusArray;
        }

        public static DaemonStatus[] values() {
            return (DaemonStatus[])$VALUES.clone();
        }

        public static DaemonStatus valueOf(String string) {
            return Enum.valueOf(DaemonStatus.class, string);
        }
    }

    @VisibleForTesting
    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u000e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR$\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/profilers/perfetto/traceprocessor/TraceProcessorDaemonManager$TPDStdoutListener;", "Ljava/lang/Runnable;", "outputReader", "Ljava/io/BufferedReader;", "(Ljava/io/BufferedReader;)V", "<set-?>", "", "selectedPort", "getSelectedPort", "()I", "newStatus", "Lcom/android/tools/idea/profilers/perfetto/traceprocessor/TraceProcessorDaemonManager$DaemonStatus;", "status", "getStatus", "()Lcom/android/tools/idea/profilers/perfetto/traceprocessor/TraceProcessorDaemonManager$DaemonStatus;", "setStatus", "(Lcom/android/tools/idea/profilers/perfetto/traceprocessor/TraceProcessorDaemonManager$DaemonStatus;)V", "statusLock", "Ljava/lang/Object;", "run", "", "waitForRunningOrFailed", "timeout", "", "intellij.android.profilersAndroid"})
    public static final class TPDStdoutListener
    implements Runnable {
        private final Object statusLock;
        @NotNull
        private DaemonStatus status;
        private int selectedPort;
        private final BufferedReader outputReader;

        @NotNull
        public final DaemonStatus getStatus() {
            return this.status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void setStatus(DaemonStatus newStatus) {
            Object object = this.statusLock;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (object) {
                boolean bl3 = false;
                Companion;
                LOGGER.debug("TPD Manager: Daemon status: " + (Object)((Object)newStatus));
                this.status = newStatus;
                this.statusLock.notifyAll();
                Unit unit = Unit.INSTANCE;
            }
        }

        public final int getSelectedPort() {
            return this.selectedPort;
        }

        @Override
        public void run() {
            block3: {
                String line2;
                do {
                    if ((line2 = this.outputReader.readLine()) == null) {
                        Companion;
                        LOGGER.debug("TPD Manager: [TPD Log] EOF");
                        this.setStatus(DaemonStatus.END_OF_STREAM);
                        break block3;
                    }
                    Companion;
                    LOGGER.debug("TPD Manager: [TPD Log] " + line2);
                    Companion;
                    Matcher serverOkMatcher = SERVER_STARTED.matcher(line2);
                    if (serverOkMatcher.matches()) {
                        String string = serverOkMatcher.group("port");
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"serverOkMatcher.group(\"port\")");
                        String string2 = string;
                        boolean bl = false;
                        this.selectedPort = Integer.parseInt(string2);
                        this.setStatus(DaemonStatus.RUNNING);
                        break block3;
                    }
                    Companion;
                } while (!StringsKt.startsWith$default((String)line2, (String)TraceProcessorDaemonManager.SERVER_PORT_BIND_FAILED, (boolean)false, (int)2, null));
                this.setStatus(DaemonStatus.FAILED);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void waitForRunningOrFailed(long timeout) {
            Object object = this.statusLock;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (object) {
                boolean bl3 = false;
                if (this.status == DaemonStatus.STARTING) {
                    this.statusLock.wait(timeout);
                }
                Unit unit = Unit.INSTANCE;
            }
        }

        public TPDStdoutListener(@NotNull BufferedReader outputReader) {
            Intrinsics.checkNotNullParameter((Object)outputReader, (String)"outputReader");
            this.outputReader = outputReader;
            this.statusLock = new Object();
            this.status = DaemonStatus.STARTING;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0018\u001a\u00020\u0007H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0012\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0011\u001a\u0004\b\u0013\u0010\u000fR\u000e\u0010\u0015\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/profilers/perfetto/traceprocessor/TraceProcessorDaemonManager$Companion;", "", "()V", "LOGGER", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "SERVER_PORT_BIND_FAILED", "", "SERVER_STARTED", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "TPD_BINARY", "Lcom/android/tools/idea/transport/DeployableFile;", "TPD_DEV_PATH", "getTPD_DEV_PATH", "()Ljava/lang/String;", "TPD_DEV_PATH$delegate", "Lkotlin/Lazy;", "TPD_EXECUTABLE", "getTPD_EXECUTABLE", "TPD_EXECUTABLE$delegate", "TPD_RELEASE_PATH", "TPD_SPAWN_TIMEOUT", "", "getExecutablePath", "intellij.android.profilersAndroid"})
    private static final class Companion {
        private final String getTPD_DEV_PATH() {
            Lazy lazy = TPD_DEV_PATH$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return (String)lazy.getValue();
        }

        private final String getTPD_EXECUTABLE() {
            Lazy lazy = TPD_EXECUTABLE$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return (String)lazy.getValue();
        }

        private final String getExecutablePath() {
            String string = new File(TPD_BINARY.getDir(), TPD_BINARY.getFileName()).getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"File(TPD_BINARY.dir, TPD\u2026RY.fileName).absolutePath");
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

