/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.commands;

import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.profilers.LegacyCpuProfilingHandler;
import com.android.tools.idea.profilers.LegacyCpuTraceRecord;
import com.android.tools.idea.profilers.commands.LegacyCpuTraceCommandHandler$WhenMappings;
import com.android.tools.idea.protobuf.ByteString;
import com.android.tools.idea.transport.TransportProxy;
import com.android.tools.profiler.proto.Commands;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profiler.proto.TransportServiceGrpc;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.diagnostic.Logger;
import io.grpc.StatusRuntimeException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0015H\u0002J\b\u0010&\u001a\u00020'H\u0002J\u0018\u0010(\u001a\u00020)2\u0006\u0010!\u001a\u00020\"2\u0006\u0010*\u001a\u00020+H\u0002J\u0018\u0010,\u001a\u00020)2\u0006\u0010!\u001a\u00020\"2\u0006\u0010-\u001a\u00020.H\u0002J\u0018\u0010/\u001a\u00020)2\u0006\u0010!\u001a\u00020\"2\u0006\u0010*\u001a\u000200H\u0002J\u0018\u00101\u001a\u00020)2\u0006\u0010!\u001a\u00020\"2\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u00102\u001a\u0002032\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u00104\u001a\u00020)2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u00105\u001a\u00020)2\u0006\u0010!\u001a\u00020\"H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R*\u0010\u0012\u001a\u001e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013j\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0015`\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0017\u001a\u00020\u00188\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u00066"}, d2={"Lcom/android/tools/idea/profilers/commands/LegacyCpuTraceCommandHandler;", "Lcom/android/tools/idea/transport/TransportProxy$ProxyCommandHandler;", "device", "Lcom/android/ddmlib/IDevice;", "transportStub", "Lcom/android/tools/profiler/proto/TransportServiceGrpc$TransportServiceBlockingStub;", "eventQueue", "Ljava/util/concurrent/BlockingDeque;", "Lcom/android/tools/profiler/proto/Common$Event;", "byteCache", "", "", "Lcom/android/tools/idea/protobuf/ByteString;", "(Lcom/android/ddmlib/IDevice;Lcom/android/tools/profiler/proto/TransportServiceGrpc$TransportServiceBlockingStub;Ljava/util/concurrent/BlockingDeque;Ljava/util/Map;)V", "getDevice", "()Lcom/android/ddmlib/IDevice;", "getEventQueue", "()Ljava/util/concurrent/BlockingDeque;", "legacyProfilingRecord", "Ljava/util/HashMap;", "", "Lcom/android/tools/idea/profilers/LegacyCpuTraceRecord;", "Lkotlin/collections/HashMap;", "profilingHandler", "Lcom/android/tools/idea/profilers/LegacyCpuProfilingHandler;", "getProfilingHandler$intellij_android_profilersAndroid$annotations", "()V", "getProfilingHandler$intellij_android_profilersAndroid", "()Lcom/android/tools/idea/profilers/LegacyCpuProfilingHandler;", "getTransportStub", "()Lcom/android/tools/profiler/proto/TransportServiceGrpc$TransportServiceBlockingStub;", "execute", "Lcom/android/tools/profiler/proto/Transport$ExecuteResponse;", "command", "Lcom/android/tools/profiler/proto/Commands$Command;", "getDeviceTimestamp", "", "record", "getLogger", "Lcom/intellij/openapi/diagnostic/Logger;", "sendStartStatusEvent", "", "startStatus", "Lcom/android/tools/profiler/proto/Cpu$TraceStartStatus;", "sendStartTraceEvent", "traceInfo", "Lcom/android/tools/profiler/proto/Cpu$CpuTraceInfo;", "sendStopStatusEvent", "Lcom/android/tools/profiler/proto/Cpu$TraceStopStatus;", "sendStopTraceEvent", "shouldHandle", "", "startTrace", "stopTrace", "intellij.android.profilersAndroid"})
public final class LegacyCpuTraceCommandHandler
implements TransportProxy.ProxyCommandHandler {
    private final HashMap<Integer, LegacyCpuTraceRecord> legacyProfilingRecord;
    @NotNull
    private final LegacyCpuProfilingHandler profilingHandler;
    @NotNull
    private final IDevice device;
    @NotNull
    private final TransportServiceGrpc.TransportServiceBlockingStub transportStub;
    @NotNull
    private final BlockingDeque<Common.Event> eventQueue;

    private final Logger getLogger() {
        Logger logger2 = Logger.getInstance(LegacyCpuTraceCommandHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(Legac\u2026mmandHandler::class.java)");
        return logger2;
    }

    @VisibleForTesting
    public static /* synthetic */ void getProfilingHandler$intellij_android_profilersAndroid$annotations() {
    }

    @NotNull
    public final LegacyCpuProfilingHandler getProfilingHandler$intellij_android_profilersAndroid() {
        return this.profilingHandler;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean shouldHandle(@NotNull Commands.Command command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Commands.Command.CommandType commandType = command.getType();
        if (commandType == null) return false;
        switch (LegacyCpuTraceCommandHandler$WhenMappings.$EnumSwitchMapping$0[commandType.ordinal()]) {
            case 1: {
                Cpu.StartCpuTrace startCpuTrace = command.getStartCpuTrace();
                Intrinsics.checkNotNullExpressionValue((Object)startCpuTrace, (String)"command.startCpuTrace");
                Cpu.CpuTraceConfiguration cpuTraceConfiguration = startCpuTrace.getConfiguration();
                Intrinsics.checkNotNullExpressionValue((Object)cpuTraceConfiguration, (String)"command.startCpuTrace.configuration");
                Cpu.CpuTraceConfiguration.UserOptions userOptions = cpuTraceConfiguration.getUserOptions();
                Intrinsics.checkNotNullExpressionValue((Object)userOptions, (String)"command.startCpuTrace.configuration.userOptions");
                if (userOptions.getTraceType() != Cpu.CpuTraceType.ART) return false;
                return true;
            }
            case 2: {
                Cpu.StopCpuTrace stopCpuTrace = command.getStopCpuTrace();
                Intrinsics.checkNotNullExpressionValue((Object)stopCpuTrace, (String)"command.stopCpuTrace");
                Cpu.CpuTraceConfiguration cpuTraceConfiguration = stopCpuTrace.getConfiguration();
                Intrinsics.checkNotNullExpressionValue((Object)cpuTraceConfiguration, (String)"command.stopCpuTrace.configuration");
                Cpu.CpuTraceConfiguration.UserOptions userOptions = cpuTraceConfiguration.getUserOptions();
                Intrinsics.checkNotNullExpressionValue((Object)userOptions, (String)"command.stopCpuTrace.configuration.userOptions");
                if (userOptions.getTraceType() != Cpu.CpuTraceType.ART) return false;
                return true;
            }
            default: {
                return false;
            }
        }
    }

    @Override
    @NotNull
    public Transport.ExecuteResponse execute(@NotNull Commands.Command command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Commands.Command.CommandType commandType = command.getType();
        if (commandType != null) {
            switch (LegacyCpuTraceCommandHandler$WhenMappings.$EnumSwitchMapping$1[commandType.ordinal()]) {
                case 1: {
                    this.startTrace(command);
                    break;
                }
                case 2: {
                    this.stopTrace(command);
                    break;
                }
            }
        }
        Transport.ExecuteResponse executeResponse = Transport.ExecuteResponse.getDefaultInstance();
        Intrinsics.checkNotNullExpressionValue((Object)executeResponse, (String)"Transport.ExecuteResponse.getDefaultInstance()");
        return executeResponse;
    }

    private final void startTrace(Commands.Command command) {
        Client client;
        Cpu.CpuTraceConfiguration.UserOptions userOptions;
        Cpu.CpuTraceConfiguration traceConfiguration;
        Cpu.StartCpuTrace startCpuTrace = command.getStartCpuTrace();
        Intrinsics.checkNotNullExpressionValue((Object)startCpuTrace, (String)"command.startCpuTrace");
        Cpu.CpuTraceConfiguration cpuTraceConfiguration = traceConfiguration = startCpuTrace.getConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)cpuTraceConfiguration, (String)"traceConfiguration");
        Cpu.CpuTraceConfiguration.UserOptions userOptions2 = userOptions = cpuTraceConfiguration.getUserOptions();
        Intrinsics.checkNotNullExpressionValue((Object)userOptions2, (String)"userOptions");
        boolean bl = userOptions2.getTraceType() == Cpu.CpuTraceType.ART;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        int pid = command.getPid();
        String appPkgName = this.device.getClientName(pid);
        Client client2 = client = appPkgName != null ? this.device.getClient(appPkgName) : null;
        if (client == null) {
            Cpu.TraceStartStatus status;
            Cpu.TraceStartStatus.Builder builder2 = Cpu.TraceStartStatus.newBuilder();
            boolean bl5 = false;
            boolean bl6 = false;
            Cpu.TraceStartStatus.Builder $this$apply = builder2;
            boolean bl7 = false;
            $this$apply.setStatus(Cpu.TraceStartStatus.Status.FAILURE);
            $this$apply.setErrorMessage("App is not running");
            Cpu.TraceStartStatus traceStartStatus = status = builder2.build();
            Intrinsics.checkNotNullExpressionValue((Object)traceStartStatus, (String)"status");
            this.sendStartStatusEvent(command, traceStartStatus);
        } else if (!LegacyCpuTraceRecord.Companion.isMethodProfilingStatusOff(this.legacyProfilingRecord.get(pid), client)) {
            Cpu.TraceStartStatus status;
            Cpu.TraceStartStatus.Builder builder3 = Cpu.TraceStartStatus.newBuilder();
            boolean bl8 = false;
            boolean bl9 = false;
            Cpu.TraceStartStatus.Builder $this$apply = builder3;
            boolean bl10 = false;
            $this$apply.setStatus(Cpu.TraceStartStatus.Status.FAILURE);
            $this$apply.setErrorMessage("Start request ignored. The app has an on-going profiling session.");
            Cpu.TraceStartStatus traceStartStatus = status = builder3.build();
            Intrinsics.checkNotNullExpressionValue((Object)traceStartStatus, (String)"status");
            this.sendStartStatusEvent(command, traceStartStatus);
        } else {
            DdmPreferences.setProfilerBufferSizeMb((int)userOptions.getBufferSizeInMb());
            Transport.TimeResponse timeResponse = this.transportStub.getCurrentTime(Transport.TimeRequest.getDefaultInstance());
            Intrinsics.checkNotNullExpressionValue((Object)timeResponse, (String)"transportStub.getCurrent\u2026est.getDefaultInstance())");
            long requestTimeNs = timeResponse.getTimestampNs();
            LegacyCpuTraceRecord record = new LegacyCpuTraceRecord();
            this.legacyProfilingRecord.put(pid, record);
            try {
                if (userOptions.getTraceMode() == Cpu.CpuTraceMode.SAMPLED) {
                    client.startSamplingProfiler(userOptions.getSamplingIntervalUs(), TimeUnit.MICROSECONDS);
                } else {
                    client.startMethodTracer();
                }
                record.getStartLatch().await(100L, TimeUnit.MILLISECONDS);
                record.getStartLatch().countDown();
                if (record.isStartFailed()) {
                    Cpu.TraceStartStatus.Builder $this$apply = Cpu.TraceStartStatus.newBuilder();
                    boolean bl11 = false;
                    boolean bl12 = false;
                    Cpu.TraceStartStatus.Builder $this$apply2 = $this$apply;
                    boolean bl13 = false;
                    $this$apply2.setStatus(Cpu.TraceStartStatus.Status.FAILURE);
                    $this$apply2.setErrorMessage("Failed to start profiling: " + record.getStartFailureMessage());
                    Cpu.TraceStartStatus status = $this$apply.build();
                    this.legacyProfilingRecord.remove(pid);
                    Cpu.TraceStartStatus traceStartStatus = status;
                    Intrinsics.checkNotNullExpressionValue((Object)traceStartStatus, (String)"status");
                    this.sendStartStatusEvent(command, traceStartStatus);
                } else {
                    Cpu.TraceStartStatus status;
                    Cpu.TraceStartStatus.Builder $this$apply = Cpu.TraceStartStatus.newBuilder();
                    boolean bl14 = false;
                    boolean bl15 = false;
                    Cpu.TraceStartStatus.Builder $this$apply3 = $this$apply;
                    boolean bl16 = false;
                    $this$apply3.setStatus(Cpu.TraceStartStatus.Status.SUCCESS);
                    Cpu.TraceStartStatus traceStartStatus = status = $this$apply.build();
                    Intrinsics.checkNotNullExpressionValue((Object)traceStartStatus, (String)"status");
                    this.sendStartStatusEvent(command, traceStartStatus);
                    Cpu.CpuTraceInfo.Builder builder4 = Cpu.CpuTraceInfo.newBuilder();
                    bl15 = false;
                    boolean bl17 = false;
                    Cpu.CpuTraceInfo.Builder $this$apply4 = builder4;
                    boolean bl18 = false;
                    $this$apply4.setTraceId(requestTimeNs);
                    $this$apply4.setConfiguration(traceConfiguration);
                    $this$apply4.setFromTimestamp(requestTimeNs);
                    $this$apply4.setToTimestamp(-1L);
                    $this$apply4.setStartStatus(status);
                    Cpu.CpuTraceInfo.Builder traceInfo = builder4;
                    record.setTraceInfo(traceInfo);
                    Cpu.CpuTraceInfo cpuTraceInfo = traceInfo.build();
                    Intrinsics.checkNotNullExpressionValue((Object)cpuTraceInfo, (String)"traceInfo.build()");
                    this.sendStartTraceEvent(command, cpuTraceInfo);
                }
            }
            catch (Exception e) {
                Cpu.TraceStartStatus.Builder builder5 = Cpu.TraceStartStatus.newBuilder();
                boolean bl19 = false;
                boolean bl20 = false;
                Cpu.TraceStartStatus.Builder $this$apply = builder5;
                boolean bl21 = false;
                $this$apply.setStatus(Cpu.TraceStartStatus.Status.FAILURE);
                $this$apply.setErrorMessage("Failed: " + e);
                Cpu.TraceStartStatus status = builder5.build();
                this.legacyProfilingRecord.remove(pid);
                Cpu.TraceStartStatus traceStartStatus = status;
                Intrinsics.checkNotNullExpressionValue((Object)traceStartStatus, (String)"status");
                this.sendStartStatusEvent(command, traceStartStatus);
                this.getLogger().error("Exception while CpuServiceProxy startProfilingAppDdms: " + e);
            }
        }
    }

    private final void stopTrace(Commands.Command command) {
        Client client;
        Cpu.CpuTraceConfiguration.UserOptions userOptions;
        Cpu.CpuTraceConfiguration traceConfiguration;
        Cpu.StopCpuTrace stopCpuTrace = command.getStopCpuTrace();
        Intrinsics.checkNotNullExpressionValue((Object)stopCpuTrace, (String)"command.stopCpuTrace");
        Cpu.CpuTraceConfiguration cpuTraceConfiguration = traceConfiguration = stopCpuTrace.getConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)cpuTraceConfiguration, (String)"traceConfiguration");
        Cpu.CpuTraceConfiguration.UserOptions userOptions2 = userOptions = cpuTraceConfiguration.getUserOptions();
        Intrinsics.checkNotNullExpressionValue((Object)userOptions2, (String)"userOptions");
        boolean bl = userOptions2.getTraceType() == Cpu.CpuTraceType.ART;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        int pid = command.getPid();
        String appPkgName = this.device.getClientName(pid);
        Client client2 = client = appPkgName != null ? this.device.getClient(appPkgName) : null;
        if (client == null) {
            Cpu.TraceStopStatus status;
            Cpu.TraceStopStatus.Builder builder2 = Cpu.TraceStopStatus.newBuilder();
            boolean bl5 = false;
            boolean bl6 = false;
            Cpu.TraceStopStatus.Builder $this$apply = builder2;
            boolean bl7 = false;
            $this$apply.setStatus(Cpu.TraceStopStatus.Status.APP_PROCESS_DIED);
            $this$apply.setErrorMessage("App is not running");
            Cpu.TraceStopStatus traceStopStatus = status = builder2.build();
            Intrinsics.checkNotNullExpressionValue((Object)traceStopStatus, (String)"status");
            this.sendStopStatusEvent(command, traceStopStatus);
            LegacyCpuTraceRecord record = this.legacyProfilingRecord.get(pid);
            if (record != null) {
                long endTimeNs = this.getDeviceTimestamp(record);
                Cpu.CpuTraceInfo.Builder builder3 = record.getTraceInfo();
                Intrinsics.checkNotNull((Object)builder3);
                Cpu.CpuTraceInfo cpuTraceInfo = builder3.setToTimestamp(endTimeNs).build();
                Intrinsics.checkNotNullExpressionValue((Object)cpuTraceInfo, (String)"record.traceInfo!!.setTo\u2026estamp(endTimeNs).build()");
                this.sendStopTraceEvent(command, cpuTraceInfo);
            }
        } else {
            LegacyCpuTraceRecord record = this.legacyProfilingRecord.get(pid);
            if (LegacyCpuTraceRecord.Companion.isMethodProfilingStatusOff(record, client)) {
                Cpu.TraceStopStatus status;
                Cpu.TraceStopStatus.Builder endTimeNs = Cpu.TraceStopStatus.newBuilder();
                boolean bl8 = false;
                boolean bl9 = false;
                Cpu.TraceStopStatus.Builder $this$apply = endTimeNs;
                boolean bl10 = false;
                $this$apply.setStatus(Cpu.TraceStopStatus.Status.NO_ONGOING_PROFILING);
                $this$apply.setErrorMessage("The app is not being profiled.");
                Cpu.TraceStopStatus traceStopStatus = status = endTimeNs.build();
                Intrinsics.checkNotNullExpressionValue((Object)traceStopStatus, (String)"status");
                this.sendStopStatusEvent(command, traceStopStatus);
            } else {
                try {
                    if (userOptions.getTraceMode() == Cpu.CpuTraceMode.SAMPLED) {
                        client.stopSamplingProfiler();
                    } else {
                        client.stopMethodTracer();
                    }
                    LegacyCpuTraceRecord legacyCpuTraceRecord = record;
                    Intrinsics.checkNotNull((Object)legacyCpuTraceRecord);
                    legacyCpuTraceRecord.getStopLatch().await();
                    long endTimeNs = this.getDeviceTimestamp(record);
                    Cpu.CpuTraceInfo.Builder builder4 = record.getTraceInfo();
                    Intrinsics.checkNotNull((Object)builder4);
                    Cpu.TraceStopStatus traceStopStatus = builder4.getStopStatus();
                    Intrinsics.checkNotNullExpressionValue((Object)traceStopStatus, (String)"record.traceInfo!!.stopStatus");
                    this.sendStopStatusEvent(command, traceStopStatus);
                    Cpu.CpuTraceInfo.Builder builder5 = record.getTraceInfo();
                    Intrinsics.checkNotNull((Object)builder5);
                    Cpu.CpuTraceInfo cpuTraceInfo = builder5.setToTimestamp(endTimeNs).build();
                    Intrinsics.checkNotNullExpressionValue((Object)cpuTraceInfo, (String)"record.traceInfo!!.setTo\u2026estamp(endTimeNs).build()");
                    this.sendStopTraceEvent(command, cpuTraceInfo);
                }
                catch (Exception e) {
                    Cpu.TraceStopStatus status;
                    Cpu.TraceStopStatus.Builder builder6 = Cpu.TraceStopStatus.newBuilder();
                    boolean bl11 = false;
                    boolean bl12 = false;
                    Cpu.TraceStopStatus.Builder $this$apply = builder6;
                    boolean bl13 = false;
                    $this$apply.setStatus(Cpu.TraceStopStatus.Status.STOP_COMMAND_FAILED);
                    $this$apply.setErrorMessage("Failed: " + e);
                    Cpu.TraceStopStatus traceStopStatus = status = builder6.build();
                    Intrinsics.checkNotNullExpressionValue((Object)traceStopStatus, (String)"status");
                    this.sendStopStatusEvent(command, traceStopStatus);
                    this.getLogger().error("Exception while CpuServiceProxy stopProfilingApp: " + e);
                }
            }
        }
        this.legacyProfilingRecord.remove(pid);
    }

    private final long getDeviceTimestamp(LegacyCpuTraceRecord record) {
        long endTimeNs = 0L;
        try {
            Transport.TimeResponse timeResponse = this.transportStub.getCurrentTime(Transport.TimeRequest.getDefaultInstance());
            Intrinsics.checkNotNullExpressionValue((Object)timeResponse, (String)"transportStub.getCurrent\u2026est.getDefaultInstance())");
            endTimeNs = timeResponse.getTimestampNs();
        }
        catch (StatusRuntimeException exception) {
            Cpu.CpuTraceInfo.Builder builder2 = record.getTraceInfo();
            Intrinsics.checkNotNull((Object)builder2);
            endTimeNs = builder2.getFromTimestamp() + 1L;
        }
        return endTimeNs;
    }

    private final void sendStartStatusEvent(Commands.Command command, Cpu.TraceStartStatus startStatus) {
        Common.Event.Builder builder2 = Common.Event.newBuilder();
        boolean bl = false;
        boolean bl2 = false;
        Common.Event.Builder $this$apply = builder2;
        boolean bl3 = false;
        $this$apply.setPid(command.getPid());
        $this$apply.setKind(Common.Event.Kind.CPU_TRACE_STATUS);
        $this$apply.setCommandId(command.getCommandId());
        $this$apply.setCpuTraceStatus(Cpu.CpuTraceStatusData.newBuilder().setTraceStartStatus(startStatus).build());
        Common.Event statusEvent = builder2.build();
        this.eventQueue.offer(statusEvent);
    }

    private final void sendStartTraceEvent(Commands.Command command, Cpu.CpuTraceInfo traceInfo) {
        Common.Event.Builder builder2 = Common.Event.newBuilder();
        boolean bl = false;
        boolean bl2 = false;
        Common.Event.Builder $this$apply = builder2;
        boolean bl3 = false;
        $this$apply.setPid(command.getPid());
        $this$apply.setKind(Common.Event.Kind.CPU_TRACE);
        $this$apply.setTimestamp(traceInfo.getFromTimestamp());
        $this$apply.setGroupId(traceInfo.getTraceId());
        $this$apply.setCpuTrace(Cpu.CpuTraceData.newBuilder().setTraceStarted(Cpu.CpuTraceData.TraceStarted.newBuilder().setTraceInfo(traceInfo)).build());
        Common.Event traceStartEvent = builder2.build();
        this.eventQueue.offer(traceStartEvent);
    }

    private final void sendStopStatusEvent(Commands.Command command, Cpu.TraceStopStatus startStatus) {
        Common.Event.Builder builder2 = Common.Event.newBuilder();
        boolean bl = false;
        boolean bl2 = false;
        Common.Event.Builder $this$apply = builder2;
        boolean bl3 = false;
        $this$apply.setPid(command.getPid());
        $this$apply.setKind(Common.Event.Kind.CPU_TRACE_STATUS);
        $this$apply.setCommandId(command.getCommandId());
        $this$apply.setCpuTraceStatus(Cpu.CpuTraceStatusData.newBuilder().setTraceStopStatus(startStatus).build());
        Common.Event statusEvent = builder2.build();
        this.eventQueue.offer(statusEvent);
    }

    private final void sendStopTraceEvent(Commands.Command command, Cpu.CpuTraceInfo traceInfo) {
        Common.Event.Builder builder2 = Common.Event.newBuilder();
        boolean bl = false;
        boolean bl2 = false;
        Common.Event.Builder $this$apply = builder2;
        boolean bl3 = false;
        $this$apply.setPid(command.getPid());
        $this$apply.setKind(Common.Event.Kind.CPU_TRACE);
        $this$apply.setTimestamp(traceInfo.getToTimestamp());
        $this$apply.setGroupId(traceInfo.getTraceId());
        $this$apply.setCpuTrace(Cpu.CpuTraceData.newBuilder().setTraceEnded(Cpu.CpuTraceData.TraceEnded.newBuilder().setTraceInfo(traceInfo)).build());
        Common.Event traceStartEvent = builder2.build();
        this.eventQueue.offer(traceStartEvent);
    }

    @NotNull
    public final IDevice getDevice() {
        return this.device;
    }

    @NotNull
    public final TransportServiceGrpc.TransportServiceBlockingStub getTransportStub() {
        return this.transportStub;
    }

    @NotNull
    public final BlockingDeque<Common.Event> getEventQueue() {
        return this.eventQueue;
    }

    public LegacyCpuTraceCommandHandler(@NotNull IDevice device, @NotNull TransportServiceGrpc.TransportServiceBlockingStub transportStub, @NotNull BlockingDeque<Common.Event> eventQueue, @NotNull Map<String, ByteString> byteCache) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        Intrinsics.checkNotNullParameter((Object)transportStub, (String)"transportStub");
        Intrinsics.checkNotNullParameter(eventQueue, (String)"eventQueue");
        Intrinsics.checkNotNullParameter(byteCache, (String)"byteCache");
        this.device = device;
        this.transportStub = transportStub;
        this.eventQueue = eventQueue;
        this.legacyProfilingRecord = new HashMap();
        this.profilingHandler = new LegacyCpuProfilingHandler((Map<Integer, LegacyCpuTraceRecord>)this.legacyProfilingRecord, byteCache);
        ClientData.setMethodProfilingHandler((ClientData.IMethodProfilingHandler)this.profilingHandler);
    }
}

