/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.tools.datastore.poller.MemoryDataPoller;
import com.android.tools.idea.profilers.LegacyAllocationTracker;
import com.intellij.openapi.diagnostic.Logger;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class StudioLegacyAllocationTracker
implements LegacyAllocationTracker {
    private IDevice myDevice;
    private int myPid;
    private boolean myOngoingTracking;

    private static Logger getLogger() {
        return Logger.getInstance(MemoryDataPoller.class);
    }

    public StudioLegacyAllocationTracker(@NotNull IDevice device, int processId) {
        if (device == null) {
            StudioLegacyAllocationTracker.$$$reportNull$$$0(0);
        }
        this.myDevice = device;
        this.myPid = processId;
    }

    @Override
    public boolean trackAllocations(boolean enabled, Executor executor, Consumer<byte[]> allocationConsumer) {
        Client client = this.getClient(this.myPid);
        if (client == null) {
            return false;
        }
        if (enabled == this.myOngoingTracking) {
            return false;
        }
        this.myOngoingTracking = enabled;
        if (!enabled) {
            assert (executor != null);
            this.getAllocationTrackingDump(client, executor, data -> {
                assert (allocationConsumer != null);
                allocationConsumer.accept((byte[])data);
            });
        }
        client.enableAllocationTracker(enabled);
        return true;
    }

    private void getAllocationTrackingDump(final @NotNull Client callingClient, final @NotNull Executor executor, final @NotNull Consumer<byte[]> consumer) {
        if (callingClient == null) {
            StudioLegacyAllocationTracker.$$$reportNull$$$0(1);
        }
        if (executor == null) {
            StudioLegacyAllocationTracker.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            StudioLegacyAllocationTracker.$$$reportNull$$$0(3);
        }
        AndroidDebugBridge.addClientChangeListener((AndroidDebugBridge.IClientChangeListener)new AndroidDebugBridge.IClientChangeListener(){

            public void clientChanged(Client client, int changeMask) {
                if (callingClient == client && (changeMask & 0x200) != 0) {
                    byte[] data = client.getClientData().getAllocationsData();
                    executor.execute(() -> consumer.accept(data));
                    AndroidDebugBridge.removeClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
                }
            }
        });
        callingClient.requestAllocationDetails();
    }

    private Client getClient(int processId) {
        if (!this.myDevice.isOnline()) {
            return null;
        }
        Client client = this.myDevice.getClient(this.myDevice.getClientName(processId));
        if (client == null) {
            StudioLegacyAllocationTracker.getLogger().info("StudioLegacyAllocationTracker unable to find application with process Id: " + processId);
        }
        return client;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callingClient";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/profilers/StudioLegacyAllocationTracker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getAllocationTrackingDump";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

