/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.tools.idea.profilers.LegacyCpuTraceRecord;
import com.android.tools.idea.protobuf.ByteString;
import com.android.tools.profiler.proto.Cpu;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0016J\u0018\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0016J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/profilers/LegacyCpuProfilingHandler;", "Lcom/android/ddmlib/ClientData$IMethodProfilingHandler;", "profilingRecords", "", "", "Lcom/android/tools/idea/profilers/LegacyCpuTraceRecord;", "byteCache", "", "", "Lcom/android/tools/idea/protobuf/ByteString;", "(Ljava/util/Map;Ljava/util/Map;)V", "onEndFailure", "", "client", "Lcom/android/ddmlib/Client;", "message", "onStartFailure", "onSuccess", "data", "", "remoteFilePath", "intellij.android.profilersAndroid"})
public final class LegacyCpuProfilingHandler
implements ClientData.IMethodProfilingHandler {
    private final Map<Integer, LegacyCpuTraceRecord> profilingRecords;
    private final Map<String, ByteString> byteCache;

    public void onSuccess(@NotNull String remoteFilePath, @NotNull Client client) {
        Intrinsics.checkNotNullParameter((Object)remoteFilePath, (String)"remoteFilePath");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        ClientData clientData = client.getClientData();
        Intrinsics.checkNotNullExpressionValue((Object)clientData, (String)"client.clientData");
        LegacyCpuTraceRecord record = this.profilingRecords.get(clientData.getPid());
        if (record != null) {
            Cpu.TraceStopStatus status = Cpu.TraceStopStatus.newBuilder().setStatus(Cpu.TraceStopStatus.Status.CANNOT_COPY_FILE).setErrorMessage("Method profiling: Older devices (API level < 10) are not supported. Please use DDMS.").build();
            Cpu.CpuTraceInfo.Builder builder2 = record.getTraceInfo();
            Intrinsics.checkNotNull((Object)builder2);
            builder2.setStopStatus(status);
            record.getStopLatch().countDown();
        }
    }

    public void onSuccess(@NotNull byte[] data, @NotNull Client client) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        ClientData clientData = client.getClientData();
        Intrinsics.checkNotNullExpressionValue((Object)clientData, (String)"client.clientData");
        LegacyCpuTraceRecord record = this.profilingRecords.get(clientData.getPid());
        if (record != null) {
            Cpu.CpuTraceInfo.Builder builder2 = record.getTraceInfo();
            Intrinsics.checkNotNull((Object)builder2);
            builder2.setStopStatus(Cpu.TraceStopStatus.newBuilder().setStatus(Cpu.TraceStopStatus.Status.SUCCESS).build());
            Cpu.CpuTraceInfo.Builder builder3 = record.getTraceInfo();
            Intrinsics.checkNotNull((Object)builder3);
            String string = String.valueOf(builder3.getTraceId());
            ByteString byteString = ByteString.copyFrom((byte[])data);
            Intrinsics.checkNotNullExpressionValue((Object)byteString, (String)"ByteString.copyFrom(data)");
            this.byteCache.put(string, byteString);
            record.getStopLatch().countDown();
        }
    }

    public void onStartFailure(@NotNull Client client, @NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
    }

    public void onEndFailure(@NotNull Client client, @NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        ClientData clientData = client.getClientData();
        Intrinsics.checkNotNullExpressionValue((Object)clientData, (String)"client.clientData");
        LegacyCpuTraceRecord record = this.profilingRecords.get(clientData.getPid());
        if (record != null) {
            if (record.getStartLatch().getCount() > 0L) {
                record.setStartFailureMessage(message2);
                record.getStartLatch().countDown();
            } else {
                Cpu.TraceStopStatus status = Cpu.TraceStopStatus.newBuilder().setStatus(Cpu.TraceStopStatus.Status.STOP_COMMAND_FAILED).setErrorMessage("Failed to stop profiling: " + message2).build();
                Cpu.CpuTraceInfo.Builder builder2 = record.getTraceInfo();
                Intrinsics.checkNotNull((Object)builder2);
                builder2.setStopStatus(status);
                record.getStopLatch().countDown();
            }
        }
    }

    public LegacyCpuProfilingHandler(@NotNull Map<Integer, LegacyCpuTraceRecord> profilingRecords, @NotNull Map<String, ByteString> byteCache) {
        Intrinsics.checkNotNullParameter(profilingRecords, (String)"profilingRecords");
        Intrinsics.checkNotNullParameter(byteCache, (String)"byteCache");
        this.profilingRecords = profilingRecords;
        this.byteCache = byteCache;
    }
}

