/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.TimeoutException;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.profilers.AndroidProfilerToolWindow;
import com.android.tools.idea.profilers.AndroidProfilerToolWindowFactory;
import com.android.tools.idea.profilers.PreferredProcessInfo;
import com.android.tools.idea.profilers.analytics.StudioFeatureTracker;
import com.android.tools.idea.profilers.profilingconfig.CpuProfilerConfigConverter;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.run.AndroidLaunchTaskContributor;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.LaunchOptions;
import com.android.tools.idea.run.editor.ProfilerState;
import com.android.tools.idea.run.profiler.CpuProfilerConfig;
import com.android.tools.idea.run.profiler.CpuProfilerConfigsState;
import com.android.tools.idea.run.tasks.LaunchContext;
import com.android.tools.idea.run.tasks.LaunchResult;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.android.tools.idea.run.util.ProcessHandlerLaunchStatus;
import com.android.tools.idea.transport.TransportFileManager;
import com.android.tools.idea.transport.TransportService;
import com.android.tools.profiler.proto.Commands;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profiler.proto.Memory;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.ProfilerClient;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.cpu.config.ProfilingConfiguration;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import io.grpc.StatusRuntimeException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidProfilerLaunchTaskContributor
implements AndroidLaunchTaskContributor {
    private static final String STARTUP_AGENT_CONFIG_NAME = "startupagent.config";

    private static Logger getLogger() {
        return Logger.getInstance(AndroidProfilerLaunchTaskContributor.class);
    }

    @Override
    @NotNull
    public LaunchTask getTask(@NotNull Module module2, @NotNull String applicationId2, @NotNull LaunchOptions launchOptions) {
        if (module2 == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(0);
        }
        if (applicationId2 == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(1);
        }
        if (launchOptions == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(2);
        }
        return new AndroidProfilerToolWindowLaunchTask(module2.getProject(), launchOptions, AndroidProfilerToolWindow.getModuleName(module2));
    }

    @NotNull
    public static String getAmStartOptions(@NotNull Project project, @NotNull String applicationId2, @NotNull LaunchOptions launchOptions, @NotNull IDevice device) {
        Common.Device profilerDevice;
        if (project == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(3);
        }
        if (applicationId2 == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(4);
        }
        if (launchOptions == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(5);
        }
        if (device == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(6);
        }
        if (!AndroidProfilerLaunchTaskContributor.isProfilerLaunch(launchOptions)) {
            return "";
        }
        ProfilerState profilerState = AndroidProfilerLaunchTaskContributor.getProfilerStateFromCurrentRun(launchOptions, project);
        if (profilerState == null) {
            return "";
        }
        TransportService transportService = TransportService.getInstance();
        if (transportService == null) {
            return "";
        }
        ProfilerClient client = new ProfilerClient("DataStoreService");
        try {
            profilerDevice = AndroidProfilerLaunchTaskContributor.waitForDaemon(device, client);
        }
        catch (TimeoutException | InterruptedException e) {
            AndroidProfilerLaunchTaskContributor.getLogger().debug(e);
            return "";
        }
        TransportFileManager fileManager = new TransportFileManager(device, transportService.getMessageBus());
        AndroidProfilerLaunchTaskContributor.pushStartupAgentConfig(fileManager, project);
        String agentArgs = fileManager.configureStartupAgent(applicationId2, STARTUP_AGENT_CONFIG_NAME);
        String startupProfilingResult = AndroidProfilerLaunchTaskContributor.startStartupProfiling(profilerState, applicationId2, project, client, device, profilerDevice);
        String string = String.format("%s %s", agentArgs, startupProfilingResult);
        if (string == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @NotNull
    public String getAmStartOptions(@NotNull Module module2, @NotNull String applicationId2, @NotNull LaunchOptions launchOptions, @NotNull IDevice device) {
        if (module2 == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(8);
        }
        if (applicationId2 == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(9);
        }
        if (launchOptions == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(10);
        }
        if (device == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(11);
        }
        return AndroidProfilerLaunchTaskContributor.getAmStartOptions(module2.getProject(), applicationId2, launchOptions, device);
    }

    private static void pushStartupAgentConfig(@NotNull TransportFileManager fileManager, @NotNull Project project) {
        if (fileManager == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(12);
        }
        if (project == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(13);
        }
        try {
            fileManager.pushAgentConfig(STARTUP_AGENT_CONFIG_NAME, AndroidProfilerLaunchTaskContributor.getSelectedRunConfiguration(project));
        }
        catch (ShellCommandUnresponsiveException | SyncException | TimeoutException e) {
            throw new RuntimeException(e);
        }
        catch (AdbCommandRejectedException | IOException e) {
            AndroidProfilerLaunchTaskContributor.getLogger().warn("Error when trying to push AgentConfig:", e);
        }
    }

    @NotNull
    private static String startStartupProfiling(@NotNull ProfilerState profilerState, @NotNull String appPackageName, @NotNull Project project, @NotNull ProfilerClient client, @NotNull IDevice device, @NotNull Common.Device profilerDevice) {
        if (profilerState == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(14);
        }
        if (appPackageName == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(15);
        }
        if (project == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(16);
        }
        if (client == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(17);
        }
        if (device == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(18);
        }
        if (profilerDevice == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(19);
        }
        if (profilerState.isCpuStartupProfilingEnabled()) {
            String string = AndroidProfilerLaunchTaskContributor.triggerCpuStartupProfilingAndReturnArtParams(profilerState, appPackageName, project, client, device, profilerDevice);
            if (string == null) {
                AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(20);
            }
            return string;
        }
        if (profilerState.isNativeMemoryStartupProfilingEnabled()) {
            AndroidProfilerLaunchTaskContributor.triggerMemoryStartupProfiling(profilerState, appPackageName, project, client, device, profilerDevice);
        }
        return "";
    }

    private static void triggerMemoryStartupProfiling(@NotNull ProfilerState profilerState, @NotNull String appPackageName, @NotNull Project project, @NotNull ProfilerClient client, @NotNull IDevice device, @NotNull Common.Device profilerDevice) {
        if (profilerState == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(21);
        }
        if (appPackageName == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(22);
        }
        if (project == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(23);
        }
        if (client == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(24);
        }
        if (device == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(25);
        }
        if (profilerDevice == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(26);
        }
        if (!AndroidProfilerLaunchTaskContributor.isAtLeast(device, 29)) {
            AndroidNotification.getInstance(project).showBalloon("Startup Native Memory Profiling", "Starting a native memory sampling trace recording on startup is only supported on devices with API levels 28 and higher.", NotificationType.WARNING);
            return;
        }
        if (device.getAbis().isEmpty()) {
            AndroidNotification.getInstance(project).showBalloon("Startup Native Memory Profiling", "Unable to detect device abi for startup memory profiling.", NotificationType.WARNING);
            return;
        }
        if (device.getAbis().contains("x86") || device.getAbis().contains("x86_64")) {
            AndroidNotification.getInstance(project).showBalloon("Startup Native Memory Profiling", "Native memory profiling not supported on x86 and x86_64 devices.", NotificationType.WARNING);
            return;
        }
        String abi = (String)device.getAbis().get(0);
        StudioFeatureTracker featureTracker = new StudioFeatureTracker(project);
        featureTracker.trackRecordAllocations();
        String traceFilePath = String.format(Locale.US, "%s/%s.trace", "/data/local/tmp/perfd", appPackageName);
        Commands.Command sampleCommand = Commands.Command.newBuilder().setStreamId(profilerDevice.getDeviceId()).setType(Commands.Command.CommandType.START_NATIVE_HEAP_SAMPLE).setStartNativeSample(Memory.StartNativeSample.newBuilder().setSamplingIntervalBytes(profilerState.NATIVE_MEMORY_SAMPLE_RATE_BYTES).setSharedMemoryBufferBytes(0x4000000).setAbiCpuArch(abi).setTempPath(traceFilePath).setAppName(appPackageName)).build();
        Transport.ExecuteResponse response = client.getTransportClient().execute(Transport.ExecuteRequest.newBuilder().setCommand(sampleCommand).build());
    }

    private static String triggerCpuStartupProfilingAndReturnArtParams(@NotNull ProfilerState profilerState, @NotNull String appPackageName, @NotNull Project project, @NotNull ProfilerClient client, @NotNull IDevice device, @NotNull Common.Device profilerDevice) {
        String configName;
        if (profilerState == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(27);
        }
        if (appPackageName == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(28);
        }
        if (project == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(29);
        }
        if (client == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(30);
        }
        if (device == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(31);
        }
        if (profilerDevice == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(32);
        }
        if ((configName = profilerState.STARTUP_CPU_PROFILING_CONFIGURATION_NAME) == null) {
            return "";
        }
        CpuProfilerConfig startupConfig = CpuProfilerConfigsState.getInstance(project).getConfigByName(configName);
        if (startupConfig == null) {
            return "";
        }
        if (!AndroidProfilerLaunchTaskContributor.isAtLeast(device, 26)) {
            AndroidNotification.getInstance(project).showBalloon("Startup CPU Profiling", "Starting a method trace recording on startup is only supported on devices with API levels 26 and higher.", NotificationType.WARNING);
            return "";
        }
        String cpuAbi = "";
        switch (startupConfig.getTechnology()) {
            case SAMPLED_NATIVE: {
                cpuAbi = AndroidProfilerLaunchTaskContributor.getAbiDependentLibraryName("simpleperf", "simpleperf", device);
                break;
            }
            case SYSTEM_TRACE: {
                cpuAbi = AndroidProfilerLaunchTaskContributor.getAbiDependentLibraryName("perfetto", "perfetto", device);
                break;
            }
        }
        String traceFilePath = String.format(Locale.US, "%s/%s-%d.trace", "/data/local/tmp/perfd", appPackageName, System.nanoTime());
        Cpu.CpuTraceConfiguration.UserOptions traceOptions = CpuProfilerConfigConverter.toProto(startupConfig, device.getVersion().getFeatureLevel());
        Cpu.CpuTraceConfiguration configuration = Cpu.CpuTraceConfiguration.newBuilder().setAppName(appPackageName).setInitiationType(Cpu.TraceInitiationType.INITIATED_BY_STARTUP).setAbiCpuArch(cpuAbi).setTempPath(traceFilePath).setUserOptions(traceOptions).build();
        try {
            CpuProfiler.StartupProfilingResponse startupProfilingResponse;
            if (((Boolean)StudioFlags.PROFILER_UNIFIED_PIPELINE.get()).booleanValue()) {
                Commands.Command startCommand = Commands.Command.newBuilder().setStreamId(profilerDevice.getDeviceId()).setType(Commands.Command.CommandType.START_CPU_TRACE).setStartCpuTrace(Cpu.StartCpuTrace.newBuilder().setConfiguration(configuration).build()).build();
                startupProfilingResponse = client.getTransportClient().execute(Transport.ExecuteRequest.newBuilder().setCommand(startCommand).build());
            } else {
                CpuProfiler.StartupProfilingRequest.Builder requestBuilder = CpuProfiler.StartupProfilingRequest.newBuilder().setDeviceId(profilerDevice.getDeviceId()).setConfiguration(configuration);
                startupProfilingResponse = client.getCpuClient().startStartupProfiling(requestBuilder.build());
            }
        }
        catch (StatusRuntimeException exception) {
            AndroidProfilerLaunchTaskContributor.getLogger().error((Throwable)exception);
        }
        StudioFeatureTracker featureTracker = new StudioFeatureTracker(project);
        featureTracker.trackCpuStartupProfiling(profilerDevice, ProfilingConfiguration.fromProto((Cpu.CpuTraceConfiguration.UserOptions)traceOptions));
        if (traceOptions.getTraceType() != Cpu.CpuTraceType.ART) {
            return "";
        }
        StringBuilder argsBuilder = new StringBuilder("--start-profiler ").append(traceFilePath);
        if (startupConfig.getTechnology() == CpuProfilerConfig.Technology.SAMPLED_JAVA) {
            argsBuilder.append(" --sampling ").append(startupConfig.getSamplingIntervalUs());
        }
        argsBuilder.append(" --streaming");
        return argsBuilder.toString();
    }

    private static boolean isAtLeast(@NotNull IDevice device, int version2) {
        if (device == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(33);
        }
        return device.getVersion().getFeatureLevel() >= version2;
    }

    @Nullable
    private static ProfilerState getProfilerStateFromCurrentRun(@NotNull LaunchOptions launchOptions, Project project) {
        AndroidRunConfigurationBase runConfig;
        if (launchOptions == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(34);
        }
        if ((runConfig = AndroidProfilerLaunchTaskContributor.getSelectedRunConfiguration(project)) != null) {
            return runConfig.getProfilerState();
        }
        Object stateFromExtraOptions = launchOptions.getExtraOption("android.profilers.state");
        if (stateFromExtraOptions instanceof ProfilerState) {
            return (ProfilerState)stateFromExtraOptions;
        }
        return null;
    }

    @Nullable
    private static AndroidRunConfigurationBase getSelectedRunConfiguration(@NotNull Project project) {
        RunnerAndConfigurationSettings settings;
        if (project == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(35);
        }
        if ((settings = RunManager.getInstance((Project)project).getSelectedConfiguration()) != null && settings.getConfiguration() instanceof AndroidRunConfigurationBase) {
            return (AndroidRunConfigurationBase)settings.getConfiguration();
        }
        return null;
    }

    @NotNull
    private static Common.Device waitForDaemon(@NotNull IDevice device, @NotNull ProfilerClient client) throws InterruptedException, TimeoutException {
        if (device == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(36);
        }
        if (client == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(37);
        }
        for (int i2 = 0; i2 < 60; ++i2) {
            Common.Device profilerDevice = AndroidProfilerLaunchTaskContributor.getProfilerDevice(device, client);
            if (!Common.Device.getDefaultInstance().equals((Object)profilerDevice)) {
                Common.Device device2 = profilerDevice;
                if (device2 == null) {
                    AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(38);
                }
                return device2;
            }
            Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
        }
        throw new TimeoutException("Timeout waiting for daemon");
    }

    @NotNull
    private static Common.Device getProfilerDevice(@NotNull IDevice device, @NotNull ProfilerClient client) {
        if (device == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(39);
        }
        if (client == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(40);
        }
        List devices2 = StudioProfilers.getUpToDateDevices((boolean)((Boolean)StudioFlags.PROFILER_UNIFIED_PIPELINE.get()), (ProfilerClient)client, null, null);
        for (Common.Device profilerDevice : devices2) {
            if (!profilerDevice.getSerial().equals(device.getSerialNumber()) || profilerDevice.getState() != Common.Device.State.ONLINE) continue;
            Common.Device device2 = profilerDevice;
            if (device2 == null) {
                AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(41);
            }
            return device2;
        }
        Common.Device device3 = Common.Device.getDefaultInstance();
        if (device3 == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(42);
        }
        return device3;
    }

    @NotNull
    private static String getAbiDependentLibraryName(String dir, String fileName, IDevice device) {
        return AndroidProfilerLaunchTaskContributor.getBestAbiCpuArch(device, "plugins/android/resources/" + dir, "../../prebuilts/tools/common/" + dir, fileName);
    }

    @NotNull
    private static String getBestAbiCpuArch(@NotNull IDevice device, @NotNull String releaseDir, @NotNull String devDir, @NotNull String fileName) {
        File dir;
        if (device == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(43);
        }
        if (releaseDir == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(44);
        }
        if (devDir == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(45);
        }
        if (fileName == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(46);
        }
        if (!(dir = new File(PathManager.getHomePath(), releaseDir)).exists()) {
            dir = new File(PathManager.getHomePath(), devDir);
        }
        for (String abi : device.getAbis()) {
            File candidate = new File(dir, abi + "/" + fileName);
            if (!candidate.exists()) continue;
            String string = Abi.getEnum((String)abi).getCpuArch();
            if (string == null) {
                AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(47);
            }
            return string;
        }
        return "";
    }

    public static boolean isProfilerLaunch(@NotNull LaunchOptions options2) {
        Object launchValue;
        if (options2 == null) {
            AndroidProfilerLaunchTaskContributor.$$$reportNull$$$0(48);
        }
        return (launchValue = options2.getExtraOption("isProfiling")) instanceof Boolean && (Boolean)launchValue != false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 20: 
            case 38: 
            case 41: 
            case 42: 
            case 47: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 20: 
            case 38: 
            case 41: 
            case 42: 
            case 47: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationId";
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchOptions";
                break;
            }
            case 3: 
            case 13: 
            case 16: 
            case 23: 
            case 29: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 11: 
            case 18: 
            case 25: 
            case 31: 
            case 33: 
            case 36: 
            case 39: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 7: 
            case 20: 
            case 38: 
            case 41: 
            case 42: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/profilers/AndroidProfilerLaunchTaskContributor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileManager";
                break;
            }
            case 14: 
            case 21: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilerState";
                break;
            }
            case 15: 
            case 22: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appPackageName";
                break;
            }
            case 17: 
            case 24: 
            case 30: 
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 19: 
            case 26: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilerDevice";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "releaseDir";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "devDir";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/profilers/AndroidProfilerLaunchTaskContributor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAmStartOptions";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "startStartupProfiling";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "waitForDaemon";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfilerDevice";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getBestAbiCpuArch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTask";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getAmStartOptions";
                break;
            }
            case 7: 
            case 20: 
            case 38: 
            case 41: 
            case 42: 
            case 47: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "pushStartupAgentConfig";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "startStartupProfiling";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "triggerMemoryStartupProfiling";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "triggerCpuStartupProfilingAndReturnArtParams";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isAtLeast";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getProfilerStateFromCurrentRun";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedRunConfiguration";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "waitForDaemon";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getProfilerDevice";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getBestAbiCpuArch";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "isProfilerLaunch";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 20: 
            case 38: 
            case 41: 
            case 42: 
            case 47: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class AndroidProfilerToolWindowLaunchTask
    implements LaunchTask {
        private static final String ID = "PROFILER_TOOLWINDOW";
        @NotNull
        private final Project myProject;
        @NotNull
        private final LaunchOptions myLaunchOptions;
        @Nullable
        private final String myTargetProcessName;

        public AndroidProfilerToolWindowLaunchTask(@NotNull Project project, @NotNull LaunchOptions launchOptions, @Nullable String targetProcessName) {
            if (project == null) {
                AndroidProfilerToolWindowLaunchTask.$$$reportNull$$$0(0);
            }
            if (launchOptions == null) {
                AndroidProfilerToolWindowLaunchTask.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myLaunchOptions = launchOptions;
            this.myTargetProcessName = targetProcessName;
        }

        @Override
        @NotNull
        public String getDescription() {
            return "Launching the Profiler Tool Window";
        }

        @Override
        public int getDuration() {
            return 2;
        }

        @Override
        public LaunchResult run(@NotNull LaunchContext launchContext) {
            if (launchContext == null) {
                AndroidProfilerToolWindowLaunchTask.$$$reportNull$$$0(2);
            }
            IDevice device = launchContext.getDevice();
            long currentDeviceTimeNs = AndroidProfilerLaunchTaskContributor.isProfilerLaunch(this.myLaunchOptions) ? this.getCurrentDeviceTime(device) : Long.MIN_VALUE;
            ApplicationManager.getApplication().invokeLater(() -> {
                ToolWindow window2 = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Android Profiler");
                if (window2 != null) {
                    AndroidProfilerToolWindow profilerToolWindow;
                    window2.setShowStripeButton(true);
                    String deviceName = AndroidProfilerToolWindow.getDeviceDisplayName(device);
                    PreferredProcessInfo preferredProcessInfo = new PreferredProcessInfo(deviceName, this.myTargetProcessName, (Function1<? super Common.Process, Boolean>)((Function1)p -> p.getStartTimestampNs() >= currentDeviceTimeNs));
                    boolean profileStarted = false;
                    if (window2.isVisible() && (profilerToolWindow = AndroidProfilerToolWindowFactory.getProfilerToolWindow(this.myProject)) != null) {
                        profilerToolWindow.profile(preferredProcessInfo);
                        profileStarted = true;
                    }
                    if (!profileStarted) {
                        this.myProject.putUserData(AndroidProfilerToolWindow.LAST_RUN_APP_INFO, (Object)preferredProcessInfo);
                    }
                }
            });
            LaunchStatus launchStatus = launchContext.getLaunchStatus();
            if (launchStatus instanceof ProcessHandlerLaunchStatus) {
                final ProcessHandler processHandler = ((ProcessHandlerLaunchStatus)launchStatus).getProcessHandler();
                ProcessAdapter adapter = new ProcessAdapter(){

                    public void processTerminated(@NotNull ProcessEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        myProject.putUserData(AndroidProfilerToolWindow.LAST_RUN_APP_INFO, null);
                        processHandler.removeProcessListener((ProcessListener)this);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/profilers/AndroidProfilerLaunchTaskContributor$AndroidProfilerToolWindowLaunchTask$1", "processTerminated"));
                    }
                };
                processHandler.addProcessListener((ProcessListener)adapter);
            }
            return LaunchResult.success();
        }

        @Override
        @NotNull
        public String getId() {
            return ID;
        }

        private long getCurrentDeviceTime(@NotNull IDevice device) {
            if (device == null) {
                AndroidProfilerToolWindowLaunchTask.$$$reportNull$$$0(3);
            }
            assert (AndroidProfilerLaunchTaskContributor.isProfilerLaunch(this.myLaunchOptions));
            long startTimeNs = Long.MIN_VALUE;
            TransportService transportService = TransportService.getInstance();
            if (transportService == null) {
                return startTimeNs;
            }
            ProfilerClient client = new ProfilerClient("DataStoreService");
            long deviceId = -1L;
            try {
                deviceId = AndroidProfilerLaunchTaskContributor.waitForDaemon(device, client).getDeviceId();
            }
            catch (TimeoutException | InterruptedException e) {
                AndroidProfilerLaunchTaskContributor.getLogger().debug(e);
            }
            try {
                Transport.TimeResponse timeResponse = client.getTransportClient().getCurrentTime(Transport.TimeRequest.newBuilder().setStreamId(deviceId).build());
                if (!Transport.TimeResponse.getDefaultInstance().equals((Object)timeResponse)) {
                    startTimeNs = timeResponse.getTimestampNs();
                }
            }
            catch (StatusRuntimeException exception) {
                AndroidProfilerLaunchTaskContributor.getLogger().error((Throwable)exception);
            }
            return startTimeNs;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "launchOptions";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "launchContext";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "device";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/profilers/AndroidProfilerLaunchTaskContributor$AndroidProfilerToolWindowLaunchTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getCurrentDeviceTime";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

