/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.observable.adapters;

import com.android.tools.idea.observable.AbstractProperty;
import com.android.tools.idea.observable.adapters.AdapterProperty;
import com.android.utils.DecimalUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParsePosition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StringToDoubleAdapterProperty
extends AdapterProperty<String, Double> {
    @NotNull
    private final DecimalFormat myFormat;
    @NotNull
    private final DecimalFormatSymbols mySymbols;

    public StringToDoubleAdapterProperty(@NotNull AbstractProperty<String> wrappedProperty) {
        if (wrappedProperty == null) {
            StringToDoubleAdapterProperty.$$$reportNull$$$0(0);
        }
        this(wrappedProperty, 1);
    }

    public StringToDoubleAdapterProperty(@NotNull AbstractProperty<String> wrappedProperty, int numDecimals) {
        if (wrappedProperty == null) {
            StringToDoubleAdapterProperty.$$$reportNull$$$0(1);
        }
        this(wrappedProperty, numDecimals, numDecimals);
    }

    public StringToDoubleAdapterProperty(@NotNull AbstractProperty<String> wrappedProperty, int numDecimals, int maxDecimals) {
        if (wrappedProperty == null) {
            StringToDoubleAdapterProperty.$$$reportNull$$$0(2);
        }
        this(wrappedProperty, StringToDoubleAdapterProperty.createFormat(numDecimals, maxDecimals));
    }

    public StringToDoubleAdapterProperty(@NotNull AbstractProperty<String> wrappedProperty, @NotNull DecimalFormat format2) {
        if (wrappedProperty == null) {
            StringToDoubleAdapterProperty.$$$reportNull$$$0(3);
        }
        if (format2 == null) {
            StringToDoubleAdapterProperty.$$$reportNull$$$0(4);
        }
        super(wrappedProperty, 0.0);
        this.myFormat = format2;
        this.mySymbols = format2.getDecimalFormatSymbols();
    }

    private static DecimalFormat createFormat(int numDecimals, int maxDecimals) {
        Preconditions.checkArgument((maxDecimals >= numDecimals ? 1 : 0) != 0, (Object)"maxDecimals may not be less than numDecimals");
        String pattern = numDecimals == 0 ? "0" : "0." + Strings.repeat((String)"0", (int)numDecimals) + Strings.repeat((String)"#", (int)(maxDecimals - numDecimals));
        return new DecimalFormat(pattern, new DecimalFormatSymbols());
    }

    @Override
    @Nullable
    protected Double convertFromSourceType(@NotNull String value2) {
        ParsePosition pos;
        Number number;
        if (value2 == null) {
            StringToDoubleAdapterProperty.$$$reportNull$$$0(5);
        }
        if ((number = this.myFormat.parse(value2 = value2.trim(), pos = new ParsePosition(0))) == null || pos.getIndex() != value2.length()) {
            return null;
        }
        return number.doubleValue();
    }

    @Override
    @NotNull
    protected String convertFromDestType(@NotNull Double value2) {
        if (value2 == null) {
            StringToDoubleAdapterProperty.$$$reportNull$$$0(6);
        }
        String string = DecimalUtils.trimInsignificantZeros((String)this.myFormat.format(value2), (DecimalFormatSymbols)this.mySymbols);
        if (string == null) {
            StringToDoubleAdapterProperty.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrappedProperty";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/observable/adapters/StringToDoubleAdapterProperty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/observable/adapters/StringToDoubleAdapterProperty";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "convertFromDestType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "convertFromSourceType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "convertFromDestType";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

