/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.validator;

import com.android.tools.adtui.validation.Validator;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.npw.module.ModuleModelKt;
import com.android.tools.idea.ui.validation.validators.PathValidator;
import com.google.common.base.CharMatcher;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0016R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\r\u001a\u00070\u0002\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/npw/validator/ModuleValidator;", "Lcom/android/tools/adtui/validation/Validator;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "ILLEGAL_CHAR_MATCHER", "Lcom/google/common/base/CharMatcher;", "kotlin.jvm.PlatformType", "pathValidator", "Lcom/android/tools/idea/ui/validation/validators/PathValidator;", "getProject", "()Lcom/intellij/openapi/project/Project;", "projectPath", "Lorg/jetbrains/annotations/SystemIndependent;", "validate", "Lcom/android/tools/adtui/validation/Validator$Result;", "moduleGradlePath", "intellij.android.core"})
public final class ModuleValidator
implements Validator<String> {
    private final String projectPath;
    private final PathValidator pathValidator;
    private final CharMatcher ILLEGAL_CHAR_MATCHER;
    @NotNull
    private final Project project;

    @NotNull
    public Validator.Result validate(@NotNull String moduleGradlePath) {
        Validator.Result result2;
        Intrinsics.checkNotNullParameter((Object)moduleGradlePath, (String)"moduleGradlePath");
        int illegalCharIdx = this.ILLEGAL_CHAR_MATCHER.indexIn((CharSequence)moduleGradlePath);
        String rootedModuleGradlePath = StringsKt.startsWith$default((String)moduleGradlePath, (String)":", (boolean)false, (int)2, null) ? moduleGradlePath : ":" + moduleGradlePath;
        CharSequence charSequence = moduleGradlePath;
        boolean bl = false;
        if (charSequence.length() == 0) {
            String string = AndroidBundle.message("android.wizard.validate.empty.module.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"android.wizard.\u2026idate.empty.module.name\")");
            result2 = new Validator.Result(Validator.Severity.ERROR, string, null, 4, null);
        } else if (illegalCharIdx >= 0) {
            String string = AndroidBundle.message("android.wizard.validate.module.illegal.character", Character.valueOf(moduleGradlePath.charAt(illegalCharIdx)), moduleGradlePath);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"android.wizard.\u2026arIdx], moduleGradlePath)");
            result2 = new Validator.Result(Validator.Severity.ERROR, string, null, 4, null);
        } else if (GradleUtil.findModuleByGradlePath(this.project, rootedModuleGradlePath) != null) {
            String string = AndroidBundle.message("android.wizard.validate.module.already.exists", moduleGradlePath);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"android.wizard.\u2026xists\", moduleGradlePath)");
            result2 = new Validator.Result(Validator.Severity.ERROR, string, null, 4, null);
        } else {
            result2 = this.pathValidator.validate(ModuleModelKt.getModuleRoot(this.projectPath, moduleGradlePath));
        }
        return result2;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public ModuleValidator(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        String string = this.project.getBasePath();
        Intrinsics.checkNotNull((Object)string);
        this.projectPath = string;
        this.pathValidator = PathValidator.Companion.createDefault("module location");
        this.ILLEGAL_CHAR_MATCHER = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.inRange((char)'0', (char)'9')).or(CharMatcher.anyOf((CharSequence)"_-: ")).negate();
    }
}

