/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.importing;

import com.android.tools.adtui.util.FormScalingUtil;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.ModuleImporter;
import com.android.tools.idea.gradle.project.ModuleToImport;
import com.android.tools.idea.npw.importing.ModuleWizardStepAdapter;
import com.android.tools.idea.npw.importing.ModulesTable;
import com.android.tools.idea.npw.importing.PrimaryModuleImportSettings;
import com.android.tools.idea.npw.importing.SourceToGradleModuleModel;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.ui.TextProperty;
import com.android.tools.idea.ui.wizard.WizardUtils;
import com.android.tools.idea.util.FormatUtil;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.tools.idea.wizard.model.SkippableWizardStep;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SourceToGradleModuleStep
extends SkippableWizardStep<SourceToGradleModuleModel> {
    private final BindingsManager myBindings;
    @NotNull
    private final JComponent myRootPanel;
    @NotNull
    private ValidatorPanel myValidatorPanel;
    private final BoolProperty myCanGoForward;
    @Nullable
    private ModelWizard.Facade myFacade;
    private JPanel myPanel;
    private TextFieldWithBrowseButton mySourceLocation;
    private JBScrollPane myModulesScroller;
    private ModulesTable myModulesPanel;
    private JLabel myRequiredModulesLabel;
    private JBLabel mySourceDirTitle;
    private PrimaryModuleImportSettings myPrimaryModel;
    private JBLabel myModuleNameLabel;
    private JTextField myModuleNameField;
    private JBLabel myPrimaryModuleState;
    @Nullable
    private VirtualFile myVFile;
    @Nullable
    private ModuleImporter myImporter;
    @Nullable
    private Collection<ModuleToImport> myModules;

    public SourceToGradleModuleStep(@NotNull SourceToGradleModuleModel model2) {
        if (model2 == null) {
            SourceToGradleModuleStep.$$$reportNull$$$0(0);
        }
        super(model2, AndroidBundle.message("android.wizard.module.import.source.title", new Object[0]));
        this.$$$setupUI$$$();
        this.myBindings = new BindingsManager();
        this.myCanGoForward = new BoolValueProperty();
        this.mySourceLocation.addBrowseFolderListener(AndroidBundle.message("android.wizard.module.import.source.browse.title", new Object[0]), AndroidBundle.message("android.wizard.module.import.source.browse.description", new Object[0]), ((SourceToGradleModuleModel)this.getModel()).getProject(), FileChooserDescriptorFactory.createSingleFileOrFolderDescriptor());
        this.myBindings.bindTwoWay(new TextProperty(this.mySourceLocation.getTextField()), model2.sourceLocation);
        this.myModulesPanel.bindPrimaryModuleEntryComponents(this.myPrimaryModel, this.myRequiredModulesLabel);
        this.myModulesPanel.addPropertyChangeListener("selectedModules", event -> {
            if ("selectedModules".equals(event.getPropertyName())) {
                this.updateStepStatus();
            }
        });
        this.myValidatorPanel = new ValidatorPanel((Disposable)this, (JComponent)this.myPanel);
        this.myValidatorPanel.registerValidator((ObservableValue)model2.sourceLocation, value2 -> this.updateStepStatus(model2.sourceLocation.get()), new ObservableValue[0]);
        if (((Boolean)StudioFlags.NPW_NEW_MODULE_WITH_SIDE_BAR.get()).booleanValue()) {
            this.myRootPanel = WizardUtils.wrapWithVScroll((JPanel)this.myValidatorPanel, WizardUtils.WIZARD_BORDER.SMALL);
        } else {
            this.mySourceDirTitle.setVisible(false);
            this.myRootPanel = WizardUtils.wrapWithVScroll((JPanel)this.myValidatorPanel);
        }
        FormScalingUtil.scaleComponentTree(this.getClass(), (JComponent)this.myRootPanel);
    }

    @Override
    protected void onWizardStarting(@NotNull ModelWizard.Facade wizard) {
        if (wizard == null) {
            SourceToGradleModuleStep.$$$reportNull$$$0(1);
        }
        this.myFacade = wizard;
    }

    @Override
    protected void onProceeding() {
        ((SourceToGradleModuleModel)this.getModel()).setModulesToImport(this.myModulesPanel.getSelectedModulesMap());
    }

    @Override
    public void dispose() {
        this.myBindings.releaseAll();
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        BoolProperty boolProperty = this.myCanGoForward;
        if (boolProperty == null) {
            SourceToGradleModuleStep.$$$reportNull$$$0(2);
        }
        return boolProperty;
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        JComponent jComponent = this.myRootPanel;
        if (jComponent == null) {
            SourceToGradleModuleStep.$$$reportNull$$$0(3);
        }
        return jComponent;
    }

    @Override
    @Nullable
    protected JComponent getPreferredFocusComponent() {
        return this.mySourceLocation;
    }

    @Override
    @NotNull
    protected Collection<? extends ModelWizardStep<ModuleWizardStepAdapter.AdapterModel>> createDependentSteps() {
        WizardContext context = ((SourceToGradleModuleModel)this.getModel()).getContext();
        ArrayList<ModuleWizardStepAdapter> wrappedSteps = new ArrayList<ModuleWizardStepAdapter>();
        for (ModuleImporter importer : ModuleImporter.getAllImporters(context)) {
            for (ModuleWizardStep moduleWizardStep : importer.createWizardSteps()) {
                wrappedSteps.add(new ModuleWizardStepAdapter(context, moduleWizardStep));
            }
        }
        ArrayList<ModuleWizardStepAdapter> arrayList = wrappedSteps;
        if (arrayList == null) {
            SourceToGradleModuleStep.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    @VisibleForTesting
    Validator.Result updateStepStatus(@NotNull String path2) {
        if (path2 == null) {
            SourceToGradleModuleStep.$$$reportNull$$$0(5);
        }
        this.myPrimaryModel.setVisible(false);
        this.myRequiredModulesLabel.setVisible(false);
        this.myModulesScroller.setVisible(false);
        if (Strings.isNullOrEmpty((String)path2)) {
            this.myCanGoForward.set(false);
            Validator.Result result2 = Validator.Result.OK;
            if (result2 == null) {
                SourceToGradleModuleStep.$$$reportNull$$$0(6);
            }
            return result2;
        }
        Validator.Result result3 = this.checkPath(path2);
        if (result3.getSeverity() != Validator.Severity.ERROR) {
            this.updateModuleValidation();
        }
        this.updateStepStatus();
        Validator.Result result4 = result3;
        if (result4 == null) {
            SourceToGradleModuleStep.$$$reportNull$$$0(7);
        }
        return result4;
    }

    private void updateModuleValidation() {
        this.myModulesPanel.setModules(((SourceToGradleModuleModel)this.getModel()).getProject(), this.myVFile, this.myModules);
        this.myModulesScroller.setVisible(this.myModulesPanel.getComponentCount() > 0);
        this.myRootPanel.revalidate();
        this.myRootPanel.repaint();
        ModuleImporter.setImporter(((SourceToGradleModuleModel)this.getModel()).getContext(), this.myImporter);
        assert (this.myFacade != null);
        this.myFacade.updateNavigationProperties();
    }

    private void updateStepStatus() {
        if (this.myModulesPanel.getSelectedModules().isEmpty()) {
            this.myCanGoForward.set(false);
            return;
        }
        this.myCanGoForward.set((Boolean)this.myValidatorPanel.hasErrors().get() == false && this.myModulesPanel.canImport());
    }

    @NotNull
    @VisibleForTesting
    Validator.Result checkPath(@NotNull String path2) {
        if (path2 == null) {
            SourceToGradleModuleStep.$$$reportNull$$$0(8);
        }
        this.myVFile = VfsUtil.findFileByIoFile((File)new File(path2), (boolean)false);
        if (this.myVFile == null || !this.myVFile.exists()) {
            return new Validator.Result(Validator.Severity.ERROR, AndroidBundle.message("android.wizard.module.import.source.browse.invalid.location", new Object[0]));
        }
        if (this.isProjectOrModule(this.myVFile)) {
            return new Validator.Result(Validator.Severity.ERROR, AndroidBundle.message("android.wizard.module.import.source.browse.taken.location", new Object[0]));
        }
        this.myImporter = ModuleImporter.importerForLocation(((SourceToGradleModuleModel)this.getModel()).getContext(), this.myVFile);
        if (!this.myImporter.isValid()) {
            return new Validator.Result(Validator.Severity.ERROR, AndroidBundle.message("android.wizard.module.import.source.browse.cant.import", new Object[0]));
        }
        this.myModules = (Collection)ApplicationManager.getApplication().runReadAction(() -> {
            try {
                return this.myImporter.findModules(this.myVFile);
            }
            catch (IOException e) {
                Logger.getInstance(SourceToGradleModuleStep.class).error((Throwable)e);
                return null;
            }
        });
        if (this.myModules == null) {
            return new Validator.Result(Validator.Severity.ERROR, AndroidBundle.message("android.wizard.module.import.source.browse.error", new Object[0]));
        }
        TreeSet<String> missingSourceModuleNames = new TreeSet<String>();
        for (ModuleToImport module2 : this.myModules) {
            if (module2.location != null && module2.location.exists()) continue;
            missingSourceModuleNames.add(module2.name);
        }
        if (!missingSourceModuleNames.isEmpty()) {
            String formattedMessage = FormatUtil.formatElementListString(missingSourceModuleNames, AndroidBundle.message("android.wizard.module.import.source.browse.bad.modules.1", new Object[0]), AndroidBundle.message("android.wizard.module.import.source.browse.bad.modules.2", new Object[0]), AndroidBundle.message("android.wizard.module.import.source.browse.bad.modules.more", new Object[0]));
            String htmlFormattedMessage = WizardUtils.toHtmlString(formattedMessage);
            return new Validator.Result(Validator.Severity.WARNING, htmlFormattedMessage);
        }
        Validator.Result result2 = Validator.Result.OK;
        if (result2 == null) {
            SourceToGradleModuleStep.$$$reportNull$$$0(9);
        }
        return result2;
    }

    private boolean isProjectOrModule(@NotNull VirtualFile dir) {
        Project project;
        if (dir == null) {
            SourceToGradleModuleStep.$$$reportNull$$$0(10);
        }
        if (dir.equals(ProjectUtil.guessProjectDir((Project)(project = ((SourceToGradleModuleModel)this.getModel()).getProject())))) {
            return true;
        }
        for (Module module2 : ModuleManager.getInstance((Project)project).getModules()) {
            if (!ModuleUtilCore.isModuleDir((Module)module2, (VirtualFile)dir)) continue;
            return true;
        }
        return false;
    }

    private void createUIComponents() {
        this.myPrimaryModel = new PrimaryModuleImportSettings();
        this.myModuleNameLabel = this.myPrimaryModel.getModuleNameLabel();
        this.myModuleNameField = this.myPrimaryModel.getModuleNameField();
        this.myPrimaryModuleState = this.myPrimaryModel.getPrimaryModuleState();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wizard";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/importing/SourceToGradleModuleStep";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/importing/SourceToGradleModuleStep";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "canGoForward";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createDependentSteps";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "updateStepStatus";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "checkPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "onWizardStarting";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateStepStatus";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkPath";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isProjectOrModule";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ModulesTable modulesTable;
        JBScrollPane jBScrollPane;
        JLabel jLabel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JBLabel jBLabel;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.mySourceDirTitle = jBLabel = new JBLabel();
        jBLabel.setText("Gradle or Eclipse project");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(6, 1, 1, 1, 0, 2, 1, 7, null, new Dimension(1, 1), null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Source directory:");
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySourceLocation = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 1, new Dimension(-1, 16), new Dimension(-1, 40), new Dimension(-1, 40)));
        this.myRequiredModulesLabel = jLabel = new JLabel();
        jLabel.setText("Additional required modules:");
        jPanel.add((Component)jLabel, new GridConstraints(4, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myModulesScroller = jBScrollPane = new JBScrollPane();
        jBScrollPane.setHorizontalScrollBarPolicy(31);
        jBScrollPane.setVisible(false);
        jPanel.add((Component)jBScrollPane, new GridConstraints(5, 0, 1, 2, 0, 3, 7, 7, null, null, null));
        this.myModulesPanel = modulesTable = new ModulesTable();
        jBScrollPane.setViewportView((Component)((Object)modulesTable));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel3 = this.myModuleNameLabel;
        jBLabel3.setHorizontalAlignment(2);
        jBLabel3.setText("Module name");
        jPanel2.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JTextField jTextField = this.myModuleNameField;
        jPanel2.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel4 = this.myPrimaryModuleState;
        jBLabel4.setText("");
        jPanel2.add((Component)jBLabel4, new GridConstraints(0, 2, 1, 1, 0, 1, 7, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

