/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.dynamicapp;

import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.idea.npw.dynamicapp.DeviceFeatureModel;
import com.android.tools.idea.npw.dynamicapp.ModuleDownloadDeviceFeature;
import com.android.tools.idea.npw.dynamicapp.ModuleDownloadDeviceFeatureListener;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.collections.ObservableList;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.expressions.bool.AndExpression;
import com.intellij.openapi.project.Project;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class ModuleDownloadConditions {
    private static final String myLinkUrl = "org.jetbrains.android.r/studio-ui/dynamic-delivery/conditional-delivery";
    public JPanel myRootPanel;
    private JPanel myDeviceFeaturesContainer;
    private LinkLabel<Void> myAddDeviceFeatureLinkLabel;
    private HyperlinkLabel myFeatureHelpLink;
    private ObservableList<DeviceFeatureModel> myModel;
    private ObservableValue<Boolean> myIsPanelActive;
    private Project myProject;
    private ValidatorPanel myValidatorPanel;

    public ModuleDownloadConditions() {
        this.$$$setupUI$$$();
        this.myDeviceFeaturesContainer.setLayout(new BoxLayout(this.myDeviceFeaturesContainer, 1));
        this.myAddDeviceFeatureLinkLabel.setIcon(null);
        this.myAddDeviceFeatureLinkLabel.setName("ModuleDownloadConditions.myAddDeviceFeatureLinkLabel");
        this.myDeviceFeaturesContainer.setName("ModuleDownloadConditions.myDeviceFeaturesContainer");
        this.myAddDeviceFeatureLinkLabel.setListener((LinkListener)new LinkListener<Void>(){

            public void linkSelected(LinkLabel<Void> aSource, Void aLinkData) {
                ModuleDownloadConditions.this.addDeviceFeatureRow();
            }
        }, null);
        this.myFeatureHelpLink.setHyperlinkTarget(myLinkUrl);
        this.myFeatureHelpLink.setHtmlText("<html><a>Learn more</a> about supported conditions, such as device features and user country</html>");
    }

    public void init(@NotNull Project project, @NotNull ValidatorPanel validatorPanel2, @NotNull ObservableValue<Boolean> isPanelActive) {
        if (project == null) {
            ModuleDownloadConditions.$$$reportNull$$$0(0);
        }
        if (validatorPanel2 == null) {
            ModuleDownloadConditions.$$$reportNull$$$0(1);
        }
        if (isPanelActive == null) {
            ModuleDownloadConditions.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myValidatorPanel = validatorPanel2;
        this.myIsPanelActive = isPanelActive;
    }

    public void setModel(@NotNull ObservableList<DeviceFeatureModel> model2) {
        if (model2 == null) {
            ModuleDownloadConditions.$$$reportNull$$$0(3);
        }
        this.myModel = model2;
    }

    private void addDeviceFeatureRow() {
        if (this.myModel != null) {
            final DeviceFeatureModel deviceFeature = new DeviceFeatureModel();
            this.myModel.add(deviceFeature);
            final BoolValueProperty isFeatureActive = new BoolValueProperty(true);
            AndExpression isFeatureActiveExpression = new AndExpression((ObservableValue<Boolean>)isFeatureActive, this.myIsPanelActive);
            ModuleDownloadDeviceFeature deviceFeatureForm = new ModuleDownloadDeviceFeature(this.myProject, deviceFeature, isFeatureActiveExpression, this.myValidatorPanel);
            deviceFeatureForm.addListener(new ModuleDownloadDeviceFeatureListener(){

                @Override
                public void removeFeatureInvoked() {
                    isFeatureActive.set(false);
                    deviceFeature.deviceFeatureValue.clear();
                    ModuleDownloadConditions.this.removeDeviceFeatureRow(deviceFeature);
                }
            });
            this.myDeviceFeaturesContainer.add((Component)deviceFeatureForm.getComponent(), -1);
            this.myDeviceFeaturesContainer.revalidate();
            this.myDeviceFeaturesContainer.repaint();
        }
    }

    private void removeDeviceFeatureRow(@NotNull DeviceFeatureModel deviceFeatureModel) {
        int rowIndex;
        if (deviceFeatureModel == null) {
            ModuleDownloadConditions.$$$reportNull$$$0(4);
        }
        if ((rowIndex = this.myModel.indexOf(deviceFeatureModel)) < 0) {
            return;
        }
        this.myModel.remove(rowIndex);
        this.myDeviceFeaturesContainer.remove(rowIndex);
        this.myDeviceFeaturesContainer.revalidate();
        this.myDeviceFeaturesContainer.repaint();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validatorPanel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isPanelActive";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceFeatureModel";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/npw/dynamicapp/ModuleDownloadConditions";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "init";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "removeDeviceFeatureRow";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        HyperlinkLabel hyperlinkLabel;
        LinkLabel linkLabel;
        JPanel jPanel;
        JPanel jPanel2;
        this.myRootPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myDeviceFeaturesContainer = jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 4, 0, 3, 7, 3, null, null, null));
        this.myAddDeviceFeatureLinkLabel = linkLabel = new LinkLabel();
        linkLabel.setText("+ device-feature");
        jPanel2.add((Component)linkLabel, new GridConstraints(1, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(4, 0, 1, 3, 0, 2, 1, 6, null, null, null));
        this.myFeatureHelpLink = hyperlinkLabel = new HyperlinkLabel();
        hyperlinkLabel.setText("");
        jPanel2.add((Component)hyperlinkLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(2, 0, 1, 3, 0, 2, 1, 0, null, new Dimension(-1, 16), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

