/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.wizard;

import com.android.resources.Density;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.adtui.validation.validators.FalseValidator;
import com.android.tools.idea.npw.assetstudio.IconGenerator;
import com.android.tools.idea.npw.assetstudio.ProportionalImageScaler;
import com.android.tools.idea.npw.assetstudio.wizard.GenerateIconsModel;
import com.android.tools.idea.npw.assetstudio.wizard.PersistentState;
import com.android.tools.idea.npw.assetstudio.wizard.PersistentStateUtil;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.ui.SelectedItemProperty;
import com.android.tools.idea.projectsystem.NamedModuleTemplate;
import com.android.tools.idea.ui.wizard.ProposedFileTreeCellRenderer;
import com.android.tools.idea.ui.wizard.ProposedFileTreeModel;
import com.android.tools.idea.ui.wizard.WizardUtils;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.NotNull;

public final class ConfirmGenerateIconsStep
extends ModelWizardStep<GenerateIconsModel>
implements PersistentStateComponent<PersistentState> {
    private static final int MAX_ICON_HEIGHT = 24;
    private static final String CONFIRMATION_STEP_PROPERTY = "confirmationStep";
    private static final String RESOURCE_DIRECTORY_PROPERTY = "resourceDirectory";
    private final List<NamedModuleTemplate> myTemplates;
    private final ValidatorPanel myValidatorPanel;
    private final ListenerManager myListeners;
    private JPanel myRootPanel;
    private JComboBox<NamedModuleTemplate> myPathsComboBox;
    private Tree myOutputPreviewTree;
    private ObjectProperty<NamedModuleTemplate> mySelectedTemplate;
    private final BoolProperty myFilesAlreadyExist;
    private ProposedFileTreeModel myProposedFileTreeModel;

    public ConfirmGenerateIconsStep(@NotNull GenerateIconsModel model2, @NotNull List<NamedModuleTemplate> templates) {
        if (model2 == null) {
            ConfirmGenerateIconsStep.$$$reportNull$$$0(0);
        }
        if (templates == null) {
            ConfirmGenerateIconsStep.$$$reportNull$$$0(1);
        }
        super(model2, "Confirm Icon Path");
        this.$$$setupUI$$$();
        this.myListeners = new ListenerManager();
        this.myFilesAlreadyExist = new BoolValueProperty();
        Preconditions.checkArgument((!templates.isEmpty() ? 1 : 0) != 0);
        this.myTemplates = templates;
        this.myValidatorPanel = new ValidatorPanel((Disposable)this, (JComponent)this.myRootPanel);
        DefaultComboBoxModel<NamedModuleTemplate> moduleTemplatesModel = new DefaultComboBoxModel<NamedModuleTemplate>();
        for (NamedModuleTemplate template : templates) {
            moduleTemplatesModel.addElement(template);
        }
        this.myPathsComboBox.setRenderer((ListCellRenderer<NamedModuleTemplate>)SimpleListCellRenderer.create((String)"", NamedModuleTemplate::getName));
        this.myPathsComboBox.setModel(moduleTemplatesModel);
        DefaultTreeModel emptyModel = new DefaultTreeModel(null);
        this.myOutputPreviewTree.setModel((TreeModel)emptyModel);
        this.myOutputPreviewTree.setCellRenderer((TreeCellRenderer)((Object)new ProposedFileTreeCellRenderer()));
        this.myOutputPreviewTree.setBorder(BorderFactory.createLineBorder(UIUtil.getBoundsColor()));
        this.myOutputPreviewTree.setRowHeight(-1);
        this.myOutputPreviewTree.getEmptyText().setText("No resource folder defined in project");
        String alreadyExistsError = WizardUtils.toHtmlString("Some files (shown in red) will overwrite existing files.");
        this.myValidatorPanel.registerValidator((ObservableValue)this.myFilesAlreadyExist, (Validator)new FalseValidator(Validator.Severity.WARNING, alreadyExistsError), new ObservableValue[0]);
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        ValidatorPanel validatorPanel2 = this.myValidatorPanel;
        if (validatorPanel2 == null) {
            ConfirmGenerateIconsStep.$$$reportNull$$$0(2);
        }
        return validatorPanel2;
    }

    @Override
    protected void onWizardStarting(@NotNull ModelWizard.Facade wizard) {
        if (wizard == null) {
            ConfirmGenerateIconsStep.$$$reportNull$$$0(3);
        }
        this.mySelectedTemplate = ObjectProperty.wrap(new SelectedItemProperty(this.myPathsComboBox));
        PersistentStateUtil.load(this, ((GenerateIconsModel)this.getModel()).getPersistentState().getChild(CONFIRMATION_STEP_PROPERTY));
    }

    @Override
    public void onWizardFinished() {
        ((GenerateIconsModel)this.getModel()).getPersistentState().setChild(CONFIRMATION_STEP_PROPERTY, this.getState());
    }

    @NotNull
    public PersistentState getState() {
        PersistentState state = new PersistentState();
        NamedModuleTemplate moduleTemplate = (NamedModuleTemplate)this.mySelectedTemplate.get();
        state.set(RESOURCE_DIRECTORY_PROPERTY, moduleTemplate.getName(), this.myTemplates.get(0).getName());
        PersistentState persistentState = state;
        if (persistentState == null) {
            ConfirmGenerateIconsStep.$$$reportNull$$$0(4);
        }
        return persistentState;
    }

    public void loadState(@NotNull PersistentState state) {
        String templateName;
        if (state == null) {
            ConfirmGenerateIconsStep.$$$reportNull$$$0(5);
        }
        if ((templateName = state.get(RESOURCE_DIRECTORY_PROPERTY)) != null) {
            for (NamedModuleTemplate template : this.myTemplates) {
                if (!template.getName().equals(templateName)) continue;
                this.mySelectedTemplate.set(template);
                break;
            }
        }
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        ObservableBool observableBool = this.myValidatorPanel.hasErrors().not();
        if (observableBool == null) {
            ConfirmGenerateIconsStep.$$$reportNull$$$0(6);
        }
        return observableBool;
    }

    @Override
    protected void onProceeding() {
        ((GenerateIconsModel)this.getModel()).setPaths(((NamedModuleTemplate)this.mySelectedTemplate.get()).getPaths());
        ((GenerateIconsModel)this.getModel()).setFilesToDelete(this.myProposedFileTreeModel.getShadowConflictedFiles());
    }

    @Override
    protected void onEntering() {
        this.myListeners.release(this.mySelectedTemplate);
        this.myListeners.listenAndFire(this.mySelectedTemplate, template -> {
            IconGenerator iconGenerator = ((GenerateIconsModel)this.getModel()).getIconGenerator();
            File resDirectory = IconGenerator.getResDirectory(template.getPaths());
            if (iconGenerator == null || resDirectory == null || resDirectory.getParentFile() == null) {
                return;
            }
            Map<File, BufferedImage> pathToUnscaledImage = iconGenerator.generateIntoFileMap(resDirectory);
            TreeMap pathToIcon = Maps.newTreeMap((file1, file2) -> {
                Density density2;
                String path1 = file1.getAbsolutePath();
                String path2 = file2.getAbsolutePath();
                Density density1 = IconGenerator.pathToDensity(path1);
                int cmp = Boolean.compare(density1 != null, (density2 = IconGenerator.pathToDensity(path2)) != null);
                if (cmp != 0) {
                    return cmp;
                }
                if (density1 != null && density1 != density2) {
                    return Integer.compare(density2.getDpiValue(), density1.getDpiValue());
                }
                BufferedImage image1 = (BufferedImage)pathToUnscaledImage.get(file1);
                BufferedImage image2 = (BufferedImage)pathToUnscaledImage.get(file2);
                cmp = Integer.compare(image2.getHeight(), image1.getHeight());
                return cmp != 0 ? cmp : path2.compareTo(path1);
            });
            ProportionalImageScaler imageScaler = ProportionalImageScaler.forImages(pathToUnscaledImage.values());
            for (Map.Entry<File, BufferedImage> entry : pathToUnscaledImage.entrySet()) {
                Image image = imageScaler.scale(entry.getValue(), 24);
                pathToIcon.put(entry.getKey(), new ImageIcon(image));
            }
            this.myProposedFileTreeModel = new ProposedFileTreeModel(resDirectory.getParentFile(), pathToIcon);
            this.myFilesAlreadyExist.set(this.myProposedFileTreeModel.hasConflicts());
            this.myOutputPreviewTree.setModel((TreeModel)this.myProposedFileTreeModel);
            for (int i2 = 0; i2 < this.myOutputPreviewTree.getRowCount(); ++i2) {
                this.myOutputPreviewTree.expandRow(i2);
            }
        });
    }

    @Override
    public void dispose() {
        this.myListeners.releaseAll();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templates";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/assetstudio/wizard/ConfirmGenerateIconsStep";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wizard";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/assetstudio/wizard/ConfirmGenerateIconsStep";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "canGoForward";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "onWizardStarting";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        Tree tree;
        JPanel jPanel;
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        jLabel.setText("Res Directory:");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Output Directories:");
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myPathsComboBox = jComboBox;
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        jComboBox.setModel(defaultComboBoxModel);
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(1, 1, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myOutputPreviewTree = tree = new Tree();
        tree.setOpaque(false);
        tree.setToolTipText("A preview rendering of the output tree");
        jBScrollPane.setViewportView((Component)tree);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

