/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.assets;

import com.android.ide.common.util.AssetUtil;
import com.android.ide.common.vectordrawable.PathBuilder;
import com.android.utils.XmlUtils;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VectorTextRenderer {
    private static final String INDENT = "  ";
    private static final String DOUBLE_INDENT = "    ";

    @NotNull
    public static String renderToVectorDrawable(@NotNull String text2, @NotNull String fontFamily, int fontSize, @Nullable Color color, double opacity) {
        if (text2 == null) {
            VectorTextRenderer.$$$reportNull$$$0(0);
        }
        if (fontFamily == null) {
            VectorTextRenderer.$$$reportNull$$$0(1);
        }
        String[] lines2 = StringUtil.splitByLines((String)StringUtil.trimTrailing((String)text2));
        StringBuilder result2 = new StringBuilder();
        Font font = new Font(fontFamily, 0, fontSize);
        BufferedImage newImage = AssetUtil.newArgbBufferedImage((int)fontSize, (int)fontSize);
        Graphics2D gc = (Graphics2D)newImage.getGraphics();
        FontRenderContext frc = gc.getFontRenderContext();
        RectangularShape textBounds = null;
        for (String line2 : lines2) {
            LineMetrics lineMetrics = font.getLineMetrics(line2, frc);
            GlyphVector glyphVector = font.createGlyphVector(frc, line2);
            Rectangle2D lineBounds = glyphVector.getLogicalBounds();
            if (textBounds == null) {
                textBounds = lineBounds;
                continue;
            }
            ((Rectangle2D)textBounds).setRect(textBounds.getX(), textBounds.getY(), Math.max(textBounds.getWidth(), lineBounds.getWidth()), textBounds.getHeight() + (double)lineMetrics.getLeading() + lineBounds.getHeight());
        }
        double viewportWidth = textBounds.getWidth();
        double viewportHeight = textBounds.getHeight();
        result2.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        result2.append(String.format("<vector %s:%s=\"%s\"", "xmlns", "android", "http://schemas.android.com/apk/res/android"));
        result2.append('\n').append(DOUBLE_INDENT).append("android:width=\"").append(XmlUtils.formatFloatValue((double)textBounds.getWidth())).append("dp\"");
        result2.append('\n').append(DOUBLE_INDENT).append("android:height=\"").append(XmlUtils.formatFloatValue((double)textBounds.getHeight())).append("dp\"");
        result2.append('\n').append(DOUBLE_INDENT).append("android:viewportWidth=\"").append(XmlUtils.formatFloatValue((double)viewportWidth)).append("\"");
        result2.append('\n').append(DOUBLE_INDENT).append("android:viewportHeight=\"").append(XmlUtils.formatFloatValue((double)viewportHeight)).append("\">");
        double lineOffsetY = 0.0;
        for (String line3 : lines2) {
            String translateY;
            LineMetrics lineMetrics = font.getLineMetrics(line3, frc);
            GlyphVector glyphVector = font.createGlyphVector(frc, line3);
            Rectangle2D lineBounds = glyphVector.getLogicalBounds();
            double offsetX = -textBounds.getX();
            double offsetY = -lineBounds.getY() + lineOffsetY;
            lineOffsetY += (double)lineMetrics.getLeading() + lineBounds.getHeight();
            Object indent = INDENT;
            String translateX = VectorTextRenderer.isSignificantlyDifferentFromZero(offsetX) ? XmlUtils.formatFloatValue((double)offsetX) : null;
            String string = translateY = VectorTextRenderer.isSignificantlyDifferentFromZero(offsetY) ? XmlUtils.formatFloatValue((double)offsetY) : null;
            if (translateX != null || translateY != null) {
                result2.append('\n').append(INDENT);
                result2.append("<group");
                if (translateX != null) {
                    result2.append(' ').append("android:translateX=\"").append(translateX).append('\"');
                }
                if (translateY != null) {
                    result2.append(' ').append("android:translateY=\"").append(translateY).append('\"');
                }
                result2.append('>');
                indent = (String)indent + INDENT;
            }
            if (color != null && opacity != 0.0) {
                int numGlyphs = glyphVector.getNumGlyphs();
                float[] coords = new float[6];
                for (int i2 = 0; i2 < numGlyphs; ++i2) {
                    Shape outline = glyphVector.getGlyphOutline(i2);
                    VectorTextRenderer.renderGlyph(outline, (String)indent, color, opacity, coords, result2);
                }
            }
            if (translateX == null && translateY == null) continue;
            result2.append('\n').append(INDENT).append("</group>");
        }
        result2.append('\n').append("</vector>");
        String string = result2.toString();
        if (string == null) {
            VectorTextRenderer.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static boolean isSignificantlyDifferentFromZero(double value2) {
        return Math.abs(value2) >= 1.0E-6;
    }

    /*
     * WARNING - void declaration
     */
    private static void renderGlyph(@NotNull Shape outline, @NotNull String indent, @NotNull Color color, double opacity, @NotNull float[] coords, @NotNull StringBuilder stringBuilder) {
        if (outline == null) {
            VectorTextRenderer.$$$reportNull$$$0(3);
        }
        if (indent == null) {
            VectorTextRenderer.$$$reportNull$$$0(4);
        }
        if (color == null) {
            VectorTextRenderer.$$$reportNull$$$0(5);
        }
        if (stringBuilder == null) {
            VectorTextRenderer.$$$reportNull$$$0(6);
        }
        if (coords == null) {
            VectorTextRenderer.$$$reportNull$$$0(7);
        }
        PathIterator pathIterator = outline.getPathIterator(null);
        int windingRule = pathIterator.getWindingRule();
        PathBuilder pathBuilder = new PathBuilder();
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(coords)) {
                case 0: {
                    pathBuilder.absoluteMoveTo((double)coords[0], (double)coords[1]);
                    break;
                }
                case 1: {
                    pathBuilder.absoluteLineTo((double)coords[0], (double)coords[1]);
                    break;
                }
                case 2: {
                    pathBuilder.absoluteQuadraticCurveTo((double)coords[0], (double)coords[1], (double)coords[2], (double)coords[3]);
                    break;
                }
                case 3: {
                    pathBuilder.absoluteCurveTo((double)coords[0], (double)coords[1], (double)coords[2], (double)coords[3], (double)coords[4], (double)coords[5]);
                    break;
                }
                case 4: {
                    pathBuilder.absoluteClose();
                }
            }
            pathIterator.next();
        }
        if (!pathBuilder.isEmpty()) {
            void result2;
            result2.append('\n').append(indent).append("<path android:pathData=\"").append(pathBuilder.toString()).append('\"').append('\n').append(indent).append(DOUBLE_INDENT).append("android:fillColor=\"").append(String.format("#%06X", color.getRGB() & 0xFFFFFF)).append('\"');
            String opacityValue = XmlUtils.formatFloatValue((double)opacity);
            if (!opacityValue.equals("1")) {
                result2.append('\n').append(indent).append(DOUBLE_INDENT).append("android:fillAlpha=\"").append(opacityValue).append('\"');
            }
            if (windingRule == 0) {
                result2.append('\n').append(indent).append(DOUBLE_INDENT).append("android:fillType=\"evenOdd\"");
            }
            result2.append("/>");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontFamily";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/assetstudio/assets/VectorTextRenderer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outline";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coords";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/assetstudio/assets/VectorTextRenderer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "renderToVectorDrawable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "renderToVectorDrawable";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "renderGlyph";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

