/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.ide.common.util.PathString;
import com.android.resources.Density;
import com.android.tools.idea.npw.assetstudio.AnnotatedImage;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.GeneratedIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedXmlResource;
import com.android.tools.idea.npw.assetstudio.GraphicGeneratorContext;
import com.android.tools.idea.npw.assetstudio.IconCategory;
import com.android.tools.idea.npw.assetstudio.IconGenerator;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.npw.assetstudio.assets.VectorAsset;
import com.intellij.openapi.project.Project;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VectorIconGenerator
extends IconGenerator {
    public VectorIconGenerator(@NotNull Project project, int minSdkVersion2) {
        if (project == null) {
            VectorIconGenerator.$$$reportNull$$$0(0);
        }
        super(project, minSdkVersion2, new GraphicGeneratorContext(40, null));
    }

    @Override
    @NotNull
    public VectorIconOptions createOptions(boolean forPreview) {
        VectorIconOptions options2 = new VectorIconOptions(forPreview);
        BaseAsset asset = this.sourceAsset().getValueOrNull();
        if (asset != null) {
            options2.sourceImageFuture = asset.toImage();
            options2.isTrimmed = (Boolean)asset.trimmed().get();
            options2.paddingPercent = (Integer)asset.paddingPercent().get();
        }
        options2.density = Density.ANYDPI;
        VectorIconOptions vectorIconOptions = options2;
        if (vectorIconOptions == null) {
            VectorIconGenerator.$$$reportNull$$$0(1);
        }
        return vectorIconOptions;
    }

    @Override
    @NotNull
    public AnnotatedImage generateRasterImage(@NotNull GraphicGeneratorContext context, @NotNull IconGenerator.IconOptions options2) {
        if (context == null) {
            VectorIconGenerator.$$$reportNull$$$0(2);
        }
        if (options2 == null) {
            VectorIconGenerator.$$$reportNull$$$0(3);
        }
        if (options2.usePlaceholders) {
            AnnotatedImage annotatedImage = PLACEHOLDER_IMAGE;
            if (annotatedImage == null) {
                VectorIconGenerator.$$$reportNull$$$0(4);
            }
            return annotatedImage;
        }
        BufferedImage image = VectorIconGenerator.getTrimmedAndPaddedImage(options2);
        if (image == null) {
            AnnotatedImage annotatedImage = PLACEHOLDER_IMAGE;
            if (annotatedImage == null) {
                VectorIconGenerator.$$$reportNull$$$0(5);
            }
            return annotatedImage;
        }
        return new AnnotatedImage(image, null);
    }

    @Nullable
    private static BufferedImage getTrimmedAndPaddedImage(@NotNull IconGenerator.IconOptions options2) {
        if (options2 == null) {
            VectorIconGenerator.$$$reportNull$$$0(6);
        }
        if (options2.sourceImageFuture == null) {
            return null;
        }
        try {
            BufferedImage image = (BufferedImage)options2.sourceImageFuture.get();
            if (image != null) {
                if (options2.isTrimmed) {
                    image = AssetStudioUtils.trim(image);
                }
                if (options2.paddingPercent != 0) {
                    image = AssetStudioUtils.pad(image, options2.paddingPercent);
                }
            }
            return image;
        }
        catch (InterruptedException | ExecutionException e) {
            return null;
        }
    }

    @Override
    @NotNull
    public Collection<GeneratedIcon> generateIcons(@NotNull GraphicGeneratorContext context, @NotNull IconGenerator.IconOptions options2, @NotNull String name) {
        VectorAsset vectorAsset;
        VectorAsset.Preview result2;
        if (context == null) {
            VectorIconGenerator.$$$reportNull$$$0(7);
        }
        if (options2 == null) {
            VectorIconGenerator.$$$reportNull$$$0(8);
        }
        if (name == null) {
            VectorIconGenerator.$$$reportNull$$$0(9);
        }
        if (!(result2 = (vectorAsset = (VectorAsset)this.sourceAsset().getValue()).generatePreview()).isValid()) {
            Set<GeneratedIcon> set = Collections.emptySet();
            if (set == null) {
                VectorIconGenerator.$$$reportNull$$$0(10);
            }
            return set;
        }
        String xmlContent = result2.getXmlContent();
        assert (xmlContent != null);
        GeneratedXmlResource icon2 = new GeneratedXmlResource(name, new PathString(this.getIconPath(options2, name)), IconCategory.XML_RESOURCE, xmlContent);
        Set<GeneratedIcon> set = Collections.singleton(icon2);
        if (set == null) {
            VectorIconGenerator.$$$reportNull$$$0(11);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/assetstudio/VectorIconGenerator";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/assetstudio/VectorIconGenerator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptions";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "generateRasterImage";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "generateIcons";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 10: 
            case 11: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "generateRasterImage";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTrimmedAndPaddedImage";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "generateIcons";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class VectorIconOptions
    extends IconGenerator.IconOptions {
        public VectorIconOptions(boolean forPreview) {
            super(forPreview);
            this.iconFolderKind = IconGenerator.IconFolderKind.DRAWABLE_NO_DPI;
        }
    }
}

