/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.ide.common.util.PathString;
import com.android.resources.Density;
import com.android.tools.idea.npw.assetstudio.AdaptiveIconGenerator;
import com.android.tools.idea.npw.assetstudio.AnnotatedImage;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.GeneratedIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedImageIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedXmlResource;
import com.android.tools.idea.npw.assetstudio.GraphicGeneratorContext;
import com.android.tools.idea.npw.assetstudio.IconCategory;
import com.android.tools.idea.npw.assetstudio.IconGenerator;
import com.android.tools.idea.npw.assetstudio.PrimitiveShapesHelper;
import com.android.tools.idea.npw.assetstudio.TransformedImageAsset;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.npw.assetstudio.assets.ImageAsset;
import com.android.tools.idea.npw.assetstudio.assets.TextAsset;
import com.android.tools.idea.rendering.DrawableRenderer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TvChannelIconGenerator
extends AdaptiveIconGenerator {
    private static final Rectangle IMAGE_SIZE_FULL_BLEED_DP = new Rectangle(0, 0, 120, 120);
    private static final Dimension SIZE_FULL_BLEED_DP = IMAGE_SIZE_FULL_BLEED_DP.getSize();
    private static final Rectangle IMAGE_SIZE_SAFE_ZONE_DP = new Rectangle(0, 0, 73, 73);
    private static final Rectangle IMAGE_SIZE_VIEWPORT_DP = new Rectangle(0, 0, 80, 80);
    private static final Rectangle IMAGE_SIZE_LEGACY_DP = new Rectangle(0, 0, 80, 80);
    private static final Density LEGACY_DENSITY = Density.XHIGH;
    private static final double PREVIEW_SCALE = 0.6;

    public TvChannelIconGenerator(@NotNull Project project, int minSdkVersion2, @Nullable DrawableRenderer renderer2) {
        if (project == null) {
            TvChannelIconGenerator.$$$reportNull$$$0(0);
        }
        super(project, minSdkVersion2, new GraphicGeneratorContext(40, renderer2));
    }

    @Override
    @NotNull
    public TvChannelIconOptions createOptions(boolean forPreview) {
        ImageAsset backgroundAsset;
        double scaleFactor;
        TvChannelIconOptions options2 = new TvChannelIconOptions(forPreview);
        BaseAsset foregroundAsset = this.sourceAsset().getValueOrNull();
        if (foregroundAsset != null) {
            Color color;
            options2.useForegroundColor = foregroundAsset.isColorable();
            Color color2 = color = foregroundAsset.isColorable() ? (Color)foregroundAsset.color().getValueOrNull() : null;
            if (color != null) {
                options2.foregroundColor = color.getRGB();
            }
            scaleFactor = (double)((Integer)foregroundAsset.scalingPercent().get()).intValue() / 100.0;
            if (foregroundAsset instanceof ImageAsset && ((ImageAsset)foregroundAsset).isClipart()) {
                scaleFactor *= 0.58;
            } else if (foregroundAsset instanceof TextAsset) {
                scaleFactor *= 0.46;
            } else if (((Boolean)foregroundAsset.trimmed().get()).booleanValue()) {
                scaleFactor *= IMAGE_SIZE_SAFE_ZONE_DP.getWidth() / SIZE_FULL_BLEED_DP.getWidth();
            }
            options2.foregroundImage = new TransformedImageAsset(foregroundAsset, SIZE_FULL_BLEED_DP, scaleFactor, color, this.getGraphicGeneratorContext(), this.myLineSeparator);
        }
        if ((backgroundAsset = this.backgroundImageAsset().getValueOrNull()) != null) {
            scaleFactor = (double)((Integer)backgroundAsset.scalingPercent().get()).intValue() / 100.0;
            options2.backgroundImage = new TransformedImageAsset(backgroundAsset, SIZE_FULL_BLEED_DP, scaleFactor, null, this.getGraphicGeneratorContext(), this.myLineSeparator);
        }
        options2.backgroundColor = ((Color)this.backgroundColor().get()).getRGB();
        options2.showSafeZone = (Boolean)this.showSafeZone().get();
        options2.previewDensity = LEGACY_DENSITY;
        options2.foregroundLayerName = (String)this.foregroundLayerName().get();
        options2.backgroundLayerName = (String)this.backgroundLayerName().get();
        options2.generateLegacyIcon = (Boolean)this.generateLegacyIcon().get();
        TvChannelIconOptions tvChannelIconOptions = options2;
        if (tvChannelIconOptions == null) {
            TvChannelIconGenerator.$$$reportNull$$$0(1);
        }
        return tvChannelIconOptions;
    }

    @Override
    @NotNull
    protected List<Callable<GeneratedIcon>> createIconGenerationTasks(@NotNull GraphicGeneratorContext context, @NotNull IconGenerator.IconOptions options2, @NotNull String name) {
        if (context == null) {
            TvChannelIconGenerator.$$$reportNull$$$0(2);
        }
        if (options2 == null) {
            TvChannelIconGenerator.$$$reportNull$$$0(3);
        }
        if (name == null) {
            TvChannelIconGenerator.$$$reportNull$$$0(4);
        }
        TvChannelIconOptions launcherIconOptions = (TvChannelIconOptions)options2;
        ArrayList<Callable<GeneratedIcon>> tasks = new ArrayList<Callable<GeneratedIcon>>();
        this.createOutputIconsTasks(context, name, launcherIconOptions, tasks);
        this.createXmlDrawableResourcesTasks(name, launcherIconOptions, tasks);
        this.createPreviewImagesTasks(context, launcherIconOptions, tasks);
        ArrayList<Callable<GeneratedIcon>> arrayList = tasks;
        if (arrayList == null) {
            TvChannelIconGenerator.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private void createOutputIconsTasks(@NotNull GraphicGeneratorContext context, @NotNull String name, @NotNull TvChannelIconOptions options2, @NotNull List<Callable<GeneratedIcon>> tasks) {
        if (context == null) {
            TvChannelIconGenerator.$$$reportNull$$$0(6);
        }
        if (name == null) {
            TvChannelIconGenerator.$$$reportNull$$$0(7);
        }
        if (options2 == null) {
            TvChannelIconGenerator.$$$reportNull$$$0(8);
        }
        if (tasks == null) {
            TvChannelIconGenerator.$$$reportNull$$$0(9);
        }
        if (!options2.generateOutputIcons) {
            return;
        }
        TvChannelIconOptions localOptions = options2.clone();
        localOptions.density = LEGACY_DENSITY;
        this.createOutputIconsForSingleDensityTasks(context, name, localOptions, localOptions.density, tasks);
    }

    private void createOutputIconsForSingleDensityTasks(@NotNull GraphicGeneratorContext context, @NotNull String name, @NotNull TvChannelIconOptions options2, @NotNull Density density, @NotNull List<Callable<GeneratedIcon>> tasks) {
        if (context == null) {
            TvChannelIconGenerator.$$$reportNull$$$0(10);
        }
        if (name == null) {
            TvChannelIconGenerator.$$$reportNull$$$0(11);
        }
        if (options2 == null) {
            TvChannelIconGenerator.$$$reportNull$$$0(12);
        }
        if (density == null) {
            TvChannelIconGenerator.$$$reportNull$$$0(13);
        }
        if (tasks == null) {
            TvChannelIconGenerator.$$$reportNull$$$0(14);
        }
        if (options2.foregroundImage != null && options2.foregroundImage.isRasterImage()) {
            tasks.add(() -> {
                TvChannelIconOptions foregroundOptions = options2.clone();
                foregroundOptions.generatePreviewIcons = false;
                foregroundOptions.generateOutputIcons = true;
                AnnotatedImage foregroundImage = this.generateIconForegroundLayer(context, foregroundOptions);
                return new GeneratedImageIcon(foregroundOptions.foregroundLayerName, new PathString(this.getIconPath(foregroundOptions, options2.foregroundLayerName)), IconCategory.ADAPTIVE_FOREGROUND_LAYER, density, foregroundImage);
            });
        }
        if (options2.backgroundImage != null && options2.backgroundImage.isRasterImage()) {
            tasks.add(() -> {
                TvChannelIconOptions backgroundOptions = options2.clone();
                backgroundOptions.generatePreviewIcons = false;
                backgroundOptions.generateOutputIcons = true;
                AnnotatedImage backgroundImage = this.generateIconBackgroundLayer(context, backgroundOptions);
                return new GeneratedImageIcon(backgroundOptions.backgroundLayerName, new PathString(this.getIconPath(backgroundOptions, options2.backgroundLayerName)), IconCategory.ADAPTIVE_BACKGROUND_LAYER, density, backgroundImage);
            });
        }
        if (options2.generateLegacyIcon) {
            tasks.add(() -> {
                TvChannelIconOptions legacyOptions = options2.clone();
                legacyOptions.previewShape = PreviewShape.LEGACY;
                legacyOptions.generatePreviewIcons = false;
                legacyOptions.generateOutputIcons = true;
                AnnotatedImage legacy = this.generateLegacyImage(context, legacyOptions);
                return new GeneratedImageIcon(name, new PathString(this.getIconPath(legacyOptions, name)), IconCategory.LEGACY, density, legacy);
            });
        }
    }

    private void createXmlDrawableResourcesTasks(@NotNull String name, @NotNull TvChannelIconOptions options2, @NotNull List<Callable<GeneratedIcon>> tasks) {
        TransformedImageAsset image;
        if (name == null) {
            TvChannelIconGenerator.$$$reportNull$$$0(15);
        }
        if (options2 == null) {
            TvChannelIconGenerator.$$$reportNull$$$0(16);
        }
        if (tasks == null) {
            TvChannelIconGenerator.$$$reportNull$$$0(17);
        }
        if (!options2.generateOutputIcons) {
            return;
        }
        TvChannelIconOptions iconOptions = options2.clone();
        iconOptions.density = Density.ANYDPI;
        iconOptions.iconFolderKind = IconGenerator.IconFolderKind.MIPMAP;
        iconOptions.apiVersion = 26;
        tasks.add(() -> {
            String xmlAdaptiveIcon = this.getAdaptiveIconXml(iconOptions);
            return new GeneratedXmlResource(name, new PathString(this.getIconPath(iconOptions, name)), IconCategory.XML_RESOURCE, xmlAdaptiveIcon);
        });
        if (options2.foregroundImage != null && options2.foregroundImage.isDrawable()) {
            image = options2.foregroundImage;
            tasks.add(() -> {
                String xmlDrawableText;
                TvChannelIconOptions iconOptions = options2.clone();
                iconOptions.density = Density.ANYDPI;
                iconOptions.iconFolderKind = IconGenerator.IconFolderKind.DRAWABLE_NO_DPI;
                if (!image.isDrawable()) {
                    TvChannelIconGenerator.getLog().error("Background image is not drawable!", new Throwable());
                }
                if ((xmlDrawableText = image.getTransformedDrawable()) == null) {
                    TvChannelIconGenerator.getLog().error("Transformed foreground drawable is null" + (image.isDrawable() ? " but the image is drawable" : ""), new Throwable());
                    xmlDrawableText = "<vector/>";
                }
                iconOptions.apiVersion = this.calculateMinRequiredApiLevel(xmlDrawableText, this.myMinSdkVersion);
                return new GeneratedXmlResource(name, new PathString(this.getIconPath(iconOptions, iconOptions.foregroundLayerName)), IconCategory.ADAPTIVE_FOREGROUND_LAYER, xmlDrawableText);
            });
        }
        if (options2.backgroundImage != null && options2.backgroundImage.isDrawable()) {
            image = options2.backgroundImage;
            tasks.add(() -> {
                String xmlDrawableText;
                TvChannelIconOptions iconOptions = options2.clone();
                iconOptions.density = Density.ANYDPI;
                iconOptions.iconFolderKind = IconGenerator.IconFolderKind.DRAWABLE_NO_DPI;
                if (!image.isDrawable()) {
                    TvChannelIconGenerator.getLog().error("Background image is not drawable!", new Throwable());
                }
                if ((xmlDrawableText = image.getTransformedDrawable()) == null) {
                    TvChannelIconGenerator.getLog().error("Transformed background drawable is null" + (image.isDrawable() ? " but the image is drawable" : ""), new Throwable());
                    xmlDrawableText = "<vector/>";
                }
                iconOptions.apiVersion = this.calculateMinRequiredApiLevel(xmlDrawableText, this.myMinSdkVersion);
                return new GeneratedXmlResource(name, new PathString(this.getIconPath(iconOptions, iconOptions.backgroundLayerName)), IconCategory.ADAPTIVE_BACKGROUND_LAYER, xmlDrawableText);
            });
        } else if (options2.backgroundImage == null) {
            tasks.add(() -> {
                TvChannelIconOptions iconOptions = options2.clone();
                iconOptions.density = Density.ANYDPI;
                iconOptions.iconFolderKind = IconGenerator.IconFolderKind.VALUES;
                String format2 = "<?xml version=\"1.0\" encoding=\"utf-8\"?>%1$s<resources>%1$s    <color name=\"%2$s\">#%3$06X</color>%1$s</resources>";
                String xmlColor = String.format(format2, this.myLineSeparator, iconOptions.backgroundLayerName, iconOptions.backgroundColor & 0xFFFFFF);
                return new GeneratedXmlResource(name, new PathString(this.getIconPath(iconOptions, iconOptions.backgroundLayerName)), IconCategory.XML_RESOURCE, xmlColor);
            });
        }
    }

    private void createPreviewImagesTasks(@NotNull GraphicGeneratorContext context, @NotNull TvChannelIconOptions options2, @NotNull List<Callable<GeneratedIcon>> tasks) {
        if (context == null) {
            TvChannelIconGenerator.$$$reportNull$$$0(18);
        }
        if (options2 == null) {
            TvChannelIconGenerator.$$$reportNull$$$0(19);
        }
        if (tasks == null) {
            TvChannelIconGenerator.$$$reportNull$$$0(20);
        }
        if (!options2.generatePreviewIcons) {
            return;
        }
        ArrayList<PreviewShape> previewShapes = new ArrayList<PreviewShape>(2);
        previewShapes.add(PreviewShape.ADAPTIVE);
        if (options2.generateLegacyIcon) {
            previewShapes.add(PreviewShape.LEGACY);
        }
        for (PreviewShape previewShape : previewShapes) {
            tasks.add(() -> {
                AnnotatedImage image;
                TvChannelIconOptions localOptions = options2.clone();
                localOptions.density = options2.previewDensity;
                localOptions.previewShape = previewShape;
                localOptions.generateLegacyIcon = previewShape == PreviewShape.LEGACY;
                try {
                    image = this.generatePreviewImage(context, localOptions);
                }
                catch (Throwable e) {
                    TvChannelIconGenerator.getLog().error(e);
                    image = TvChannelIconGenerator.createPlaceholderErrorImage(e, localOptions);
                }
                return new GeneratedImageIcon(previewShape.id, null, IconCategory.PREVIEW, localOptions.density, image);
            });
        }
    }

    @Override
    public void generateRasterImage(@Nullable String category, @NotNull Map<String, Map<String, AnnotatedImage>> categoryMap, @NotNull GraphicGeneratorContext context, @NotNull IconGenerator.IconOptions options2, @NotNull String name) {
        if (categoryMap == null) {
            TvChannelIconGenerator.$$$reportNull$$$0(21);
        }
        if (context == null) {
            TvChannelIconGenerator.$$$reportNull$$$0(22);
        }
        if (options2 == null) {
            TvChannelIconGenerator.$$$reportNull$$$0(23);
        }
        if (name == null) {
            TvChannelIconGenerator.$$$reportNull$$$0(24);
        }
        TvChannelIconOptions launcherIconOptions = (TvChannelIconOptions)options2;
        TvChannelIconOptions localOptions = launcherIconOptions.clone();
        Collection<GeneratedIcon> icons = this.generateIcons(context, options2, name);
        icons.stream().filter(icon2 -> icon2 instanceof GeneratedImageIcon).map(icon2 -> (GeneratedImageIcon)icon2).filter(icon2 -> icon2.getOutputPath() != null).forEach(icon2 -> {
            assert (icon2.getOutputPath() != null);
            Map imageMap = categoryMap.computeIfAbsent(icon2.getCategory().toString(), k -> new LinkedHashMap());
            TvChannelIconOptions iconOptions = localOptions.clone();
            iconOptions.density = icon2.getDensity();
            iconOptions.iconFolderKind = IconGenerator.IconFolderKind.MIPMAP;
            imageMap.put(icon2.getOutputPath().toString(), new AnnotatedImage(icon2.getImage(), icon2.getErrorMessage()));
        });
    }

    @Override
    @NotNull
    public AnnotatedImage generateRasterImage(@NotNull GraphicGeneratorContext context, @NotNull IconGenerator.IconOptions options2) {
        if (context == null) {
            TvChannelIconGenerator.$$$reportNull$$$0(25);
        }
        if (options2 == null) {
            TvChannelIconGenerator.$$$reportNull$$$0(26);
        }
        if (options2.usePlaceholders) {
            AnnotatedImage annotatedImage = PLACEHOLDER_IMAGE;
            if (annotatedImage == null) {
                TvChannelIconGenerator.$$$reportNull$$$0(27);
            }
            return annotatedImage;
        }
        return this.generatePreviewImage(context, (TvChannelIconOptions)options2);
    }

    @NotNull
    private AnnotatedImage generatePreviewImage(@NotNull GraphicGeneratorContext context, @NotNull TvChannelIconOptions options2) {
        if (context == null) {
            TvChannelIconGenerator.$$$reportNull$$$0(28);
        }
        if (options2 == null) {
            TvChannelIconGenerator.$$$reportNull$$$0(29);
        }
        switch (options2.previewShape) {
            case ADAPTIVE: {
                return this.generateViewportPreviewImage(context, options2);
            }
            case LEGACY: {
                return this.generateLegacyImage(context, options2);
            }
        }
        throw new IllegalArgumentException();
    }

    @NotNull
    private AnnotatedImage generateLegacyImage(@NotNull GraphicGeneratorContext context, @NotNull TvChannelIconOptions options2) {
        if (context == null) {
            TvChannelIconGenerator.$$$reportNull$$$0(30);
        }
        if (options2 == null) {
            TvChannelIconGenerator.$$$reportNull$$$0(31);
        }
        AnnotatedImage mergedImage = this.generateMergedLayers(context, options2, null);
        BufferedImage image = this.cropImageToViewport(options2, mergedImage.getImage());
        if (options2.generatePreviewIcons && options2.showSafeZone) {
            TvChannelIconGenerator.drawSafeZone(image);
        }
        return new AnnotatedImage(image, mergedImage.getErrorMessage());
    }

    @NotNull
    private AnnotatedImage generateViewportPreviewImage(@NotNull GraphicGeneratorContext context, @NotNull TvChannelIconOptions options2) {
        if (context == null) {
            TvChannelIconGenerator.$$$reportNull$$$0(32);
        }
        if (options2 == null) {
            TvChannelIconGenerator.$$$reportNull$$$0(33);
        }
        AnnotatedImage mergedImage = this.generateMergedLayers(context, options2, null);
        BufferedImage image = this.cropImageToViewport(options2, mergedImage.getImage());
        if (options2.showSafeZone) {
            TvChannelIconGenerator.drawSafeZone(image);
        }
        return new AnnotatedImage(image, mergedImage.getErrorMessage());
    }

    private static void drawSafeZone(@NotNull BufferedImage image) {
        if (image == null) {
            TvChannelIconGenerator.$$$reportNull$$$0(34);
        }
        Graphics2D gOut = (Graphics2D)image.getGraphics();
        Color c = new Color(0.0f, 0.0f, 0.0f, 0.2f);
        gOut.setColor(c);
        gOut.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        PrimitiveShapesHelper g = new PrimitiveShapesHelper(gOut, 1.0);
        g.drawCenteredCircle(image.getWidth() / 2, image.getHeight() / 2, AssetStudioUtils.roundToInt((double)image.getWidth() * 0.4583333333333333));
        gOut.dispose();
    }

    @Override
    @NotNull
    protected Rectangle getFullBleedRectangle(@NotNull AdaptiveIconGenerator.AdaptiveIconOptions options2) {
        if (options2 == null) {
            TvChannelIconGenerator.$$$reportNull$$$0(35);
        }
        Rectangle rectangle = AssetStudioUtils.scaleRectangle(IMAGE_SIZE_FULL_BLEED_DP, TvChannelIconGenerator.computeScaleFactor(options2));
        if (rectangle == null) {
            TvChannelIconGenerator.$$$reportNull$$$0(36);
        }
        return rectangle;
    }

    @Override
    @NotNull
    protected Rectangle getViewportRectangle(@NotNull AdaptiveIconGenerator.AdaptiveIconOptions options2) {
        if (options2 == null) {
            TvChannelIconGenerator.$$$reportNull$$$0(37);
        }
        Rectangle rectangle = AssetStudioUtils.scaleRectangle(IMAGE_SIZE_VIEWPORT_DP, TvChannelIconGenerator.computeScaleFactor(options2));
        if (rectangle == null) {
            TvChannelIconGenerator.$$$reportNull$$$0(38);
        }
        return rectangle;
    }

    @Override
    @NotNull
    protected Rectangle getLegacyRectangle(@NotNull AdaptiveIconGenerator.AdaptiveIconOptions options2) {
        if (options2 == null) {
            TvChannelIconGenerator.$$$reportNull$$$0(39);
        }
        Rectangle rectangle = AssetStudioUtils.scaleRectangle(IMAGE_SIZE_LEGACY_DP, TvChannelIconGenerator.computeScaleFactor(options2));
        if (rectangle == null) {
            TvChannelIconGenerator.$$$reportNull$$$0(40);
        }
        return rectangle;
    }

    private static double computeScaleFactor(@NotNull IconGenerator.IconOptions options2) {
        if (options2 == null) {
            TvChannelIconGenerator.$$$reportNull$$$0(41);
        }
        double scaleFactor = TvChannelIconGenerator.getMdpiScaleFactor(TvChannelIconGenerator.getDensity(options2));
        if (((TvChannelIconOptions)options2).generatePreviewIcons) {
            scaleFactor *= 0.6;
        }
        return scaleFactor;
    }

    @NotNull
    private static Density getDensity(@NotNull IconGenerator.IconOptions options2) {
        if (options2 == null) {
            TvChannelIconGenerator.$$$reportNull$$$0(42);
        }
        Density density = ((TvChannelIconOptions)options2).previewShape == PreviewShape.LEGACY ? options2.density : Density.XXXHIGH;
        if (density == null) {
            TvChannelIconGenerator.$$$reportNull$$$0(43);
        }
        return density;
    }

    @Override
    protected Rectangle getMaxIconRectangle() {
        return IMAGE_SIZE_FULL_BLEED_DP;
    }

    @Override
    protected boolean includeDensity(@NotNull Density density) {
        if (density == null) {
            TvChannelIconGenerator.$$$reportNull$$$0(44);
        }
        return density == LEGACY_DENSITY;
    }

    @NotNull
    private static Logger getLog() {
        Logger logger2 = Logger.getInstance(TvChannelIconGenerator.class);
        if (logger2 == null) {
            TvChannelIconGenerator.$$$reportNull$$$0(45);
        }
        return logger2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 27: 
            case 36: 
            case 38: 
            case 40: 
            case 43: 
            case 45: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 27: 
            case 36: 
            case 38: 
            case 40: 
            case 43: 
            case 45: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 27: 
            case 36: 
            case 38: 
            case 40: 
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/assetstudio/TvChannelIconGenerator";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 18: 
            case 22: 
            case 25: 
            case 28: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 8: 
            case 12: 
            case 16: 
            case 19: 
            case 23: 
            case 26: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 15: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: 
            case 14: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 13: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "density";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "categoryMap";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/assetstudio/TvChannelIconGenerator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createIconGenerationTasks";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "generateRasterImage";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullBleedRectangle";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewportRectangle";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getLegacyRectangle";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getDensity";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 27: 
            case 36: 
            case 38: 
            case 40: 
            case 43: 
            case 45: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createIconGenerationTasks";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createOutputIconsTasks";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createOutputIconsForSingleDensityTasks";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createXmlDrawableResourcesTasks";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createPreviewImagesTasks";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "generateRasterImage";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "generatePreviewImage";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "generateLegacyImage";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "generateViewportPreviewImage";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "drawSafeZone";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getFullBleedRectangle";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getViewportRectangle";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getLegacyRectangle";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "computeScaleFactor";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getDensity";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "includeDensity";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 27: 
            case 36: 
            case 38: 
            case 40: 
            case 43: 
            case 45: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum PreviewShape {
        NONE("none", "none"),
        ADAPTIVE("adaptive", "Adaptive (anydpi)"),
        LEGACY("legacy", "Legacy (xhdpi)");

        public final String id;
        public final String displayName;

        private PreviewShape(String id, String displayName) {
            if (id == null) {
                PreviewShape.$$$reportNull$$$0(0);
            }
            if (displayName == null) {
                PreviewShape.$$$reportNull$$$0(1);
            }
            this.id = id;
            this.displayName = displayName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "id";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "displayName";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/npw/assetstudio/TvChannelIconGenerator$PreviewShape";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class TvChannelIconOptions
    extends AdaptiveIconGenerator.AdaptiveIconOptions
    implements Cloneable {
        public PreviewShape previewShape = PreviewShape.NONE;

        public TvChannelIconOptions(boolean forPreview) {
            super(forPreview);
            this.iconFolderKind = IconGenerator.IconFolderKind.MIPMAP;
        }

        @Override
        @NotNull
        public TvChannelIconOptions clone() {
            TvChannelIconOptions tvChannelIconOptions = (TvChannelIconOptions)super.clone();
            if (tvChannelIconOptions == null) {
                TvChannelIconOptions.$$$reportNull$$$0(0);
            }
            return tvChannelIconOptions;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/TvChannelIconGenerator$TvChannelIconOptions", "clone"));
        }
    }
}

