/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.ide.common.util.AssetUtil;
import com.android.tools.adtui.ImageUtils;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.GraphicGeneratorContext;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.npw.assetstudio.assets.ImageAsset;
import com.android.tools.idea.npw.assetstudio.assets.TextAsset;
import com.android.tools.idea.rendering.Gravity;
import com.android.tools.idea.rendering.VectorDrawableTransformer;
import com.google.common.util.concurrent.Futures;
import com.intellij.util.ExceptionUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TransformedImageAsset {
    @Nullable
    private final Future<BufferedImage> myImageFuture;
    @Nullable
    private final Future<String> myDrawableFuture;
    @NotNull
    private final GraphicGeneratorContext myContext;
    @Nullable
    private final Color myTint;
    private final double myOpacity;
    private final boolean myIsTrimmed;
    @NotNull
    private final String myLineSeparator;
    @NotNull
    private final Dimension myTargetSize;
    @Nullable
    private Rectangle2D myTrimRectangle;
    private double myScaleFactor;
    @Nullable
    private Point2D myShift;
    @NotNull
    private Gravity myGravity;
    @Nullable
    private String myTransformedDrawable;
    @Nullable
    private BufferedImage myTrimmedImage;
    private final Object myLock;
    private static final Pattern LINE_ENDING_PATTERN = Pattern.compile("(\r\n|\n)");

    /*
     * WARNING - void declaration
     */
    public TransformedImageAsset(@NotNull BaseAsset asset, @NotNull Dimension targetSize, double scaleFactor, @Nullable Color tint, @NotNull GraphicGeneratorContext context, @NotNull String string) {
        void lineSeparator;
        if (asset == null) {
            TransformedImageAsset.$$$reportNull$$$0(0);
        }
        if (targetSize == null) {
            TransformedImageAsset.$$$reportNull$$$0(1);
        }
        if (context == null) {
            TransformedImageAsset.$$$reportNull$$$0(2);
        }
        if (string == null) {
            TransformedImageAsset.$$$reportNull$$$0(3);
        }
        this.myLock = new Object();
        this.myDrawableFuture = asset instanceof ImageAsset ? ((ImageAsset)asset).getXmlDrawable() : (asset instanceof TextAsset ? ((TextAsset)asset).getXmlDrawable() : null);
        this.myImageFuture = this.myDrawableFuture == null ? asset.toImage() : null;
        this.myTint = asset instanceof TextAsset && asset.color().equals(tint) ? null : tint;
        this.myOpacity = asset instanceof TextAsset ? 1.0 : (double)((Integer)asset.opacityPercent().get()).intValue() / 100.0;
        this.myIsTrimmed = (Boolean)asset.trimmed().get();
        this.myTargetSize = targetSize;
        this.myScaleFactor = scaleFactor;
        this.myContext = context;
        this.myGravity = Gravity.CENTER;
        this.myLineSeparator = lineSeparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Point2D getShift() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myShift;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShift(@Nullable Point2D shift) {
        Object object = this.myLock;
        synchronized (object) {
            this.myShift = shift;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Gravity getGravity() {
        Object object = this.myLock;
        // MONITORENTER : object
        Gravity gravity = this.myGravity;
        // MONITOREXIT : object
        if (gravity != null) return gravity;
        TransformedImageAsset.$$$reportNull$$$0(4);
        return gravity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGravity(@NotNull Gravity gravity) {
        if (gravity == null) {
            TransformedImageAsset.$$$reportNull$$$0(5);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myGravity = gravity;
        }
    }

    public boolean isDrawable() {
        return this.myDrawableFuture != null;
    }

    public boolean isRasterImage() {
        return this.myImageFuture != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getTransformedDrawable() {
        if (this.myDrawableFuture == null) {
            return null;
        }
        try {
            Object object = this.myLock;
            synchronized (object) {
                String xmlDrawable = this.myDrawableFuture.get();
                if (xmlDrawable == null) {
                    return null;
                }
                if (this.myTransformedDrawable == null) {
                    xmlDrawable = LINE_ENDING_PATTERN.matcher(xmlDrawable).replaceAll(this.myLineSeparator);
                    Rectangle2D clipRectangle = this.myIsTrimmed ? this.getTrimRectangle(xmlDrawable) : null;
                    this.myTransformedDrawable = VectorDrawableTransformer.transform(xmlDrawable, this.myTargetSize, this.myGravity, this.myScaleFactor, clipRectangle, this.myShift, this.myTint, this.myOpacity);
                }
                return this.myTransformedDrawable;
            }
        }
        catch (InterruptedException | ExecutionException e) {
            return null;
        }
    }

    @NotNull
    public BufferedImage getTransformedImage(@NotNull Dimension imageSize) {
        BufferedImage trimmedImage;
        String drawable;
        if (imageSize == null) {
            TransformedImageAsset.$$$reportNull$$$0(6);
        }
        if (this.isDrawable() && (drawable = this.getTransformedDrawable()) != null) {
            BufferedImage bufferedImage;
            Future<BufferedImage> future2 = this.myContext.renderDrawable(drawable, imageSize);
            try {
                bufferedImage = future2.get();
            }
            catch (ExecutionException e) {
                ExceptionUtil.rethrow((Throwable)e.getCause());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (bufferedImage == null) {
                TransformedImageAsset.$$$reportNull$$$0(7);
            }
            return bufferedImage;
        }
        if ((trimmedImage = this.getTrimmedImage()) == null) {
            BufferedImage bufferedImage = this.createErrorImage(imageSize);
            if (bufferedImage == null) {
                TransformedImageAsset.$$$reportNull$$$0(8);
            }
            return bufferedImage;
        }
        return this.applyScaleShiftTintAndOpacity(imageSize, trimmedImage);
    }

    @NotNull
    public BufferedImage createErrorImage(@NotNull Dimension imageSize) {
        if (imageSize == null) {
            TransformedImageAsset.$$$reportNull$$$0(9);
        }
        return this.applyScaleShiftTintAndOpacity(imageSize, AssetStudioUtils.createPlaceholderImage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private BufferedImage applyScaleShiftTintAndOpacity(@NotNull Dimension imageSize, @NotNull BufferedImage sourceImage) {
        AssetUtil.Effect[] effectArray;
        double y;
        double x;
        int height;
        int width;
        if (imageSize == null) {
            TransformedImageAsset.$$$reportNull$$$0(10);
        }
        if (sourceImage == null) {
            TransformedImageAsset.$$$reportNull$$$0(11);
        }
        Object object = this.myLock;
        synchronized (object) {
            double scaleFactor = Math.min(imageSize.getWidth() * this.myScaleFactor / (double)sourceImage.getWidth(), imageSize.getHeight() * this.myScaleFactor / (double)sourceImage.getHeight());
            width = AssetStudioUtils.roundToInt((double)sourceImage.getWidth() * scaleFactor);
            height = AssetStudioUtils.roundToInt((double)sourceImage.getHeight() * scaleFactor);
            x = (double)(imageSize.width - width) / 2.0;
            y = (double)(imageSize.height - height) / 2.0;
            if (this.myShift != null) {
                x += imageSize.getWidth() * this.myShift.getX();
                y += imageSize.getHeight() * this.myShift.getY();
            }
        }
        BufferedImage scaledImage = AssetUtil.scaledImage((BufferedImage)sourceImage, (int)width, (int)height);
        BufferedImage outImage = AssetUtil.newArgbBufferedImage((int)imageSize.width, (int)imageSize.height);
        Graphics2D g = (Graphics2D)outImage.getGraphics();
        if (this.myTint == null || this.myOpacity == 0.0) {
            effectArray = AssetUtil.NO_EFFECTS;
        } else {
            AssetUtil.FillEffect[] fillEffectArray = new AssetUtil.FillEffect[1];
            effectArray = fillEffectArray;
            fillEffectArray[0] = new AssetUtil.FillEffect((Paint)this.myTint, this.myOpacity);
        }
        AssetUtil.Effect[] effects = effectArray;
        AssetUtil.drawEffects((Graphics2D)g, (BufferedImage)scaledImage, (int)AssetStudioUtils.roundToInt(x), (int)AssetStudioUtils.roundToInt(y), (AssetUtil.Effect[])effects);
        g.dispose();
        BufferedImage bufferedImage = outImage;
        if (bufferedImage == null) {
            TransformedImageAsset.$$$reportNull$$$0(12);
        }
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getScaleFactor() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myScaleFactor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double applyAdditionalScaleFactor(double scale) {
        Object object = this.myLock;
        synchronized (object) {
            this.myScaleFactor *= scale;
            return this.myScaleFactor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public BufferedImage getTrimmedImage() {
        if (this.myImageFuture == null) {
            return null;
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myTrimmedImage == null) {
                try {
                    BufferedImage image = this.myImageFuture.get();
                    this.myTrimmedImage = this.myIsTrimmed ? AssetStudioUtils.trim(image) : image;
                }
                catch (InterruptedException | ExecutionException e) {
                    return null;
                }
            }
            return this.myTrimmedImage;
        }
    }

    @NotNull
    private Rectangle2D getTrimRectangle(@NotNull String xmlDrawable) {
        if (xmlDrawable == null) {
            TransformedImageAsset.$$$reportNull$$$0(13);
        }
        if (this.myTrimRectangle == null) {
            this.myTrimRectangle = this.calculateTrimRectangle(xmlDrawable);
        }
        Rectangle2D rectangle2D = this.myTrimRectangle;
        if (rectangle2D == null) {
            TransformedImageAsset.$$$reportNull$$$0(14);
        }
        return rectangle2D;
    }

    @NotNull
    private Rectangle2D calculateTrimRectangle(@NotNull String xmlDrawable) {
        Rectangle2D rectangle2D;
        if (xmlDrawable == null) {
            TransformedImageAsset.$$$reportNull$$$0(15);
        }
        Future<BufferedImage> futureImage = this.myContext.renderDrawable(xmlDrawable, this.myTargetSize);
        Future rectangleFuture = Futures.lazyTransform(futureImage, image -> {
            Rectangle bounds2 = ImageUtils.getCropBounds((BufferedImage)image, (ImageUtils.CropFilter)ImageUtils.TRANSPARENCY_FILTER, null);
            if (bounds2 == null) {
                return new Rectangle(this.myTargetSize);
            }
            double width = this.myTargetSize.getWidth();
            double height = this.myTargetSize.getHeight();
            return new Rectangle2D.Double(bounds2.getX() / width, bounds2.getY() / height, bounds2.getWidth() / width, bounds2.getHeight() / height);
        });
        try {
            rectangle2D = (Rectangle2D)rectangleFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            return new Rectangle(this.myTargetSize);
        }
        if (rectangle2D == null) {
            TransformedImageAsset.$$$reportNull$$$0(16);
        }
        return rectangle2D;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 12: 
            case 14: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 12: 
            case 14: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "asset";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetSize";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineSeparator";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/assetstudio/TransformedImageAsset";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gravity";
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageSize";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceImage";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlDrawable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/assetstudio/TransformedImageAsset";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGravity";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTransformedImage";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "applyScaleShiftTintAndOpacity";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTrimRectangle";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateTrimRectangle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 12: 
            case 14: 
            case 16: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setGravity";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTransformedImage";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createErrorImage";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "applyScaleShiftTintAndOpacity";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTrimRectangle";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "calculateTrimRectangle";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 12: 
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

