/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.ide.common.util.AssetUtil;
import com.android.ide.common.util.PathString;
import com.android.resources.Density;
import com.android.tools.idea.npw.assetstudio.AnnotatedImage;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.GeneratedIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedImageIcon;
import com.android.tools.idea.npw.assetstudio.GraphicGeneratorContext;
import com.android.tools.idea.npw.assetstudio.IconCategory;
import com.android.tools.idea.npw.assetstudio.IconGenerator;
import com.android.tools.idea.npw.assetstudio.TransformedImageAsset;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObjectValueProperty;
import com.android.tools.idea.rendering.DrawableRenderer;
import com.android.utils.Pair;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.project.Project;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LauncherLegacyIconGenerator
extends IconGenerator {
    public static final Color DEFAULT_BACKGROUND_COLOR = Color.WHITE;
    public static final IconGenerator.Shape DEFAULT_ICON_SHAPE = IconGenerator.Shape.SQUARE;
    private static final Rectangle IMAGE_SIZE_MDPI = new Rectangle(0, 0, 48, 48);
    private static final Map<Pair<IconGenerator.Shape, Density>, Rectangle> TARGET_RECTS = LauncherLegacyIconGenerator.buildTargetRectangles();
    private final ObjectProperty<Color> myBackgroundColor;
    private final ObjectProperty<IconGenerator.Shape> myShape;
    private final BoolProperty myCropped;
    private final BoolProperty myDogEared;

    public LauncherLegacyIconGenerator(@NotNull Project project, int minSdkVersion2, @Nullable DrawableRenderer renderer2) {
        if (project == null) {
            LauncherLegacyIconGenerator.$$$reportNull$$$0(0);
        }
        super(project, minSdkVersion2, new GraphicGeneratorContext(40, renderer2));
        this.myBackgroundColor = new ObjectValueProperty<Color>(DEFAULT_BACKGROUND_COLOR);
        this.myShape = new ObjectValueProperty<IconGenerator.Shape>(DEFAULT_ICON_SHAPE);
        this.myCropped = new BoolValueProperty();
        this.myDogEared = new BoolValueProperty();
    }

    @NotNull
    public ObjectProperty<Color> backgroundColor() {
        ObjectProperty<Color> objectProperty = this.myBackgroundColor;
        if (objectProperty == null) {
            LauncherLegacyIconGenerator.$$$reportNull$$$0(1);
        }
        return objectProperty;
    }

    @NotNull
    public BoolProperty cropped() {
        BoolProperty boolProperty = this.myCropped;
        if (boolProperty == null) {
            LauncherLegacyIconGenerator.$$$reportNull$$$0(2);
        }
        return boolProperty;
    }

    @NotNull
    public ObjectProperty<IconGenerator.Shape> shape() {
        ObjectProperty<IconGenerator.Shape> objectProperty = this.myShape;
        if (objectProperty == null) {
            LauncherLegacyIconGenerator.$$$reportNull$$$0(3);
        }
        return objectProperty;
    }

    @NotNull
    public BoolProperty dogEared() {
        BoolProperty boolProperty = this.myDogEared;
        if (boolProperty == null) {
            LauncherLegacyIconGenerator.$$$reportNull$$$0(4);
        }
        return boolProperty;
    }

    @Override
    @NotNull
    public LauncherLegacyOptions createOptions(boolean forPreview) {
        LauncherLegacyOptions options2 = new LauncherLegacyOptions(forPreview);
        BaseAsset asset = this.sourceAsset().getValueOrNull();
        if (asset != null) {
            Color color;
            double paddingFactor = (double)((Integer)asset.paddingPercent().get()).intValue() / 100.0;
            double scaleFactor = 1.0 / (1.0 + paddingFactor * 2.0);
            options2.useForegroundColor = asset.isColorable();
            Color color2 = color = asset.isColorable() ? (Color)asset.color().getValueOrNull() : null;
            if (color != null) {
                options2.foregroundColor = color.getRGB();
            }
            options2.image = new TransformedImageAsset(asset, IMAGE_SIZE_MDPI.getSize(), scaleFactor, color, this.getGraphicGeneratorContext(), this.myLineSeparator);
        }
        options2.shape = (IconGenerator.Shape)((Object)this.myShape.get());
        options2.crop = (Boolean)this.myCropped.get();
        options2.style = IconGenerator.Style.SIMPLE;
        options2.backgroundColor = ((Color)this.myBackgroundColor.get()).getRGB();
        options2.isDogEar = (Boolean)this.myDogEared.get();
        LauncherLegacyOptions launcherLegacyOptions = options2;
        if (launcherLegacyOptions == null) {
            LauncherLegacyIconGenerator.$$$reportNull$$$0(5);
        }
        return launcherLegacyOptions;
    }

    private static IconGenerator.Shape applyDog(IconGenerator.Shape shape) {
        if (shape == IconGenerator.Shape.SQUARE) {
            return IconGenerator.Shape.SQUARE_DOG;
        }
        if (shape == IconGenerator.Shape.HRECT) {
            return IconGenerator.Shape.HRECT_DOG;
        }
        if (shape == IconGenerator.Shape.VRECT) {
            return IconGenerator.Shape.VRECT_DOG;
        }
        return shape;
    }

    @NotNull
    public static Rectangle getTargetRect(@Nullable IconGenerator.Shape shape, @NotNull Density density) {
        Rectangle targetRect;
        if (density == null) {
            LauncherLegacyIconGenerator.$$$reportNull$$$0(6);
        }
        if ((targetRect = TARGET_RECTS.get(Pair.of((Object)((Object)shape), (Object)density))) == null) {
            targetRect = AssetStudioUtils.scaleRectangle(TARGET_RECTS.get(Pair.of((Object)((Object)shape), (Object)Density.MEDIUM)), LauncherLegacyIconGenerator.getMdpiScaleFactor(density));
        }
        Rectangle rectangle = targetRect;
        if (rectangle == null) {
            LauncherLegacyIconGenerator.$$$reportNull$$$0(7);
        }
        return rectangle;
    }

    @Override
    @NotNull
    public AnnotatedImage generateRasterImage(@NotNull GraphicGeneratorContext context, @NotNull IconGenerator.IconOptions options2) {
        if (context == null) {
            LauncherLegacyIconGenerator.$$$reportNull$$$0(8);
        }
        if (options2 == null) {
            LauncherLegacyIconGenerator.$$$reportNull$$$0(9);
        }
        if (options2.usePlaceholders) {
            AnnotatedImage annotatedImage = PLACEHOLDER_IMAGE;
            if (annotatedImage == null) {
                LauncherLegacyIconGenerator.$$$reportNull$$$0(10);
            }
            return annotatedImage;
        }
        LauncherLegacyOptions launcherOptions = (LauncherLegacyOptions)options2;
        Rectangle imageRect = AssetStudioUtils.scaleRectangle(IMAGE_SIZE_MDPI, LauncherLegacyIconGenerator.getMdpiScaleFactor(launcherOptions.density));
        if (launcherOptions.isDogEar) {
            launcherOptions.shape = LauncherLegacyIconGenerator.applyDog(launcherOptions.shape);
        }
        BufferedImage shapeImageBack = null;
        BufferedImage shapeImageFore = null;
        BufferedImage shapeImageMask = null;
        if (launcherOptions.shape != IconGenerator.Shape.NONE && launcherOptions.shape != null && launcherOptions.renderShape) {
            shapeImageBack = LauncherLegacyIconGenerator.loadBackImage(context, launcherOptions.shape, launcherOptions.density);
            shapeImageFore = LauncherLegacyIconGenerator.loadStyleImage(context, launcherOptions.shape, launcherOptions.density, launcherOptions.style);
            shapeImageMask = LauncherLegacyIconGenerator.loadMaskImage(context, launcherOptions.shape, launcherOptions.density);
        }
        Rectangle targetRect = LauncherLegacyIconGenerator.getTargetRect(launcherOptions.shape, launcherOptions.density);
        BufferedImage tempImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        Graphics2D gTemp = (Graphics2D)tempImage.getGraphics();
        gTemp.setPaint(new Color(launcherOptions.backgroundColor));
        gTemp.fillRect(0, 0, imageRect.width, imageRect.height);
        AnnotatedImage sourceImage = this.generateRasterImage(targetRect.getSize(), options2);
        BufferedImage iconImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        Graphics2D gIcon = (Graphics2D)iconImage.getGraphics();
        if (launcherOptions.crop) {
            AssetUtil.drawCenterCrop((Graphics2D)gIcon, (BufferedImage)sourceImage.getImage(), (Rectangle)targetRect);
        } else {
            AssetUtil.drawCenterInside((Graphics2D)gIcon, (BufferedImage)sourceImage.getImage(), (Rectangle)targetRect);
        }
        AssetUtil.Effect[] effects = launcherOptions.useForegroundColor ? new AssetUtil.Effect[]{new AssetUtil.FillEffect((Paint)new Color(launcherOptions.foregroundColor), 1.0)} : AssetUtil.NO_EFFECTS;
        AssetUtil.drawEffects((Graphics2D)gTemp, (BufferedImage)iconImage, (int)0, (int)0, (AssetUtil.Effect[])effects);
        if (shapeImageMask != null) {
            gTemp.setComposite(AlphaComposite.DstIn);
            gTemp.drawImage((Image)shapeImageMask, 0, 0, null);
        }
        BufferedImage outImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        Graphics2D gOut = (Graphics2D)outImage.getGraphics();
        if (shapeImageBack != null) {
            gOut.drawImage((Image)shapeImageBack, 0, 0, null);
        }
        gOut.drawImage((Image)tempImage, 0, 0, null);
        if (shapeImageFore != null) {
            gOut.drawImage((Image)shapeImageFore, 0, 0, null);
        }
        gOut.dispose();
        gTemp.dispose();
        gIcon.dispose();
        return new AnnotatedImage(outImage, sourceImage.getErrorMessage());
    }

    @Override
    protected boolean includeDensity(@NotNull Density density) {
        if (density == null) {
            LauncherLegacyIconGenerator.$$$reportNull$$$0(11);
        }
        return super.includeDensity(density) || density == Density.XXXHIGH;
    }

    @Override
    @NotNull
    public Collection<GeneratedIcon> generateIcons(@NotNull GraphicGeneratorContext context, @NotNull IconGenerator.IconOptions options2, @NotNull String name) {
        if (context == null) {
            LauncherLegacyIconGenerator.$$$reportNull$$$0(12);
        }
        if (options2 == null) {
            LauncherLegacyIconGenerator.$$$reportNull$$$0(13);
        }
        if (name == null) {
            LauncherLegacyIconGenerator.$$$reportNull$$$0(14);
        }
        HashMap<String, Map<String, AnnotatedImage>> categoryMap = new HashMap<String, Map<String, AnnotatedImage>>();
        this.generateRasterImage(null, categoryMap, context, options2, name);
        ArrayList<GeneratedIcon> icons = new ArrayList<GeneratedIcon>();
        categoryMap.forEach((category, images) -> images.forEach((path2, image) -> {
            IconCategory iconCategory = IconCategory.REGULAR;
            Density density = LauncherLegacyIconGenerator.pathToDensity(path2);
            if (density == null) {
                density = Density.NODPI;
                iconCategory = IconCategory.PLAY_STORE;
            }
            GeneratedImageIcon icon2 = new GeneratedImageIcon((String)path2, new PathString(path2), iconCategory, density, (AnnotatedImage)image);
            icons.add(icon2);
        }));
        ArrayList<GeneratedIcon> arrayList = icons;
        if (arrayList == null) {
            LauncherLegacyIconGenerator.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    private static Map<Pair<IconGenerator.Shape, Density>, Rectangle> buildTargetRectangles() {
        ImmutableMap.Builder targetRects = new ImmutableMap.Builder();
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.NONE), (Object)Density.HIGH), (Object)new Rectangle(4, 4, 64, 64));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.NONE), (Object)Density.MEDIUM), (Object)new Rectangle(3, 3, 42, 42));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.CIRCLE), (Object)Density.HIGH), (Object)new Rectangle(3, 3, 66, 66));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.CIRCLE), (Object)Density.MEDIUM), (Object)new Rectangle(2, 2, 44, 44));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.SQUARE), (Object)Density.HIGH), (Object)new Rectangle(7, 7, 57, 57));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.SQUARE), (Object)Density.MEDIUM), (Object)new Rectangle(5, 5, 38, 38));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.VRECT), (Object)Density.HIGH), (Object)new Rectangle(12, 3, 48, 66));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.VRECT), (Object)Density.MEDIUM), (Object)new Rectangle(8, 2, 32, 44));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.HRECT), (Object)Density.HIGH), (Object)new Rectangle(3, 12, 66, 48));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.HRECT), (Object)Density.MEDIUM), (Object)new Rectangle(2, 8, 44, 32));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.SQUARE_DOG), (Object)Density.HIGH), (Object)new Rectangle(7, 21, 57, 43));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.SQUARE_DOG), (Object)Density.MEDIUM), (Object)new Rectangle(5, 14, 38, 29));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.VRECT_DOG), (Object)Density.HIGH), (Object)new Rectangle(12, 17, 48, 52));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.VRECT_DOG), (Object)Density.MEDIUM), (Object)new Rectangle(8, 11, 32, 35));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.HRECT_DOG), (Object)Density.HIGH), (Object)new Rectangle(3, 12, 52, 48));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.HRECT_DOG), (Object)Density.MEDIUM), (Object)new Rectangle(2, 8, 35, 32));
        return targetRects.build();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/assetstudio/LauncherLegacyIconGenerator";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "density";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/assetstudio/LauncherLegacyIconGenerator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "backgroundColor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "cropped";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "shape";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "dogEared";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetRect";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "generateRasterImage";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "generateIcons";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 15: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTargetRect";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "generateRasterImage";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "includeDensity";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "generateIcons";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class LauncherLegacyOptions
    extends IconGenerator.IconOptions {
        public boolean useForegroundColor = true;
        public int foregroundColor;
        public int backgroundColor;
        public boolean crop = true;
        public IconGenerator.Shape shape = IconGenerator.Shape.SQUARE;
        public IconGenerator.Style style = IconGenerator.Style.SIMPLE;
        public boolean isDogEar;
        public boolean renderShape = true;

        public LauncherLegacyOptions(boolean forPreview) {
            super(forPreview);
            this.iconFolderKind = IconGenerator.IconFolderKind.MIPMAP;
        }
    }
}

