/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.ide.common.util.AssetUtil;
import com.android.ide.common.util.PathString;
import com.android.resources.Density;
import com.android.resources.ResourceFolderType;
import com.android.tools.idea.lint.common.LintIdeClient;
import com.android.tools.idea.npw.assetstudio.AnnotatedImage;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.GeneratedIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedImageIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedXmlResource;
import com.android.tools.idea.npw.assetstudio.GraphicGeneratorContext;
import com.android.tools.idea.npw.assetstudio.IconCategory;
import com.android.tools.idea.npw.assetstudio.TransformedImageAsset;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.npw.assetstudio.icon.CategoryIconMap;
import com.android.tools.idea.npw.assetstudio.icon.IconGeneratorResult;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.projectsystem.AndroidModulePaths;
import com.android.tools.lint.checks.ApiLookup;
import com.android.utils.CharSequences;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNullableLazyValue;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public abstract class IconGenerator
implements Disposable {
    protected static final ImmutableSet<Density> DENSITIES = ImmutableSet.of((Object)Density.MEDIUM, (Object)Density.HIGH, (Object)Density.XHIGH, (Object)Density.XXHIGH, (Object)Density.XXXHIGH);
    private static final Map<Density, Pattern> DENSITY_PATTERNS;
    protected static final AnnotatedImage PLACEHOLDER_IMAGE;
    private final OptionalProperty<BaseAsset> mySourceAsset;
    private final StringProperty myOutputName;
    protected final int myMinSdkVersion;
    @NotNull
    private final GraphicGeneratorContext myContext;
    @NotNull
    private final AtomicNullableLazyValue<ApiLookup> myApiLookup;
    @NotNull
    protected final String myLineSeparator;

    public IconGenerator(final @NotNull Project project, int minSdkVersion2, @NotNull GraphicGeneratorContext context) {
        if (project == null) {
            IconGenerator.$$$reportNull$$$0(0);
        }
        if (context == null) {
            IconGenerator.$$$reportNull$$$0(1);
        }
        this.mySourceAsset = new OptionalValueProperty<BaseAsset>();
        this.myOutputName = new StringValueProperty();
        this.myMinSdkVersion = minSdkVersion2;
        this.myContext = context;
        this.myApiLookup = new AtomicNullableLazyValue<ApiLookup>(){

            @Nullable
            protected ApiLookup compute() {
                return LintIdeClient.getApiLookup((Project)project);
            }
        };
        this.myLineSeparator = CodeStyle.getSettings((Project)project).getLineSeparator();
    }

    public void dispose() {
    }

    @NotNull
    public GraphicGeneratorContext getGraphicGeneratorContext() {
        GraphicGeneratorContext graphicGeneratorContext = this.myContext;
        if (graphicGeneratorContext == null) {
            IconGenerator.$$$reportNull$$$0(2);
        }
        return graphicGeneratorContext;
    }

    @NotNull
    public final OptionalProperty<BaseAsset> sourceAsset() {
        OptionalProperty<BaseAsset> optionalProperty = this.mySourceAsset;
        if (optionalProperty == null) {
            IconGenerator.$$$reportNull$$$0(3);
        }
        return optionalProperty;
    }

    @NotNull
    public final StringProperty outputName() {
        StringProperty stringProperty = this.myOutputName;
        if (stringProperty == null) {
            IconGenerator.$$$reportNull$$$0(4);
        }
        return stringProperty;
    }

    @NotNull
    public IconGeneratorResult generateIcons(@NotNull IconOptions options2) {
        if (options2 == null) {
            IconGenerator.$$$reportNull$$$0(5);
        }
        return new IconGeneratorResult(this.generateIcons(this.myContext, options2, (String)this.myOutputName.get()), options2);
    }

    @NotNull
    private CategoryIconMap generateIntoMemory() {
        if (!((Optional)this.mySourceAsset.get()).isPresent()) {
            throw new IllegalStateException("Can't generate icons without a source asset set first");
        }
        IconOptions options2 = this.createOptions(false);
        return this.generateIntoMemory(options2);
    }

    @NotNull
    private CategoryIconMap generateIntoMemory(@NotNull IconOptions options2) {
        if (options2 == null) {
            IconGenerator.$$$reportNull$$$0(6);
        }
        HashMap<String, Map<String, AnnotatedImage>> categoryMap = new HashMap<String, Map<String, AnnotatedImage>>();
        this.generateRasterImage(null, categoryMap, this.myContext, options2, (String)this.myOutputName.get());
        return new CategoryIconMap(categoryMap);
    }

    @NotNull
    public final Map<File, BufferedImage> generateIntoFileMap(@NotNull File resDirectory) {
        if (resDirectory == null) {
            IconGenerator.$$$reportNull$$$0(7);
        }
        if (((String)this.myOutputName.get()).isEmpty()) {
            throw new IllegalStateException("Can't save icons to disk if a filename isn't set first");
        }
        if (resDirectory.getParentFile() == null) {
            throw new IllegalArgumentException("Invalid paths used when trying to generate an icon");
        }
        CategoryIconMap categoryIconMap = this.generateIntoMemory();
        Map<File, BufferedImage> map2 = categoryIconMap.toFileMap(resDirectory.getParentFile());
        if (map2 == null) {
            IconGenerator.$$$reportNull$$$0(8);
        }
        return map2;
    }

    @NotNull
    public Map<File, GeneratedIcon> generateIntoIconMap(@NotNull AndroidModulePaths paths) {
        if (paths == null) {
            IconGenerator.$$$reportNull$$$0(9);
        }
        IconOptions options2 = this.createOptions(false);
        return this.generateIntoIconMap(paths, options2);
    }

    @NotNull
    public final Map<File, GeneratedIcon> generateIconPlaceholders(@NotNull AndroidModulePaths paths) {
        if (paths == null) {
            IconGenerator.$$$reportNull$$$0(10);
        }
        if (((String)this.myOutputName.get()).isEmpty()) {
            Map<File, GeneratedIcon> map2 = Collections.emptyMap();
            if (map2 == null) {
                IconGenerator.$$$reportNull$$$0(11);
            }
            return map2;
        }
        IconOptions options2 = this.createOptions(false);
        options2.usePlaceholders = true;
        return this.generateIntoIconMap(paths, options2);
    }

    @NotNull
    private Map<File, GeneratedIcon> generateIntoIconMap(@NotNull AndroidModulePaths paths, @NotNull IconOptions options2) {
        if (paths == null) {
            IconGenerator.$$$reportNull$$$0(12);
        }
        if (options2 == null) {
            IconGenerator.$$$reportNull$$$0(13);
        }
        if (((String)this.myOutputName.get()).isEmpty()) {
            throw new IllegalStateException("Can't save icons to disk if a filename isn't set first");
        }
        IconGeneratorResult icons = this.generateIcons(options2);
        HashMap<File, GeneratedIcon> outputMap = new HashMap<File, GeneratedIcon>();
        icons.getIcons().forEach(icon2 -> {
            PathString relativePath = icon2.getOutputPath();
            if (relativePath != null && icon2.getCategory() != IconCategory.PREVIEW) {
                File path2 = new File(IconGenerator.getBaseDirectory(paths, icon2.getCategory()), relativePath.getNativePath());
                outputMap.put(path2, (GeneratedIcon)icon2);
            }
        });
        HashMap<File, GeneratedIcon> hashMap = outputMap;
        if (hashMap == null) {
            IconGenerator.$$$reportNull$$$0(14);
        }
        return hashMap;
    }

    @NotNull
    private static File getBaseDirectory(@NotNull AndroidModulePaths paths, @NotNull IconCategory category) {
        File dir;
        if (paths == null) {
            IconGenerator.$$$reportNull$$$0(15);
        }
        if (category == null) {
            IconGenerator.$$$reportNull$$$0(16);
        }
        if (category == IconCategory.PLAY_STORE) {
            dir = paths.getManifestDirectory();
            if (dir != null) {
                File file2 = dir;
                if (file2 == null) {
                    IconGenerator.$$$reportNull$$$0(17);
                }
                return file2;
            }
            dir = IconGenerator.getResDirectory(paths);
            if (dir != null) {
                dir = dir.getParentFile();
            }
        } else {
            dir = IconGenerator.getResDirectory(paths);
        }
        if (dir == null) {
            throw new IllegalArgumentException("Invalid paths used when trying to generate an icon");
        }
        File file3 = dir;
        if (file3 == null) {
            IconGenerator.$$$reportNull$$$0(18);
        }
        return file3;
    }

    public void generateIconsToDisk(@NotNull AndroidModulePaths paths) {
        if (paths == null) {
            IconGenerator.$$$reportNull$$$0(19);
        }
        Map<File, GeneratedIcon> pathIconMap = this.generateIntoIconMap(paths);
        ApplicationManager.getApplication().runWriteAction(() -> {
            for (Map.Entry fileImageEntry : pathIconMap.entrySet()) {
                File file2 = (File)fileImageEntry.getKey();
                GeneratedIcon icon2 = (GeneratedIcon)fileImageEntry.getValue();
                if (icon2 instanceof GeneratedImageIcon) {
                    if (FileUtilRt.extensionEquals((String)file2.getName(), (String)"png")) {
                        this.writePngToDisk(file2, ((GeneratedImageIcon)icon2).getImage());
                        continue;
                    }
                    IconGenerator.getLog().error("Please report this error. Unable to create icon for invalid file: " + file2.getAbsolutePath());
                    continue;
                }
                if (icon2 instanceof GeneratedXmlResource) {
                    if (FileUtilRt.extensionEquals((String)file2.getName(), (String)"xml")) {
                        this.writeTextToDisk(file2, ((GeneratedXmlResource)icon2).getXmlText());
                        continue;
                    }
                    IconGenerator.getLog().error("Please report this error. Unable to create icon for invalid file: " + file2.getAbsolutePath());
                    continue;
                }
                IconGenerator.getLog().error("Please report this error. Unable to create icon for invalid file: " + file2.getAbsolutePath());
            }
        });
    }

    private void writePngToDisk(@NotNull File file2, @NotNull BufferedImage image) {
        if (file2 == null) {
            IconGenerator.$$$reportNull$$$0(20);
        }
        if (image == null) {
            IconGenerator.$$$reportNull$$$0(21);
        }
        try {
            VirtualFile directory = VfsUtil.createDirectories((String)file2.getParentFile().getAbsolutePath());
            VirtualFile virtualFile = directory.findChild(file2.getName());
            if (virtualFile == null || !virtualFile.exists()) {
                virtualFile = directory.createChildData((Object)this, file2.getName());
            }
            try (OutputStream outputStream = virtualFile.getOutputStream((Object)this);){
                ImageIO.write((RenderedImage)image, "PNG", outputStream);
            }
        }
        catch (IOException e) {
            IconGenerator.getLog().error((Throwable)e);
        }
    }

    private void writeTextToDisk(@NotNull File file2, @NotNull String text2) {
        if (file2 == null) {
            IconGenerator.$$$reportNull$$$0(22);
        }
        if (text2 == null) {
            IconGenerator.$$$reportNull$$$0(23);
        }
        try {
            VirtualFile directory = VfsUtil.createDirectories((String)file2.getParentFile().getAbsolutePath());
            VirtualFile virtualFile = directory.findChild(file2.getName());
            if (virtualFile == null || !virtualFile.exists()) {
                virtualFile = directory.createChildData((Object)this, file2.getName());
            }
            try (OutputStream outputStream = virtualFile.getOutputStream((Object)this);){
                byte[] bytes = text2.getBytes(StandardCharsets.UTF_8);
                outputStream.write(bytes);
            }
        }
        catch (IOException e) {
            IconGenerator.getLog().error((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Collection<GeneratedIcon> generateIcons(@NotNull GraphicGeneratorContext context, @NotNull IconOptions options2, @NotNull String name) {
        if (context == null) {
            IconGenerator.$$$reportNull$$$0(24);
        }
        if (options2 == null) {
            IconGenerator.$$$reportNull$$$0(25);
        }
        if (name == null) {
            IconGenerator.$$$reportNull$$$0(26);
        }
        List<Callable<GeneratedIcon>> tasks = this.createIconGenerationTasks(context, options2, name);
        ArrayList<Future> futures2 = new ArrayList<Future>(tasks.size());
        ArrayList<GeneratedIcon> icons = new ArrayList<GeneratedIcon>(tasks.size());
        Disposable taskCanceler = () -> {
            List list = futures2;
            synchronized (list) {
                for (Future f : futures2) {
                    f.cancel(true);
                }
            }
        };
        Disposer.register((Disposable)this, (Disposable)taskCanceler);
        ArrayList<Future> arrayList = futures2;
        synchronized (arrayList) {
            for (Callable<GeneratedIcon> task2 : tasks) {
                futures2.add(ApplicationManager.getApplication().executeOnPooledThread(task2));
            }
        }
        for (Future future2 : futures2) {
            try {
                icons.add((GeneratedIcon)future2.get());
            }
            catch (InterruptedException | ExecutionException e) {
                Disposer.dispose((Disposable)taskCanceler);
            }
        }
        ArrayList<GeneratedIcon> arrayList2 = icons;
        if (arrayList2 == null) {
            IconGenerator.$$$reportNull$$$0(27);
        }
        return arrayList2;
    }

    @NotNull
    protected List<Callable<GeneratedIcon>> createIconGenerationTasks(@NotNull GraphicGeneratorContext context, @NotNull IconOptions options2, @NotNull String name) {
        TransformedImageAsset imageAsset;
        if (context == null) {
            IconGenerator.$$$reportNull$$$0(28);
        }
        if (options2 == null) {
            IconGenerator.$$$reportNull$$$0(29);
        }
        if (name == null) {
            IconGenerator.$$$reportNull$$$0(30);
        }
        if ((imageAsset = options2.image) == null) {
            List<Callable<GeneratedIcon>> list = Collections.emptyList();
            if (list == null) {
                IconGenerator.$$$reportNull$$$0(31);
            }
            return list;
        }
        ArrayList<Callable<GeneratedIcon>> tasks = new ArrayList<Callable<GeneratedIcon>>();
        for (Density density : DENSITIES) {
            Density outputDensity;
            IconOptions localOptions = options2.clone();
            localOptions.density = density;
            Density density2 = outputDensity = density == Density.XXXHIGH && imageAsset.isDrawable() ? Density.ANYDPI : density;
            if (options2.generateOutputIcons) {
                if (outputDensity == Density.ANYDPI) {
                    tasks.add(() -> {
                        IconOptions iconOptions = options2.clone();
                        iconOptions.density = Density.ANYDPI;
                        String xmlDrawableText = imageAsset.getTransformedDrawable();
                        assert (xmlDrawableText != null);
                        iconOptions.apiVersion = this.calculateMinRequiredApiLevel(xmlDrawableText, this.myMinSdkVersion);
                        return new GeneratedXmlResource(name, new PathString(this.getIconPath(iconOptions, name)), IconCategory.REGULAR, xmlDrawableText);
                    });
                } else {
                    tasks.add(() -> {
                        AnnotatedImage foregroundImage = this.generateRasterImage(context, localOptions);
                        return new GeneratedImageIcon(name, new PathString(this.getIconPath(localOptions, name)), IconCategory.REGULAR, density, foregroundImage);
                    });
                }
            }
            if (!options2.generatePreviewIcons) continue;
            tasks.add(() -> {
                AnnotatedImage image;
                try {
                    image = this.generateRasterImage(context, localOptions);
                }
                catch (Throwable e) {
                    IconGenerator.getLog().error(e);
                    image = IconGenerator.createPlaceholderErrorImage(e, localOptions);
                }
                return new GeneratedImageIcon(outputDensity.getResourceValue(), null, IconCategory.PREVIEW, density, image);
            });
        }
        ArrayList<Callable<GeneratedIcon>> arrayList = tasks;
        if (arrayList == null) {
            IconGenerator.$$$reportNull$$$0(32);
        }
        return arrayList;
    }

    @NotNull
    protected static AnnotatedImage createPlaceholderErrorImage(@NotNull Throwable e, @NotNull IconOptions options2) {
        if (e == null) {
            IconGenerator.$$$reportNull$$$0(33);
        }
        if (options2 == null) {
            IconGenerator.$$$reportNull$$$0(34);
        }
        StringBuilder errorMessage = new StringBuilder("Preview rendering error: ");
        String message2 = e.getMessage();
        if (message2 == null) {
            message2 = e.getClass().getSimpleName();
        }
        errorMessage.append(message2);
        Throwable cause = e.getCause();
        if (cause != null && (message2 = cause.getMessage()) != null) {
            errorMessage.append(": ").append(message2);
        }
        double scaleFactor = IconGenerator.getMdpiScaleFactor(options2.density);
        int size = AssetStudioUtils.roundToInt(24.0 * scaleFactor);
        return new AnnotatedImage(AssetUtil.newArgbBufferedImage((int)size, (int)size), errorMessage.toString());
    }

    @NotNull
    public abstract AnnotatedImage generateRasterImage(@NotNull GraphicGeneratorContext var1, @NotNull IconOptions var2);

    @NotNull
    protected AnnotatedImage generateRasterImage(@NotNull Dimension iconSize, @NotNull IconOptions options2) {
        BufferedImage image;
        if (iconSize == null) {
            IconGenerator.$$$reportNull$$$0(35);
        }
        if (options2 == null) {
            IconGenerator.$$$reportNull$$$0(36);
        }
        if (options2.usePlaceholders) {
            AnnotatedImage annotatedImage = PLACEHOLDER_IMAGE;
            if (annotatedImage == null) {
                IconGenerator.$$$reportNull$$$0(37);
            }
            return annotatedImage;
        }
        double scaleFactor = IconGenerator.getMdpiScaleFactor(options2.density);
        Dimension imageSize = AssetStudioUtils.scaleDimension(iconSize, scaleFactor);
        TransformedImageAsset imageAsset = options2.image;
        if (imageAsset == null) {
            AnnotatedImage annotatedImage = PLACEHOLDER_IMAGE;
            if (annotatedImage == null) {
                IconGenerator.$$$reportNull$$$0(38);
            }
            return annotatedImage;
        }
        Object errorMessage = null;
        try {
            image = imageAsset.getTransformedImage(imageSize);
        }
        catch (RuntimeException e) {
            errorMessage = imageAsset.isDrawable() ? "Unable to generate image, possibly invalid drawable" : "Failed to transform %s image";
            String exceptionMessage = e.getMessage();
            if (exceptionMessage != null) {
                errorMessage = (String)errorMessage + ": " + exceptionMessage;
            }
            image = imageAsset.createErrorImage(imageSize);
        }
        return new AnnotatedImage(image, (String)errorMessage);
    }

    @NotNull
    public abstract IconOptions createOptions(boolean var1);

    @NotNull
    protected String getIconPath(@NotNull IconOptions options2, @NotNull String iconName) {
        if (options2 == null) {
            IconGenerator.$$$reportNull$$$0(39);
        }
        if (iconName == null) {
            IconGenerator.$$$reportNull$$$0(40);
        }
        String string = this.getIconFolder(options2) + "/" + IconGenerator.getIconFileName(options2, iconName);
        if (string == null) {
            IconGenerator.$$$reportNull$$$0(41);
        }
        return string;
    }

    @NotNull
    private static String getIconFileName(@NotNull IconOptions options2, @NotNull String iconName) {
        if (options2 == null) {
            IconGenerator.$$$reportNull$$$0(42);
        }
        if (iconName == null) {
            IconGenerator.$$$reportNull$$$0(43);
        }
        if (options2.density == Density.ANYDPI) {
            String string = iconName + ".xml";
            if (string == null) {
                IconGenerator.$$$reportNull$$$0(44);
            }
            return string;
        }
        String string = iconName + ".png";
        if (string == null) {
            IconGenerator.$$$reportNull$$$0(45);
        }
        return string;
    }

    @NotNull
    protected String getIconFolder(@NotNull IconOptions options2) {
        if (options2 == null) {
            IconGenerator.$$$reportNull$$$0(46);
        }
        switch (options2.iconFolderKind) {
            case DRAWABLE: {
                return IconGenerator.getIconFolder(ResourceFolderType.DRAWABLE, options2.density, options2.apiVersion);
            }
            case MIPMAP: {
                return IconGenerator.getIconFolder(ResourceFolderType.MIPMAP, options2.density, options2.apiVersion);
            }
            case DRAWABLE_NO_DPI: {
                return IconGenerator.getIconFolder(ResourceFolderType.DRAWABLE, Density.NODPI, options2.apiVersion);
            }
            case VALUES: {
                return IconGenerator.getIconFolder(ResourceFolderType.VALUES, Density.NODPI, options2.apiVersion);
            }
        }
        throw new IllegalArgumentException("Unexpected folder kind: " + options2.iconFolderKind);
    }

    @NotNull
    private static String getIconFolder(@NotNull ResourceFolderType folderType, @NotNull Density density, int apiVersion) {
        if (folderType == null) {
            IconGenerator.$$$reportNull$$$0(47);
        }
        if (density == null) {
            IconGenerator.$$$reportNull$$$0(48);
        }
        StringBuilder buf = new StringBuilder(50);
        buf.append(folderType.getName());
        if (density != Density.NODPI) {
            buf.append('-');
            buf.append(density.getResourceValue());
        }
        if (apiVersion > 1) {
            buf.append("-v");
            buf.append(apiVersion);
        }
        String string = buf.toString();
        if (string == null) {
            IconGenerator.$$$reportNull$$$0(49);
        }
        return string;
    }

    public void generateRasterImage(@Nullable String category, @NotNull Map<String, Map<String, AnnotatedImage>> categoryMap, @NotNull GraphicGeneratorContext context, @NotNull IconOptions options2, @NotNull String name) {
        if (categoryMap == null) {
            IconGenerator.$$$reportNull$$$0(50);
        }
        if (context == null) {
            IconGenerator.$$$reportNull$$$0(51);
        }
        if (options2 == null) {
            IconGenerator.$$$reportNull$$$0(52);
        }
        if (name == null) {
            IconGenerator.$$$reportNull$$$0(53);
        }
        if (options2.density == Density.ANYDPI) {
            this.generateImageAndUpdateMap(category, categoryMap, context, options2, name);
            return;
        }
        Density[] densityValues = Density.values();
        Arrays.sort(densityValues, Comparator.comparingInt(Density::getDpiValue));
        for (Density density : densityValues) {
            if (!density.isValidValueForDevice() || !this.includeDensity(density)) continue;
            options2.density = density;
            this.generateImageAndUpdateMap(category, categoryMap, context, options2, name);
        }
    }

    private void generateImageAndUpdateMap(@Nullable String category, @NotNull Map<String, Map<String, AnnotatedImage>> categoryMap, @NotNull GraphicGeneratorContext context, @NotNull IconOptions options2, @NotNull String name) {
        if (categoryMap == null) {
            IconGenerator.$$$reportNull$$$0(54);
        }
        if (context == null) {
            IconGenerator.$$$reportNull$$$0(55);
        }
        if (options2 == null) {
            IconGenerator.$$$reportNull$$$0(56);
        }
        if (name == null) {
            IconGenerator.$$$reportNull$$$0(57);
        }
        AnnotatedImage annotatedImage = this.generateRasterImage(context, options2);
        String mapCategory = category;
        if (mapCategory == null) {
            mapCategory = options2.density.getResourceValue();
        }
        Map imageMap = categoryMap.computeIfAbsent(mapCategory, k -> new LinkedHashMap());
        imageMap.put(this.getIconPath(options2, name), annotatedImage);
    }

    protected boolean includeDensity(@NotNull Density density) {
        if (density == null) {
            IconGenerator.$$$reportNull$$$0(58);
        }
        return density.isRecommended() && density != Density.LOW;
    }

    public static double getMdpiScaleFactor(@NotNull Density density) {
        if (density == null) {
            IconGenerator.$$$reportNull$$$0(59);
        }
        if (density == Density.ANYDPI) {
            density = Density.XXXHIGH;
        }
        if (density == Density.NODPI) {
            density = Density.MEDIUM;
        }
        return (double)density.getDpiValue() / (double)Density.MEDIUM.getDpiValue();
    }

    @Nullable
    public static Density pathToDensity(@NotNull String iconPath) {
        if (iconPath == null) {
            IconGenerator.$$$reportNull$$$0(60);
        }
        iconPath = FileUtils.toSystemIndependentPath((String)iconPath);
        iconPath = iconPath.substring(0, iconPath.lastIndexOf(47) + 1);
        for (Density density : Density.values()) {
            if (!DENSITY_PATTERNS.get(density).matcher(iconPath).matches()) continue;
            return density;
        }
        return null;
    }

    protected int calculateMinRequiredApiLevel(@NotNull String xmlDrawableText, int minSdk) {
        ApiLookup apiLookup;
        if (xmlDrawableText == null) {
            IconGenerator.$$$reportNull$$$0(61);
        }
        if ((apiLookup = (ApiLookup)this.myApiLookup.getValue()) == null) {
            return 0;
        }
        KXmlParser parser = new KXmlParser();
        int requiredApiLevel = 0;
        try {
            int type;
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            parser.setInput((Reader)CharSequences.getReader((CharSequence)xmlDrawableText, (boolean)true));
            while ((type = parser.next()) != 1) {
                if (type != 2) continue;
                for (int i2 = 0; i2 < parser.getAttributeCount(); ++i2) {
                    int attributeApiLevel;
                    String attributeName;
                    if (!"http://schemas.android.com/apk/res/android".equals(parser.getAttributeNamespace(i2)) || (attributeName = parser.getAttributeName(i2)).equals("fillType") || requiredApiLevel >= (attributeApiLevel = apiLookup.getFieldVersion("android/R$attr", attributeName))) continue;
                    requiredApiLevel = attributeApiLevel;
                }
            }
        }
        catch (IOException | XmlPullParserException throwable) {
            // empty catch block
        }
        return requiredApiLevel > minSdk && requiredApiLevel > 21 ? requiredApiLevel : 0;
    }

    @NotNull
    private static Logger getLog() {
        Logger logger2 = Logger.getInstance(IconGenerator.class);
        if (logger2 == null) {
            IconGenerator.$$$reportNull$$$0(62);
        }
        return logger2;
    }

    @Nullable
    public static File getResDirectory(@NotNull AndroidModulePaths paths) {
        if (paths == null) {
            IconGenerator.$$$reportNull$$$0(63);
        }
        List<File> directories = paths.getResDirectories();
        int i2 = directories.size();
        while (--i2 >= 0) {
            File dir = directories.get(i2);
            File parent = dir.getParentFile();
            if (parent != null && "generated".equals(parent.getName())) continue;
            return dir;
        }
        return (File)Iterables.getLast(directories, null);
    }

    @Nullable
    private static BufferedImage loadImage(@NotNull GraphicGeneratorContext context, @NotNull Shape shape, @NotNull Density density, @NotNull String fileName) {
        if (context == null) {
            IconGenerator.$$$reportNull$$$0(64);
        }
        if (shape == null) {
            IconGenerator.$$$reportNull$$$0(65);
        }
        if (density == null) {
            IconGenerator.$$$reportNull$$$0(66);
        }
        if (fileName == null) {
            IconGenerator.$$$reportNull$$$0(67);
        }
        String densityValue = density == Density.NODPI ? "playstore" : density.getResourceValue();
        String name = String.format("/images/launcher_stencil/%s/%s/%s.png", shape.id, densityValue, fileName);
        return context.loadImageResource(name);
    }

    @Nullable
    protected static BufferedImage loadMaskImage(@NotNull GraphicGeneratorContext context, @NotNull Shape shape, @NotNull Density density) {
        if (context == null) {
            IconGenerator.$$$reportNull$$$0(68);
        }
        if (shape == null) {
            IconGenerator.$$$reportNull$$$0(69);
        }
        if (density == null) {
            IconGenerator.$$$reportNull$$$0(70);
        }
        return IconGenerator.loadImage(context, shape, density, "mask");
    }

    @Nullable
    protected static BufferedImage loadBackImage(@NotNull GraphicGeneratorContext context, @NotNull Shape shape, @NotNull Density density) {
        if (context == null) {
            IconGenerator.$$$reportNull$$$0(71);
        }
        if (shape == null) {
            IconGenerator.$$$reportNull$$$0(72);
        }
        if (density == null) {
            IconGenerator.$$$reportNull$$$0(73);
        }
        return IconGenerator.loadImage(context, shape, density, "back");
    }

    @Nullable
    protected static BufferedImage loadStyleImage(@NotNull GraphicGeneratorContext context, @NotNull Shape shape, @NotNull Density density, @NotNull Style style) {
        if (context == null) {
            IconGenerator.$$$reportNull$$$0(74);
        }
        if (shape == null) {
            IconGenerator.$$$reportNull$$$0(75);
        }
        if (density == null) {
            IconGenerator.$$$reportNull$$$0(76);
        }
        if (style == null) {
            IconGenerator.$$$reportNull$$$0(77);
        }
        return IconGenerator.loadImage(context, shape, density, style.id);
    }

    static {
        ImmutableMap.Builder builder2 = ImmutableMap.builder();
        for (Density density : Density.values()) {
            builder2.put((Object)density, (Object)Pattern.compile(String.format(".*[^a-z]%s[^a-z].*", density.getResourceValue()), 2));
        }
        DENSITY_PATTERNS = builder2.build();
        PLACEHOLDER_IMAGE = new AnnotatedImage(AssetStudioUtils.createPlaceholderImage());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 27: 
            case 31: 
            case 32: 
            case 37: 
            case 38: 
            case 41: 
            case 44: 
            case 45: 
            case 49: 
            case 62: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 27: 
            case 31: 
            case 32: 
            case 37: 
            case 38: 
            case 41: 
            case 44: 
            case 45: 
            case 49: 
            case 62: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 24: 
            case 28: 
            case 51: 
            case 55: 
            case 64: 
            case 68: 
            case 71: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 27: 
            case 31: 
            case 32: 
            case 37: 
            case 38: 
            case 41: 
            case 44: 
            case 45: 
            case 49: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/assetstudio/IconGenerator";
                break;
            }
            case 5: 
            case 6: 
            case 13: 
            case 25: 
            case 29: 
            case 34: 
            case 36: 
            case 39: 
            case 42: 
            case 46: 
            case 52: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resDirectory";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 19: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 26: 
            case 30: 
            case 53: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconSize";
                break;
            }
            case 40: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconName";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderType";
                break;
            }
            case 48: 
            case 58: 
            case 59: 
            case 66: 
            case 70: 
            case 73: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "density";
                break;
            }
            case 50: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "categoryMap";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconPath";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlDrawableText";
                break;
            }
            case 65: 
            case 69: 
            case 72: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shape";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "style";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/assetstudio/IconGenerator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraphicGeneratorContext";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "sourceAsset";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "outputName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "generateIntoFileMap";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "generateIconPlaceholders";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "generateIntoIconMap";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseDirectory";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "generateIcons";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createIconGenerationTasks";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "generateRasterImage";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconPath";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconFileName";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconFolder";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 27: 
            case 31: 
            case 32: 
            case 37: 
            case 38: 
            case 41: 
            case 44: 
            case 45: 
            case 49: 
            case 62: {
                break;
            }
            case 5: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "generateIcons";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "generateIntoMemory";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "generateIntoFileMap";
                break;
            }
            case 9: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "generateIntoIconMap";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "generateIconPlaceholders";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getBaseDirectory";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "generateIconsToDisk";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "writePngToDisk";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "writeTextToDisk";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createIconGenerationTasks";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createPlaceholderErrorImage";
                break;
            }
            case 35: 
            case 36: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "generateRasterImage";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getIconPath";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getIconFileName";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getIconFolder";
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "generateImageAndUpdateMap";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "includeDensity";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getMdpiScaleFactor";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "pathToDensity";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "calculateMinRequiredApiLevel";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getResDirectory";
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "loadImage";
                break;
            }
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "loadMaskImage";
                break;
            }
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "loadBackImage";
                break;
            }
            case 74: 
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "loadStyleImage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 27: 
            case 31: 
            case 32: 
            case 37: 
            case 38: 
            case 41: 
            case 44: 
            case 45: 
            case 49: 
            case 62: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Style {
        SIMPLE("fore1");

        public final String id;

        private Style(String id) {
            this.id = id;
        }
    }

    public static enum Shape {
        NONE("none"),
        CIRCLE("circle"),
        SQUARE("square"),
        VRECT("vrect"),
        HRECT("hrect"),
        SQUARE_DOG("square_dogear"),
        VRECT_DOG("vrect_dogear"),
        HRECT_DOG("hrect_dogear");

        public final String id;

        private Shape(String id) {
            this.id = id;
        }
    }

    public static enum IconFolderKind {
        DRAWABLE,
        DRAWABLE_NO_DPI,
        MIPMAP,
        VALUES;

    }

    public static class IconOptions
    implements Cloneable {
        public boolean generateOutputIcons;
        public boolean generatePreviewIcons;
        @Nullable
        public TransformedImageAsset image;
        @Nullable
        public ListenableFuture<BufferedImage> sourceImageFuture;
        public boolean isTrimmed;
        public int paddingPercent;
        @NotNull
        public IconFolderKind iconFolderKind = IconFolderKind.DRAWABLE;
        @NotNull
        public Density density = Density.XHIGH;
        public int apiVersion;
        public boolean usePlaceholders;

        public IconOptions(boolean forPreview) {
            this.generatePreviewIcons = forPreview;
            this.generateOutputIcons = !forPreview;
        }

        @NotNull
        public IconOptions clone() {
            IconOptions iconOptions;
            try {
                iconOptions = (IconOptions)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new Error(e);
            }
            if (iconOptions == null) {
                IconOptions.$$$reportNull$$$0(0);
            }
            return iconOptions;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/IconGenerator$IconOptions", "clone"));
        }
    }
}

