/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.ide.common.vectordrawable.VdPreview;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.BuiltInImages;
import com.android.tools.idea.rendering.DrawableRenderer;
import com.android.utils.Pair;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraphicGeneratorContext {
    private final Cache<Object, Future<BufferedImage>> myImageCache;
    private final DrawableRenderer myDrawableRenderer;

    public GraphicGeneratorContext(int maxCacheSize) {
        this(maxCacheSize, null);
    }

    public GraphicGeneratorContext(int maxCacheSize, @Nullable DrawableRenderer drawableRenderer) {
        this.myImageCache = CacheBuilder.newBuilder().maximumSize((long)maxCacheSize).build();
        this.myDrawableRenderer = drawableRenderer;
    }

    @NotNull
    public final Future<BufferedImage> getFromCacheOrCreate(@NotNull Object key, @NotNull Callable<? extends Future<BufferedImage>> creator) {
        Future future2;
        if (key == null) {
            GraphicGeneratorContext.$$$reportNull$$$0(0);
        }
        if (creator == null) {
            GraphicGeneratorContext.$$$reportNull$$$0(1);
        }
        try {
            future2 = (Future)this.myImageCache.get(key, creator);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            this.getLog().error(cause);
            ListenableFuture listenableFuture = Futures.immediateFailedFuture((Throwable)cause);
            if (listenableFuture == null) {
                GraphicGeneratorContext.$$$reportNull$$$0(3);
            }
            return listenableFuture;
        }
        if (future2 == null) {
            GraphicGeneratorContext.$$$reportNull$$$0(2);
        }
        return future2;
    }

    @Nullable
    public BufferedImage loadImageResource(@NotNull String path2) {
        if (path2 == null) {
            GraphicGeneratorContext.$$$reportNull$$$0(4);
        }
        try {
            Future<BufferedImage> imageFuture = this.getFromCacheOrCreate(path2, () -> GraphicGeneratorContext.getStencilImage(path2));
            return imageFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            this.getLog().error((Throwable)e);
            return null;
        }
    }

    @NotNull
    public Future<BufferedImage> renderDrawable(@NotNull String xmlDrawableText, @NotNull Dimension size) {
        if (xmlDrawableText == null) {
            GraphicGeneratorContext.$$$reportNull$$$0(5);
        }
        if (size == null) {
            GraphicGeneratorContext.$$$reportNull$$$0(6);
        }
        Pair key = Pair.of((Object)xmlDrawableText, (Object)size);
        Callable<Future> renderer2 = this.myDrawableRenderer == null ? () -> GraphicGeneratorContext.renderVectorDrawable(xmlDrawableText, size) : () -> this.myDrawableRenderer.renderDrawable(xmlDrawableText, size);
        return this.getFromCacheOrCreate(key, renderer2);
    }

    @NotNull
    private static Future<BufferedImage> renderVectorDrawable(@NotNull String vectorDrawableText, @NotNull Dimension size) {
        VdPreview.TargetSize targetSize;
        BufferedImage image;
        if (vectorDrawableText == null) {
            GraphicGeneratorContext.$$$reportNull$$$0(7);
        }
        if (size == null) {
            GraphicGeneratorContext.$$$reportNull$$$0(8);
        }
        if ((image = VdPreview.getPreviewFromVectorXml((VdPreview.TargetSize)(targetSize = VdPreview.TargetSize.createFromMaxDimension((int)Math.max(size.width, size.height))), (String)vectorDrawableText, null)) == null) {
            image = AssetStudioUtils.createPlaceholderImage();
        }
        ListenableFuture listenableFuture = Futures.immediateFuture((Object)image);
        if (listenableFuture == null) {
            GraphicGeneratorContext.$$$reportNull$$$0(9);
        }
        return listenableFuture;
    }

    @NotNull
    private static Future<BufferedImage> getStencilImage(@NotNull String path2) throws IOException {
        if (path2 == null) {
            GraphicGeneratorContext.$$$reportNull$$$0(10);
        }
        BufferedImage image = BuiltInImages.getStencilImage(path2);
        ListenableFuture listenableFuture = Futures.immediateFuture((Object)image);
        if (listenableFuture == null) {
            GraphicGeneratorContext.$$$reportNull$$$0(11);
        }
        return listenableFuture;
    }

    @NotNull
    private Logger getLog() {
        Logger logger2 = Logger.getInstance(this.getClass());
        if (logger2 == null) {
            GraphicGeneratorContext.$$$reportNull$$$0(12);
        }
        return logger2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creator";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/assetstudio/GraphicGeneratorContext";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlDrawableText";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "size";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vectorDrawableText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/assetstudio/GraphicGeneratorContext";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFromCacheOrCreate";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "renderVectorDrawable";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getStencilImage";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFromCacheOrCreate";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 11: 
            case 12: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadImageResource";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "renderDrawable";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "renderVectorDrawable";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getStencilImage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

