/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.ndk.includes.view;

import com.android.tools.idea.navigator.nodes.ndk.includes.model.PackageValue;
import com.android.tools.idea.navigator.nodes.ndk.includes.model.SimpleIncludeValue;
import com.android.tools.idea.navigator.nodes.ndk.includes.utils.LexicalIncludePaths;
import com.android.tools.idea.navigator.nodes.ndk.includes.utils.PresentationDataWrapper;
import com.android.tools.idea.navigator.nodes.ndk.includes.view.IncludeViewNode;
import com.android.tools.idea.navigator.nodes.ndk.includes.view.IncludeViewNodes;
import com.google.common.collect.ImmutableList;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackagingViewNode
extends IncludeViewNode<PackageValue> {
    protected PackagingViewNode(@NotNull Collection<File> includeFolders, @Nullable Project project, @NotNull PackageValue dependency, @NotNull ViewSettings viewSettings, boolean showPackageType) {
        if (includeFolders == null) {
            PackagingViewNode.$$$reportNull$$$0(0);
        }
        if (dependency == null) {
            PackagingViewNode.$$$reportNull$$$0(1);
        }
        if (viewSettings == null) {
            PackagingViewNode.$$$reportNull$$$0(2);
        }
        super(dependency, includeFolders, showPackageType, project, viewSettings);
    }

    @NotNull
    private PackageValue getPackageValue() {
        PackageValue value2 = (PackageValue)this.getValue();
        assert (value2 != null);
        PackageValue packageValue = value2;
        if (packageValue == null) {
            PackagingViewNode.$$$reportNull$$$0(3);
        }
        return packageValue;
    }

    @NotNull
    public Collection<? extends AbstractTreeNode<?>> getChildren() {
        Project project = this.getProject();
        if (project == null) {
            List list = Collections.EMPTY_LIST;
            if (list == null) {
                PackagingViewNode.$$$reportNull$$$0(4);
            }
            return list;
        }
        ArrayList<File> folders = new ArrayList<File>();
        ArrayList<SimpleIncludeValue> result2 = new ArrayList<SimpleIncludeValue>();
        PackageValue value2 = this.getPackageValue();
        for (File folder : this.myIncludeFolders) {
            for (SimpleIncludeValue simpleIncludeValue : value2.getIncludes()) {
                if (!FileUtil.filesEqual((File)simpleIncludeValue.getIncludeFolder(), (File)folder)) continue;
                result2.add(simpleIncludeValue);
            }
        }
        for (SimpleIncludeValue child : result2) {
            folders.add(child.getIncludeFolder());
        }
        Collection<AbstractTreeNode<?>> collection2 = IncludeViewNodes.getIncludeFolderNodesWithShadowing(folders, (ImmutableList<VirtualFile>)ImmutableList.of(), true, project, this.getSettings());
        if (collection2 == null) {
            PackagingViewNode.$$$reportNull$$$0(5);
        }
        return collection2;
    }

    @Override
    protected void writeDescription(@NotNull PresentationDataWrapper presentation) {
        if (presentation == null) {
            PackagingViewNode.$$$reportNull$$$0(6);
        }
        presentation.setIcon(AllIcons.Nodes.Module);
        PackageValue value2 = this.getPackageValue();
        presentation.addText(value2.getSimplePackageName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (this.myShowPackageType) {
            presentation.addText(String.format(" (%s, ", this.getPackageValue().getPackageType().myDescription), SimpleTextAttributes.GRAY_ATTRIBUTES);
        } else {
            presentation.addText(" (", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        presentation.addText(String.format("%s)", this.getPackageValue().getDescriptiveText()), SimpleTextAttributes.GRAY_ATTRIBUTES);
    }

    public boolean contains(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PackagingViewNode.$$$reportNull$$$0(7);
        }
        if (!LexicalIncludePaths.hasHeaderExtension(file2.getName())) {
            return false;
        }
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        PackageValue value2 = this.getPackageValue();
        for (SimpleIncludeValue include : value2.getIncludes()) {
            VirtualFile ancestor = fileSystem.findFileByIoFile(include.getIncludeFolder());
            if (ancestor == null || !VfsUtilCore.isAncestor((VirtualFile)ancestor, (VirtualFile)file2, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includeFolders";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewSettings";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/navigator/nodes/ndk/includes/view/PackagingViewNode";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/navigator/nodes/ndk/includes/view/PackagingViewNode";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageValue";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "writeDescription";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

