/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.ndk.includes.view;

import com.android.tools.idea.navigator.nodes.ndk.includes.model.ClassifiedIncludeValue;
import com.android.tools.idea.navigator.nodes.ndk.includes.model.PackageFamilyValue;
import com.android.tools.idea.navigator.nodes.ndk.includes.utils.LexicalIncludePaths;
import com.android.tools.idea.navigator.nodes.ndk.includes.utils.PresentationDataWrapper;
import com.android.tools.idea.navigator.nodes.ndk.includes.view.IncludeViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackagingFamilyViewNode
extends IncludeViewNode<PackageFamilyValue> {
    protected PackagingFamilyViewNode(@NotNull Collection<File> includeFolders, @Nullable Project project, @NotNull PackageFamilyValue include, @NotNull ViewSettings viewSettings, boolean showPackageType) {
        if (includeFolders == null) {
            PackagingFamilyViewNode.$$$reportNull$$$0(0);
        }
        if (include == null) {
            PackagingFamilyViewNode.$$$reportNull$$$0(1);
        }
        if (viewSettings == null) {
            PackagingFamilyViewNode.$$$reportNull$$$0(2);
        }
        super(include, includeFolders, showPackageType, project, viewSettings);
    }

    @NotNull
    private PackageFamilyValue getPackageFamilyValue() {
        PackageFamilyValue value2 = (PackageFamilyValue)this.getValue();
        assert (value2 != null);
        PackageFamilyValue packageFamilyValue = value2;
        if (packageFamilyValue == null) {
            PackagingFamilyViewNode.$$$reportNull$$$0(3);
        }
        return packageFamilyValue;
    }

    @NotNull
    public Collection<? extends AbstractTreeNode<?>> getChildren() {
        ArrayList<IncludeViewNode> children = new ArrayList<IncludeViewNode>();
        PackageFamilyValue value2 = this.getPackageFamilyValue();
        for (ClassifiedIncludeValue child : value2.myIncludes) {
            children.add(PackagingFamilyViewNode.createIncludeView(child, this.myIncludeFolders, false, this.getProject(), this.getSettings()));
        }
        ArrayList<IncludeViewNode> arrayList = children;
        if (arrayList == null) {
            PackagingFamilyViewNode.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Override
    final void writeDescription(@NotNull PresentationDataWrapper presentation) {
        if (presentation == null) {
            PackagingFamilyViewNode.$$$reportNull$$$0(5);
        }
        presentation.addText(this.getPackageFamilyValue().myKey.getDescription(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        presentation.addText(String.format(" (%s)", this.getPackageFamilyValue().getPackagingFamilyBaseFolderNameRelativeToHome()), SimpleTextAttributes.GRAY_ATTRIBUTES);
    }

    public boolean contains(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PackagingFamilyViewNode.$$$reportNull$$$0(6);
        }
        if (!LexicalIncludePaths.hasHeaderExtension(file2.getName())) {
            return false;
        }
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        PackageFamilyValue value2 = this.getPackageFamilyValue();
        for (ClassifiedIncludeValue include : value2.myIncludes) {
            VirtualFile ancestor = fileSystem.findFileByIoFile(include.getPackageFamilyBaseFolder());
            if (ancestor == null || !VfsUtilCore.isAncestor((VirtualFile)ancestor, (VirtualFile)file2, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includeFolders";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "include";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewSettings";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/navigator/nodes/ndk/includes/view/PackagingFamilyViewNode";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/navigator/nodes/ndk/includes/view/PackagingFamilyViewNode";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageFamilyValue";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeDescription";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

