/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.ndk;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.ui.SimpleTextAttributes;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class NdkSourceFolderNode
extends PsiDirectoryNode {
    private boolean myShowFolderPath;

    public NdkSourceFolderNode(@NotNull Project project, @NotNull PsiDirectory folder, @NotNull ViewSettings settings) {
        if (project == null) {
            NdkSourceFolderNode.$$$reportNull$$$0(0);
        }
        if (folder == null) {
            NdkSourceFolderNode.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            NdkSourceFolderNode.$$$reportNull$$$0(2);
        }
        super(project, folder, settings);
    }

    protected boolean shouldShowModuleName() {
        return false;
    }

    protected boolean shouldShowSourcesRoot() {
        return false;
    }

    protected void updateImpl(@NotNull PresentationData presentation) {
        if (presentation == null) {
            NdkSourceFolderNode.$$$reportNull$$$0(3);
        }
        VirtualFile folder = this.getVirtualFile();
        assert (folder != null);
        presentation.setPresentableText(folder.getName());
        presentation.addText(folder.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (this.myShowFolderPath) {
            String text2 = String.format(" (%1$s)", FileUtil.getLocationRelativeToUserHome((String)folder.getPresentableUrl()));
            presentation.addText(text2, SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        presentation.setIcon(AllIcons.Nodes.Folder);
    }

    public Collection<AbstractTreeNode<?>> getChildrenImpl() {
        PsiDirectory folder = (PsiDirectory)this.getValue();
        if (folder == null) {
            return Collections.emptyList();
        }
        return ProjectViewDirectoryHelper.getInstance((Project)this.myProject).getDirectoryChildren(folder, this.getSettings(), true);
    }

    void setShowFolderPath(boolean showFolderPath) {
        this.myShowFolderPath = showFolderPath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/navigator/nodes/ndk/NdkSourceFolderNode";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "updateImpl";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

