/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.ndk;

import com.android.ide.common.gradle.model.ndk.v1.IdeNativeArtifact;
import com.android.ide.common.gradle.model.ndk.v1.IdeNativeSettings;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacet;
import com.android.tools.idea.gradle.project.model.NdkModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.model.NdkVariant;
import com.android.tools.idea.gradle.project.model.V1NdkModel;
import com.android.tools.idea.gradle.project.model.VariantAbi;
import com.android.tools.idea.navigator.nodes.ndk.GetContentRootBasedNativeNodesKt;
import com.android.tools.idea.navigator.nodes.ndk.NativeLibraryKey;
import com.android.tools.idea.navigator.nodes.ndk.NativeLibraryType;
import com.android.tools.idea.navigator.nodes.ndk.NdkLibraryEnhancedHeadersNode;
import com.android.tools.idea.navigator.nodes.ndk.includes.utils.LexicalIncludePaths;
import com.android.tools.idea.navigator.nodes.ndk.includes.view.NativeIncludes;
import com.android.tools.idea.ndk.ModuleVariantAbi;
import com.android.tools.idea.ndk.NativeHeaderDir;
import com.android.tools.idea.ndk.NativeWorkspaceService;
import com.android.tools.idea.util.FileExtensions;
import com.google.common.collect.HashMultimap;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u00008\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a2\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a(\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0012"}, d2={"containedInIncludeFolders", "", "project", "Lcom/intellij/openapi/project/Project;", "ndkModuleModel", "Lcom/android/tools/idea/gradle/project/model/NdkModuleModel;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getLibraryBasedNativeNodes", "", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "ndkFacet", "Lcom/android/tools/idea/gradle/project/facet/ndk/NdkFacet;", "v1NdkModel", "Lcom/android/tools/idea/gradle/project/model/V1NdkModel;", "settings", "Lcom/intellij/ide/projectView/ViewSettings;", "getNativeSourceNodes", "intellij.android.core"})
public final class NdkModuleNodeKt {
    @NotNull
    public static final Collection<AbstractTreeNode<?>> getNativeSourceNodes(@NotNull Project project, @NotNull NdkModuleModel ndkModuleModel, @NotNull ViewSettings settings) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)ndkModuleModel, (String)"ndkModuleModel");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Module module2 = ModuleManager.getInstance((Project)project).findModuleByName(ndkModuleModel.getModuleName());
        if (module2 == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"ModuleManager.getInstanc\u2026    ?: return emptyList()");
        Module module3 = module2;
        NdkModel ndkModel = ndkModuleModel.getNdkModel();
        if (!((Boolean)StudioFlags.USE_CONTENT_ROOTS_FOR_NATIVE_PROJECT_VIEW.get()).booleanValue() && ndkModel instanceof V1NdkModel) {
            NdkFacet ndkFacet = NdkFacet.Companion.getInstance(module3);
            if (ndkFacet == null) {
                return CollectionsKt.emptyList();
            }
            NdkFacet ndkFacet2 = ndkFacet;
            return NdkModuleNodeKt.getLibraryBasedNativeNodes(ndkFacet2, (V1NdkModel)ndkModel, project, settings);
        }
        return GetContentRootBasedNativeNodesKt.getContentRootBasedNativeNodes(module3, settings);
    }

    private static final Collection<AbstractTreeNode<?>> getLibraryBasedNativeNodes(NdkFacet ndkFacet, V1NdkModel v1NdkModel, Project project, ViewSettings settings) {
        Collection collection2;
        NdkVariant ndkVariant = v1NdkModel.getNdkVariant(ndkFacet.getSelectedVariantAbi());
        if (ndkVariant == null) {
            return CollectionsKt.emptyList();
        }
        NdkVariant variant2 = ndkVariant;
        HashMultimap nativeLibraries = HashMultimap.create();
        for (IdeNativeArtifact artifact : variant2.getArtifacts()) {
            File file2 = artifact.getOutputFile();
            String nativeLibraryName = null;
            NativeLibraryType nativeLibraryType = null;
            if (file2 == null) {
                nativeLibraryName = artifact.getTargetName();
                nativeLibraryType = NativeLibraryType.OBJECT_LIBRARY;
            } else {
                String name = file2.getName();
                String string = name;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
                if (StringsKt.endsWith$default((String)string, (String)".so", (boolean)false, (int)2, null)) {
                    String string2 = StringUtil.trimEnd((String)name, (String)".so");
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"trimEnd(name, \".so\")");
                    nativeLibraryName = string2;
                    nativeLibraryType = NativeLibraryType.SHARED_LIBRARY;
                } else if (StringsKt.endsWith$default((String)name, (String)".a", (boolean)false, (int)2, null)) {
                    String string3 = StringUtil.trimEnd((String)name, (String)".a");
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"trimEnd(name, \".a\")");
                    nativeLibraryName = string3;
                    nativeLibraryType = NativeLibraryType.STATIC_LIBRARY;
                } else {
                    nativeLibraryName = name;
                    nativeLibraryType = NativeLibraryType.OTHER;
                }
                String string4 = StringUtil.trimStart((String)nativeLibraryName, (String)"lib");
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"trimStart(nativeLibraryName, \"lib\")");
                nativeLibraryName = string4;
            }
            nativeLibraries.put((Object)new NativeLibraryKey(nativeLibraryName, nativeLibraryType), (Object)artifact);
        }
        ArrayList<NdkLibraryEnhancedHeadersNode> children = new ArrayList<NdkLibraryEnhancedHeadersNode>();
        for (NativeLibraryKey key : nativeLibraries.keySet()) {
            String nativeLibraryType = key.getType().getDisplayText();
            String nativeLibraryName = key.getName();
            NdkLibraryEnhancedHeadersNode node2 = new NdkLibraryEnhancedHeadersNode(project, nativeLibraryName, nativeLibraryType, nativeLibraries.get((Object)key), new NativeIncludes(new Function(v1NdkModel){
                final /* synthetic */ V1NdkModel $v1NdkModel;

                public final IdeNativeSettings apply(String it) {
                    String string = it;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it");
                    return this.$v1NdkModel.findSettings(string);
                }
                {
                    this.$v1NdkModel = v1NdkModel;
                }
            }, nativeLibraries.get((Object)key)), settings);
            children.add(node2);
        }
        if (children.size() == 1) {
            Object e = children.get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"children[0]");
            Collection collection3 = ((AbstractTreeNode)e).getChildren();
            collection2 = collection3;
            Intrinsics.checkNotNullExpressionValue((Object)collection3, (String)"children[0].children");
        } else {
            collection2 = children;
        }
        return collection2;
    }

    public static final boolean containedInIncludeFolders(@NotNull Project project, @NotNull NdkModuleModel ndkModuleModel, @NotNull VirtualFile file2) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)ndkModuleModel, (String)"ndkModuleModel");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            if (!LexicalIncludePaths.hasHeaderExtension(file2.getName())) {
                return false;
            }
            Module module2 = ModuleManager.getInstance((Project)project).findModuleByName(ndkModuleModel.getModuleName());
            Intrinsics.checkNotNull((Object)module2);
            Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"ModuleManager.getInstanc\u2026ModuleModel.moduleName)!!");
            Module module3 = module2;
            NdkFacet ndkFacet = NdkFacet.Companion.getInstance(module3);
            Intrinsics.checkNotNull((Object)((Object)ndkFacet));
            NdkFacet ndkFacet2 = ndkFacet;
            VariantAbi variantAbi = ndkFacet2.getSelectedVariantAbi();
            if (variantAbi == null) {
                return false;
            }
            VariantAbi selectedVariantAbi = variantAbi;
            String variant2 = selectedVariantAbi.getVariant();
            String abi = selectedVariantAbi.getAbi();
            NativeWorkspaceService nativeWorkspaceService = NativeWorkspaceService.Companion.getInstance(project);
            Set<NativeHeaderDir> nativeHeaderDirs = nativeWorkspaceService.getNativeHeaderDirs(new ModuleVariantAbi(ndkModuleModel.getModuleName(), variant2, abi));
            Iterable $this$any$iv = nativeHeaderDirs;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    NativeHeaderDir it = (NativeHeaderDir)element$iv;
                    boolean bl2 = false;
                    if (!VfsUtil.isAncestor((File)it.getDir(), (File)FileExtensions.toIoFile(file2), (boolean)false)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }
}

