/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.apk.ndk;

import com.android.tools.idea.apk.paths.PathNode;
import com.android.tools.idea.apk.paths.PathTree;
import com.android.tools.idea.navigator.nodes.apk.ndk.SourceCodeFilter;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileSystemItemFilter;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PathTrees {
    private PathTrees() {
    }

    @NotNull
    static List<PsiDirectory> findSourceFolders(@NotNull PathTree tree, @NotNull String basePath, @NotNull Project project) {
        if (tree == null) {
            PathTrees.$$$reportNull$$$0(0);
        }
        if (basePath == null) {
            PathTrees.$$$reportNull$$$0(1);
        }
        if (project == null) {
            PathTrees.$$$reportNull$$$0(2);
        }
        ArrayList<PsiDirectory> children = new ArrayList<PsiDirectory>();
        ArrayList<PathNode> nodes = new ArrayList<PathNode>();
        PathTrees.removeEmptyRoots(tree.getChildren(), nodes);
        for (PathNode pathNode : nodes) {
            PathTrees.addRoots(pathNode, basePath, children, project);
        }
        ArrayList<PsiDirectory> arrayList = children;
        if (arrayList == null) {
            PathTrees.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private static void addRoots(@NotNull PathNode pathNode, @NotNull String basePath, @NotNull List<PsiDirectory> roots, @NotNull Project project) {
        String path2;
        if (pathNode == null) {
            PathTrees.$$$reportNull$$$0(4);
        }
        if (basePath == null) {
            PathTrees.$$$reportNull$$$0(5);
        }
        if (roots == null) {
            PathTrees.$$$reportNull$$$0(6);
        }
        if (project == null) {
            PathTrees.$$$reportNull$$$0(7);
        }
        if (FileUtil.isAncestor((String)basePath, (String)(path2 = pathNode.getPath()), (boolean)true)) {
            roots.add(PathTrees.findFolder(path2, project));
            return;
        }
        for (PathNode child : pathNode.getChildren()) {
            PathTrees.addRoots(child, basePath, roots, project);
        }
    }

    @NotNull
    static List<AbstractTreeNode<?>> getSourceFolderNodes(@NotNull PathTree tree, @NotNull SourceCodeFilter filter2, @NotNull Project project, @NotNull ViewSettings settings) {
        if (tree == null) {
            PathTrees.$$$reportNull$$$0(8);
        }
        if (filter2 == null) {
            PathTrees.$$$reportNull$$$0(9);
        }
        if (project == null) {
            PathTrees.$$$reportNull$$$0(10);
        }
        if (settings == null) {
            PathTrees.$$$reportNull$$$0(11);
        }
        ArrayList children = new ArrayList();
        ArrayList<PathNode> rootSrcNodes = new ArrayList<PathNode>();
        PathTrees.removeEmptyRoots(tree.getChildren(), rootSrcNodes);
        for (PathNode pathNode : rootSrcNodes) {
            String path2 = pathNode.getPath();
            PsiDirectory psiFolder = PathTrees.findFolder(path2, project);
            if (psiFolder == null) continue;
            children.add((AbstractTreeNode<?>)new PsiDirectoryNode(project, psiFolder, settings, (PsiFileSystemItemFilter)filter2));
        }
        ArrayList arrayList = children;
        if (arrayList == null) {
            PathTrees.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    private static void removeEmptyRoots(@NotNull Collection<PathNode> nodes, @NotNull List<PathNode> rootNodes) {
        if (nodes == null) {
            PathTrees.$$$reportNull$$$0(13);
        }
        if (rootNodes == null) {
            PathTrees.$$$reportNull$$$0(14);
        }
        for (PathNode node2 : nodes) {
            String path2 = node2.getPath();
            if (StringUtil.isNotEmpty((String)path2)) {
                rootNodes.add(node2);
                continue;
            }
            PathTrees.removeEmptyRoots(node2.getChildren(), rootNodes);
        }
    }

    @Nullable
    private static PsiDirectory findFolder(@NotNull String path2, @NotNull Project project) {
        VirtualFile folder;
        if (path2 == null) {
            PathTrees.$$$reportNull$$$0(15);
        }
        if (project == null) {
            PathTrees.$$$reportNull$$$0(16);
        }
        if ((folder = LocalFileSystem.getInstance().findFileByPath(path2)) != null) {
            return PsiManager.getInstance((Project)project).findDirectory(folder);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePath";
                break;
            }
            case 2: 
            case 7: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/navigator/nodes/apk/ndk/PathTrees";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathNode";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootNodes";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/navigator/nodes/apk/ndk/PathTrees";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findSourceFolders";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceFolderNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findSourceFolders";
                break;
            }
            case 3: 
            case 12: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addRoots";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSourceFolderNodes";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removeEmptyRoots";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findFolder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

