/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.apk.ndk;

import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.ApkFacetConfiguration;
import com.android.tools.idea.apk.debugging.NativeLibrary;
import com.android.tools.idea.navigator.nodes.apk.SourceFolders;
import com.android.tools.idea.navigator.nodes.apk.ndk.LibraryNode;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.android.facet.AndroidSourceType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibFolderNode
extends ProjectViewNode<VirtualFile> {
    @NotNull
    private final VirtualFile myFolder;

    public LibFolderNode(@NotNull Project project, @NotNull VirtualFile libFolder, @NotNull ViewSettings settings) {
        if (project == null) {
            LibFolderNode.$$$reportNull$$$0(0);
        }
        if (libFolder == null) {
            LibFolderNode.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            LibFolderNode.$$$reportNull$$$0(2);
        }
        super(project, (Object)libFolder, settings);
        this.myFolder = libFolder;
    }

    @NotNull
    public Collection<? extends AbstractTreeNode<?>> getChildren() {
        assert (this.myProject != null);
        ArrayList<NativeLibrary> libraries = new ArrayList<NativeLibrary>();
        for (Module module2 : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            ApkFacet facet2 = ApkFacet.getInstance(module2);
            if (facet2 == null) continue;
            libraries.addAll(((ApkFacetConfiguration)facet2.getConfiguration()).NATIVE_LIBRARIES);
        }
        ViewSettings settings = this.getSettings();
        ArrayList<LibraryNode> children = new ArrayList<LibraryNode>();
        for (NativeLibrary library : libraries) {
            children.add(new LibraryNode(this.myProject, library, settings));
        }
        ArrayList<LibraryNode> arrayList = children;
        if (arrayList == null) {
            LibFolderNode.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    public boolean contains(@NotNull VirtualFile file2) {
        if (file2 == null) {
            LibFolderNode.$$$reportNull$$$0(4);
        }
        if (VfsUtilCore.isAncestor((VirtualFile)this.myFolder, (VirtualFile)file2, (boolean)false)) {
            return true;
        }
        assert (this.myProject != null);
        return SourceFolders.isInSourceFolder(file2, this.myProject);
    }

    protected void update(@NotNull PresentationData presentation) {
        if (presentation == null) {
            LibFolderNode.$$$reportNull$$$0(5);
        }
        presentation.setIcon(AllIcons.Modules.SourceRoot);
        presentation.addText(LibFolderNode.getSourceType().getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        presentation.addText(" (lib)", SimpleTextAttributes.GRAY_ATTRIBUTES);
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        return this.myFolder;
    }

    @Nullable
    public Comparable getSortKey() {
        return this.getTypeSortKey();
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return LibFolderNode.getSourceType();
    }

    @NotNull
    private static AndroidSourceType getSourceType() {
        AndroidSourceType androidSourceType = AndroidSourceType.CPP;
        if (androidSourceType == null) {
            LibFolderNode.$$$reportNull$$$0(6);
        }
        return androidSourceType;
    }

    public boolean isAlwaysExpand() {
        return true;
    }

    public boolean isAlwaysShowPlus() {
        return true;
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return LibFolderNode.getSourceType().getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LibFolderNode)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LibFolderNode node2 = (LibFolderNode)((Object)o);
        return Objects.equals(this.myFolder, node2.myFolder);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.myFolder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libFolder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/navigator/nodes/apk/ndk/LibFolderNode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/navigator/nodes/apk/ndk/LibFolderNode";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

