/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.apk.java;

import com.android.tools.idea.apk.debugging.ApkClass;
import com.android.tools.idea.apk.debugging.ApkPackage;
import com.android.tools.idea.apk.debugging.DexSourceFiles;
import com.android.tools.idea.navigator.nodes.apk.java.ClassNode;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformIcons;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PackageNode
extends ProjectViewNode<ApkPackage> {
    @NotNull
    private final ApkPackage myPackage;
    @NotNull
    private final DexSourceFiles myDexSourceFiles;

    PackageNode(@NotNull Project project, @NotNull ApkPackage apkPackage, @NotNull ViewSettings settings, @NotNull DexSourceFiles dexSourceFiles) {
        if (project == null) {
            PackageNode.$$$reportNull$$$0(0);
        }
        if (apkPackage == null) {
            PackageNode.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            PackageNode.$$$reportNull$$$0(2);
        }
        if (dexSourceFiles == null) {
            PackageNode.$$$reportNull$$$0(3);
        }
        super(project, (Object)apkPackage, settings);
        this.myPackage = apkPackage;
        this.myDexSourceFiles = dexSourceFiles;
    }

    @NotNull
    public Collection<? extends AbstractTreeNode<?>> getChildren() {
        assert (this.myProject != null);
        ArrayList children = new ArrayList();
        ViewSettings settings = this.getSettings();
        if (!settings.isFlattenPackages()) {
            this.addSubpackagesAsTree(this.myPackage.getSubpackages(), children);
        }
        for (ApkClass apkClass : this.myPackage.getClasses()) {
            children.add((AbstractTreeNode<?>)new ClassNode(this.myProject, apkClass, settings, this.myDexSourceFiles));
        }
        ArrayList arrayList = children;
        if (arrayList == null) {
            PackageNode.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private void addSubpackagesAsTree(@NotNull Collection<ApkPackage> subpackages, @NotNull Collection<AbstractTreeNode<?>> children) {
        if (subpackages == null) {
            PackageNode.$$$reportNull$$$0(5);
        }
        if (children == null) {
            PackageNode.$$$reportNull$$$0(6);
        }
        if (this.getSettings().isHideEmptyMiddlePackages()) {
            for (ApkPackage subpackage : subpackages) {
                if (!subpackage.getClasses().isEmpty() || subpackage.doSubpackagesHaveClasses()) {
                    children.add((AbstractTreeNode<?>)this.createChildNode(subpackage));
                    continue;
                }
                this.addSubpackagesAsTree(subpackage.getSubpackages(), children);
            }
        } else {
            for (ApkPackage subpackage : subpackages) {
                children.add((AbstractTreeNode<?>)this.createChildNode(subpackage));
            }
        }
    }

    @NotNull
    private PackageNode createChildNode(@NotNull ApkPackage subpackage) {
        if (subpackage == null) {
            PackageNode.$$$reportNull$$$0(7);
        }
        assert (this.myProject != null);
        return new PackageNode(this.myProject, subpackage, this.getSettings(), this.myDexSourceFiles);
    }

    public boolean contains(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PackageNode.$$$reportNull$$$0(8);
        }
        String fqn = this.myPackage.getFqn();
        if (this.myDexSourceFiles.isJavaFile(file2)) {
            assert (this.myProject != null);
            String foundPackage = this.myDexSourceFiles.findJavaPackageNameIn(file2);
            if (foundPackage != null && foundPackage.contains(fqn)) {
                return true;
            }
        } else if (this.myDexSourceFiles.isSmaliFile(file2)) {
            File filePath = VfsUtilCore.virtualToIoFile((VirtualFile)file2);
            File packageFilePath = this.myDexSourceFiles.findSmaliFilePathForPackage(fqn);
            return FileUtil.isAncestor((File)packageFilePath, (File)filePath, (boolean)false);
        }
        return false;
    }

    protected void update(@NotNull PresentationData presentation) {
        if (presentation == null) {
            PackageNode.$$$reportNull$$$0(9);
        }
        presentation.setIcon(PlatformIcons.PACKAGE_ICON);
        presentation.setPresentableText(this.getText());
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return this.getText();
    }

    @NotNull
    private String getText() {
        String text2;
        ViewSettings settings = this.getSettings();
        if (settings.isFlattenPackages()) {
            text2 = this.myPackage.getFqn();
        } else if (settings.isHideEmptyMiddlePackages()) {
            ApkPackage parentPackage = this.myPackage.getParent();
            AbstractTreeNode parentNode = this.getParent();
            ApkPackage parentNodePackage = parentNode instanceof PackageNode ? (ApkPackage)((PackageNode)parentNode).getValue() : null;
            text2 = parentPackage != parentNodePackage ? this.myPackage.getFqn() : this.myPackage.getName();
        } else {
            text2 = this.myPackage.getName();
        }
        String string = text2;
        if (string == null) {
            PackageNode.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "apkPackage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dexSourceFiles";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/navigator/nodes/apk/java/PackageNode";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subpackages";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subpackage";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/navigator/nodes/apk/java/PackageNode";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 10: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addSubpackagesAsTree";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createChildNode";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

