/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.apk.java;

import com.android.tools.idea.apk.debugging.ApkClass;
import com.android.tools.idea.apk.debugging.DexSourceFiles;
import com.android.tools.idea.smali.SmaliIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.util.PlatformIcons;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ClassNode
extends ProjectViewNode<ApkClass> {
    @NotNull
    private final ApkClass myClass;
    @NotNull
    private final DexSourceFiles myDexSourceFiles;

    ClassNode(@NotNull Project project, @NotNull ApkClass apkClass, @NotNull ViewSettings settings, @NotNull DexSourceFiles dexSourceFiles) {
        if (project == null) {
            ClassNode.$$$reportNull$$$0(0);
        }
        if (apkClass == null) {
            ClassNode.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            ClassNode.$$$reportNull$$$0(2);
        }
        if (dexSourceFiles == null) {
            ClassNode.$$$reportNull$$$0(3);
        }
        super(project, (Object)apkClass, settings);
        this.myClass = apkClass;
        this.myDexSourceFiles = dexSourceFiles;
    }

    @NotNull
    public Collection<? extends AbstractTreeNode<?>> getChildren() {
        List list = Collections.emptyList();
        if (list == null) {
            ClassNode.$$$reportNull$$$0(4);
        }
        return list;
    }

    protected void update(@NotNull PresentationData presentation) {
        if (presentation == null) {
            ClassNode.$$$reportNull$$$0(5);
        }
        Icon icon2 = SmaliIcons.SmaliFile;
        if (this.myDexSourceFiles.findJavaPsiClass(this.myClass.getFqn()) != null) {
            icon2 = PlatformIcons.CLASS_ICON;
        }
        presentation.setIcon(icon2);
        presentation.setPresentableText(this.getText());
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return this.getText();
    }

    @NotNull
    private String getText() {
        String string = this.myClass.getName();
        if (string == null) {
            ClassNode.$$$reportNull$$$0(6);
        }
        return string;
    }

    public void navigate(boolean requestFocus) {
        if (this.canNavigate()) {
            assert (this.myProject != null);
            String fqn = this.myClass.getFqn();
            if (this.myDexSourceFiles.navigateToJavaFile(fqn)) {
                return;
            }
            VirtualFile smaliFile = this.myDexSourceFiles.findSmaliFile(fqn);
            if (smaliFile != null) {
                FileEditorManager.getInstance((Project)this.myProject).openFile(smaliFile, requestFocus);
            }
        }
    }

    public boolean canNavigate() {
        return true;
    }

    public boolean canRepresent(Object element2) {
        VirtualFile file2;
        if (element2 instanceof VirtualFile) {
            return this.contains((VirtualFile)element2);
        }
        if (element2 instanceof PsiClass) {
            return this.canRepresent((PsiClass)element2);
        }
        if (element2 instanceof PsiMethod) {
            PsiClass containingClass = ((PsiMethod)element2).getContainingClass();
            if (containingClass != null) {
                return this.canRepresent(containingClass);
            }
        } else if (element2 instanceof PsiElement && (file2 = ClassNode.getContainingFile((PsiElement)element2)) != null) {
            return this.contains(file2);
        }
        return false;
    }

    private boolean canRepresent(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            ClassNode.$$$reportNull$$$0(7);
        }
        return this.myClass.getFqn().equals(psiClass.getQualifiedName());
    }

    @Nullable
    private static VirtualFile getContainingFile(@NotNull PsiElement element2) {
        PsiFile containingFile;
        if (element2 == null) {
            ClassNode.$$$reportNull$$$0(8);
        }
        return (containingFile = element2.getContainingFile()) != null ? containingFile.getVirtualFile() : null;
    }

    public boolean contains(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ClassNode.$$$reportNull$$$0(9);
        }
        String fqn = this.myClass.getFqn();
        if (this.myDexSourceFiles.isJavaFile(file2)) {
            assert (this.myProject != null);
            List<String> classes2 = this.myDexSourceFiles.findJavaClassesIn(file2);
            if (classes2.contains(fqn)) {
                return true;
            }
        } else if (this.myDexSourceFiles.isSmaliFile(file2)) {
            File filePath = this.myDexSourceFiles.findSmaliFilePathForClass(fqn);
            return FileUtil.filesEqual((File)filePath, (File)VfsUtilCore.virtualToIoFile((VirtualFile)file2));
        }
        return false;
    }

    public boolean isAlwaysLeaf() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "apkClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dexSourceFiles";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/navigator/nodes/apk/java/ClassNode";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/navigator/nodes/apk/java/ClassNode";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "canRepresent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getContainingFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

