/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.android;

import com.android.tools.idea.navigator.AndroidProjectViewPane;
import com.android.tools.idea.navigator.nodes.FolderGroupNode;
import com.android.tools.idea.navigator.nodes.GroupNodes;
import com.android.tools.idea.navigator.nodes.android.AndroidPsiDirectoryNode;
import com.android.tools.idea.navigator.nodes.android.AndroidPsiFileNode;
import com.android.tools.idea.projectsystem.NamedIdeaSourceProvider;
import com.android.tools.idea.projectsystem.SourceProvidersKt;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidSourceType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidSourceTypeNode
extends ProjectViewNode<AndroidFacet>
implements FolderGroupNode {
    @NotNull
    private static final String GENERATED_SUFFIX = " (generated)";
    @NotNull
    private final AndroidSourceType mySourceType;
    @NotNull
    private final Set<VirtualFile> mySourceRoots;
    @NotNull
    protected final AndroidProjectViewPane myProjectViewPane;

    AndroidSourceTypeNode(@NotNull Project project, @NotNull AndroidFacet androidFacet, @NotNull ViewSettings settings, @NotNull AndroidSourceType sourceType, @NotNull Set<VirtualFile> sources, @NotNull AndroidProjectViewPane projectViewPane) {
        if (project == null) {
            AndroidSourceTypeNode.$$$reportNull$$$0(0);
        }
        if (androidFacet == null) {
            AndroidSourceTypeNode.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            AndroidSourceTypeNode.$$$reportNull$$$0(2);
        }
        if (sourceType == null) {
            AndroidSourceTypeNode.$$$reportNull$$$0(3);
        }
        if (sources == null) {
            AndroidSourceTypeNode.$$$reportNull$$$0(4);
        }
        if (projectViewPane == null) {
            AndroidSourceTypeNode.$$$reportNull$$$0(5);
        }
        super(project, (Object)androidFacet, settings);
        this.mySourceType = sourceType;
        this.mySourceRoots = sources;
        this.myProjectViewPane = projectViewPane;
    }

    @NotNull
    public Collection<? extends AbstractTreeNode<?>> getChildren() {
        ArrayList children = new ArrayList();
        ProjectViewDirectoryHelper projectViewDirectoryHelper = ProjectViewDirectoryHelper.getInstance((Project)this.myProject);
        for (PsiDirectory directory : this.getSourceFolders()) {
            Collection directoryChildren = projectViewDirectoryHelper.getDirectoryChildren(directory, this.getSettings(), true);
            children.addAll(this.annotateWithSourceProvider(directoryChildren));
        }
        ArrayList arrayList = children;
        if (arrayList == null) {
            AndroidSourceTypeNode.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    private Collection<AbstractTreeNode<?>> annotateWithSourceProvider(@NotNull Collection<AbstractTreeNode<?>> folderChildren) {
        if (folderChildren == null) {
            AndroidSourceTypeNode.$$$reportNull$$$0(7);
        }
        ArrayList children = new ArrayList(folderChildren.size());
        assert (this.myProject != null);
        for (AbstractTreeNode<?> child : folderChildren) {
            if (child instanceof PsiDirectoryNode) {
                PsiDirectory folder = (PsiDirectory)((PsiDirectoryNode)child).getValue();
                assert (folder != null);
                children.add((AbstractTreeNode<?>)new AndroidPsiDirectoryNode(this.myProject, folder, this.getSettings(), this.findSourceProvider(folder.getVirtualFile())));
                continue;
            }
            if (child instanceof PsiFileNode) {
                PsiFile file2 = (PsiFile)((PsiFileNode)child).getValue();
                assert (file2 != null);
                VirtualFile virtualFile = file2.getVirtualFile();
                children.add((AbstractTreeNode<?>)new AndroidPsiFileNode(this.myProject, file2, this.getSettings(), this.findSourceProvider(virtualFile)));
                continue;
            }
            children.add(child);
        }
        ArrayList arrayList = children;
        if (arrayList == null) {
            AndroidSourceTypeNode.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @Nullable
    private NamedIdeaSourceProvider findSourceProvider(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            AndroidSourceTypeNode.$$$reportNull$$$0(9);
        }
        AndroidFacet androidFacet = (AndroidFacet)this.getValue();
        assert (androidFacet != null);
        for (NamedIdeaSourceProvider provider2 : AndroidProjectViewPane.getSourceProviders(androidFacet)) {
            if (!SourceProvidersKt.containsFile(provider2, virtualFile)) continue;
            return provider2;
        }
        return null;
    }

    @NotNull
    protected List<PsiDirectory> getSourceFolders() {
        assert (this.myProject != null);
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        ArrayList<PsiDirectory> folders = new ArrayList<PsiDirectory>(this.mySourceRoots.size());
        for (VirtualFile root2 : this.mySourceRoots) {
            PsiDirectory folder;
            if (!root2.isValid() || (folder = psiManager.findDirectory(root2)) == null) continue;
            folders.add(folder);
        }
        ArrayList<PsiDirectory> arrayList = folders;
        if (arrayList == null) {
            AndroidSourceTypeNode.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    protected void update(@NotNull PresentationData presentation) {
        Icon icon2;
        if (presentation == null) {
            AndroidSourceTypeNode.$$$reportNull$$$0(11);
        }
        presentation.addText(this.mySourceType.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (this.mySourceType.isGenerated()) {
            presentation.addText(GENERATED_SUFFIX, SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        if ((icon2 = this.mySourceType.getIcon()) != null) {
            presentation.setIcon(icon2);
        }
        presentation.setPresentableText(this.toTestString(null));
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return this.mySourceType.isGenerated() ? this.mySourceType.getName() + GENERATED_SUFFIX : this.mySourceType.getName();
    }

    public boolean contains(@NotNull VirtualFile file2) {
        if (file2 == null) {
            AndroidSourceTypeNode.$$$reportNull$$$0(12);
        }
        for (VirtualFile root2 : this.mySourceRoots) {
            if (!VfsUtilCore.isAncestor((VirtualFile)root2, (VirtualFile)file2, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public boolean canRepresent(Object element2) {
        return GroupNodes.canRepresent(this, element2);
    }

    @Nullable
    public Comparable getSortKey() {
        return this.mySourceType;
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return this.mySourceType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AndroidSourceTypeNode that = (AndroidSourceTypeNode)o;
        if (this.mySourceType != that.mySourceType) {
            return false;
        }
        return this.mySourceRoots.equals(that.mySourceRoots);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.mySourceType, this.mySourceRoots});
    }

    @Override
    @NotNull
    public List<PsiDirectory> getFolders() {
        List<PsiDirectory> list = this.getSourceFolders();
        if (list == null) {
            AndroidSourceTypeNode.$$$reportNull$$$0(13);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidFacet";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sources";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectViewPane";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/navigator/nodes/android/AndroidSourceTypeNode";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderChildren";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/navigator/nodes/android/AndroidSourceTypeNode";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "annotateWithSourceProvider";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceFolders";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFolders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 13: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "annotateWithSourceProvider";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findSourceProvider";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

