/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.android;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.navigator.nodes.FolderGroupNode;
import com.android.tools.idea.navigator.nodes.GroupNodes;
import com.android.tools.idea.navigator.nodes.android.AndroidResFileNode;
import com.android.tools.idea.navigator.nodes.android.AndroidResGroupNode;
import com.google.common.collect.HashMultimap;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidResFolderTypeNode
extends ProjectViewNode<List<PsiDirectory>>
implements FolderGroupNode {
    @NotNull
    private final AndroidFacet myFacet;
    @NotNull
    private final ResourceFolderType myFolderType;

    AndroidResFolderTypeNode(@NotNull Project project, @NotNull AndroidFacet androidFacet, @NotNull List<PsiDirectory> folders, @NotNull ViewSettings settings, @NotNull ResourceFolderType folderType) {
        if (project == null) {
            AndroidResFolderTypeNode.$$$reportNull$$$0(0);
        }
        if (androidFacet == null) {
            AndroidResFolderTypeNode.$$$reportNull$$$0(1);
        }
        if (folders == null) {
            AndroidResFolderTypeNode.$$$reportNull$$$0(2);
        }
        if (settings == null) {
            AndroidResFolderTypeNode.$$$reportNull$$$0(3);
        }
        if (folderType == null) {
            AndroidResFolderTypeNode.$$$reportNull$$$0(4);
        }
        super(project, folders, settings);
        this.myFacet = androidFacet;
        this.myFolderType = folderType;
    }

    @Override
    @NotNull
    public List<PsiDirectory> getFolders() {
        return this.getResFolders();
    }

    public boolean contains(@NotNull VirtualFile file2) {
        if (file2 == null) {
            AndroidResFolderTypeNode.$$$reportNull$$$0(5);
        }
        for (PsiDirectory resFolder : this.getResFolders()) {
            VirtualFile folder = resFolder.getVirtualFile();
            if (!VfsUtilCore.isAncestor((VirtualFile)folder, (VirtualFile)file2, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public boolean canRepresent(Object element2) {
        return GroupNodes.canRepresent(this, element2);
    }

    @NotNull
    public Collection<? extends AbstractTreeNode<?>> getChildren() {
        HashMultimap multimap = HashMultimap.create();
        for (PsiDirectory resFolder : this.getResFolders()) {
            for (PsiFile file2 : resFolder.getFiles()) {
                String resName = FileUtilRt.getNameWithoutExtension((String)file2.getName());
                multimap.put((Object)resName, (Object)file2);
            }
        }
        assert (this.myProject != null);
        ArrayList<Comparable> children = new ArrayList<Comparable>(multimap.size());
        for (String resName : multimap.keySet()) {
            ArrayList<PsiFile> files2 = new ArrayList<PsiFile>(multimap.get((Object)resName));
            if (files2.size() > 1) {
                children.add(new AndroidResGroupNode(this.myProject, this.myFacet, files2, resName, this.getSettings()));
                continue;
            }
            children.add(new AndroidResFileNode(this.myProject, (PsiFile)files2.get(0), this.getSettings(), this.myFacet));
        }
        ArrayList<Comparable> arrayList = children;
        if (arrayList == null) {
            AndroidResFolderTypeNode.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    private List<PsiDirectory> getResFolders() {
        List folders = (List)this.getValue();
        assert (folders != null);
        List list = folders;
        if (list == null) {
            AndroidResFolderTypeNode.$$$reportNull$$$0(7);
        }
        return list;
    }

    protected void update(@NotNull PresentationData presentation) {
        if (presentation == null) {
            AndroidResFolderTypeNode.$$$reportNull$$$0(8);
        }
        presentation.addText(this.myFolderType.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        presentation.setIcon(PlatformIcons.PACKAGE_ICON);
        presentation.setPresentableText(this.myFolderType.getName());
    }

    @Nullable
    public Comparable getSortKey() {
        return this.myFolderType;
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return this.myFolderType;
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return this.myFolderType.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidFacet";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folders";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/navigator/nodes/android/AndroidResFolderTypeNode";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/navigator/nodes/android/AndroidResFolderTypeNode";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getResFolders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

