/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.android;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.tools.idea.navigator.AndroidProjectViewPane;
import com.android.tools.idea.navigator.nodes.android.AndroidResComparator;
import com.android.tools.idea.projectsystem.NamedIdeaSourceProvider;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleTextAttributes;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidResFileNode
extends PsiFileNode
implements Comparable {
    private final AndroidFacet myFacet;

    AndroidResFileNode(@NotNull Project project, @NotNull PsiFile psiFile2, @NotNull ViewSettings settings, @NotNull AndroidFacet facet2) {
        if (project == null) {
            AndroidResFileNode.$$$reportNull$$$0(0);
        }
        if (psiFile2 == null) {
            AndroidResFileNode.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            AndroidResFileNode.$$$reportNull$$$0(2);
        }
        if (facet2 == null) {
            AndroidResFileNode.$$$reportNull$$$0(3);
        }
        super(project, psiFile2, settings);
        this.myFacet = facet2;
    }

    public void update(@NotNull PresentationData data) {
        if (data == null) {
            AndroidResFileNode.$$$reportNull$$$0(4);
        }
        super.update(data);
        String text2 = data.getPresentableText();
        data.addText(text2, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        data.setPresentableText(text2);
        String qualifier = this.getQualifier();
        if (qualifier != null) {
            data.addText(qualifier, SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        PsiFile psiFile2 = (PsiFile)this.getValue();
        assert (psiFile2 != null);
        String qualifier = this.getQualifier();
        return psiFile2.getName() + (qualifier == null ? "" : qualifier);
    }

    @Nullable
    String getQualifier() {
        NamedIdeaSourceProvider ideaSourceProvider;
        PsiFile resFile = (PsiFile)this.getValue();
        if (resFile == null) {
            return null;
        }
        PsiDirectory resTypeFolder = resFile.getParent();
        if (resTypeFolder == null) {
            return null;
        }
        String folderName = resTypeFolder.getName();
        int index2 = folderName.indexOf(45);
        String qualifier = index2 < 0 ? null : folderName.substring(index2 + 1);
        String providerName = null;
        PsiDirectory resFolder = resTypeFolder.getParent();
        if (resFolder != null && (ideaSourceProvider = this.findSourceProviderForResFolder(resFolder)) != null && "main".equals(providerName = ideaSourceProvider.getName())) {
            providerName = null;
        }
        if (qualifier == null && providerName == null) {
            return null;
        }
        return " (" + Joiner.on((String)", ").skipNulls().join((Object)qualifier, (Object)providerName, new Object[0]) + ")";
    }

    @Nullable
    public FolderConfiguration getFolderConfiguration() {
        PsiFile psiFile2 = (PsiFile)this.getValue();
        if (psiFile2 == null) {
            return null;
        }
        PsiDirectory folder = psiFile2.getParent();
        return folder == null ? null : FolderConfiguration.getConfigForFolder((String)folder.getName());
    }

    @Nullable
    public Comparable getSortKey() {
        return this;
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return this;
    }

    public int compareTo(@NotNull Object obj) {
        if (obj == null) {
            AndroidResFileNode.$$$reportNull$$$0(5);
        }
        return AndroidResComparator.INSTANCE.compare(this, obj);
    }

    @Nullable
    String getResName() {
        PsiFile f = (PsiFile)this.getValue();
        return f == null || !f.isValid() ? null : f.getName();
    }

    @Nullable
    private NamedIdeaSourceProvider findSourceProviderForResFolder(@NotNull PsiDirectory resFolder) {
        if (resFolder == null) {
            AndroidResFileNode.$$$reportNull$$$0(6);
        }
        for (NamedIdeaSourceProvider provider2 : AndroidProjectViewPane.getSourceProviders(this.myFacet)) {
            if (!Iterables.contains(provider2.getResDirectories(), (Object)resFolder.getVirtualFile())) continue;
            return provider2;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resFolder";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/navigator/nodes/android/AndroidResFileNode";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "compareTo";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "findSourceProviderForResFolder";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

