/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.android;

import com.android.ide.common.gradle.model.IdeAndroidArtifact;
import com.android.ide.common.gradle.model.IdeBaseArtifact;
import com.android.ide.common.gradle.model.IdeJavaArtifact;
import com.android.ide.common.util.PathString;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.navigator.AndroidProjectViewPane;
import com.android.tools.idea.navigator.nodes.AndroidViewModuleNode;
import com.android.tools.idea.navigator.nodes.android.AndroidJniFolderNode;
import com.android.tools.idea.navigator.nodes.android.AndroidManifestsGroupNode;
import com.android.tools.idea.navigator.nodes.android.AndroidResFolderNode;
import com.android.tools.idea.navigator.nodes.android.AndroidSourceTypeNode;
import com.android.tools.idea.navigator.nodes.ndk.NdkModuleNodeKt;
import com.android.tools.idea.projectsystem.AndroidModuleSystem;
import com.android.tools.idea.projectsystem.NamedIdeaSourceProvider;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.util.FileExtensions;
import com.google.common.collect.HashMultimap;
import com.intellij.codeInsight.dataflow.SetUtil;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidSourceType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidModuleNode
extends AndroidViewModuleNode {
    public AndroidModuleNode(@NotNull Project project, @NotNull Module module2, @NotNull AndroidProjectViewPane projectViewPane, @NotNull ViewSettings settings) {
        if (project == null) {
            AndroidModuleNode.$$$reportNull$$$0(0);
        }
        if (module2 == null) {
            AndroidModuleNode.$$$reportNull$$$0(1);
        }
        if (projectViewPane == null) {
            AndroidModuleNode.$$$reportNull$$$0(2);
        }
        if (settings == null) {
            AndroidModuleNode.$$$reportNull$$$0(3);
        }
        super(project, module2, projectViewPane, settings);
    }

    @Override
    @NotNull
    protected Collection<AbstractTreeNode<?>> getModuleChildren() {
        Module module2 = (Module)this.getValue();
        if (module2 == null || module2.isDisposed()) {
            List<AbstractTreeNode<?>> list = Collections.emptyList();
            if (list == null) {
                AndroidModuleNode.$$$reportNull$$$0(4);
            }
            return list;
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        if (facet2 == null || AndroidModel.get(facet2) == null) {
            Collection<AbstractTreeNode<?>> collection2 = this.platformGetChildren();
            if (collection2 == null) {
                AndroidModuleNode.$$$reportNull$$$0(5);
            }
            return collection2;
        }
        return AndroidModuleNode.getChildren(facet2, this.getSettings(), this.myProjectViewPane, AndroidProjectViewPane.getSourceProviders(facet2));
    }

    @NotNull
    static Collection<AbstractTreeNode<?>> getChildren(@NotNull AndroidFacet facet2, @NotNull ViewSettings settings, @NotNull AndroidProjectViewPane projectViewPane, @NotNull Iterable<NamedIdeaSourceProvider> providers2) {
        AndroidModuleSystem moduleSystem;
        PsiDirectory sampleDataPsi;
        if (facet2 == null) {
            AndroidModuleNode.$$$reportNull$$$0(6);
        }
        if (settings == null) {
            AndroidModuleNode.$$$reportNull$$$0(7);
        }
        if (projectViewPane == null) {
            AndroidModuleNode.$$$reportNull$$$0(8);
        }
        if (providers2 == null) {
            AndroidModuleNode.$$$reportNull$$$0(9);
        }
        ArrayList result2 = new ArrayList();
        Project project = facet2.getModule().getProject();
        AndroidModuleModel androidModuleModel = AndroidModuleModel.get(facet2);
        HashMultimap<AndroidSourceType, VirtualFile> sourcesByType = AndroidModuleNode.getSourcesBySourceType(providers2, androidModuleModel);
        NdkModuleModel ndkModuleModel = NdkModuleModel.get(facet2.getModule());
        for (AndroidSourceType sourceType : sourcesByType.keySet()) {
            if (sourceType == AndroidSourceType.CPP && ndkModuleModel != null) continue;
            if (sourceType == AndroidSourceType.MANIFEST) {
                result2.add((AbstractTreeNode<?>)new AndroidManifestsGroupNode(project, facet2, settings, sourcesByType.get((Object)sourceType)));
                continue;
            }
            if (sourceType == AndroidSourceType.RES || sourceType == AndroidSourceType.GENERATED_RES) {
                result2.add((AbstractTreeNode<?>)new AndroidResFolderNode(project, facet2, sourceType, settings, (Set<VirtualFile>)sourcesByType.get((Object)sourceType), projectViewPane));
                continue;
            }
            if (sourceType == AndroidSourceType.SHADERS && (androidModuleModel == null || !androidModuleModel.getFeatures().isShadersSupported())) continue;
            result2.add((AbstractTreeNode<?>)new AndroidSourceTypeNode(project, facet2, settings, sourceType, sourcesByType.get((Object)sourceType), projectViewPane));
        }
        if (ndkModuleModel != null) {
            result2.add((AbstractTreeNode<?>)new AndroidJniFolderNode(project, ndkModuleModel, settings));
        }
        if ((sampleDataPsi = AndroidModuleNode.getPsiDirectory(project, (moduleSystem = ProjectSystemUtil.getModuleSystem(facet2.getModule())).getSampleDataDirectory())) != null) {
            result2.add((AbstractTreeNode<?>)new PsiDirectoryNode(project, sampleDataPsi, settings));
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            AndroidModuleNode.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @Nullable
    private static PsiDirectory getPsiDirectory(@NotNull Project project, @Nullable PathString path2) {
        VirtualFile virtualFile;
        if (project == null) {
            AndroidModuleNode.$$$reportNull$$$0(11);
        }
        return (virtualFile = FileExtensions.toVirtualFile(path2)) != null ? PsiManager.getInstance((Project)project).findDirectory(virtualFile) : null;
    }

    @NotNull
    private static HashMultimap<AndroidSourceType, VirtualFile> getSourcesBySourceType(@NotNull Iterable<NamedIdeaSourceProvider> providers2, @Nullable AndroidModuleModel androidModel) {
        if (providers2 == null) {
            AndroidModuleNode.$$$reportNull$$$0(12);
        }
        HashMultimap sourcesByType = HashMultimap.create();
        HashSet<VirtualFile> allSources = new HashSet<VirtualFile>();
        for (AndroidSourceType sourceType : AndroidSourceType.values()) {
            Set<VirtualFile> sources;
            if (sourceType == AndroidSourceType.SHADERS && (androidModel == null || !androidModel.getFeatures().isShadersSupported()) || (sources = sourceType == AndroidSourceType.GENERATED_JAVA ? AndroidModuleNode.getGeneratedSources(androidModel) : (sourceType == AndroidSourceType.GENERATED_RES ? AndroidModuleNode.getGeneratedResFolders(androidModel) : AndroidModuleNode.getSources(sourceType, providers2))).isEmpty()) continue;
            if (SetUtil.intersect(allSources, sources).isEmpty()) {
                sourcesByType.putAll((Object)sourceType, sources);
            } else if (!allSources.containsAll(sources)) {
                sources.removeAll(allSources);
                sourcesByType.putAll((Object)sourceType, sources);
            }
            allSources.addAll(sources);
        }
        HashMultimap hashMultimap = sourcesByType;
        if (hashMultimap == null) {
            AndroidModuleNode.$$$reportNull$$$0(13);
        }
        return hashMultimap;
    }

    @NotNull
    private static Set<VirtualFile> getSources(@NotNull AndroidSourceType sourceType, @NotNull Iterable<NamedIdeaSourceProvider> providers2) {
        if (sourceType == null) {
            AndroidModuleNode.$$$reportNull$$$0(14);
        }
        if (providers2 == null) {
            AndroidModuleNode.$$$reportNull$$$0(15);
        }
        HashSet<VirtualFile> sources = new HashSet<VirtualFile>();
        for (NamedIdeaSourceProvider provider2 : providers2) {
            sources.addAll(sourceType.getSources(provider2));
        }
        HashSet<VirtualFile> hashSet = sources;
        if (hashSet == null) {
            AndroidModuleNode.$$$reportNull$$$0(16);
        }
        return hashSet;
    }

    @NotNull
    private static Set<VirtualFile> getGeneratedSources(@Nullable AndroidModuleModel androidModuleModel) {
        HashSet<VirtualFile> sources = new HashSet<VirtualFile>();
        if (androidModuleModel != null) {
            IdeJavaArtifact unitTestArtifact;
            ArrayList<File> files2 = new ArrayList<File>(GradleUtil.getGeneratedSourceFoldersToUse((IdeBaseArtifact)androidModuleModel.getMainArtifact(), androidModuleModel));
            IdeAndroidArtifact androidTestArtifact = androidModuleModel.getArtifactForAndroidTest();
            if (androidTestArtifact != null) {
                files2.addAll(GradleUtil.getGeneratedSourceFoldersToUse((IdeBaseArtifact)androidTestArtifact, androidModuleModel));
            }
            if ((unitTestArtifact = androidModuleModel.getSelectedVariant().getUnitTestArtifact()) != null) {
                files2.addAll(unitTestArtifact.getGeneratedSourceFolders());
            }
            for (File file2 : files2) {
                VirtualFile vFile = VfsUtil.findFileByIoFile((File)file2, (boolean)false);
                if (vFile == null) continue;
                sources.add(vFile);
            }
        }
        HashSet<VirtualFile> hashSet = sources;
        if (hashSet == null) {
            AndroidModuleNode.$$$reportNull$$$0(17);
        }
        return hashSet;
    }

    @NotNull
    private static Set<VirtualFile> getGeneratedResFolders(@Nullable AndroidModuleModel androidModuleModel) {
        HashSet<VirtualFile> sources = new HashSet<VirtualFile>();
        if (androidModuleModel != null) {
            ArrayList files2 = new ArrayList(androidModuleModel.getMainArtifact().getGeneratedResourceFolders());
            IdeAndroidArtifact androidTest = androidModuleModel.getArtifactForAndroidTest();
            if (androidTest != null) {
                files2.addAll(androidTest.getGeneratedResourceFolders());
            }
            for (File file2 : files2) {
                VirtualFile vFile = VfsUtil.findFileByIoFile((File)file2, (boolean)false);
                if (vFile == null) continue;
                sources.add(vFile);
            }
        }
        HashSet<VirtualFile> hashSet = sources;
        if (hashSet == null) {
            AndroidModuleNode.$$$reportNull$$$0(18);
        }
        return hashSet;
    }

    @Override
    public boolean contains(@NotNull VirtualFile file2) {
        if (file2 == null) {
            AndroidModuleNode.$$$reportNull$$$0(19);
        }
        if (super.contains(file2)) {
            return true;
        }
        Module module2 = (Module)this.getValue();
        if (module2 == null || module2.isDisposed()) {
            return false;
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        if (facet2 == null || AndroidModel.get(facet2) == null) {
            return false;
        }
        NdkModuleModel ndkModuleModel = NdkModuleModel.get(facet2.getModule());
        if (ndkModuleModel != null) {
            return NdkModuleNodeKt.containedInIncludeFolders(this.myProject, ndkModuleModel, file2);
        }
        return false;
    }

    @Nullable
    public Comparable getSortKey() {
        Module module2 = (Module)this.getValue();
        if (module2 == null || module2.isDisposed()) {
            return null;
        }
        return module2.getName();
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return this.getSortKey();
    }

    @Override
    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        Module module2 = (Module)this.getValue();
        if (module2 == null || module2.isDisposed()) {
            return module2 == null ? "(null)" : "(Disposed)";
        }
        return String.format("%1$s (Android)", super.toTestString(printInfo));
    }

    @Override
    public void update(@NotNull PresentationData presentation) {
        if (presentation == null) {
            AndroidModuleNode.$$$reportNull$$$0(20);
        }
        super.update(presentation);
        Module module2 = (Module)this.getValue();
        if (module2 == null || module2.isDisposed()) {
            return;
        }
        presentation.setIcon(GradleUtil.getModuleIcon(module2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectViewPane";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/navigator/nodes/android/AndroidModuleNode";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 9: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceType";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/navigator/nodes/android/AndroidModuleNode";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleChildren";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourcesBySourceType";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSources";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getGeneratedSources";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getGeneratedResFolders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getPsiDirectory";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSourcesBySourceType";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSources";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

