/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.android;

import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.navigator.nodes.android.AndroidBuildScriptNode;
import com.android.tools.idea.navigator.nodes.android.AndroidBuildScriptsGroupNodeKt;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import icons.GradleIcons;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u0012\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0018\u00010\u00020\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ&\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0011\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0096\u0002J\u0014\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00110\u0015H\u0002J\u0014\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00180\u0017H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0014\u0010\u001b\u001a\u0004\u0018\u00010\u00112\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020 H\u0014\u00a8\u0006!"}, d2={"Lcom/android/tools/idea/navigator/nodes/android/AndroidBuildScriptsGroupNode;", "Lcom/intellij/ide/projectView/ProjectViewNode;", "", "Lcom/intellij/psi/PsiDirectory;", "project", "Lcom/intellij/openapi/project/Project;", "settings", "Lcom/intellij/ide/projectView/ViewSettings;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ide/projectView/ViewSettings;)V", "addPsiFile", "", "psiFileNodes", "", "Lcom/intellij/ide/projectView/impl/nodes/PsiFileNode;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "qualifier", "", "contains", "", "getBuildScriptsWithQualifiers", "", "getChildren", "", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "getWeight", "", "toTestString", "printInfo", "Lcom/intellij/openapi/ui/Queryable$PrintInfo;", "update", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "intellij.android.core"})
public final class AndroidBuildScriptsGroupNode
extends ProjectViewNode<List<? extends PsiDirectory>> {
    public boolean contains(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return this.getBuildScriptsWithQualifiers().containsKey(file2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<AbstractTreeNode<?>> getChildren() {
        VirtualFile scripts = this.getBuildScriptsWithQualifiers();
        ArrayList children = new ArrayList(scripts.size());
        VirtualFile virtualFile = scripts;
        boolean bl = false;
        Iterator<Map.Entry<VirtualFile, String>> iterator = virtualFile.entrySet().iterator();
        while (iterator.hasNext()) {
            void key;
            Map.Entry<VirtualFile, String> entry;
            Map.Entry<VirtualFile, String> entry2 = entry = iterator.next();
            boolean bl2 = false;
            virtualFile = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            String value2 = entry2.getValue();
            this.addPsiFile(children, (VirtualFile)key, value2);
        }
        return children;
    }

    private final Map<VirtualFile, String> getBuildScriptsWithQualifiers() {
        VirtualFile file2;
        File userSettingsFile;
        boolean bl = false;
        Map buildScripts = new LinkedHashMap();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(myProject)");
        for (Module module2 : moduleManager.getModules()) {
            StringBuilder stringBuilder = new StringBuilder();
            Module module3 = module2;
            Intrinsics.checkNotNullExpressionValue((Object)module3, (String)"module");
            String moduleName2 = stringBuilder.append(AndroidBuildScriptsGroupNodeKt.access$getPrefixForModule(module3)).append(module2.getName()).toString();
            VirtualFile gradleBuildFile = GradleUtil.getGradleBuildFile(module2);
            if (gradleBuildFile != null) {
                buildScripts.put(gradleBuildFile, moduleName2);
            }
            for (VirtualFile file3 : AndroidBuildScriptsGroupNodeKt.access$findAllGradleScriptsInModule(module2)) {
                String string;
                if (file3.getFileType() == AndroidBuildScriptsGroupNodeKt.access$getProguardFileType()) {
                    StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                    String string2 = "ProGuard Rules for %1$s";
                    Object[] objectArray = new Object[]{module2.getName()};
                    boolean bl2 = false;
                    String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
                } else {
                    string = moduleName2;
                }
                buildScripts.put(file3, string);
            }
        }
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        VirtualFile projectRootFolder = project.getBaseDir();
        if (projectRootFolder != null) {
            AndroidBuildScriptsGroupNodeKt.access$findChildAndAddToMapIfFound("settings.gradle", projectRootFolder, "Project Settings", buildScripts);
            AndroidBuildScriptsGroupNodeKt.access$findChildAndAddToMapIfFound("settings.gradle.kts", projectRootFolder, "Project Settings", buildScripts);
            AndroidBuildScriptsGroupNodeKt.access$findChildAndAddToMapIfFound("gradle.properties", projectRootFolder, "Project Properties", buildScripts);
            VirtualFile child = projectRootFolder.findFileByRelativePath(FileUtilRt.toSystemIndependentName((String)GradleUtil.GRADLEW_PROPERTIES_PATH));
            if (child != null) {
                buildScripts.put(child, "Gradle Version");
            }
            AndroidBuildScriptsGroupNodeKt.access$findChildAndAddToMapIfFound("local.properties", projectRootFolder, "SDK Location", buildScripts);
        }
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (!application.isUnitTestMode() && (userSettingsFile = GradleUtil.getGradleUserSettingsFile()) != null && (file2 = VfsUtil.findFileByIoFile((File)userSettingsFile, (boolean)false)) != null) {
            buildScripts.put(file2, "Global Properties");
        }
        return buildScripts;
    }

    private final void addPsiFile(List<PsiFileNode> psiFileNodes, VirtualFile file2, String qualifier) {
        PsiFile psiFile2 = PsiManager.getInstance((Project)this.myProject).findFile(file2);
        if (psiFile2 != null) {
            psiFileNodes.add(new AndroidBuildScriptNode(this.myProject, psiFile2, this.getSettings(), qualifier));
        }
    }

    public int getWeight() {
        return 100;
    }

    protected void update(@NotNull PresentationData presentation) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        presentation.setPresentableText("Gradle Scripts");
        presentation.setIcon(GradleIcons.Gradle);
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return "Gradle Scripts";
    }

    public AndroidBuildScriptsGroupNode(@NotNull Project project, @NotNull ViewSettings settings) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(project, (Object)CollectionsKt.emptyList(), settings);
    }
}

