/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator;

import com.android.tools.idea.Projects;
import com.android.tools.idea.navigator.nodes.AndroidViewProjectNode;
import com.android.tools.idea.navigator.nodes.FileGroupNode;
import com.android.tools.idea.navigator.nodes.FolderGroupNode;
import com.android.tools.idea.navigator.nodes.android.BuildScriptTreeStructureProvider;
import com.android.tools.idea.projectsystem.NamedIdeaSourceProvider;
import com.android.tools.idea.projectsystem.SourceProviders;
import com.google.common.collect.Iterables;
import com.intellij.facet.Facet;
import com.intellij.facet.ProjectWideFacetAdapter;
import com.intellij.facet.ProjectWideFacetListener;
import com.intellij.facet.ProjectWideFacetListenersRegistry;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.impl.ProjectViewSelectInTarget;
import com.intellij.ide.projectView.BaseProjectTreeBuilder;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.AbstractProjectViewPSIPane;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.ProjectAbstractTreeStructureBase;
import com.intellij.ide.projectView.impl.ProjectTreeStructure;
import com.intellij.ide.projectView.impl.ProjectViewTree;
import com.intellij.ide.projectView.impl.nodes.PackageElement;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeUpdater;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import icons.AndroidIcons;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.facet.SourceProviderManager;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidProjectViewPane
extends AbstractProjectViewPSIPane {
    public static final String ID = "AndroidView";
    public static final DataKey<TreeNode[]> SELECTED_TREE_NODES = DataKey.create((String)"selectedTreeNodes");
    private final AtomicBoolean isProcessingChanges = new AtomicBoolean(false);

    public AndroidProjectViewPane(final Project project) {
        super(project);
        ProjectWideFacetListenersRegistry.getInstance((Project)project).registerListener((ProjectWideFacetListener)new ProjectWideFacetAdapter<Facet>(){

            public void facetAdded(@NotNull Facet facet2) {
                if (facet2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.somethingChanged();
            }

            public void facetRemoved(@NotNull Facet facet2) {
                if (facet2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.somethingChanged();
            }

            private void somethingChanged() {
                if (!AndroidProjectViewPane.this.isProcessingChanges.getAndSet(true)) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        try {
                            if (project.isDisposed()) {
                                return;
                            }
                            ProjectView projectView = ProjectView.getInstance((Project)project);
                            AbstractProjectViewPane pane = projectView.getProjectViewPaneById(AndroidProjectViewPane.ID);
                            boolean visible = AndroidProjectViewPane.this.isInitiallyVisible();
                            if (visible && pane == null) {
                                projectView.addProjectPane((AbstractProjectViewPane)AndroidProjectViewPane.this);
                            } else if (!visible && pane != null) {
                                projectView.removeProjectPane(pane);
                            }
                        }
                        finally {
                            AndroidProjectViewPane.this.isProcessingChanges.set(false);
                        }
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "facet";
                objectArray2[1] = "com/android/tools/idea/navigator/AndroidProjectViewPane$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    public String getTitle() {
        return "Android";
    }

    @NotNull
    public Icon getIcon() {
        Icon icon2 = AndroidIcons.Android;
        if (icon2 == null) {
            AndroidProjectViewPane.$$$reportNull$$$0(0);
        }
        return icon2;
    }

    @NotNull
    public String getId() {
        return ID;
    }

    public int getWeight() {
        return 142;
    }

    public boolean isInitiallyVisible() {
        return AndroidUtils.hasAndroidFacets(this.myProject);
    }

    @NotNull
    public static Iterable<NamedIdeaSourceProvider> getSourceProviders(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            AndroidProjectViewPane.$$$reportNull$$$0(1);
        }
        SourceProviders sourceProviderManager = SourceProviderManager.getInstance(facet2);
        Iterable iterable = Iterables.concat(sourceProviderManager.getCurrentSourceProviders(), sourceProviderManager.getCurrentUnitTestSourceProviders(), sourceProviderManager.getCurrentAndroidTestSourceProviders());
        if (iterable == null) {
            AndroidProjectViewPane.$$$reportNull$$$0(2);
        }
        return iterable;
    }

    @NotNull
    public SelectInTarget createSelectInTarget() {
        return new ProjectViewSelectInTarget(this.myProject){

            public String toString() {
                return AndroidProjectViewPane.this.getTitle();
            }

            public String getMinorViewId() {
                return AndroidProjectViewPane.this.getId();
            }

            public float getWeight() {
                return AndroidProjectViewPane.this.getWeight();
            }
        };
    }

    @NotNull
    protected ProjectAbstractTreeStructureBase createStructure() {
        return new ProjectTreeStructure(this.myProject, ID){

            public List<TreeStructureProvider> getProviders() {
                List providers2 = super.getProviders();
                if (providers2 == null) {
                    return null;
                }
                return ContainerUtil.map((Collection)providers2, provider2 -> new BuildScriptTreeStructureProvider((TreeStructureProvider)provider2));
            }

            protected AbstractTreeNode createRoot(@NotNull Project project, @NotNull ViewSettings settings) {
                if (project == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (settings == null) {
                    3.$$$reportNull$$$0(1);
                }
                return new AndroidViewProjectNode(project, settings, AndroidProjectViewPane.this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "settings";
                        break;
                    }
                }
                objectArray[1] = "com/android/tools/idea/navigator/AndroidProjectViewPane$3";
                objectArray[2] = "createRoot";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Nullable
    protected BaseProjectTreeBuilder createBuilder(@NotNull DefaultTreeModel treeModel) {
        if (treeModel == null) {
            AndroidProjectViewPane.$$$reportNull$$$0(3);
        }
        return null;
    }

    @NotNull
    protected ProjectViewTree createTree(@NotNull DefaultTreeModel treeModel) {
        if (treeModel == null) {
            AndroidProjectViewPane.$$$reportNull$$$0(4);
        }
        return new MyProjectViewTree(treeModel);
    }

    @NotNull
    protected AbstractTreeUpdater createTreeUpdater(@NotNull AbstractTreeBuilder treeBuilder) {
        if (treeBuilder == null) {
            AndroidProjectViewPane.$$$reportNull$$$0(5);
        }
        return new AbstractTreeUpdater(treeBuilder){};
    }

    @NotNull
    public PsiDirectory[] getSelectedDirectories() {
        PackageElement packageElement;
        Module m;
        Object selectedElement = this.getSelectedElement();
        if (selectedElement instanceof PackageElement && (m = (packageElement = (PackageElement)selectedElement).getModule()) != null) {
            PsiDirectory[] psiDirectoryArray = packageElement.getPackage().getDirectories(GlobalSearchScope.moduleScope((Module)m));
            if (psiDirectoryArray == null) {
                AndroidProjectViewPane.$$$reportNull$$$0(6);
            }
            return psiDirectoryArray;
        }
        NodeDescriptor descriptor2 = this.getSelectedDescriptor();
        if (descriptor2 instanceof FolderGroupNode) {
            PsiDirectory[] psiDirectoryArray = ((FolderGroupNode)descriptor2).getFolders().toArray(PsiDirectory.EMPTY_ARRAY);
            if (psiDirectoryArray == null) {
                AndroidProjectViewPane.$$$reportNull$$$0(7);
            }
            return psiDirectoryArray;
        }
        PsiDirectory[] selectedDirectories = super.getSelectedDirectories();
        if (selectedElement instanceof Module && selectedDirectories.length > 0) {
            ArrayList<PsiDirectory> dirs = new ArrayList<PsiDirectory>(selectedDirectories.length);
            for (PsiDirectory dir : selectedDirectories) {
                VirtualFile file2 = dir.getVirtualFile();
                if (GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)file2, (Project)this.myProject) || file2.getParent() != null && file2.getPath().contains("/generated/")) continue;
                dirs.add(dir);
            }
            selectedDirectories = dirs.toArray(PsiDirectory.EMPTY_ARRAY);
        }
        if (selectedDirectories == null) {
            AndroidProjectViewPane.$$$reportNull$$$0(8);
        }
        return selectedDirectories;
    }

    @Nullable
    public Object getValueFromNode(@Nullable Object node2) {
        Object o = super.getValueFromNode(node2);
        if (o instanceof ArrayList && TreeUtil.getUserObject((Object)node2) instanceof FolderGroupNode) {
            return ((ArrayList)o).toArray();
        }
        return o;
    }

    public Object getData(@NotNull String dataId) {
        Module m;
        PackageElement packageElement;
        VirtualFile directory;
        Object o;
        if (dataId == null) {
            AndroidProjectViewPane.$$$reportNull$$$0(9);
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId) && (o = this.getSelectedElement()) instanceof PsiDirectory && this.isTopModuleDirectoryOrParent(directory = ((PsiDirectory)o).getVirtualFile())) {
            return new NoOpDeleteProvider();
        }
        if (LangDataKeys.MODULE.is(dataId)) {
            o = this.getSelectedElement();
            if (o instanceof PackageElement) {
                packageElement = (PackageElement)o;
                return packageElement.getModule();
            }
            if (o instanceof AndroidFacet) {
                return ((AndroidFacet)o).getModule();
            }
        }
        if (CommonDataKeys.VIRTUAL_FILE.is(dataId) && (o = this.getSelectedElement()) instanceof PackageElement && (m = (packageElement = (PackageElement)o).getModule()) != null) {
            PsiDirectory[] folders = packageElement.getPackage().getDirectories(GlobalSearchScope.moduleScope((Module)m));
            if (folders.length > 0) {
                return folders[0].getVirtualFile();
            }
            return null;
        }
        if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
            List<PsiDirectory> directories;
            ArrayList<VirtualFile> virtualFiles;
            List<PsiFile> files2;
            NodeDescriptor selectedDescriptor = this.getSelectedDescriptor();
            if (selectedDescriptor instanceof FileGroupNode && !(files2 = ((FileGroupNode)selectedDescriptor).getFiles()).isEmpty()) {
                virtualFiles = new ArrayList<VirtualFile>(files2.size());
                for (PsiFile file2 : files2) {
                    if (!file2.isValid()) continue;
                    virtualFiles.add(file2.getVirtualFile());
                }
                return virtualFiles.toArray(VirtualFile.EMPTY_ARRAY);
            }
            if (selectedDescriptor instanceof FolderGroupNode && !(directories = ((FolderGroupNode)selectedDescriptor).getFolders()).isEmpty()) {
                virtualFiles = new ArrayList(directories.size());
                for (PsiDirectory directory2 : directories) {
                    if (!directory2.isValid()) continue;
                    virtualFiles.add(directory2.getVirtualFile());
                }
                return virtualFiles.toArray(VirtualFile.EMPTY_ARRAY);
            }
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            List<PsiDirectory> directories;
            List<PsiFile> files3;
            List l;
            o = this.getSelectedElement();
            if (o instanceof PsiElement) {
                return o;
            }
            if (o instanceof List && !(l = (List)o).isEmpty() && l.get(0) instanceof PsiElement) {
                return l.get(0);
            }
            NodeDescriptor selectedDescriptor = this.getSelectedDescriptor();
            if (selectedDescriptor instanceof FileGroupNode && !(files3 = ((FileGroupNode)selectedDescriptor).getFiles()).isEmpty()) {
                return files3.get(0);
            }
            if (selectedDescriptor instanceof FolderGroupNode && !(directories = ((FolderGroupNode)selectedDescriptor).getFolders()).isEmpty()) {
                return directories.get(0);
            }
        }
        if (SELECTED_TREE_NODES.is(dataId)) {
            return this.getSelectedTreeNodes();
        }
        return super.getData(dataId);
    }

    @Nullable
    private TreeNode[] getSelectedTreeNodes() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            return null;
        }
        ArrayList<TreeNode> result2 = new ArrayList<TreeNode>();
        for (TreePath path2 : paths) {
            Object lastPathComponent = path2.getLastPathComponent();
            if (!(lastPathComponent instanceof DefaultMutableTreeNode)) continue;
            result2.add((TreeNode)lastPathComponent);
        }
        return result2.toArray(new TreeNode[0]);
    }

    private boolean isTopModuleDirectoryOrParent(@NotNull VirtualFile directory) {
        if (directory == null) {
            AndroidProjectViewPane.$$$reportNull$$$0(10);
        }
        for (Module module2 : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            File baseDirPath;
            File moduleRootFolderPath = AndroidRootUtil.findModuleRootFolderPath(module2);
            if (moduleRootFolderPath == null || !FileUtil.filesEqual((File)moduleRootFolderPath, (File)(baseDirPath = Projects.getBaseDirPath((Project)this.myProject)))) continue;
            File directoryPath = VfsUtilCore.virtualToIoFile((VirtualFile)directory);
            return FileUtil.isAncestor((File)directoryPath, (File)baseDirPath, (boolean)false);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/navigator/AndroidProjectViewPane";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeModel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeBuilder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/navigator/AndroidProjectViewPane";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceProviders";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedDirectories";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSourceProviders";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createTree";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createTreeUpdater";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isTopModuleDirectoryOrParent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NoOpDeleteProvider
    implements DeleteProvider {
        private NoOpDeleteProvider() {
        }

        public void deleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                NoOpDeleteProvider.$$$reportNull$$$0(0);
            }
        }

        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                NoOpDeleteProvider.$$$reportNull$$$0(1);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "dataContext";
            objectArray2[1] = "com/android/tools/idea/navigator/AndroidProjectViewPane$NoOpDeleteProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "deleteElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canDeleteElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyProjectViewTree
    extends ProjectViewTree
    implements DataProvider {
        MyProjectViewTree(DefaultTreeModel treeModel) {
            super((TreeModel)treeModel);
        }

        @Nullable
        public Object getData(@NotNull @NonNls String dataId) {
            if (dataId == null) {
                MyProjectViewTree.$$$reportNull$$$0(0);
            }
            return AndroidProjectViewPane.this.getData(dataId);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/android/tools/idea/navigator/AndroidProjectViewPane$MyProjectViewTree", "getData"));
        }
    }
}

