/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.model;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.manifmerger.Actions;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.XmlNode;
import com.android.resources.ScreenSize;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.tools.idea.configurations.ThemeUtils;
import com.android.tools.idea.model.ActivityAttributesSnapshot;
import com.android.tools.idea.model.ImmutablePermissionHolder;
import com.android.tools.idea.model.MergedManifestInfo;
import com.android.tools.idea.run.activity.ActivityLocatorUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Clock;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MergedManifestSnapshot {
    private final long myCreationTimeMs;
    private final Module myModule;
    @Nullable
    private final String myPackageName;
    @Nullable
    private final String myApplicationId;
    @Nullable
    private final Integer myVersionCode;
    @Nullable
    private final Actions myActions;
    @NotNull
    private final ImmutableList<MergingReport.Record> myLoggingRecords;
    @Nullable
    private String myManifestTheme;
    @NotNull
    private final ImmutableMap<String, ActivityAttributesSnapshot> myAttributes;
    @Nullable
    private final MergedManifestInfo myMergedManifestInfo;
    @NotNull
    private final AndroidVersion myMinSdk;
    @NotNull
    private final AndroidVersion myTargetSdk;
    @Nullable
    private final ResourceValue myAppIcon;
    @Nullable
    private final ResourceValue myAppLabel;
    private final boolean mySupportsRtl;
    @Nullable
    private final Boolean myIsDebuggable;
    @NotNull
    private final ImmutableMap<String, XmlNode.NodeKey> myNodeKeys;
    @Nullable
    private final Document myDocument;
    @NotNull
    private final ImmutableList<VirtualFile> myFiles;
    @NotNull
    private final ImmutablePermissionHolder myPermissions;
    private final boolean myAppHasCode;
    private final ImmutableList<Element> myActivities;
    private final ImmutableList<Element> myActivityAliases;
    private final ImmutableList<Element> myServices;
    private final boolean myIsValid;

    MergedManifestSnapshot(@NotNull Module module2, @Nullable String packageName, @Nullable String applicationId2, @Nullable Integer versionCode2, @Nullable String manifestTheme, @NotNull ImmutableMap<String, ActivityAttributesSnapshot> activityAttributes, @Nullable MergedManifestInfo mergedManifestInfo, @NotNull AndroidVersion minSdk, @NotNull AndroidVersion targetSdk, @Nullable ResourceValue appIcon, @Nullable ResourceValue appLabel, boolean supportsRtl, @Nullable Boolean isDebuggable, @Nullable Document document, @Nullable ImmutableList<VirtualFile> manifestFiles, @NotNull ImmutablePermissionHolder permissions, boolean appHasCode, @NotNull ImmutableList<Element> activities, @NotNull ImmutableList<Element> activityAliases, @NotNull ImmutableList<Element> services, @Nullable Actions actions2, @NotNull ImmutableList<MergingReport.Record> loggingRecords, boolean isValid2) {
        if (module2 == null) {
            MergedManifestSnapshot.$$$reportNull$$$0(0);
        }
        if (activityAttributes == null) {
            MergedManifestSnapshot.$$$reportNull$$$0(1);
        }
        if (minSdk == null) {
            MergedManifestSnapshot.$$$reportNull$$$0(2);
        }
        if (targetSdk == null) {
            MergedManifestSnapshot.$$$reportNull$$$0(3);
        }
        if (permissions == null) {
            MergedManifestSnapshot.$$$reportNull$$$0(4);
        }
        if (activities == null) {
            MergedManifestSnapshot.$$$reportNull$$$0(5);
        }
        if (activityAliases == null) {
            MergedManifestSnapshot.$$$reportNull$$$0(6);
        }
        if (services == null) {
            MergedManifestSnapshot.$$$reportNull$$$0(7);
        }
        if (loggingRecords == null) {
            MergedManifestSnapshot.$$$reportNull$$$0(8);
        }
        this.myCreationTimeMs = Clock.getTime();
        this.myModule = module2;
        this.myPackageName = packageName;
        this.myApplicationId = applicationId2;
        this.myVersionCode = versionCode2;
        this.myManifestTheme = manifestTheme;
        this.myAttributes = activityAttributes;
        this.myMergedManifestInfo = mergedManifestInfo;
        this.myMinSdk = minSdk;
        this.myTargetSdk = targetSdk;
        this.myAppIcon = appIcon;
        this.myAppLabel = appLabel;
        this.mySupportsRtl = supportsRtl;
        this.myIsDebuggable = isDebuggable;
        this.myDocument = document;
        this.myFiles = manifestFiles != null ? manifestFiles : ImmutableList.of();
        this.myPermissions = permissions;
        this.myAppHasCode = appHasCode;
        this.myActivities = activities;
        this.myActivityAliases = activityAliases;
        this.myServices = services;
        this.myLoggingRecords = loggingRecords;
        this.myActions = actions2;
        this.myIsValid = isValid2;
        if (actions2 != null) {
            ImmutableMap.Builder nodeKeysBuilder = ImmutableMap.builder();
            Set keys = this.myActions.getNodeKeys();
            for (XmlNode.NodeKey key : keys) {
                nodeKeysBuilder.put((Object)key.toString(), (Object)key);
            }
            this.myNodeKeys = nodeKeysBuilder.build();
        } else {
            this.myNodeKeys = ImmutableMap.of();
        }
    }

    public boolean isValid() {
        return this.myIsValid;
    }

    long getCreationTimestamp() {
        return this.myCreationTimeMs;
    }

    @Nullable
    MergedManifestInfo getMergedManifestInfo() {
        return this.myMergedManifestInfo;
    }

    @Nullable
    public Document getDocument() {
        return this.myDocument;
    }

    @NotNull
    public List<VirtualFile> getManifestFiles() {
        ImmutableList<VirtualFile> immutableList = this.myFiles;
        if (immutableList == null) {
            MergedManifestSnapshot.$$$reportNull$$$0(9);
        }
        return immutableList;
    }

    @Nullable
    public String getPackage() {
        return this.myPackageName;
    }

    @Nullable
    public String getApplicationId() {
        return this.myApplicationId;
    }

    @Nullable
    public Integer getVersionCode() {
        return this.myVersionCode;
    }

    @NotNull
    public Map<String, ActivityAttributesSnapshot> getActivityAttributesMap() {
        ImmutableMap<String, ActivityAttributesSnapshot> immutableMap = this.myAttributes;
        if (immutableMap == null) {
            MergedManifestSnapshot.$$$reportNull$$$0(10);
        }
        return immutableMap;
    }

    @Nullable
    public ActivityAttributesSnapshot getActivityAttributes(@NotNull String activity) {
        int index2;
        if (activity == null) {
            MergedManifestSnapshot.$$$reportNull$$$0(11);
        }
        if ((index2 = ((String)activity).indexOf(46)) <= 0 && this.myPackageName != null && !this.myPackageName.isEmpty()) {
            activity = this.myPackageName + (index2 == -1 ? "." : "") + (String)activity;
        }
        return this.getActivityAttributesMap().get(activity);
    }

    @Nullable
    public String getManifestTheme() {
        return this.myManifestTheme;
    }

    @NotNull
    public String getDefaultTheme(@Nullable IAndroidTarget renderingTarget, @Nullable ScreenSize screenSize, @Nullable Device device) {
        if (this.myManifestTheme != null) {
            String string = this.myManifestTheme;
            if (string == null) {
                MergedManifestSnapshot.$$$reportNull$$$0(12);
            }
            return string;
        }
        String string = ThemeUtils.getDefaultTheme(this.myModule, renderingTarget, screenSize, device);
        if (string == null) {
            MergedManifestSnapshot.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Nullable
    public ResourceValue getApplicationIcon() {
        return this.myAppIcon;
    }

    @Nullable
    public ResourceValue getApplicationLabel() {
        return this.myAppLabel;
    }

    public boolean isRtlSupported() {
        return this.mySupportsRtl;
    }

    @Nullable
    public Boolean getApplicationDebuggable() {
        return this.myIsDebuggable;
    }

    public boolean getApplicationHasCode() {
        return this.myAppHasCode;
    }

    @NotNull
    public AndroidVersion getTargetSdkVersion() {
        AndroidVersion androidVersion = this.myTargetSdk;
        if (androidVersion == null) {
            MergedManifestSnapshot.$$$reportNull$$$0(14);
        }
        return androidVersion;
    }

    @NotNull
    public AndroidVersion getMinSdkVersion() {
        AndroidVersion androidVersion = this.myMinSdk;
        if (androidVersion == null) {
            MergedManifestSnapshot.$$$reportNull$$$0(15);
        }
        return androidVersion;
    }

    @NotNull
    public ImmutablePermissionHolder getPermissionHolder() {
        ImmutablePermissionHolder immutablePermissionHolder = this.myPermissions;
        if (immutablePermissionHolder == null) {
            MergedManifestSnapshot.$$$reportNull$$$0(16);
        }
        return immutablePermissionHolder;
    }

    @NotNull
    public List<Element> getActivities() {
        ImmutableList<Element> immutableList = this.myActivities;
        if (immutableList == null) {
            MergedManifestSnapshot.$$$reportNull$$$0(17);
        }
        return immutableList;
    }

    @NotNull
    public List<Element> getActivityAliases() {
        ImmutableList<Element> immutableList = this.myActivityAliases;
        if (immutableList == null) {
            MergedManifestSnapshot.$$$reportNull$$$0(18);
        }
        return immutableList;
    }

    @NotNull
    public List<Element> getServices() {
        ImmutableList<Element> immutableList = this.myServices;
        if (immutableList == null) {
            MergedManifestSnapshot.$$$reportNull$$$0(19);
        }
        return immutableList;
    }

    @Nullable
    public Element findUsedFeature(@NotNull String name) {
        if (name == null) {
            MergedManifestSnapshot.$$$reportNull$$$0(20);
        }
        if (this.myDocument == null) {
            return null;
        }
        for (Node node2 = this.myDocument.getDocumentElement().getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Element element2;
            if (node2.getNodeType() != 1 || !"uses-feature".equals(node2.getNodeName()) || !name.equals((element2 = (Element)node2).getAttributeNS("http://schemas.android.com/apk/res/android", "name"))) continue;
            return element2;
        }
        return null;
    }

    @NotNull
    public ImmutableList<MergingReport.Record> getLoggingRecords() {
        ImmutableList<MergingReport.Record> immutableList = this.myMergedManifestInfo != null ? this.myMergedManifestInfo.getLoggingRecords() : ImmutableList.of();
        if (immutableList == null) {
            MergedManifestSnapshot.$$$reportNull$$$0(21);
        }
        return immutableList;
    }

    @Nullable
    public Actions getActions() {
        return this.myActions;
    }

    @Nullable
    public XmlNode.NodeKey getNodeKey(String name) {
        return (XmlNode.NodeKey)this.myNodeKeys.get((Object)name);
    }

    @Nullable
    public Element findActivity(@Nullable String qualifiedName) {
        if (qualifiedName == null || this.myActivities == null) {
            return null;
        }
        return MergedManifestSnapshot.getActivityOrAliasByName(qualifiedName, this.myActivities);
    }

    @Nullable
    public Element findActivityAlias(@Nullable String qualifiedName) {
        if (qualifiedName == null || this.myActivityAliases == null) {
            return null;
        }
        return MergedManifestSnapshot.getActivityOrAliasByName(qualifiedName, this.myActivityAliases);
    }

    @Nullable
    private static Element getActivityOrAliasByName(@NotNull String qualifiedName, @NotNull List<Element> activityOrAliasElements) {
        if (qualifiedName == null) {
            MergedManifestSnapshot.$$$reportNull$$$0(22);
        }
        if (activityOrAliasElements == null) {
            MergedManifestSnapshot.$$$reportNull$$$0(23);
        }
        for (Element activity : activityOrAliasElements) {
            if (!qualifiedName.equals(ActivityLocatorUtils.getQualifiedName(activity))) continue;
            return activity;
        }
        return null;
    }

    @NotNull
    public Module getModule() {
        Module module2 = this.myModule;
        if (module2 == null) {
            MergedManifestSnapshot.$$$reportNull$$$0(24);
        }
        return module2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activityAttributes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minSdk";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetSdk";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "permissions";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activities";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activityAliases";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "services";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loggingRecords";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/model/MergedManifestSnapshot";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activity";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activityOrAliasElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/model/MergedManifestSnapshot";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getManifestFiles";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getActivityAttributesMap";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultTheme";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetSdkVersion";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getMinSdkVersion";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPermissionHolder";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getActivities";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getActivityAliases";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getServices";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoggingRecords";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 24: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getActivityAttributes";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findUsedFeature";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getActivityOrAliasByName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

