/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.model;

import com.android.annotations.concurrency.Slow;
import com.android.manifmerger.Actions;
import com.android.manifmerger.ManifestMerger2;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.XmlDocument;
import com.android.tools.idea.model.MergedManifestException;
import com.android.tools.idea.model.MergedManifestManager;
import com.android.tools.idea.model.MergedManifestSnapshot;
import com.android.tools.idea.project.SyncTimestampUtil;
import com.android.tools.idea.projectsystem.ManifestOverrides;
import com.android.tools.idea.projectsystem.MergedManifestContributors;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.SourceProvidersKt;
import com.android.utils.ILogger;
import com.android.utils.NullLogger;
import com.android.utils.Pair;
import com.android.utils.XmlUtils;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import gnu.trove.TObjectLongHashMap;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.input.CharSequenceInputStream;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Node;

final class MergedManifestInfo {
    private static final Logger LOG = Logger.getInstance(MergedManifestInfo.class);
    @NotNull
    private final AndroidFacet myFacet;
    @Nullable
    private final org.w3c.dom.Document myDomDocument;
    @NotNull
    private final ModificationStamps myModificationStamps;
    private final long mySyncTimestamp;
    @Nullable
    private final ImmutableList<MergingReport.Record> myLoggingRecords;
    @Nullable
    private final Actions myActions;

    /*
     * WARNING - void declaration
     */
    private MergedManifestInfo(@NotNull AndroidFacet facet2, @Nullable org.w3c.dom.Document domDocument, @NotNull ModificationStamps modificationStamps, long syncTimestamp, @Nullable ImmutableList<MergingReport.Record> loggingRecords, @Nullable Actions actions2) {
        void actions3;
        if (facet2 == null) {
            MergedManifestInfo.$$$reportNull$$$0(0);
        }
        if (modificationStamps == null) {
            MergedManifestInfo.$$$reportNull$$$0(1);
        }
        this.myFacet = facet2;
        this.myDomDocument = domDocument;
        this.myModificationStamps = modificationStamps;
        this.mySyncTimestamp = syncTimestamp;
        this.myLoggingRecords = loggingRecords;
        this.myActions = actions3;
    }

    @Slow
    @NotNull
    public static MergedManifestInfo create(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            MergedManifestInfo.$$$reportNull$$$0(2);
        }
        Project project = facet2.getModule().getProject();
        long syncTimestamp = SyncTimestampUtil.getLastSyncTimestamp(project);
        MergedManifestContributors contributors = ProjectSystemUtil.getModuleSystem(facet2).getMergedManifestContributors();
        ModificationStamps modificationStamps = ModificationStamps.forFiles(project, contributors.allFiles);
        org.w3c.dom.Document document = null;
        ImmutableList<MergingReport.Record> loggingRecords = null;
        Actions actions2 = null;
        ParsedMergeResult result2 = MergedManifestInfo.mergeManifests(facet2, contributors);
        if (result2 != null) {
            document = result2.document;
            loggingRecords = result2.loggingRecords;
            actions2 = result2.actions;
        }
        return new MergedManifestInfo(facet2, document, modificationStamps, syncTimestamp, loggingRecords, actions2);
    }

    @Slow
    @Nullable
    private static ParsedMergeResult mergeManifests(@NotNull AndroidFacet facet2, @NotNull MergedManifestContributors manifests) {
        if (facet2 == null) {
            MergedManifestInfo.$$$reportNull$$$0(3);
        }
        if (manifests == null) {
            MergedManifestInfo.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Project project = facet2.getModule().getProject();
        if (project.isDisposed() || manifests.primaryManifest == null) {
            return null;
        }
        try {
            MergingReport mergingReport = MergedManifestInfo.getMergedManifest(facet2, manifests.primaryManifest, manifests.flavorAndBuildTypeManifests, manifests.libraryManifests, manifests.navigationFiles);
            XmlDocument doc = mergingReport.getMergedXmlDocument(MergingReport.MergedManifestKind.MERGED);
            if (doc != null) {
                return new ParsedMergeResult(doc.getXml(), (ImmutableList<MergingReport.Record>)mergingReport.getLoggingRecords(), mergingReport.getActions());
            }
            LOG.warn("getMergedManifestSupplier failed " + mergingReport.getReportString());
            return new ParsedMergeResult(null, (ImmutableList<MergingReport.Record>)mergingReport.getLoggingRecords(), mergingReport.getActions());
        }
        catch (ManifestMerger2.MergeFailureException e) {
            if (e.getCause() instanceof ProcessCanceledException) {
                throw (ProcessCanceledException)e.getCause();
            }
            throw new MergedManifestException.MergingError(facet2.getModule(), (Throwable)e);
        }
    }

    public boolean isUpToDate() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (Disposer.isDisposed((Disposable)this.myFacet)) {
            return true;
        }
        MergedManifestContributors manifests = ProjectSystemUtil.getModuleSystem(this.myFacet).getMergedManifestContributors();
        if (manifests.primaryManifest == null) {
            return true;
        }
        long lastSyncTimestamp = SyncTimestampUtil.getLastSyncTimestamp(this.myFacet.getModule().getProject());
        if (this.myDomDocument == null || this.mySyncTimestamp != lastSyncTimestamp) {
            return false;
        }
        return this.myModificationStamps.equals(ModificationStamps.forFiles(this.myFacet.getModule().getProject(), manifests.allFiles));
    }

    public boolean hasSevereError() {
        return this.myLoggingRecords != null && this.myLoggingRecords.stream().anyMatch(record -> record.getSeverity() == MergingReport.Record.Severity.ERROR);
    }

    @Nullable
    public org.w3c.dom.Document getXmlDocument() {
        return this.myDomDocument;
    }

    @NotNull
    public AndroidFacet getFacet() {
        AndroidFacet androidFacet = this.myFacet;
        if (androidFacet == null) {
            MergedManifestInfo.$$$reportNull$$$0(5);
        }
        return androidFacet;
    }

    @NotNull
    public ImmutableList<VirtualFile> getFiles() {
        ImmutableList<VirtualFile> immutableList = this.myModificationStamps.getFiles();
        if (immutableList == null) {
            MergedManifestInfo.$$$reportNull$$$0(6);
        }
        return immutableList;
    }

    @NotNull
    public ImmutableList<MergingReport.Record> getLoggingRecords() {
        ImmutableList<MergingReport.Record> immutableList = this.myLoggingRecords == null ? ImmutableList.of() : this.myLoggingRecords;
        if (immutableList == null) {
            MergedManifestInfo.$$$reportNull$$$0(7);
        }
        return immutableList;
    }

    @Nullable
    public Actions getActions() {
        return this.myActions;
    }

    @Slow
    @NotNull
    static MergingReport getMergedManifest(@NotNull AndroidFacet facet2, final @NotNull VirtualFile primaryManifestFile, @NotNull List<VirtualFile> flavorAndBuildTypeManifests, final @NotNull List<VirtualFile> libManifests, @NotNull List<VirtualFile> navigationFiles) throws ManifestMerger2.MergeFailureException {
        if (facet2 == null) {
            MergedManifestInfo.$$$reportNull$$$0(8);
        }
        if (primaryManifestFile == null) {
            MergedManifestInfo.$$$reportNull$$$0(9);
        }
        if (flavorAndBuildTypeManifests == null) {
            MergedManifestInfo.$$$reportNull$$$0(10);
        }
        if (libManifests == null) {
            MergedManifestInfo.$$$reportNull$$$0(11);
        }
        if (navigationFiles == null) {
            MergedManifestInfo.$$$reportNull$$$0(12);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        final File mainManifestFile = VfsUtilCore.virtualToIoFile((VirtualFile)primaryManifestFile);
        ILogger logger2 = NullLogger.getLogger();
        ManifestMerger2.MergeType mergeType = ((AndroidFacetConfiguration)facet2.getConfiguration()).isAppOrFeature() ? ManifestMerger2.MergeType.APPLICATION : ManifestMerger2.MergeType.LIBRARY;
        ManifestMerger2.Invoker manifestMergerInvoker = ManifestMerger2.newMerger((File)mainManifestFile, (ILogger)logger2, (ManifestMerger2.MergeType)mergeType);
        manifestMergerInvoker.withFeatures(new ManifestMerger2.Invoker.Feature[]{ManifestMerger2.Invoker.Feature.SKIP_BLAME, ManifestMerger2.Invoker.Feature.SKIP_XML_STRING});
        manifestMergerInvoker.addFlavorAndBuildTypeManifests(VfsUtilCore.virtualToIoFiles(flavorAndBuildTypeManifests).toArray(new File[0]));
        manifestMergerInvoker.addNavigationFiles((Iterable)VfsUtilCore.virtualToIoFiles(navigationFiles));
        ArrayList<Pair> libraryManifests = new ArrayList<Pair>();
        for (VirtualFile file2 : libManifests) {
            libraryManifests.add(Pair.of((Object)file2.getName(), (Object)VfsUtilCore.virtualToIoFile((VirtualFile)file2)));
        }
        manifestMergerInvoker.addBundleManifests(libraryManifests);
        ManifestOverrides overrides = ProjectSystemUtil.getModuleSystem(facet2.getModule()).getManifestOverrides();
        overrides.getPlaceholders().forEach((placeholder, value2) -> manifestMergerInvoker.setPlaceHolderValue(placeholder, value2));
        overrides.getDirectOverrides().forEach((property2, value2) -> manifestMergerInvoker.setOverride(property2, value2));
        if (mergeType == ManifestMerger2.MergeType.APPLICATION) {
            manifestMergerInvoker.withFeatures(new ManifestMerger2.Invoker.Feature[]{ManifestMerger2.Invoker.Feature.REMOVE_TOOLS_DECLARATIONS});
        }
        final Module module2 = facet2.getModule();
        final Project project = module2.getProject();
        final FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        manifestMergerInvoker.withFileStreamProvider(new ManifestMerger2.FileStreamProvider(){

            protected InputStream getInputStream(@NotNull File file2) throws IOException {
                MergedManifestSnapshot manifest;
                org.w3c.dom.Document document;
                Module moduleContainingManifest;
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                ProgressManager.checkCanceled();
                VirtualFile vFile = file2 == mainManifestFile ? primaryManifestFile : VfsUtil.findFileByIoFile((File)file2, (boolean)false);
                if (vFile == null) {
                    return new ByteArrayInputStream("<manifest/>".getBytes(StandardCharsets.UTF_8));
                }
                if (!libManifests.isEmpty() && (moduleContainingManifest = this.getAndroidModuleForManifest(vFile)) != null && !module2.equals(moduleContainingManifest) && (document = (manifest = MergedManifestManager.getFreshSnapshotInCallingThread(moduleContainingManifest)).getDocument()) != null) {
                    String text2 = XmlUtils.toXml((Node)document);
                    return new ByteArrayInputStream(text2.getBytes(StandardCharsets.UTF_8));
                }
                Document document2 = fileDocumentManager.getCachedDocument(vFile);
                if (document2 != null) {
                    return new CharSequenceInputStream(document2.getCharsSequence(), StandardCharsets.UTF_8);
                }
                return vFile.getInputStream();
            }

            @Nullable
            private Module getAndroidModuleForManifest(@NotNull VirtualFile vFile) {
                if (vFile == null) {
                    1.$$$reportNull$$$0(1);
                }
                for (Module m : ModuleManager.getInstance((Project)project).getModules()) {
                    AndroidFacet androidFacet = AndroidFacet.getInstance((Module)m);
                    if (androidFacet == null) continue;
                    List<VirtualFile> manifestFiles = SourceProvidersKt.getManifestFiles(androidFacet);
                    for (VirtualFile manifestFile : manifestFiles) {
                        if (!vFile.equals(manifestFile)) continue;
                        return m;
                    }
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "vFile";
                        break;
                    }
                }
                objectArray2[1] = "com/android/tools/idea/model/MergedManifestInfo$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getInputStream";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getAndroidModuleForManifest";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        MergingReport mergingReport = manifestMergerInvoker.merge();
        if (mergingReport == null) {
            MergedManifestInfo.$$$reportNull$$$0(13);
        }
        return mergingReport;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modificationStamps";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manifests";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/model/MergedManifestInfo";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "primaryManifestFile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flavorAndBuildTypeManifests";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libManifests";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigationFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/model/MergedManifestInfo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacet";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoggingRecords";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getMergedManifest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "mergeManifests";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 13: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getMergedManifest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ModificationStamps {
        @NotNull
        private final ImmutableList<VirtualFile> files;
        @NotNull
        private final TObjectLongHashMap<Object> modificationStamps;

        private ModificationStamps(@NotNull ImmutableList<VirtualFile> files2, @NotNull TObjectLongHashMap<Object> modificationStamps) {
            if (files2 == null) {
                ModificationStamps.$$$reportNull$$$0(0);
            }
            if (modificationStamps == null) {
                ModificationStamps.$$$reportNull$$$0(1);
            }
            this.files = files2;
            this.modificationStamps = modificationStamps;
        }

        @NotNull
        public static ModificationStamps forFiles(@NotNull Project project, @NotNull List<VirtualFile> files2) {
            if (project == null) {
                ModificationStamps.$$$reportNull$$$0(2);
            }
            if (files2 == null) {
                ModificationStamps.$$$reportNull$$$0(3);
            }
            ImmutableList.Builder fileListBuilder = ImmutableList.builder();
            TObjectLongHashMap modificationStamps = new TObjectLongHashMap();
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            for (VirtualFile file2 : files2) {
                fileListBuilder.add((Object)file2);
                try {
                    PsiFile psiFile2 = psiManager.findFile(file2);
                    if (psiFile2 == null) {
                        modificationStamps.put((Object)file2, file2.getModificationStamp());
                        continue;
                    }
                    modificationStamps.put((Object)psiFile2, psiFile2.getModificationStamp());
                }
                catch (ProcessCanceledException processCanceledException) {}
            }
            return new ModificationStamps((ImmutableList<VirtualFile>)fileListBuilder.build(), (TObjectLongHashMap<Object>)modificationStamps);
        }

        @NotNull
        public ImmutableList<VirtualFile> getFiles() {
            ImmutableList<VirtualFile> immutableList = this.files;
            if (immutableList == null) {
                ModificationStamps.$$$reportNull$$$0(4);
            }
            return immutableList;
        }

        public boolean equals(Object other) {
            if (!(other instanceof ModificationStamps)) {
                return false;
            }
            return this.modificationStamps.equals(((ModificationStamps)other).modificationStamps);
        }

        public int hashCode() {
            return this.modificationStamps.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modificationStamps";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/model/MergedManifestInfo$ModificationStamps";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/model/MergedManifestInfo$ModificationStamps";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFiles";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "forFiles";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ParsedMergeResult {
        @Nullable
        final org.w3c.dom.Document document;
        @NotNull
        final ImmutableList<MergingReport.Record> loggingRecords;
        @NotNull
        final Actions actions;

        ParsedMergeResult(@Nullable org.w3c.dom.Document document, @NotNull ImmutableList<MergingReport.Record> loggingRecords, @NotNull Actions actions2) {
            if (loggingRecords == null) {
                ParsedMergeResult.$$$reportNull$$$0(0);
            }
            if (actions2 == null) {
                ParsedMergeResult.$$$reportNull$$$0(1);
            }
            this.document = document;
            this.loggingRecords = loggingRecords;
            this.actions = actions2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "loggingRecords";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "actions";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/model/MergedManifestInfo$ParsedMergeResult";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

