/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.mlkit.notifications;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.mlkit.LoggingUtils;
import com.android.tools.idea.mlkit.MlUtils;
import com.android.tools.idea.mlkit.viewer.TfliteModelFileEditor;
import com.android.tools.idea.npw.template.components.ModuleTemplateComboProvider;
import com.android.tools.idea.projectsystem.NamedModuleTemplate;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.google.wireless.android.sdk.stats.MlModelBindingEvent;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.refactoring.copy.CopyFilesOrDirectoriesHandler;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.io.IOException;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InNonMlFolderNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"ml.incorrect.folder.notification.panel");
    private static final Key<String> HIDDEN_KEY = Key.create((String)"ml.incorrect.folder.notification.panel.hidden");

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            InNonMlFolderNotificationProvider.$$$reportNull$$$0(0);
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor, @NotNull Project project) {
        if (file2 == null) {
            InNonMlFolderNotificationProvider.$$$reportNull$$$0(1);
        }
        if (fileEditor == null) {
            InNonMlFolderNotificationProvider.$$$reportNull$$$0(2);
        }
        if (project == null) {
            InNonMlFolderNotificationProvider.$$$reportNull$$$0(3);
        }
        if (!((Boolean)StudioFlags.ML_MODEL_BINDING.get()).booleanValue() || fileEditor.getUserData(HIDDEN_KEY) != null || !(fileEditor instanceof TfliteModelFileEditor)) {
            return null;
        }
        Module module2 = ModuleUtilCore.findModuleForFile((VirtualFile)file2, (Project)project);
        if (module2 == null || MlUtils.isModelFileInMlModelsFolder(module2, file2)) {
            return null;
        }
        List moduleTemplateList = ContainerUtil.filter(ProjectSystemUtil.getModuleSystem(module2).getModuleTemplates(file2), template -> !template.getPaths().getMlModelsDirectories().isEmpty());
        if (moduleTemplateList.isEmpty()) {
            return null;
        }
        EditorNotificationPanel panel2 = new EditorNotificationPanel(fileEditor);
        panel2.setText("This TensorFlow Lite model is not in a configured ml-model directory, so ML Model Binding is disabled. To use ML Model Binding consider moving the file.");
        panel2.createActionLabel("Move File", () -> {
            MoveModelFileDialog moveModelFileDialog = new MoveModelFileDialog(moduleTemplateList);
            if (moveModelFileDialog.showAndGet()) {
                WriteAction.run(() -> {
                    VirtualFile mlVirtualDir = null;
                    try {
                        PsiDirectory mlPsiDir;
                        mlVirtualDir = VfsUtil.createDirectoryIfMissing((String)moveModelFileDialog.getSelectedMlDirectoryPath());
                        if (mlVirtualDir != null && !CopyFilesOrDirectoriesHandler.checkFileExist((PsiDirectory)(mlPsiDir = PsiDirectoryFactory.getInstance((Project)project).createDirectory(mlVirtualDir)), null, (PsiFile)PsiManager.getInstance((Project)project).findFile(file2), (String)file2.getName(), (String)"Move")) {
                            file2.move((Object)this, mlVirtualDir);
                            EditorNotifications.getInstance((Project)project).updateNotifications(file2);
                            LoggingUtils.logEvent(MlModelBindingEvent.EventType.MODEL_IMPORT_FROM_MOVE_FILE_BUTTON, file2);
                        }
                    }
                    catch (IOException e) {
                        Logger.getInstance(InNonMlFolderNotificationProvider.class).error(String.format("Error moving %s to %s.", file2, mlVirtualDir), (Throwable)e);
                    }
                });
            }
        });
        panel2.createActionLabel("Hide notification", () -> {
            fileEditor.putUserData(HIDDEN_KEY, (Object)"true");
            EditorNotifications.getInstance((Project)project).updateNotifications(file2);
        });
        return panel2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/mlkit/notifications/InNonMlFolderNotificationProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/mlkit/notifications/InNonMlFolderNotificationProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MoveModelFileDialog
    extends DialogWrapper {
        private final List<NamedModuleTemplate> myNamedModuleTemplateList;
        private ComboBox<NamedModuleTemplate> myComboBox;

        private MoveModelFileDialog(@NotNull List<NamedModuleTemplate> namedModuleTemplateList) {
            if (namedModuleTemplateList == null) {
                MoveModelFileDialog.$$$reportNull$$$0(0);
            }
            super(true);
            this.myNamedModuleTemplateList = namedModuleTemplateList;
            this.init();
            this.setTitle("Move TensorFlow Lite Model File");
        }

        @Nullable
        protected JComponent createCenterPanel() {
            JPanel dialogPanel = new JPanel();
            dialogPanel.setLayout(new BoxLayout(dialogPanel, 0));
            dialogPanel.setAlignmentY(0.5f);
            dialogPanel.setBorder(JBUI.Borders.empty((int)10));
            dialogPanel.add((Component)new JBLabel("Move the model file to the ml directory in "));
            this.myComboBox = new ModuleTemplateComboProvider(this.myNamedModuleTemplateList).createComponent();
            dialogPanel.add((Component)this.myComboBox);
            return dialogPanel;
        }

        @NotNull
        private String getSelectedMlDirectoryPath() {
            String string = ((NamedModuleTemplate)this.myComboBox.getSelectedItem()).getPaths().getMlModelsDirectories().get(0).getPath();
            if (string == null) {
                MoveModelFileDialog.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namedModuleTemplateList";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/mlkit/notifications/InNonMlFolderNotificationProvider$MoveModelFileDialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/mlkit/notifications/InNonMlFolderNotificationProvider$MoveModelFileDialog";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSelectedMlDirectoryPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

