/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.mlkit.lightpsi;

import com.android.tools.idea.mlkit.APIVersion;
import com.android.tools.idea.mlkit.LightModelClassConfig;
import com.android.tools.idea.mlkit.LoggingUtils;
import com.android.tools.idea.mlkit.lightpsi.CodeUtils;
import com.android.tools.idea.mlkit.lightpsi.LightModelGroupClass;
import com.android.tools.idea.mlkit.lightpsi.LightModelOutputsClass;
import com.android.tools.idea.psi.light.DeprecatableLightMethodBuilder;
import com.android.tools.idea.psi.light.NullabilityLightMethodBuilder;
import com.android.tools.mlkit.ModelInfo;
import com.android.tools.mlkit.TensorGroupInfo;
import com.android.tools.mlkit.TensorInfo;
import com.google.common.collect.ImmutableSet;
import com.google.wireless.android.sdk.stats.MlModelBindingEvent;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.android.augment.AndroidLightClassBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightModelClass
extends AndroidLightClassBase {
    @NotNull
    private final VirtualFile myModelFile;
    @NotNull
    private final LightModelClassConfig myClassConfig;
    @NotNull
    private final PsiJavaFile myContainingFile;
    @NotNull
    private final CachedValue<MyClassMembers> myCachedMembers;
    @NotNull
    private final APIVersion myAPIVersion;
    @NotNull
    private PsiMethod[] myConstructors;
    private boolean myGenerateFallbackApiOnly;

    public LightModelClass(@NotNull Module module2, @NotNull VirtualFile modelFile, @NotNull LightModelClassConfig classConfig) {
        if (module2 == null) {
            LightModelClass.$$$reportNull$$$0(0);
        }
        if (modelFile == null) {
            LightModelClass.$$$reportNull$$$0(1);
        }
        if (classConfig == null) {
            LightModelClass.$$$reportNull$$$0(2);
        }
        super(PsiManager.getInstance((Project)module2.getProject()), (Collection<String>)ImmutableSet.of((Object)"public", (Object)"final"));
        this.myModelFile = modelFile;
        this.myClassConfig = classConfig;
        this.myAPIVersion = APIVersion.fromProject(module2.getProject());
        this.myGenerateFallbackApiOnly = this.myAPIVersion.generateFallbackApiOnly(this.getModelInfo().getMinParserVersion());
        this.myContainingFile = (PsiJavaFile)PsiFileFactory.getInstance((Project)module2.getProject()).createFileFromText(this.myClassConfig.myClassName + ".java", (FileType)JavaFileType.INSTANCE, (CharSequence)"// This class is generated on-the-fly by the IDE.");
        this.myContainingFile.setPackageName(classConfig.myPackageName);
        this.setModuleInfo(module2, false);
        this.myCachedMembers = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(() -> {
            ModelInfo modelInfo = this.getModelInfo();
            ArrayList<PsiMethod> methods2 = new ArrayList<PsiMethod>();
            HashMap<String, Object> innerClassMap = new HashMap<String, Object>();
            if (this.myAPIVersion.isAtLeastVersion(APIVersion.API_VERSION_1)) {
                methods2.add(this.buildProcessMethod(modelInfo.getInputs(), false));
                if (!this.myGenerateFallbackApiOnly && modelInfo.getInputs().stream().anyMatch(tensorInfo -> tensorInfo.isRGBImage())) {
                    methods2.add(this.buildProcessMethod(modelInfo.getInputs(), true));
                }
                methods2.add(this.buildCloseMethod());
                methods2.addAll(this.buildNewInstanceStaticMethods());
                LightModelOutputsClass mlkitOutputClass = new LightModelOutputsClass(module2, modelInfo, this);
                innerClassMap.putIfAbsent(mlkitOutputClass.getName(), (Object)mlkitOutputClass);
            }
            if (this.myAPIVersion.isAtLeastVersion(APIVersion.API_VERSION_2)) {
                for (TensorGroupInfo tensorGroupInfo : modelInfo.getOutputTensorGroups()) {
                    LightModelGroupClass mlkitGroupClass = new LightModelGroupClass(module2, modelInfo.getOutputs(), tensorGroupInfo, this);
                    innerClassMap.putIfAbsent(mlkitGroupClass.getName(), (Object)mlkitGroupClass);
                }
            }
            MyClassMembers data = new MyClassMembers(methods2.toArray(PsiMethod.EMPTY_ARRAY), innerClassMap.values().toArray(PsiClass.EMPTY_ARRAY));
            return CachedValueProvider.Result.create((Object)data, (Object[])new Object[]{ModificationTracker.NEVER_CHANGED});
        }, false);
        LoggingUtils.logEvent(MlModelBindingEvent.EventType.MODEL_API_GEN, this.getModelInfo());
    }

    @NotNull
    private List<PsiMethod> buildNewInstanceStaticMethods() {
        ArrayList<PsiMethod> methods2 = new ArrayList<PsiMethod>();
        PsiClassType thisType = PsiType.getTypeByName((String)this.getQualifiedName(), (Project)this.getProject(), (GlobalSearchScope)this.getResolveScope());
        PsiClassType context = PsiType.getTypeByName((String)"android.content.Context", (Project)this.getProject(), (GlobalSearchScope)this.getResolveScope());
        PsiClassType options2 = PsiType.getTypeByName((String)"org.tensorflow.lite.support.model.Model.Options", (Project)this.getProject(), (GlobalSearchScope)this.getResolveScope());
        LightMethodBuilder method2 = new NullabilityLightMethodBuilder(this.getManager(), "newInstance").setMethodReturnType((PsiType)thisType, true).addNullabilityParameter("context", (PsiType)context, true).addException("java.io.IOException").addModifiers(new String[]{"public", "final", "static"}).setContainingClass((PsiClass)this);
        method2.setNavigationElement((PsiElement)this);
        methods2.add((PsiMethod)method2);
        LightMethodBuilder methodWithOptions = new NullabilityLightMethodBuilder(this.getManager(), "newInstance").setMethodReturnType((PsiType)thisType, true).addNullabilityParameter("context", (PsiType)context, true).addNullabilityParameter("options", (PsiType)options2, true).addException("java.io.IOException").addModifiers(new String[]{"public", "final", "static"}).setContainingClass((PsiClass)this);
        methodWithOptions.setNavigationElement((PsiElement)this);
        methods2.add((PsiMethod)methodWithOptions);
        ArrayList<PsiMethod> arrayList = methods2;
        if (arrayList == null) {
            LightModelClass.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    private PsiMethod buildCloseMethod() {
        LightMethodBuilder closeMethod = new NullabilityLightMethodBuilder(this.getManager(), "close").addModifier("public").setMethodReturnType((PsiType)PsiType.VOID).setContainingClass((PsiClass)this);
        closeMethod.setNavigationElement((PsiElement)this);
        LightMethodBuilder lightMethodBuilder = closeMethod;
        if (lightMethodBuilder == null) {
            LightModelClass.$$$reportNull$$$0(4);
        }
        return lightMethodBuilder;
    }

    public String getName() {
        return this.myClassConfig.myClassName;
    }

    @NotNull
    public String getQualifiedName() {
        String string = this.myClassConfig.myPackageName + "." + this.getName();
        if (string == null) {
            LightModelClass.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public PsiClass getContainingClass() {
        return null;
    }

    @Override
    @NotNull
    public PsiFile getContainingFile() {
        PsiJavaFile psiJavaFile = this.myContainingFile;
        if (psiJavaFile == null) {
            LightModelClass.$$$reportNull$$$0(6);
        }
        return psiJavaFile;
    }

    public boolean isValid() {
        return true;
    }

    @Override
    @NotNull
    public PsiMethod[] getMethods() {
        if (((MyClassMembers)this.myCachedMembers.getValue()).myMethods == null) {
            LightModelClass.$$$reportNull$$$0(7);
        }
        return ((MyClassMembers)this.myCachedMembers.getValue()).myMethods;
    }

    @Override
    @NotNull
    public PsiMethod[] getConstructors() {
        if (this.myConstructors == null) {
            PsiClassType contextType = PsiType.getTypeByName((String)"android.content.Context", (Project)this.getProject(), (GlobalSearchScope)this.getResolveScope());
            this.myConstructors = new PsiMethod[]{new NullabilityLightMethodBuilder((PsiClass)this, (Language)JavaLanguage.INSTANCE).addNullabilityParameter("context", (PsiType)contextType, true).setConstructor(true).addException("java.io.IOException").addModifier("private")};
        }
        if (this.myConstructors == null) {
            LightModelClass.$$$reportNull$$$0(8);
        }
        return this.myConstructors;
    }

    @NotNull
    private PsiMethod buildProcessMethod(@NotNull List<TensorInfo> tensorInfos, boolean usedForFallback) {
        if (tensorInfos == null) {
            LightModelClass.$$$reportNull$$$0(9);
        }
        GlobalSearchScope scope2 = this.getResolveScope();
        String outputClassName = String.join((CharSequence)".", this.myClassConfig.myPackageName, this.myClassConfig.myClassName, "Outputs");
        PsiClassType outputType = PsiType.getTypeByName((String)outputClassName, (Project)this.getProject(), (GlobalSearchScope)scope2);
        DeprecatableLightMethodBuilder method2 = new DeprecatableLightMethodBuilder(this.getManager(), (Language)JavaLanguage.INSTANCE, "process");
        method2.setMethodReturnType((PsiType)outputType, true).addModifiers(new String[]{"public", "final"}).setContainingClass((PsiClass)this);
        method2.setDeprecated(usedForFallback);
        for (TensorInfo tensorInfo : tensorInfos) {
            PsiClassType tensorType = usedForFallback ? PsiType.getTypeByName((String)"org.tensorflow.lite.support.tensorbuffer.TensorBuffer", (Project)this.getProject(), (GlobalSearchScope)scope2) : CodeUtils.getPsiClassType(tensorInfo, this.getProject(), scope2, this.myGenerateFallbackApiOnly);
            method2.addNullabilityParameter(tensorInfo.getIdentifierName(), (PsiType)tensorType, true);
        }
        method2.setNavigationElement((PsiElement)this);
        DeprecatableLightMethodBuilder deprecatableLightMethodBuilder = method2;
        if (deprecatableLightMethodBuilder == null) {
            LightModelClass.$$$reportNull$$$0(10);
        }
        return deprecatableLightMethodBuilder;
    }

    @Override
    @NotNull
    public PsiClass[] getInnerClasses() {
        if (((MyClassMembers)this.myCachedMembers.getValue()).myInnerClasses == null) {
            LightModelClass.$$$reportNull$$$0(11);
        }
        return ((MyClassMembers)this.myCachedMembers.getValue()).myInnerClasses;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiFile psiFile2 = PsiManager.getInstance((Project)this.getProject()).findFile(this.myModelFile);
        Object object = psiFile2 != null ? psiFile2 : super.getNavigationElement();
        if (object == null) {
            LightModelClass.$$$reportNull$$$0(12);
        }
        return object;
    }

    @NotNull
    public VirtualFile getModelFile() {
        VirtualFile virtualFile = this.myModelFile;
        if (virtualFile == null) {
            LightModelClass.$$$reportNull$$$0(13);
        }
        return virtualFile;
    }

    @NotNull
    public ModelInfo getModelInfo() {
        ModelInfo modelInfo = this.myClassConfig.myModelMetadata.myModelInfo;
        if (modelInfo == null) {
            LightModelClass.$$$reportNull$$$0(14);
        }
        return modelInfo;
    }

    public boolean equals(@Nullable Object o) {
        return o instanceof LightModelClass && this.myClassConfig.myModelMetadata.equals(((LightModelClass)((Object)o)).myClassConfig.myModelMetadata);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classConfig";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/mlkit/lightpsi/LightModelClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tensorInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/mlkit/lightpsi/LightModelClass";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildNewInstanceStaticMethods";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildCloseMethod";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethods";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructors";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "buildProcessMethod";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInnerClasses";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelFile";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "buildProcessMethod";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyClassMembers {
        public final PsiMethod[] myMethods;
        public final PsiClass[] myInnerClasses;

        private MyClassMembers(PsiMethod[] methods2, PsiClass[] innerClass) {
            this.myMethods = methods2;
            this.myInnerClasses = innerClass;
        }
    }
}

