/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.mlkit.importmodel;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.mlkit.importmodel.ChooseMlModelStep;
import com.android.tools.idea.mlkit.importmodel.MlWizardModel;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.projectsystem.NamedModuleTemplate;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.ui.wizard.StudioWizardDialogBuilder;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import icons.StudioIcons;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class ImportMlModelAction
extends AnAction {
    @VisibleForTesting
    static final String MIN_AGP_VERSION = "4.1.0-alpha04";
    @VisibleForTesting
    static final String TITLE = "TensorFlow Lite Model";
    @VisibleForTesting
    static final int MIN_SDK_VERSION = 19;

    public ImportMlModelAction() {
        super(TITLE, null, StudioIcons.Shell.Filetree.ANDROID_FILE);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ImportMlModelAction.$$$reportNull$$$0(0);
        }
        Module module2 = (Module)LangDataKeys.MODULE.getData(e.getDataContext());
        List<NamedModuleTemplate> moduleTemplates = ImportMlModelAction.getModuleTemplates(e);
        if (!moduleTemplates.isEmpty() && module2 != null && e.getProject() != null) {
            String title = "Import TensorFlow Lite model";
            ModelWizard wizard = new ModelWizard.Builder(new ModelWizardStep[0]).addStep(new ChooseMlModelStep(new MlWizardModel(module2), moduleTemplates, e.getProject(), title)).build();
            new StudioWizardDialogBuilder(wizard, title).build().show();
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ImportMlModelAction.$$$reportNull$$$0(1);
        }
        Presentation presentation = e.getPresentation();
        Project project = e.getProject();
        if (project == null) {
            presentation.setEnabled(false);
            return;
        }
        Module module2 = (Module)LangDataKeys.MODULE.getData(e.getDataContext());
        if (module2 == null) {
            presentation.setEnabled(false);
            return;
        }
        AndroidPluginInfo androidPluginInfo = AndroidPluginInfo.findFromModel(project);
        if (androidPluginInfo == null) {
            presentation.setEnabled(false);
            return;
        }
        GradleVersion agpVersion = androidPluginInfo.getPluginVersion();
        if (agpVersion == null || agpVersion.compareTo(MIN_AGP_VERSION) < 0) {
            presentation.setEnabled(false);
            presentation.setText(AndroidBundle.message("android.wizard.action.requires.new.agp", TITLE, MIN_AGP_VERSION));
            return;
        }
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)module2);
        if (androidFacet == null) {
            presentation.setEnabled(false);
            return;
        }
        if (AndroidModuleInfo.getInstance(androidFacet).getMinSdkVersion().getFeatureLevel() < 19) {
            presentation.setEnabled(false);
            presentation.setText(AndroidBundle.message("android.wizard.action.requires.minsdk", TITLE, 19));
            return;
        }
        if (ImportMlModelAction.getModuleTemplates(e).isEmpty()) {
            presentation.setEnabled(false);
        }
        presentation.setEnabledAndVisible(true);
    }

    @NotNull
    private static List<NamedModuleTemplate> getModuleTemplates(@NotNull AnActionEvent e) {
        if (e == null) {
            ImportMlModelAction.$$$reportNull$$$0(2);
        }
        if (e.getProject() == null) {
            List<NamedModuleTemplate> list = Collections.emptyList();
            if (list == null) {
                ImportMlModelAction.$$$reportNull$$$0(3);
            }
            return list;
        }
        Module module2 = (Module)LangDataKeys.MODULE.getData(e.getDataContext());
        VirtualFile virtualFile = e.getProject().getProjectFile();
        if (module2 == null || virtualFile == null) {
            List<NamedModuleTemplate> list = Collections.emptyList();
            if (list == null) {
                ImportMlModelAction.$$$reportNull$$$0(4);
            }
            return list;
        }
        List<NamedModuleTemplate> list = ProjectSystemUtil.getModuleSystem(module2).getModuleTemplates(virtualFile);
        if (list == null) {
            ImportMlModelAction.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/mlkit/importmodel/ImportMlModelAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/mlkit/importmodel/ImportMlModelAction";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleTemplates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getModuleTemplates";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

