/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.mlkit;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.mlkit.MlModelFileIndex;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemSyncUtil;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class ProjectMlModelFileTracker
extends SimpleModificationTracker {
    @Nullable
    private GradleVersion myGradleVersion;

    public ProjectMlModelFileTracker(final @NotNull Project project) {
        if (project == null) {
            ProjectMlModelFileTracker.$$$reportNull$$$0(0);
        }
        this.myGradleVersion = ProjectMlModelFileTracker.getGradleVersionFromProject(project);
        project.getMessageBus().connect((Disposable)project).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                boolean hasModelFile = false;
                boolean needRebuildIndex = false;
                for (VFileEvent vFileEvent : events) {
                    VirtualFile file2 = vFileEvent.getFile();
                    if (file2 == null || !"tflite".equalsIgnoreCase(file2.getExtension())) continue;
                    hasModelFile = true;
                    if (!(vFileEvent instanceof VFileContentChangeEvent)) continue;
                    needRebuildIndex = true;
                    break;
                }
                if (hasModelFile) {
                    ProjectMlModelFileTracker.this.incModificationCount();
                }
                if (needRebuildIndex) {
                    FileBasedIndex.getInstance().requestRebuild(MlModelFileIndex.INDEX_ID);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/android/tools/idea/mlkit/ProjectMlModelFileTracker$1", "after"));
            }
        });
        project.getMessageBus().connect((Disposable)project).subscribe(ProjectSystemSyncUtil.PROJECT_SYSTEM_SYNC_TOPIC, (Object)new ProjectSystemSyncManager.SyncResultListener(){

            @Override
            public void syncEnded(@NotNull ProjectSystemSyncManager.SyncResult result2) {
                GradleVersion gradleVersion2;
                if (result2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (result2.isSuccessful() && !Objects.equals(ProjectMlModelFileTracker.this.myGradleVersion, gradleVersion2 = ProjectMlModelFileTracker.getGradleVersionFromProject(project))) {
                    Logger.getInstance(ProjectMlModelFileTracker.class).info("AGP version changed, refresh all light classes cache.");
                    ProjectMlModelFileTracker.this.myGradleVersion = gradleVersion2;
                    ProjectMlModelFileTracker.this.incModificationCount();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/mlkit/ProjectMlModelFileTracker$2", "syncEnded"));
            }
        });
    }

    @Nullable
    private static GradleVersion getGradleVersionFromProject(@NotNull Project project) {
        AndroidPluginInfo androidPluginInfo;
        if (project == null) {
            ProjectMlModelFileTracker.$$$reportNull$$$0(1);
        }
        if ((androidPluginInfo = AndroidPluginInfo.findFromModel(project)) != null) {
            return androidPluginInfo.getPluginVersion();
        }
        return null;
    }

    @NotNull
    public static ProjectMlModelFileTracker getInstance(@NotNull Project project) {
        if (project == null) {
            ProjectMlModelFileTracker.$$$reportNull$$$0(2);
        }
        ProjectMlModelFileTracker projectMlModelFileTracker = (ProjectMlModelFileTracker)((Object)project.getService(ProjectMlModelFileTracker.class));
        if (projectMlModelFileTracker == null) {
            ProjectMlModelFileTracker.$$$reportNull$$$0(3);
        }
        return projectMlModelFileTracker;
    }

    @VisibleForTesting
    void setGradleVersion(@Nullable GradleVersion gradleVersion2) {
        this.myGradleVersion = gradleVersion2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/mlkit/ProjectMlModelFileTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/mlkit/ProjectMlModelFileTracker";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getGradleVersionFromProject";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

