/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.mlkit;

import com.android.tools.idea.mlkit.LightModelClassConfig;
import com.android.tools.idea.mlkit.MlModelFileIndex;
import com.android.tools.idea.mlkit.MlModelFilesSearchScope;
import com.android.tools.idea.mlkit.MlModelMetadata;
import com.android.tools.idea.mlkit.MlUtils;
import com.android.tools.idea.mlkit.ProjectMlModelFileTracker;
import com.android.tools.idea.mlkit.lightpsi.LightModelClass;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.google.common.base.Strings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MlModuleService {
    private final Module myModule;
    private final Map<MlModelMetadata, LightModelClass> myLightModelClassMap;

    public static MlModuleService getInstance(@NotNull Module module2) {
        if (module2 == null) {
            MlModuleService.$$$reportNull$$$0(0);
        }
        return Objects.requireNonNull((MlModuleService)module2.getService(MlModuleService.class));
    }

    public MlModuleService(@NotNull Module module2) {
        if (module2 == null) {
            MlModuleService.$$$reportNull$$$0(1);
        }
        this.myLightModelClassMap = new ConcurrentHashMap<MlModelMetadata, LightModelClass>();
        this.myModule = module2;
    }

    @NotNull
    public List<LightModelClass> getLightModelClassList() {
        if (!MlUtils.isMlModelBindingBuildFeatureEnabled(this.myModule) || DumbService.isDumb((Project)this.myModule.getProject())) {
            List<LightModelClass> list = Collections.emptyList();
            if (list == null) {
                MlModuleService.$$$reportNull$$$0(2);
            }
            return list;
        }
        List list = (List)CachedValuesManager.getManager((Project)this.myModule.getProject()).getCachedValue((UserDataHolder)this.myModule, () -> {
            HashSet latestModelMetadataSet = new HashSet();
            GlobalSearchScope searchScope = MlModelFilesSearchScope.inModule(this.myModule);
            FileBasedIndex index2 = FileBasedIndex.getInstance();
            for (Object key : index2.getAllKeys(MlModelFileIndex.INDEX_ID, this.myModule.getProject())) {
                index2.processValues(MlModelFileIndex.INDEX_ID, key, null, (file2, value2) -> {
                    latestModelMetadataSet.add(value2);
                    return true;
                }, searchScope);
            }
            List outdatedModelMetadataList = ContainerUtil.filter(this.myLightModelClassMap.keySet(), modelMetadata -> !latestModelMetadataSet.contains(modelMetadata));
            for (MlModelMetadata outdatedModelMetadata : outdatedModelMetadataList) {
                this.myLightModelClassMap.remove(outdatedModelMetadata);
            }
            ArrayList<LightModelClass> lightModelClassList = new ArrayList<LightModelClass>();
            for (MlModelMetadata modelMetadata2 : latestModelMetadataSet) {
                LightModelClass lightModelClass = this.getOrCreateLightModelClass(modelMetadata2);
                if (lightModelClass == null) continue;
                lightModelClassList.add(lightModelClass);
            }
            return CachedValueProvider.Result.create(lightModelClassList, (Object[])new Object[]{ProjectMlModelFileTracker.getInstance(this.myModule.getProject())});
        });
        if (list == null) {
            MlModuleService.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    private LightModelClass getOrCreateLightModelClass(@NotNull MlModelMetadata modelMetadata) {
        if (modelMetadata == null) {
            MlModuleService.$$$reportNull$$$0(4);
        }
        return this.myLightModelClassMap.computeIfAbsent(modelMetadata, key -> {
            String packageName = ProjectSystemUtil.getModuleSystem(this.myModule).getPackageName();
            if (packageName == null) {
                Logger.getInstance(MlModuleService.class).warn("Can not determine the package name for module: " + this.myModule.getName());
                return null;
            }
            String modelFileUrl = modelMetadata.myModelFileUrl;
            VirtualFile modelFile = VirtualFileManager.getInstance().findFileByUrl(modelFileUrl);
            if (modelFile == null) {
                Logger.getInstance(MlModuleService.class).warn("Failed to find the virtual file for: " + modelFileUrl);
                return null;
            }
            String className2 = MlUtils.computeModelClassName(this.myModule, modelFile);
            if (Strings.isNullOrEmpty((String)className2)) {
                Logger.getInstance(MlModuleService.class).warn("Can not determine the class name for: " + modelFileUrl);
                return null;
            }
            LightModelClassConfig classConfig = new LightModelClassConfig(modelMetadata, packageName + ".ml", className2);
            return new LightModelClass(this.myModule, modelFile, classConfig);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/mlkit/MlModuleService";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelMetadata";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/mlkit/MlModuleService";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLightModelClassList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateLightModelClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

