/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.mlkit;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.text.SemVer;
import org.jetbrains.annotations.NotNull;

public class APIVersion
implements Comparable<APIVersion> {
    @NotNull
    public static final APIVersion API_VERSION_1 = new APIVersion(SemVer.parseFromText((String)"1.0.0"), GradleVersion.parse((String)"4.1.0"));
    @NotNull
    public static final APIVersion API_VERSION_2 = new APIVersion(SemVer.parseFromText((String)"1.2.0"), GradleVersion.parse((String)"4.2.0-alpha8"));
    @NotNull
    private final SemVer myModelParserVersion;
    @NotNull
    private final GradleVersion myGradleVersion;

    @NotNull
    public static APIVersion fromProject(@NotNull Project project) {
        AndroidPluginInfo androidPluginInfo;
        if (project == null) {
            APIVersion.$$$reportNull$$$0(0);
        }
        if ((androidPluginInfo = AndroidPluginInfo.findFromModel(project)) == null) {
            Logger.getInstance(APIVersion.class).warn("AndroidPluginInfo is null in project: " + project);
            APIVersion aPIVersion = API_VERSION_1;
            if (aPIVersion == null) {
                APIVersion.$$$reportNull$$$0(1);
            }
            return aPIVersion;
        }
        GradleVersion gradleVersion2 = androidPluginInfo.getPluginVersion();
        if (gradleVersion2 == null) {
            Logger.getInstance(APIVersion.class).warn("GradleVersion is null in project: " + project);
            APIVersion aPIVersion = API_VERSION_1;
            if (aPIVersion == null) {
                APIVersion.$$$reportNull$$$0(2);
            }
            return aPIVersion;
        }
        if (gradleVersion2.compareTo(APIVersion.API_VERSION_2.myGradleVersion) >= 0) {
            APIVersion aPIVersion = API_VERSION_2;
            if (aPIVersion == null) {
                APIVersion.$$$reportNull$$$0(3);
            }
            return aPIVersion;
        }
        APIVersion aPIVersion = API_VERSION_1;
        if (aPIVersion == null) {
            APIVersion.$$$reportNull$$$0(4);
        }
        return aPIVersion;
    }

    private APIVersion(@NotNull SemVer modelParserVersion, @NotNull GradleVersion gradleVersion2) {
        if (modelParserVersion == null) {
            APIVersion.$$$reportNull$$$0(5);
        }
        if (gradleVersion2 == null) {
            APIVersion.$$$reportNull$$$0(6);
        }
        this.myModelParserVersion = modelParserVersion;
        this.myGradleVersion = gradleVersion2;
    }

    public boolean isAtLeastVersion(@NotNull APIVersion apiVersion) {
        if (apiVersion == null) {
            APIVersion.$$$reportNull$$$0(7);
        }
        return this.compareTo(apiVersion) >= 0;
    }

    public boolean generateFallbackApiOnly(@NotNull String minParserVersion) {
        SemVer semVer;
        if (minParserVersion == null) {
            APIVersion.$$$reportNull$$$0(8);
        }
        if ((semVer = SemVer.parseFromText((String)minParserVersion)) == null) {
            Logger.getInstance(APIVersion.class).error("Model min parser version is null.");
            return false;
        }
        return !this.myModelParserVersion.isGreaterOrEqualThan(semVer);
    }

    @Override
    public int compareTo(@NotNull APIVersion o) {
        if (o == null) {
            APIVersion.$$$reportNull$$$0(9);
        }
        return this.myGradleVersion.compareTo(o.myGradleVersion);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/mlkit/APIVersion";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelParserVersion";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleVersion";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "apiVersion";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minParserVersion";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/mlkit/APIVersion";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "fromProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fromProject";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAtLeastVersion";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "generateFallbackApiOnly";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

