/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.material.icons.metadata;

import com.android.tools.idea.material.icons.metadata.MaterialIconsMetadata;
import com.android.tools.idea.material.icons.metadata.MaterialMetadataIcon;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J(\u0010\t\u001a\u0004\u0018\u00010\u00022\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/material/icons/metadata/MetadataDeserializer;", "Lcom/google/gson/JsonDeserializer;", "Lcom/android/tools/idea/material/icons/metadata/MaterialIconsMetadata;", "()V", "familiesKey", "", "hostKey", "iconsKey", "urlPatternKey", "deserialize", "json", "Lcom/google/gson/JsonElement;", "typeOfT", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonDeserializationContext;", "intellij.android.core"})
final class MetadataDeserializer
implements JsonDeserializer<MaterialIconsMetadata> {
    private final String hostKey;
    private final String urlPatternKey;
    private final String familiesKey;
    private final String iconsKey;

    @Nullable
    public MaterialIconsMetadata deserialize(@Nullable JsonElement json, @Nullable Type typeOfT, @Nullable JsonDeserializationContext context) {
        if (json == null || typeOfT == null || context == null) {
            return null;
        }
        JsonObject jsonObject = json.getAsJsonObject();
        JsonElement jsonElement = jsonObject.get(this.hostKey);
        Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"jsonObject[hostKey]");
        String host = jsonElement.getAsString();
        JsonElement jsonElement2 = jsonObject.get(this.urlPatternKey);
        Intrinsics.checkNotNullExpressionValue((Object)jsonElement2, (String)"jsonObject[urlPatternKey]");
        String urlPattern = jsonElement2.getAsString();
        String[] families = (String[])context.deserialize(jsonObject.get(this.familiesKey), (Type)((Object)String[].class));
        MaterialMetadataIcon[] icons = (MaterialMetadataIcon[])context.deserialize(jsonObject.get(this.iconsKey), (Type)((Object)MaterialMetadataIcon[].class));
        String string = host;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"host");
        String string2 = urlPattern;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"urlPattern");
        Intrinsics.checkNotNullExpressionValue((Object)families, (String)"families");
        Intrinsics.checkNotNullExpressionValue((Object)icons, (String)"icons");
        return new MaterialIconsMetadata(string, string2, families, icons);
    }

    public MetadataDeserializer() {
        this.hostKey = "host";
        this.urlPatternKey = "asset_url_pattern";
        this.familiesKey = "families";
        this.iconsKey = "icons";
    }
}

