/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.material.icons.download;

import com.android.annotations.concurrency.Slow;
import com.android.tools.idea.material.icons.download.MaterialIconsDownloaderKt;
import com.android.tools.idea.material.icons.metadata.MaterialIconsMetadata;
import com.android.tools.idea.material.icons.metadata.MaterialIconsMetadataBuilder;
import com.android.tools.idea.material.icons.metadata.MaterialMetadataIcon;
import com.android.tools.idea.material.icons.utils.MaterialIconsUtils;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.download.FileDownloader;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\bH\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/material/icons/download/MaterialIconsDownloader;", "", "existingMetadata", "Lcom/android/tools/idea/material/icons/metadata/MaterialIconsMetadata;", "newMetadata", "(Lcom/android/tools/idea/material/icons/metadata/MaterialIconsMetadata;Lcom/android/tools/idea/material/icons/metadata/MaterialIconsMetadata;)V", "iconsToDownload", "", "Lcom/android/tools/idea/material/icons/metadata/MaterialMetadataIcon;", "createMaterialIconFileDescription", "Lcom/intellij/util/download/DownloadableFileDescription;", "iconMetadata", "style", "", "downloadIconStyles", "", "targetDir", "Ljava/io/File;", "downloadTo", "intellij.android.core"})
public final class MaterialIconsDownloader {
    private final List<MaterialMetadataIcon> iconsToDownload;
    private final MaterialIconsMetadata existingMetadata;

    @Slow
    public final void downloadTo(@NotNull File targetDir) {
        Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
        boolean bl = targetDir.isDirectory();
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        MaterialIconsMetadataBuilder metadataBuilder = new MaterialIconsMetadataBuilder(this.existingMetadata.getHost(), this.existingMetadata.getUrlPattern(), this.existingMetadata.getFamilies());
        Object $this$forEach$iv = this.existingMetadata.getIcons();
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv;
        int n = ((MaterialMetadataIcon[])object).length;
        for (int j = 0; j < n; ++j) {
            MaterialMetadataIcon element$iv;
            MaterialMetadataIcon p1 = element$iv = object[j];
            boolean bl6 = false;
            metadataBuilder.addIconMetadata(p1);
        }
        $this$forEach$iv = this.iconsToDownload;
        $i$f$forEach = false;
        object = $this$forEach$iv.iterator();
        while (object.hasNext()) {
            Object element$iv = object.next();
            MaterialMetadataIcon iconMetadata = (MaterialMetadataIcon)element$iv;
            boolean bl7 = false;
            ProgressManager progressManager = ProgressManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"ProgressManager.getInstance()");
            ProgressIndicator progressIndicator = progressManager.getProgressIndicator();
            if (progressIndicator != null) {
                progressIndicator.checkCanceled();
            }
            try {
                this.downloadIconStyles(targetDir, iconMetadata);
                MaterialIconsDownloaderKt.access$updateSavedMetadata(targetDir, iconMetadata, metadataBuilder);
            }
            catch (Exception e) {
                MaterialIconsDownloaderKt.access$getLOG$p().warn("Error while downloading '" + iconMetadata.getName() + '\'');
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void downloadIconStyles(File targetDir, MaterialMetadataIcon iconMetadata) {
        void $this$mapTo$iv$iv;
        Object object;
        Pair style;
        Collection collection2;
        void $this$mapTo$iv$iv2;
        String[] $this$map$iv = this.existingMetadata.getFamilies();
        boolean $i$f$map = false;
        String[] stringArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void var13_16 = item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            FilesKt.resolve((File)targetDir, (String)MaterialIconsUtils.INSTANCE.toDirFormat((String)style)).mkdir();
            object = this.createMaterialIconFileDescription(iconMetadata, (String)style);
            collection2.add(object);
        }
        List fileDescriptions = (List)destination$iv$iv;
        FileDownloader fileDownloader = DownloadableFileService.getInstance().createDownloader(fileDescriptions, "Material Icons");
        Intrinsics.checkNotNullExpressionValue((Object)fileDownloader, (String)"DownloadableFileService.\u2026ptions, \"Material Icons\")");
        FileDownloader downloader = fileDownloader;
        List list = downloader.download(targetDir);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"downloader.download(targetDir)");
        Iterable $this$map$iv2 = list;
        boolean $i$f$map2 = false;
        Iterable $i$f$mapTo22 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            style = (Pair)item$iv$iv;
            collection2 = destination$iv$iv2;
            boolean bl = false;
            object = (File)it.first;
            collection2.add(object);
        }
        List downloaded = (List)destination$iv$iv2;
        List renamedFiles = MaterialIconsDownloaderKt.access$renameDownloadedFiles(downloaded);
        MaterialIconsDownloaderKt.access$cleanUpIconDirectories(renamedFiles);
    }

    private final DownloadableFileDescription createMaterialIconFileDescription(MaterialMetadataIcon iconMetadata, String style) {
        String styleDirName = MaterialIconsUtils.INSTANCE.toDirFormat(style);
        String iconName = iconMetadata.getName();
        String host = this.existingMetadata.getHost();
        String pattern = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)this.existingMetadata.getUrlPattern(), (String)"{family}", (String)styleDirName, (boolean)false, (int)4, null), (String)"{icon}", (String)iconName, (boolean)false, (int)4, null), (String)"{version}", (String)String.valueOf(iconMetadata.getVersion()), (boolean)false, (int)4, null), (String)"{asset}", (String)"24px.xml", (boolean)false, (int)4, null);
        String string = "https://%1s%2s";
        Object[] objectArray = new Object[]{host, pattern};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(this, *args)");
        String downloadUrl = string2;
        String fileName = styleDirName + File.separatorChar + iconName + File.separatorChar + MaterialIconsDownloaderKt.access$getIconFileNameWithoutExtension(iconName, styleDirName) + ".tmp";
        DownloadableFileDescription downloadableFileDescription = DownloadableFileService.getInstance().createFileDescription(downloadUrl, fileName);
        Intrinsics.checkNotNullExpressionValue((Object)downloadableFileDescription, (String)"DownloadableFileService.\u2026on(downloadUrl, fileName)");
        return downloadableFileDescription;
    }

    public MaterialIconsDownloader(@NotNull MaterialIconsMetadata existingMetadata, @NotNull MaterialIconsMetadata newMetadata) {
        Intrinsics.checkNotNullParameter((Object)existingMetadata, (String)"existingMetadata");
        Intrinsics.checkNotNullParameter((Object)newMetadata, (String)"newMetadata");
        this.existingMetadata = existingMetadata;
        this.iconsToDownload = MaterialIconsDownloaderKt.access$getIconsToDownload(this.existingMetadata, newMetadata);
    }
}

