/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ex.CheckboxAction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.FilterComponent;
import com.intellij.ui.LightColors;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.EventListener;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RegexFilterComponent
extends FilterComponent {
    private static final String REGEX = "Regex";
    @NotNull
    private final EventDispatcher<Listener> myMulticaster = EventDispatcher.create(Listener.class);
    @NotNull
    private final Compiled myCompiled = new Compiled();
    @NotNull
    private final JCheckBox myCheckBox;
    private boolean myIsRegex = true;

    public RegexFilterComponent(@NonNls String propertyName, int historySize) {
        super(propertyName, historySize, true);
        CheckboxAction regexToggle = new CheckboxAction(REGEX){

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                return RegexFilterComponent.this.isRegex();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                RegexFilterComponent.this.setIsRegex(state);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/android/tools/idea/logcat/RegexFilterComponent$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        JComponent component = regexToggle.createCustomComponent(regexToggle.getTemplatePresentation(), "unknown");
        assert (component instanceof JCheckBox);
        this.myCheckBox = (JCheckBox)component;
        this.add(this.myCheckBox, "East");
        this.myCheckBox.setSelected(this.myIsRegex);
    }

    @Nullable
    public String getParseError() {
        return this.myCompiled.error;
    }

    @NotNull
    public Component getSearchTextField() {
        JComponent jComponent = this.getPopupLocationComponent();
        if (jComponent == null) {
            RegexFilterComponent.$$$reportNull$$$0(0);
        }
        return jComponent;
    }

    @NotNull
    public Component getRegexCheckBox() {
        JCheckBox jCheckBox = this.myCheckBox;
        if (jCheckBox == null) {
            RegexFilterComponent.$$$reportNull$$$0(1);
        }
        return jCheckBox;
    }

    public boolean isRegex() {
        return this.myIsRegex;
    }

    public void setIsRegex(boolean value2) {
        this.myIsRegex = value2;
        this.myCheckBox.setSelected(this.myIsRegex);
        this.filter();
    }

    public Pattern getPattern() {
        return this.myCompiled.pattern;
    }

    public void addRegexListener(Listener listener2) {
        this.myMulticaster.addListener((EventListener)listener2);
    }

    public static Compiled compile(String filter2, boolean isRegex) {
        return new Compiled(filter2, isRegex);
    }

    public static Pattern pattern(String filter2, boolean isRegex) {
        return new Compiled((String)filter2, (boolean)isRegex).pattern;
    }

    public void filter() {
        this.myCompiled.compile(this.getFilter(), this.isRegex());
        this.getTextEditor().setBackground(this.myCompiled.error != null ? LightColors.RED : UIUtil.getTextFieldBackground());
        ((Listener)this.myMulticaster.getMulticaster()).filterChanged(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/android/tools/idea/logcat/RegexFilterComponent";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchTextField";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegexCheckBox";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static final class Compiled {
        @Nullable
        private Pattern pattern;
        private String error = null;

        public Compiled() {
        }

        public Compiled(String filter2, boolean isRegex) {
            this.compile(filter2, isRegex);
        }

        public final void compile(String filter2, boolean isRegex) {
            this.pattern = null;
            this.error = null;
            if (StringUtil.isNotEmpty((String)filter2)) {
                int flags;
                block6: {
                    flags = 2;
                    if (StringUtil.hasUpperCaseChar((String)filter2) && StringUtil.hasLowerCaseChar((String)filter2)) {
                        flags = 0;
                    }
                    if (isRegex) {
                        try {
                            this.pattern = Pattern.compile(filter2, flags);
                        }
                        catch (PatternSyntaxException e) {
                            this.error = e.getMessage();
                            if ($assertionsDisabled || this.error != null) break block6;
                            throw new AssertionError();
                        }
                    }
                }
                if (this.pattern == null) {
                    this.pattern = Pattern.compile(Pattern.quote(filter2), flags);
                }
            }
        }
    }

    public static interface Listener
    extends EventListener {
        public void filterChanged(RegexFilterComponent var1);
    }
}

