/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.Log;
import com.android.ddmlib.logcat.LogCatHeader;
import com.android.ddmlib.logcat.LogCatLongEpochMessageParser;
import com.android.ddmlib.logcat.LogCatMessage;
import com.android.tools.idea.logcat.AndroidLogcatPreferences;
import com.android.tools.idea.logcat.MessageFormatter;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LongEpochMessageFormatter
implements MessageFormatter {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendFraction(ChronoField.MILLI_OF_SECOND, 3, 3, true).toFormatter(Locale.ROOT);
    private static final Pattern DATE_TIME = Pattern.compile("\\d+-\\d\\d-\\d\\d \\d\\d:\\d\\d:\\d\\d.\\d\\d\\d");
    private static final Pattern EPOCH_TIME_HEADER_MESSAGE = Pattern.compile("^(" + LogCatLongEpochMessageParser.EPOCH_TIME + ") +(" + PROCESS_ID + ")-(" + THREAD_ID + ")/(" + PACKAGE + ") (" + PRIORITY + ")/(" + TAG + "): (" + MESSAGE + ")$");
    private static final Pattern DATE_TIME_HEADER_MESSAGE = Pattern.compile("^(" + DATE_TIME + ") +(" + PROCESS_ID + ")-(" + THREAD_ID + ")/(" + PACKAGE + ") (" + PRIORITY + ")/(" + TAG + "): (" + MESSAGE + ")$");
    private final AndroidLogcatPreferences myPreferences;
    private final ZoneId myTimeZone;

    LongEpochMessageFormatter(@NotNull AndroidLogcatPreferences preferences, @NotNull ZoneId timeZone) {
        if (preferences == null) {
            LongEpochMessageFormatter.$$$reportNull$$$0(0);
        }
        if (timeZone == null) {
            LongEpochMessageFormatter.$$$reportNull$$$0(1);
        }
        this.myPreferences = preferences;
        this.myTimeZone = timeZone;
    }

    @Override
    @NotNull
    public String format(@NotNull String format2, @NotNull LogCatHeader header, @NotNull String message2) {
        if (format2 == null) {
            LongEpochMessageFormatter.$$$reportNull$$$0(2);
        }
        if (header == null) {
            LongEpochMessageFormatter.$$$reportNull$$$0(3);
        }
        if (message2 == null) {
            LongEpochMessageFormatter.$$$reportNull$$$0(4);
        }
        Instant timestampInstant = header.getTimestampInstant();
        assert (timestampInstant != null);
        String timestampString = this.myPreferences.SHOW_AS_SECONDS_SINCE_EPOCH ? LogCatLongEpochMessageParser.EPOCH_TIME_FORMATTER.format(timestampInstant) : DATE_TIME_FORMATTER.format(LocalDateTime.ofInstant(timestampInstant, this.myTimeZone));
        String processIdThreadId = header.getPid() + "-" + header.getTid();
        Character priority = Character.valueOf(header.getLogLevel().getPriorityLetter());
        String tag = header.getTag().replace(' ', '\u00a0');
        String string = String.format(Locale.ROOT, format2, timestampString, processIdThreadId, header.getAppName(), priority, tag, message2);
        if (string == null) {
            LongEpochMessageFormatter.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @Nullable
    public LogCatMessage tryParse(@NotNull String message2) {
        Instant timestampInstant;
        Matcher matcher;
        if (message2 == null) {
            LongEpochMessageFormatter.$$$reportNull$$$0(6);
        }
        Matcher matcher2 = matcher = this.myPreferences.SHOW_AS_SECONDS_SINCE_EPOCH ? EPOCH_TIME_HEADER_MESSAGE.matcher(message2) : DATE_TIME_HEADER_MESSAGE.matcher(message2);
        if (!matcher.matches()) {
            return null;
        }
        Log.LogLevel priority = Log.LogLevel.getByLetterString((String)matcher.group(5));
        assert (priority != null);
        int processId = Integer.parseInt(matcher.group(2));
        int threadId = Integer.parseInt(matcher.group(3));
        String tag = matcher.group(6);
        if (this.myPreferences.SHOW_AS_SECONDS_SINCE_EPOCH) {
            timestampInstant = LogCatLongEpochMessageParser.EPOCH_TIME_FORMATTER.parse((CharSequence)matcher.group(1), Instant::from);
        } else {
            LocalDateTime timestampDateTime = LocalDateTime.parse(matcher.group(1), DATE_TIME_FORMATTER);
            timestampInstant = timestampDateTime.toInstant(this.myTimeZone.getRules().getOffset(timestampDateTime));
        }
        LogCatHeader header = new LogCatHeader(priority, processId, threadId, matcher.group(4), tag, timestampInstant);
        return new LogCatMessage(header, matcher.group(7));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferences";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeZone";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "header";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/logcat/LongEpochMessageFormatter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/logcat/LongEpochMessageFormatter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "format";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "format";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "tryParse";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

