/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.logcat.AndroidLogConsole;
import com.android.tools.idea.logcat.AndroidLogFilterModel;
import com.android.tools.idea.logcat.AndroidLogcatFilter;
import com.android.tools.idea.logcat.AndroidLogcatFormatter;
import com.android.tools.idea.logcat.AndroidLogcatPreferences;
import com.android.tools.idea.logcat.AndroidLogcatService;
import com.android.tools.idea.logcat.ConfigureLogcatHeaderDialog;
import com.android.tools.idea.logcat.DefaultAndroidLogcatFilter;
import com.android.tools.idea.logcat.EditLogFilterDialog;
import com.android.tools.idea.logcat.FormattedLogcatReceiver;
import com.android.tools.idea.logcat.LogcatFilterProvider;
import com.android.tools.idea.logcat.MatchAllFilter;
import com.android.tools.idea.logcat.PersistentAndroidLogFilters;
import com.android.tools.idea.logcat.SelectedProcessFilter;
import com.android.tools.idea.logcat.ViewListener;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.diagnostic.logging.LogFormatter;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.time.ZoneId;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLogcatView {
    public static final Key<AndroidLogcatView> ANDROID_LOGCAT_VIEW_KEY = Key.create((String)"ANDROID_LOGCAT_VIEW_KEY");
    static final AndroidLogcatFilter FAKE_SHOW_ONLY_SELECTED_APPLICATION_FILTER = new MatchAllFilter(AndroidLogcatView.getSelectedAppFilter());
    static final AndroidLogcatFilter NO_FILTERS_ITEM = new MatchAllFilter(AndroidLogcatView.getNoFilters());
    static final AndroidLogcatFilter EDIT_FILTER_CONFIGURATION_ITEM = new MatchAllFilter(AndroidLogcatView.getEditFilterConfiguration());
    private final Project myProject;
    final Disposable parentDisposable;
    private final FormattedLogcatReceiver myLogcatReceiver;
    private final AndroidLogConsole myLogConsole;
    private final DeviceContext myDeviceContext;
    private final AndroidLogFilterModel myLogFilterModel;
    private volatile IDevice myDevice;
    private DefaultComboBoxModel<AndroidLogcatFilter> myFilterComboBoxModel;
    private ActionToolbar myToolbar;
    private JPanel myPanel;

    private void notifyDeviceUpdated(boolean forceReconnect) {
        UIUtil.invokeAndWaitIfNeeded(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            if (forceReconnect) {
                if (this.myDevice != null) {
                    AndroidLogcatService.getInstance().removeListener(this.myDevice, this.myLogcatReceiver);
                }
                this.myDevice = null;
            }
            this.updateLogConsole();
        });
    }

    @NotNull
    public final Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            AndroidLogcatView.$$$reportNull$$$0(0);
        }
        return project;
    }

    @NotNull
    public final AndroidLogConsole getLogConsole() {
        AndroidLogConsole androidLogConsole = this.myLogConsole;
        if (androidLogConsole == null) {
            AndroidLogcatView.$$$reportNull$$$0(1);
        }
        return androidLogConsole;
    }

    @NotNull
    DeviceContext getDeviceContext() {
        DeviceContext deviceContext = this.myDeviceContext;
        if (deviceContext == null) {
            AndroidLogcatView.$$$reportNull$$$0(2);
        }
        return deviceContext;
    }

    @NotNull
    AndroidLogFilterModel getLogFilterModel() {
        AndroidLogFilterModel androidLogFilterModel = this.myLogFilterModel;
        if (androidLogFilterModel == null) {
            AndroidLogcatView.$$$reportNull$$$0(3);
        }
        return androidLogFilterModel;
    }

    @VisibleForTesting
    @NotNull
    ListModel<AndroidLogcatFilter> getEditFiltersComboBoxModel() {
        DefaultComboBoxModel<AndroidLogcatFilter> defaultComboBoxModel = this.myFilterComboBoxModel;
        if (defaultComboBoxModel == null) {
            AndroidLogcatView.$$$reportNull$$$0(4);
        }
        return defaultComboBoxModel;
    }

    @NotNull
    ActionToolbar getToolbar() {
        ActionToolbar actionToolbar = this.myToolbar;
        if (actionToolbar == null) {
            AndroidLogcatView.$$$reportNull$$$0(5);
        }
        return actionToolbar;
    }

    AndroidLogcatView(final @NotNull Project project, @NotNull DeviceContext deviceContext, @NotNull Disposable parentDisposable) {
        if (project == null) {
            AndroidLogcatView.$$$reportNull$$$0(6);
        }
        if (deviceContext == null) {
            AndroidLogcatView.$$$reportNull$$$0(7);
        }
        if (parentDisposable == null) {
            AndroidLogcatView.$$$reportNull$$$0(8);
        }
        this.myDeviceContext = deviceContext;
        this.myProject = project;
        this.parentDisposable = parentDisposable;
        this.$$$setupUI$$$();
        AndroidLogcatFormatter formatter = new AndroidLogcatFormatter(ZoneId.systemDefault(), AndroidLogcatPreferences.getInstance(project));
        this.myLogFilterModel = new AndroidLogFilterModel(formatter){

            @NotNull
            private AndroidLogcatPreferences getPreferences() {
                AndroidLogcatPreferences androidLogcatPreferences = AndroidLogcatPreferences.getInstance(project);
                if (androidLogcatPreferences == null) {
                    1.$$$reportNull$$$0(0);
                }
                return androidLogcatPreferences;
            }

            @Override
            protected void saveLogLevel(String logLevelName) {
                this.getPreferences().TOOL_WINDOW_LOG_LEVEL = logLevelName;
            }

            @Override
            public String getSelectedLogLevelName() {
                return this.getPreferences().TOOL_WINDOW_LOG_LEVEL;
            }

            @Override
            protected void saveConfiguredFilterName(String filterName) {
                this.getPreferences().TOOL_WINDOW_CONFIGURED_FILTER = filterName;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/logcat/AndroidLogcatView$1", "getPreferences"));
            }
        };
        this.myLogConsole = new AndroidLogConsole(project, this.myLogFilterModel, (LogFormatter)formatter, this);
        this.myLogcatReceiver = new ViewListener(formatter, this);
        Disposer.register((Disposable)parentDisposable, () -> {
            if (this.myDevice != null) {
                AndroidLogcatService.getInstance().removeListener(this.myDevice, this.myLogcatReceiver);
            }
        });
        DeviceContext.DeviceSelectionListener deviceSelectionListener = new DeviceContext.DeviceSelectionListener(){

            @Override
            public void deviceSelected(@Nullable IDevice device) {
                AndroidLogcatView.this.notifyDeviceUpdated(false);
            }

            @Override
            public void deviceChanged(@NotNull IDevice device, int changeMask) {
                if (device == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (device == AndroidLogcatView.this.myDevice && (changeMask & 1) == 1) {
                    AndroidLogcatView.this.notifyDeviceUpdated(true);
                }
            }

            @Override
            public void clientSelected(@Nullable Client c) {
                if (AndroidLogcatView.this.myFilterComboBoxModel == null) {
                    return;
                }
                AndroidLogcatFilter selected = (AndroidLogcatFilter)AndroidLogcatView.this.myFilterComboBoxModel.getSelectedItem();
                AndroidLogcatView.this.updateDefaultFilters(c != null ? c.getClientData() : null);
                if (selected != null && AndroidLogcatView.this.myFilterComboBoxModel.getSelectedItem() != selected) {
                    AndroidLogcatView.this.selectFilterByName(selected.getName());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/logcat/AndroidLogcatView$2", "deviceChanged"));
            }
        };
        deviceContext.addListener(deviceSelectionListener, parentDisposable);
        JComponent consoleComponent = this.myLogConsole.getComponent();
        ConsoleView console = this.myLogConsole.getConsole();
        if (console != null) {
            this.myToolbar = ActionManager.getInstance().createActionToolbar("AndroidLogcatView", this.myLogConsole.getOrCreateActions(), false);
            this.myToolbar.setTargetComponent(console.getComponent());
            this.myPanel.add((Component)this.myToolbar.getComponent(), "West");
        }
        this.myPanel.add((Component)consoleComponent, "Center");
        Disposer.register((Disposable)parentDisposable, (Disposable)this.myLogConsole);
        this.updateLogConsole();
    }

    @NotNull
    public Component createEditFiltersComboBox() {
        ComboBox editFiltersCombo = new ComboBox();
        this.myFilterComboBoxModel = new DefaultComboBoxModel();
        this.myFilterComboBoxModel.addElement(NO_FILTERS_ITEM);
        this.myFilterComboBoxModel.addElement(EDIT_FILTER_CONFIGURATION_ITEM);
        this.updateDefaultFilters(null);
        this.updateUserFilters();
        String selectName = AndroidLogcatPreferences.getInstance((Project)this.myProject).TOOL_WINDOW_CONFIGURED_FILTER;
        if (StringUtil.isEmpty((String)selectName)) {
            selectName = this.myDeviceContext != null ? AndroidLogcatView.getSelectedAppFilter() : AndroidLogcatView.getNoFilters();
        }
        this.selectFilterByName(selectName);
        editFiltersCombo.setModel(this.myFilterComboBoxModel);
        this.applySelectedFilter();
        editFiltersCombo.addItemListener(new ItemListener((JComboBox)editFiltersCombo){
            @Nullable
            private AndroidLogcatFilter myLastSelected;
            final /* synthetic */ JComboBox val$editFiltersCombo;
            {
                this.val$editFiltersCombo = jComboBox;
            }

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object item = e.getItem();
                if (e.getStateChange() == 2) {
                    if (item instanceof AndroidLogcatFilter) {
                        this.myLastSelected = (AndroidLogcatFilter)item;
                    }
                } else if (e.getStateChange() == 1) {
                    if (item.equals(EDIT_FILTER_CONFIGURATION_ITEM)) {
                        EditLogFilterDialog dialog2 = new EditLogFilterDialog(AndroidLogcatView.this, this.myLastSelected == null ? null : this.myLastSelected.getName());
                        dialog2.setTitle(AndroidBundle.message("android.logcat.new.filter.dialog.title", new Object[0]));
                        if (dialog2.showAndGet()) {
                            PersistentAndroidLogFilters.FilterData filterData = dialog2.getActiveFilter();
                            AndroidLogcatView.this.updateUserFilters();
                            if (filterData != null) {
                                AndroidLogcatView.this.selectFilterByName(filterData.getName());
                            }
                        } else {
                            this.val$editFiltersCombo.setSelectedItem(this.myLastSelected);
                        }
                    } else {
                        AndroidLogcatView.this.applySelectedFilter();
                    }
                }
            }
        });
        editFiltersCombo.setRenderer(new ColoredListCellRenderer<Object>(){

            protected void customizeCellRenderer(@NotNull JList list, Object value2, int index2, boolean selected, boolean hasFocus) {
                if (list == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (value2 instanceof AndroidLogcatFilter) {
                    this.setBorder(null);
                    this.append(((AndroidLogcatFilter)value2).getName());
                } else {
                    this.setBorder(IdeBorderFactory.createBorder((int)8));
                    this.append(value2.toString());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/logcat/AndroidLogcatView$4", "customizeCellRenderer"));
            }
        });
        ComboBox comboBox = editFiltersCombo;
        if (comboBox == null) {
            AndroidLogcatView.$$$reportNull$$$0(9);
        }
        return comboBox;
    }

    boolean isActive() {
        return ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Logcat").isVisible();
    }

    public final void activate() {
        if (this.isActive()) {
            this.updateLogConsole();
        }
        if (this.myLogConsole != null) {
            this.myLogConsole.activate();
        }
    }

    private void updateLogConsole() {
        IDevice device = this.getSelectedDevice();
        if (this.myDevice != device) {
            AndroidLogcatService androidLogcatService = AndroidLogcatService.getInstance();
            if (this.myDevice != null) {
                androidLogcatService.removeListener(this.myDevice, this.myLogcatReceiver);
            }
            if (this.myLogConsole.getConsole() != null) {
                this.myLogConsole.clear();
            }
            this.myDevice = device;
            this.myLogFilterModel.processingStarted();
            androidLogcatService.addListener(this.myDevice, this.myLogcatReceiver, true);
        }
    }

    @Nullable
    IDevice getSelectedDevice() {
        if (this.myDeviceContext != null) {
            return this.myDeviceContext.getSelectedDevice();
        }
        return null;
    }

    private void applySelectedFilter() {
        final Object filter2 = this.myFilterComboBoxModel.getSelectedItem();
        if (filter2 instanceof AndroidLogcatFilter) {
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, "Applying Filter..."){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    AndroidLogcatView.this.myLogFilterModel.updateLogcatFilter((AndroidLogcatFilter)filter2);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/logcat/AndroidLogcatView$5", "run"));
                }
            });
        }
    }

    @VisibleForTesting
    void updateDefaultFilters(@Nullable ClientData client) {
        int noFilterIndex = this.myFilterComboBoxModel.getIndexOf(NO_FILTERS_ITEM);
        for (int i2 = 0; i2 < noFilterIndex; ++i2) {
            this.myFilterComboBoxModel.removeElementAt(0);
        }
        AndroidLogcatFilter filter2 = client == null ? FAKE_SHOW_ONLY_SELECTED_APPLICATION_FILTER : new SelectedProcessFilter(client.getPid());
        int insertIndex = 0;
        this.myFilterComboBoxModel.insertElementAt(filter2, insertIndex++);
        for (LogcatFilterProvider filterProvider : (LogcatFilterProvider[])LogcatFilterProvider.EP_NAME.getExtensions()) {
            this.myFilterComboBoxModel.insertElementAt(filterProvider.getFilter(client), insertIndex++);
        }
    }

    private void updateUserFilters() {
        int editFilterConfigurationItemIndex = this.myFilterComboBoxModel.getIndexOf(EDIT_FILTER_CONFIGURATION_ITEM);
        assert (editFilterConfigurationItemIndex != -1);
        int userFiltersStartIndex = editFilterConfigurationItemIndex + 1;
        while (this.myFilterComboBoxModel.getSize() > userFiltersStartIndex) {
            this.myFilterComboBoxModel.removeElementAt(userFiltersStartIndex);
        }
        List<PersistentAndroidLogFilters.FilterData> filters = PersistentAndroidLogFilters.getInstance(this.myProject).getFilters();
        for (PersistentAndroidLogFilters.FilterData filter2 : filters) {
            String name = filter2.getName();
            assert (name != null);
            DefaultAndroidLogcatFilter compiled = DefaultAndroidLogcatFilter.compile(filter2, name);
            this.myFilterComboBoxModel.addElement(compiled);
        }
    }

    private void selectFilterByName(String name) {
        Optional<AndroidLogcatFilter> optionalFilter = IntStream.range(0, this.myFilterComboBoxModel.getSize()).mapToObj(i2 -> this.myFilterComboBoxModel.getElementAt(i2)).filter(filter2 -> filter2.getName().equals(name)).findFirst();
        optionalFilter.ifPresent(filter2 -> this.myFilterComboBoxModel.setSelectedItem(filter2));
    }

    @NotNull
    public final JPanel getContentPanel() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            AndroidLogcatView.$$$reportNull$$$0(10);
        }
        return jPanel;
    }

    static String getSelectedAppFilter() {
        return AndroidBundle.message("android.logcat.filters.selected", new Object[0]);
    }

    static String getNoFilters() {
        return AndroidBundle.message("android.logcat.filters.none", new Object[0]);
    }

    static String getEditFilterConfiguration() {
        return AndroidBundle.message("android.logcat.filters.edit", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/logcat/AndroidLogcatView";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceContext";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogConsole";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeviceContext";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogFilterModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditFiltersComboBoxModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbar";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/logcat/AndroidLogcatView";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditFiltersComboBox";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentPanel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(-1, -1));
        ((Component)jPanel).setBackground(new Color(-1));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    static final class MyConfigureLogcatHeaderAction
    extends AnAction {
        private final AndroidLogcatView myView;

        MyConfigureLogcatHeaderAction(@NotNull AndroidLogcatView view) {
            if (view == null) {
                MyConfigureLogcatHeaderAction.$$$reportNull$$$0(0);
            }
            super(AndroidBundle.message("android.configure.logcat.header.text", new Object[0]), AndroidBundle.message("android.configure.logcat.header.description", new Object[0]), AllIcons.General.GearPlain);
            this.myView = view;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            AndroidLogcatPreferences preferences;
            Project project;
            ConfigureLogcatHeaderDialog dialog2;
            if (e == null) {
                MyConfigureLogcatHeaderAction.$$$reportNull$$$0(1);
            }
            if ((dialog2 = new ConfigureLogcatHeaderDialog(project = this.myView.myProject, preferences = AndroidLogcatPreferences.getInstance(project), ZoneId.systemDefault())).showAndGet()) {
                preferences.LOGCAT_FORMAT_STRING = dialog2.getFormat();
                preferences.SHOW_AS_SECONDS_SINCE_EPOCH = dialog2.getShowAsSecondsSinceEpochCheckBox().isSelected();
                this.myView.myLogConsole.refresh();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "view";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/logcat/AndroidLogcatView$MyConfigureLogcatHeaderAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class MyRestartAction
    extends AnAction {
        private final AndroidLogcatView myView;

        MyRestartAction(@NotNull AndroidLogcatView view) {
            if (view == null) {
                MyRestartAction.$$$reportNull$$$0(0);
            }
            super(AndroidBundle.message("android.restart.logcat.action.text", new Object[0]), AndroidBundle.message("android.restart.logcat.action.description", new Object[0]), AllIcons.Actions.Restart);
            this.myView = view;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyRestartAction.$$$reportNull$$$0(1);
            }
            this.myView.notifyDeviceUpdated(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "view";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/logcat/AndroidLogcatView$MyRestartAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

