/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.tools.idea.adb.AdbService;
import com.android.tools.idea.ddms.DevicePanel;
import com.android.tools.idea.logcat.AndroidLogcatView;
import com.android.tools.idea.logcat.LogcatPanel;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.ProjectTopics;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.swing.JComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLogcatToolWindowFactory
implements ToolWindowFactory,
DumbAware {
    public static final Key<DevicePanel> DEVICES_PANEL_KEY = Key.create((String)"DevicePanel");

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        if (project == null) {
            AndroidLogcatToolWindowFactory.$$$reportNull$$$0(0);
        }
        if (toolWindow == null) {
            AndroidLogcatToolWindowFactory.$$$reportNull$$$0(1);
        }
        RunContentManager.getInstance((Project)project);
        toolWindow.setAvailable(true);
        toolWindow.setToHideOnEmptyContent(true);
        final LogcatPanel logcatPanel = new LogcatPanel(project, toolWindow);
        AndroidLogcatView logcatView = logcatPanel.getLogcatView();
        MessageBusConnection busConnection = project.getMessageBus().connect(toolWindow.getDisposable());
        busConnection.subscribe(ToolWindowManagerListener.TOPIC, (Object)new MyToolWindowManagerListener(project, logcatView));
        busConnection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new MyAndroidPlatformListener(logcatView));
        ContentManager contentManager = toolWindow.getContentManager();
        Content c = contentManager.getFactory().createContent((JComponent)((Object)logcatPanel), "", true);
        c.putUserData(AndroidLogcatView.ANDROID_LOGCAT_VIEW_KEY, (Object)logcatView);
        c.putUserData(DEVICES_PANEL_KEY, (Object)logcatPanel.getDevicePanel());
        contentManager.addContent(c);
        ApplicationManager.getApplication().invokeLater(() -> {
            ConsoleView console;
            logcatView.activate();
            ToolWindow window2 = ToolWindowManager.getInstance((Project)project).getToolWindow(AndroidLogcatToolWindowFactory.getToolWindowId());
            if (window2 != null && window2.isVisible() && (console = logcatView.getLogConsole().getConsole()) != null) {
                AndroidLogcatToolWindowFactory.checkFacetAndSdk(project, console);
            }
        }, project.getDisposed());
        final File adb = AndroidSdkUtils.getAdb(project);
        if (adb == null) {
            return;
        }
        logcatPanel.setLoadingText("Initializing ADB");
        logcatPanel.startLoading();
        ListenableFuture<AndroidDebugBridge> future2 = AdbService.getInstance().getDebugBridge(adb);
        Futures.addCallback(future2, (FutureCallback)new FutureCallback<AndroidDebugBridge>(){

            public void onSuccess(@Nullable AndroidDebugBridge bridge) {
                Logger.getInstance(AndroidLogcatToolWindowFactory.class).info("Successfully obtained debug bridge");
                logcatPanel.stopLoading();
            }

            public void onFailure(@NotNull Throwable t) {
                if (t == null) {
                    1.$$$reportNull$$$0(0);
                }
                logcatPanel.stopLoading();
                Logger.getInstance(AndroidLogcatToolWindowFactory.class).info("Unable to obtain debug bridge", t);
                Messages.showErrorDialog((String)AdbService.getDebugBridgeDiagnosticErrorMessage(t, adb), (String)"ADB Connection Error");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/android/tools/idea/logcat/AndroidLogcatToolWindowFactory$1", "onFailure"));
            }
        }, (Executor)EdtExecutorService.getInstance());
    }

    @NotNull
    public static String getToolWindowId() {
        return "Logcat";
    }

    private static void checkFacetAndSdk(Project project, @NotNull ConsoleView console) {
        List facets;
        if (console == null) {
            AndroidLogcatToolWindowFactory.$$$reportNull$$$0(2);
        }
        if ((facets = ProjectFacetManager.getInstance((Project)project).getFacets(AndroidFacet.ID)).isEmpty()) {
            console.clear();
            console.print(AndroidBundle.message("android.logcat.no.android.facets.error", new Object[0]), ConsoleViewContentType.ERROR_OUTPUT);
            return;
        }
        AndroidFacet facet2 = (AndroidFacet)facets.get(0);
        AndroidPlatform platform = AndroidPlatform.getInstance(facet2.getModule());
        if (platform == null) {
            console.clear();
            Module module2 = facet2.getModule();
            console.print("Please ", ConsoleViewContentType.ERROR_OUTPUT);
            console.printHyperlink("configure", p -> AndroidSdkUtils.openModuleDependenciesConfigurable(module2));
            console.print(" Android SDK\n", ConsoleViewContentType.ERROR_OUTPUT);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/logcat/AndroidLogcatToolWindowFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createToolWindowContent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFacetAndSdk";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyAndroidPlatformListener
    implements ModuleRootListener {
        private final Project myProject;
        private final AndroidLogcatView myView;
        private AndroidPlatform myPrevPlatform;

        private MyAndroidPlatformListener(@NotNull AndroidLogcatView view) {
            if (view == null) {
                MyAndroidPlatformListener.$$$reportNull$$$0(0);
            }
            this.myProject = view.getProject();
            this.myView = view;
            this.myPrevPlatform = this.getPlatform();
        }

        public void rootsChanged(@NotNull ModuleRootEvent event) {
            ToolWindow window2;
            if (event == null) {
                MyAndroidPlatformListener.$$$reportNull$$$0(1);
            }
            if ((window2 = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(AndroidLogcatToolWindowFactory.getToolWindowId())) == null) {
                return;
            }
            if (window2.isDisposed() || !window2.isVisible()) {
                return;
            }
            AndroidPlatform newPlatform = this.getPlatform();
            if (!Objects.equals(this.myPrevPlatform, newPlatform)) {
                this.myPrevPlatform = newPlatform;
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (!window2.isDisposed() && window2.isVisible()) {
                        this.myView.activate();
                    }
                });
            }
        }

        @Nullable
        private AndroidPlatform getPlatform() {
            AndroidPlatform newPlatform = null;
            List facets = ProjectFacetManager.getInstance((Project)this.myProject).getFacets(AndroidFacet.ID);
            if (!facets.isEmpty()) {
                AndroidFacet facet2 = (AndroidFacet)facets.get(0);
                newPlatform = AndroidPlatform.getInstance(facet2.getModule());
            }
            return newPlatform;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "view";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/logcat/AndroidLogcatToolWindowFactory$MyAndroidPlatformListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "rootsChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyToolWindowManagerListener
    implements ToolWindowManagerListener {
        private final Project myProject;
        private final AndroidLogcatView myLogcatView;
        private boolean myToolWindowVisible;

        private MyToolWindowManagerListener(@NotNull Project project, @NotNull AndroidLogcatView logcatView) {
            if (project == null) {
                MyToolWindowManagerListener.$$$reportNull$$$0(0);
            }
            if (logcatView == null) {
                MyToolWindowManagerListener.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myLogcatView = logcatView;
        }

        public void stateChanged(@NotNull ToolWindowManager toolWindowManager) {
            ToolWindow window2;
            if (toolWindowManager == null) {
                MyToolWindowManagerListener.$$$reportNull$$$0(2);
            }
            if ((window2 = toolWindowManager.getToolWindow("Logcat")) == null) {
                return;
            }
            boolean visible = window2.isVisible();
            if (this.myToolWindowVisible == visible) {
                return;
            }
            this.myToolWindowVisible = visible;
            this.myLogcatView.activate();
            if (!visible) {
                return;
            }
            ConsoleView consoleView = this.myLogcatView.getLogConsole().getConsole();
            if (consoleView == null) {
                return;
            }
            AndroidLogcatToolWindowFactory.checkFacetAndSdk(this.myProject, consoleView);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logcatView";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolWindowManager";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/logcat/AndroidLogcatToolWindowFactory$MyToolWindowManagerListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "stateChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

